import {NgModule} from '@angular/core';
import {CommonModule} from '@angular/common';
import {FormsModule} from '@angular/forms';
import {DiscountDirective} from './directives/discount.directive';
import {MobileNumberDirective} from './directives/mobile-number.directive';
import {NgxPersianNumbersService} from './services/ngx-persian-numbers.service';
import {AmountDirective} from './directives/amount.directive';
import {MonyDirective} from './directives/mony.directive';
import {PersianNumberToEnglishDirective} from './directives/persian-number-to-english.directive';
import {VerificationCodeDirective} from './directives/verification-code.directive';

@NgModule({
  imports: [
    CommonModule,
    FormsModule,
  ],
  declarations: [
    DiscountDirective,
    MobileNumberDirective,
    AmountDirective,
    MonyDirective,
    PersianNumberToEnglishDirective,
    VerificationCodeDirective
  ],
  exports: [
    DiscountDirective,
    MobileNumberDirective,
    AmountDirective,
    MonyDirective,
    PersianNumberToEnglishDirective,
    VerificationCodeDirective
  ],
  providers: [
    NgxPersianNumbersService
  ]
})
export class NgxPersianNumberModule {
}
