import {
  Directive,
  Input,
  Output,
  EventEmitter
} from '@angular/core';

import {NgModel} from '@angular/forms';
import {NgxPersianNumbersService} from 'ngx-persian-number/src/services/ngx-persian-numbers.service';

@Directive({
  selector: '[validVerificationCode]',
  providers: [NgModel]
})

export class VerificationCodeDirective {
  public numbers;

  constructor(public ngxPE: NgxPersianNumbersService) {
  }

  @Output() ngModelChange: EventEmitter<any> = new EventEmitter();

  @Input() set ngModel(value: any) {

    if (value) {
      this.numbers = this.ngxPE.makeEnglishNumbers(value);
      console.log(this.numbers);
      this.numbers = this.ngxPE.removeLettersFromString(this.numbers);
      console.log(this.numbers);
      this.numbers = this.ngxPE.removeLettersFromString(this.numbers);
      setTimeout(() => {
        this.ngModelChange.emit(this.numbers);
      });

    }

  }

}
