import {
  Directive,
  Input,
  Output,
  EventEmitter
} from '@angular/core';

import {NgModel} from '@angular/forms';
import {NgxPersianNumbersService} from 'ngx-persian-number/src/services/ngx-persian-numbers.service';

@Directive({
  selector: '[persianNumberToEnglish]',
  providers: [NgModel]
})

export class PersianNumberToEnglishDirective {
  public numbers;

  constructor(public ngxPE: NgxPersianNumbersService) {
  }

  @Output() ngModelChange: EventEmitter<any> = new EventEmitter();

  @Input() set ngModel(value: any) {

    if (value) {
      this.numbers = this.ngxPE.makeEnglishNumbers(value);
      setTimeout(() => {
        this.ngModelChange.emit(this.numbers);
      });

    }

  }

}
