import {Directive, ElementRef, EventEmitter, Input, Output, Renderer2} from '@angular/core';
import {NgxPersianNumbersService} from '../services/ngx-persian-numbers.service';

@Directive({
  selector: '[validMony]'
})
export class MonyDirective {
  public numbers;
  public inputElem;

  constructor(public el: ElementRef,
              public render: Renderer2,
              public ngxPE: NgxPersianNumbersService) {
    this.inputElem = el.nativeElement;
  }

  @Input() set ngModel(value: any) {
    if (value) {
      this.numbers = this.ngxPE.makeEnglishNumbers(value);
      this.numbers = this.ngxPE.removeLettersFromString(this.numbers);
      if (this.numbers === '0') {
        this.numbers = 1;
      }


      let arr = [];

      for (let i = this.numbers.length; i > 0;) {

        const slice = this.numbers.slice(i - 3, i);

        if (slice.length > 2) {
          arr.push(slice);
        } else {
          arr.push(this.numbers.toString().slice(0, i));
        }

        i = i - 3;
      }

      this.numbers = arr.reverse().join(',');

      setTimeout(() => {
        this.ngModelChange.emit(this.numbers);
      });
    }

  }

  @Output() ngModelChange: EventEmitter<any> = new EventEmitter();


}
