import {Directive, ElementRef, EventEmitter, Input, OnInit, Output, Renderer2} from '@angular/core';
import {NgxPersianNumbersService} from '../services/ngx-persian-numbers.service';

@Directive({
  selector: '[validMoblieNumber]'
})
export class MobileNumberDirective implements OnInit {
  public numbers;
  public inputElem;

  constructor(public input: ElementRef,
              public render: Renderer2,
              public ngxPE: NgxPersianNumbersService) {
    this.inputElem = input.nativeElement;
  }

  @Output() ngModelChange: EventEmitter<any> = new EventEmitter();

  setMaxlength() {
    this.render.setAttribute(this.inputElem, 'maxlength', '11');
  }

  ngOnInit() {
    this.setMaxlength();
  }

  @Input() set ngModel(value: any) {
    if (value) {
      this.numbers = this.ngxPE.makeEnglishNumbers(value);
      this.numbers = this.ngxPE.removeLettersFromString(this.numbers);

      setTimeout(() => {
        this.ngModelChange.emit(this.numbers);
      });
    }

  }


}
