import {Directive, Input, Output, EventEmitter} from '@angular/core';
import {NgxPersianNumbersService} from '../services/ngx-persian-numbers.service';

@Directive({
  selector: '[validDiscount]'
})
export class DiscountDirective {
  public numbers;

  constructor(public ngxPE: NgxPersianNumbersService) {
  }

  @Input() set ngModel(value: any) {
    if (value) {
      this.numbers = this.ngxPE.makeEnglishNumbers(value);
      this.numbers = this.ngxPE.removeLettersFromString(this.numbers);

      if (value > 100) {
        this.numbers = '100';
      }

      setTimeout(() => {
        this.ngModelChange.emit(this.numbers);
      });
    }

  }

  @Output() ngModelChange: EventEmitter<any> = new EventEmitter();
}
