import {Directive, EventEmitter, Input, Output} from '@angular/core';
import {NgxPersianNumbersService} from '../services/ngx-persian-numbers.service';

@Directive({
  selector: '[validAmount]'
})

export class AmountDirective {
  public numbers;

  constructor(public ngxPE: NgxPersianNumbersService) {
  }

  @Input() set ngModel(value: any) {
    if (value) {
      this.numbers = this.ngxPE.makeEnglishNumbers(value);
      this.numbers = this.ngxPE.removeLettersFromString(this.numbers);
      if (this.numbers === '0') {
        this.numbers = 1;
      }
      setTimeout(() => {
        this.ngModelChange.emit(this.numbers);
      });
    }

  }

  @Output() ngModelChange: EventEmitter<any> = new EventEmitter();
}
