!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?e(exports,require("@angular/core"),require("@angular/common"),require("@angular/platform-browser")):"function"==typeof define&&define.amd?define(["exports","@angular/core","@angular/common","@angular/platform-browser"],e):e(t["ngx-image-cropper"]={},t.ng.core,t.ng.common,t.ng.platformBrowser)}(this,function(t,e,i,r){"use strict";var s=function(){function t(t,i,r){this.elementRef=t,this.sanitizer=i,this.cd=r,this.marginLeft="0px",this.imageVisible=!1,this.format="png",this.maintainAspectRatio=!0,this.aspectRatio=1,this.resizeToWidth=0,this.onlyScaleDown=!1,this.imageQuality=92,this.cropper={x1:-100,y1:-100,x2:1e4,y2:1e4},this.imageCropped=new e.EventEmitter,this.imageLoaded=new e.EventEmitter,this.loadImageFailed=new e.EventEmitter,this.initCropper()}return Object.defineProperty(t.prototype,"imageChangedEvent",{set:function(t){this.initCropper(),t&&t.target&&t.target.files&&t.target.files.length>0&&this.loadImage(t)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"imageBase64",{set:function(t){this.initCropper(),this.loadBase64Image(t)},enumerable:!0,configurable:!0}),t.prototype.ngOnChanges=function(t){var e=this;t.cropper&&setTimeout(function(){e.setMaxSize(),e.checkCropperPosition(!1),e.crop(),e.cd.markForCheck()})},t.prototype.initCropper=function(){this.imageVisible=!1,this.originalImage=null,this.safeImgDataUrl="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAAC0lEQVQYV2NgAAIAAAUAAarVyFEAAAAASUVORK5CYII=",this.moveStart={active:!1,type:null,position:null,x1:0,y1:0,x2:0,y2:0,clientX:0,clientY:0},this.maxSize={width:0,height:0},this.originalSize={width:0,height:0},this.cropper.x1=-100,this.cropper.y1=-100,this.cropper.x2=1e4,this.cropper.y2=1e4},t.prototype.loadImage=function(t){var e=this,i=new FileReader;i.onload=function(i){"image/jpeg"===t.target.files[0].type||"image/jpg"===t.target.files[0].type||"image/png"===t.target.files[0].type||"image/gif"===t.target.files[0].type?e.loadBase64Image(i.target.result):e.loadImageFailed.emit()},i.readAsDataURL(t.target.files[0])},t.prototype.loadBase64Image=function(t){var e=this;this.originalImage=new Image,this.originalImage.onload=function(){e.originalSize.width=e.originalImage.width,e.originalSize.height=e.originalImage.height,e.cd.markForCheck()},this.safeImgDataUrl=this.sanitizer.bypassSecurityTrustResourceUrl(t),this.originalImage.src=t},t.prototype.imageLoadedInView=function(){var t=this;null!=this.originalImage&&(this.imageLoaded.emit(),setTimeout(function(){t.setMaxSize(),t.resetCropperPosition(),t.cd.markForCheck()}))},t.prototype.imageResizedInView=function(t){this.resizeCropperPosition(),this.setMaxSize()},t.prototype.resizeCropperPosition=function(){var t=this.elementRef.nativeElement.querySelector(".source-image");this.maxSize.width===t.offsetWidth&&this.maxSize.height===t.offsetHeight||(this.cropper.x1=this.cropper.x1*t.offsetWidth/this.maxSize.width,this.cropper.x2=this.cropper.x2*t.offsetWidth/this.maxSize.width,this.cropper.y1=this.cropper.y1*t.offsetHeight/this.maxSize.height,this.cropper.y2=this.cropper.y2*t.offsetHeight/this.maxSize.height)},t.prototype.resetCropperPosition=function(){var t=this.elementRef.nativeElement.querySelector(".source-image");if(t.offsetWidth/this.aspectRatio<t.offsetHeight){this.cropper.x1=0,this.cropper.x2=t.offsetWidth;var e=t.offsetWidth/this.aspectRatio;this.cropper.y1=(t.offsetHeight-e)/2,this.cropper.y2=this.cropper.y1+e}else{this.cropper.y1=0,this.cropper.y2=t.offsetHeight;var i=t.offsetHeight*this.aspectRatio;this.cropper.x1=(t.offsetWidth-i)/2,this.cropper.x2=this.cropper.x1+i}this.crop(),this.imageVisible=!0},t.prototype.startMove=function(t,e,i){void 0===i&&(i=null),this.moveStart.active=!0,this.moveStart.type=e,this.moveStart.position=i,this.moveStart.clientX=this.getClientX(t),this.moveStart.clientY=this.getClientY(t),Object.assign(this.moveStart,this.cropper),this.cd.markForCheck()},t.prototype.moveImg=function(t){this.moveStart.active&&(t.stopPropagation(),t.preventDefault(),this.setMaxSize(),"move"===this.moveStart.type?(this.move(t),this.checkCropperPosition(!0)):"resize"===this.moveStart.type&&(this.resize(t),this.checkCropperPosition(!1)),this.cd.markForCheck())},t.prototype.setMaxSize=function(){var t=this.elementRef.nativeElement.querySelector(".source-image");this.maxSize.width=t.offsetWidth,this.maxSize.height=t.offsetHeight,this.marginLeft=this.sanitizer.bypassSecurityTrustStyle("calc(50% - "+this.maxSize.width/2+"px)")},t.prototype.checkCropperPosition=function(t){void 0===t&&(t=!1),this.cropper.x1<0&&(this.cropper.x2-=t?this.cropper.x1:0,this.cropper.x1=0),this.cropper.y1<0&&(this.cropper.y2-=t?this.cropper.y1:0,this.cropper.y1=0),this.cropper.x2>this.maxSize.width&&(this.cropper.x1-=t?this.cropper.x2-this.maxSize.width:0,this.cropper.x2=this.maxSize.width),this.cropper.y2>this.maxSize.height&&(this.cropper.y1-=t?this.cropper.y2-this.maxSize.height:0,this.cropper.y2=this.maxSize.height)},t.prototype.moveStop=function(t){this.moveStart.active&&(this.moveStart.active=!1,this.crop(),this.cd.markForCheck())},t.prototype.move=function(t){var e=this.getClientX(t)-this.moveStart.clientX,i=this.getClientY(t)-this.moveStart.clientY;this.cropper.x1=this.moveStart.x1+e,this.cropper.y1=this.moveStart.y1+i,this.cropper.x2=this.moveStart.x2+e,this.cropper.y2=this.moveStart.y2+i},t.prototype.resize=function(t){var e=this.getClientX(t)-this.moveStart.clientX,i=this.getClientY(t)-this.moveStart.clientY;switch(this.moveStart.position){case"left":this.cropper.x1=Math.min(this.moveStart.x1+e,this.cropper.x2-20);break;case"topleft":this.cropper.x1=Math.min(this.moveStart.x1+e,this.cropper.x2-20),this.cropper.y1=Math.min(this.moveStart.y1+i,this.cropper.y2-20);break;case"top":this.cropper.y1=Math.min(this.moveStart.y1+i,this.cropper.y2-20);break;case"topright":this.cropper.x2=Math.max(this.moveStart.x2+e,this.cropper.x1+20),this.cropper.y1=Math.min(this.moveStart.y1+i,this.cropper.y2-20);break;case"right":this.cropper.x2=Math.max(this.moveStart.x2+e,this.cropper.x1+20);break;case"bottomright":this.cropper.x2=Math.max(this.moveStart.x2+e,this.cropper.x1+20),this.cropper.y2=Math.max(this.moveStart.y2+i,this.cropper.y1+20);break;case"bottom":this.cropper.y2=Math.max(this.moveStart.y2+i,this.cropper.y1+20);break;case"bottomleft":this.cropper.x1=Math.min(this.moveStart.x1+e,this.cropper.x2-20),this.cropper.y2=Math.max(this.moveStart.y2+i,this.cropper.y1+20)}this.maintainAspectRatio&&this.checkAspectRatio()},t.prototype.checkAspectRatio=function(){var t=0,e=0;switch(this.moveStart.position){case"top":this.cropper.x2=this.cropper.x1+(this.cropper.y2-this.cropper.y1)*this.aspectRatio,t=Math.max(this.cropper.x2-this.maxSize.width,0),e=Math.max(0-this.cropper.y1,0),(t>0||e>0)&&(this.cropper.x2-=e*this.aspectRatio>t?e*this.aspectRatio:t,this.cropper.y1+=e*this.aspectRatio>t?e:t/this.aspectRatio);break;case"bottom":this.cropper.x2=this.cropper.x1+(this.cropper.y2-this.cropper.y1)*this.aspectRatio,t=Math.max(this.cropper.x2-this.maxSize.width,0),e=Math.max(this.cropper.y2-this.maxSize.height,0),(t>0||e>0)&&(this.cropper.x2-=e*this.aspectRatio>t?e*this.aspectRatio:t,this.cropper.y2-=e*this.aspectRatio>t?e:t/this.aspectRatio);break;case"topleft":this.cropper.y1=this.cropper.y2-(this.cropper.x2-this.cropper.x1)/this.aspectRatio,t=Math.max(0-this.cropper.x1,0),e=Math.max(0-this.cropper.y1,0),(t>0||e>0)&&(this.cropper.x1+=e*this.aspectRatio>t?e*this.aspectRatio:t,this.cropper.y1+=e*this.aspectRatio>t?e:t/this.aspectRatio);break;case"topright":this.cropper.y1=this.cropper.y2-(this.cropper.x2-this.cropper.x1)/this.aspectRatio,t=Math.max(this.cropper.x2-this.maxSize.width,0),e=Math.max(0-this.cropper.y1,0),(t>0||e>0)&&(this.cropper.x2-=e*this.aspectRatio>t?e*this.aspectRatio:t,this.cropper.y1+=e*this.aspectRatio>t?e:t/this.aspectRatio);break;case"right":case"bottomright":this.cropper.y2=this.cropper.y1+(this.cropper.x2-this.cropper.x1)/this.aspectRatio,t=Math.max(this.cropper.x2-this.maxSize.width,0),e=Math.max(this.cropper.y2-this.maxSize.height,0),(t>0||e>0)&&(this.cropper.x2-=e*this.aspectRatio>t?e*this.aspectRatio:t,this.cropper.y2-=e*this.aspectRatio>t?e:t/this.aspectRatio);break;case"left":case"bottomleft":this.cropper.y2=this.cropper.y1+(this.cropper.x2-this.cropper.x1)/this.aspectRatio,t=Math.max(0-this.cropper.x1,0),e=Math.max(this.cropper.y2-this.maxSize.height,0),(t>0||e>0)&&(this.cropper.x1+=e*this.aspectRatio>t?e*this.aspectRatio:t,this.cropper.y2-=e*this.aspectRatio>t?e:t/this.aspectRatio)}},t.prototype.crop=function(){var t=this.elementRef.nativeElement.querySelector(".source-image");if(t&&null!=this.originalImage){var e=this.originalSize.width/t.offsetWidth,i=Math.round(this.cropper.x1*e),r=Math.round(this.cropper.y1*e),s=Math.round((this.cropper.x2-this.cropper.x1)*e),o=Math.round((this.cropper.y2-this.cropper.y1)*e),p=this.getResizeRatio(s),a=document.createElement("canvas");a.width=s*p,a.height=o*p;var n=a.getContext("2d");if(n){n.drawImage(this.originalImage,i,r,s,o,0,0,s*p,o*p);var h=Math.min(1,Math.max(0,this.imageQuality/100)),c=a.toDataURL("image/"+this.format,h);c.length>10&&this.imageCropped.emit(c)}}},t.prototype.getResizeRatio=function(t){return this.resizeToWidth>0&&(!this.onlyScaleDown||t>this.resizeToWidth)?this.resizeToWidth/t:1},t.prototype.getClientX=function(t){return null!=t.clientX?t.clientX:t.touches[0].clientX},t.prototype.getClientY=function(t){return null!=t.clientY?t.clientY:t.touches[0].clientY},t}();s.decorators=[{type:e.Component,args:[{selector:"image-cropper",template:'\n      <div>\n          <img\n              [src]="safeImgDataUrl"\n              [style.visibility]="imageVisible ? \'visible\' : \'hidden\'"\n              (load)="imageLoadedInView()"\n              class="source-image"\n          />\n          <div class="cropper"\n               [style.top.px]="cropper.y1"\n               [style.left.px]="cropper.x1"\n               [style.width.px]="cropper.x2 - cropper.x1"\n               [style.height.px]="cropper.y2 - cropper.y1"\n               [style.margin-left]="marginLeft"\n               [style.visibility]="imageVisible ? \'visible\' : \'hidden\'"\n          >\n              <div\n                  (mousedown)="startMove($event, \'move\')"\n                  (touchstart)="startMove($event, \'move\')"\n                  class="move"\n              >&nbsp;</div>\n              <span\n                  class="resize topleft"\n                  (mousedown)="startMove($event, \'resize\', \'topleft\')"\n                  (touchstart)="startMove($event, \'resize\', \'topleft\')"\n              ><span class="square"></span></span>\n              <span\n                  class="resize top"\n              ><span class="square"></span></span>\n              <span\n                  class="resize topright"\n                  (mousedown)="startMove($event, \'resize\', \'topright\')"\n                  (touchstart)="startMove($event, \'resize\', \'topright\')"\n              ><span class="square"></span></span>\n              <span\n                  class="resize right"\n              ><span class="square"></span></span>\n              <span\n                  class="resize bottomright"\n                  (mousedown)="startMove($event, \'resize\', \'bottomright\')"\n                  (touchstart)="startMove($event, \'resize\', \'bottomright\')"\n              ><span class="square"></span></span>\n              <span\n                  class="resize bottom"\n              ><span class="square"></span></span>\n              <span\n                  class="resize bottomleft"\n                  (mousedown)="startMove($event, \'resize\', \'bottomleft\')"\n                  (touchstart)="startMove($event, \'resize\', \'bottomleft\')"\n              ><span class="square"></span></span>\n              <span\n                  class="resize left"\n              ><span class="square"></span></span>\n              <span\n                  class="resize-bar top"\n                  (mousedown)="startMove($event, \'resize\', \'top\')"\n                  (touchstart)="startMove($event, \'resize\', \'top\')"\n              ></span>\n              <span\n                  class="resize-bar right"\n                  (mousedown)="startMove($event, \'resize\', \'right\')"\n                  (touchstart)="startMove($event, \'resize\', \'right\')"\n              ></span>\n              <span\n                  class="resize-bar bottom"\n                  (mousedown)="startMove($event, \'resize\', \'bottom\')"\n                  (touchstart)="startMove($event, \'resize\', \'bottom\')"\n              ></span>\n              <span\n                  class="resize-bar left"\n                  (mousedown)="startMove($event, \'resize\', \'left\')"\n                  (touchstart)="startMove($event, \'resize\', \'left\')"\n              ></span>\n          </div>\n      </div>\n    ',styles:["\n      :host {\n        display: -webkit-box;\n        display: -ms-flexbox;\n        display: flex;\n        position: relative;\n        width: 100%;\n        max-width: 100%;\n        max-height: 100%;\n        overflow: hidden;\n        padding: 5px;\n        text-align: center;\n        -webkit-user-select: none;\n        -moz-user-select: none;\n        -ms-user-select: none;\n        user-select: none; }\n        :host > div {\n          position: relative;\n          width: 100%; }\n          :host > div .source-image {\n            max-width: 100%;\n            max-height: 100%; }\n        :host .cropper {\n          position: absolute;\n          display: -webkit-box;\n          display: -ms-flexbox;\n          display: flex;\n          color: #53535C !important;\n          background: transparent !important;\n          outline-color: rgba(255, 255, 255, 0.3);\n          outline-width: 1000px;\n          outline-style: solid;\n          -ms-touch-action: none;\n              touch-action: none; }\n          :host .cropper:after {\n            position: absolute;\n            content: '';\n            top: 0;\n            bottom: 0;\n            left: 0;\n            right: 0;\n            pointer-events: none;\n            border: dashed 1px;\n            opacity: .75;\n            color: inherit;\n            z-index: 1; }\n          :host .cropper .move {\n            width: 100%;\n            cursor: move;\n            border: 1px solid rgba(255, 255, 255, 0.5); }\n          :host .cropper .resize {\n            position: absolute;\n            display: inline-block;\n            line-height: 6px;\n            padding: 8px;\n            opacity: .85;\n            z-index: 1; }\n            :host .cropper .resize .square {\n              display: inline-block;\n              background: #53535C !important;\n              width: 6px;\n              height: 6px;\n              border: 1px solid rgba(255, 255, 255, 0.5); }\n            :host .cropper .resize.topleft {\n              top: -12px;\n              left: -12px;\n              cursor: nw-resize; }\n            :host .cropper .resize.top {\n              top: -12px;\n              left: calc(50% - 12px);\n              cursor: n-resize; }\n            :host .cropper .resize.topright {\n              top: -12px;\n              right: -12px;\n              cursor: ne-resize; }\n            :host .cropper .resize.right {\n              top: calc(50% - 12px);\n              right: -12px;\n              cursor: e-resize; }\n            :host .cropper .resize.bottomright {\n              bottom: -12px;\n              right: -12px;\n              cursor: se-resize; }\n            :host .cropper .resize.bottom {\n              bottom: -12px;\n              left: calc(50% - 12px);\n              cursor: s-resize; }\n            :host .cropper .resize.bottomleft {\n              bottom: -12px;\n              left: -12px;\n              cursor: sw-resize; }\n            :host .cropper .resize.left {\n              top: calc(50% - 12px);\n              left: -12px;\n              cursor: w-resize; }\n          :host .cropper .resize-bar {\n            position: absolute;\n            z-index: 1; }\n            :host .cropper .resize-bar.top {\n              top: -11px;\n              left: 11px;\n              width: calc(100% - 22px);\n              height: 22px;\n              cursor: n-resize; }\n            :host .cropper .resize-bar.right {\n              top: 11px;\n              right: -11px;\n              height: calc(100% - 22px);\n              width: 22px;\n              cursor: e-resize; }\n            :host .cropper .resize-bar.bottom {\n              bottom: -11px;\n              left: 11px;\n              width: calc(100% - 22px);\n              height: 22px;\n              cursor: s-resize; }\n            :host .cropper .resize-bar.left {\n              top: 11px;\n              left: -11px;\n              height: calc(100% - 22px);\n              width: 22px;\n              cursor: w-resize; }\n    "],changeDetection:e.ChangeDetectionStrategy.OnPush}]}],s.ctorParameters=function(){return[{type:e.ElementRef},{type:r.DomSanitizer},{type:e.ChangeDetectorRef}]},s.propDecorators={imageChangedEvent:[{type:e.Input}],imageBase64:[{type:e.Input}],format:[{type:e.Input}],maintainAspectRatio:[{type:e.Input}],aspectRatio:[{type:e.Input}],resizeToWidth:[{type:e.Input}],onlyScaleDown:[{type:e.Input}],imageQuality:[{type:e.Input}],cropper:[{type:e.Input}],imageCropped:[{type:e.Output}],imageLoaded:[{type:e.Output}],loadImageFailed:[{type:e.Output}],imageResizedInView:[{type:e.HostListener,args:["window:resize",["$event"]]}],moveImg:[{type:e.HostListener,args:["document:mousemove",["$event"]]},{type:e.HostListener,args:["document:touchmove",["$event"]]}],moveStop:[{type:e.HostListener,args:["document:mouseup",["$event"]]},{type:e.HostListener,args:["document:touchend",["$event"]]}]};var o=function(){return function(){}}();o.decorators=[{type:e.NgModule,args:[{imports:[i.CommonModule],declarations:[s],exports:[s]}]}],o.ctorParameters=function(){return[]},t.ImageCropperModule=o,t.ImageCropperComponent=s,Object.defineProperty(t,"__esModule",{value:!0})});
//# sourceMappingURL=ngx-image-cropper.umd.min.js.map
