import {Directive, ElementRef, Input, OnChanges, Renderer2} from '@angular/core';

@Directive({
  selector: '[appBase64ImagePreview]'
})

export class Base64ImagePreviewDirective implements OnChanges {
  public imageElem;
  @Input() base64Image;


  constructor(el: ElementRef, public render: Renderer2) {
    this.imageElem = el.nativeElement;
  }

  ngOnChanges() {
    if(this.base64Image){
      this.render.setAttribute(this.imageElem, 'src', 'data:image/png;base64,' + this.base64Image);
    }
  }
}
