import {Directive, ElementRef, EventEmitter, HostListener, OnInit, Output} from '@angular/core';
import {Renderer2} from '@angular/core';

@Directive({
  selector: '[appSquareBase4Directive]'
})
export class Base64FitToSquareDirective implements OnInit {
  public slectedImageBase64: any;
  @Output() onSquerePhotoReady = new EventEmitter();
  public fileInputElemet;

  constructor(public el: ElementRef, public render: Renderer2) {
    this.fileInputElemet = el.nativeElement;
  }


  @HostListener('change', ['$event.target.files[0]']) fileUploaded(file: Blob) {
    const reader: FileReader = new FileReader();

    reader.onloadend = e => {
      this.slectedImageBase64 = reader.result;
      this.resizePicture();
    };
    reader.readAsDataURL(file);
  }


  resizePicture() {
    const canvas = this.render.createElement('canvas');
    const context = canvas.getContext('2d');
    const selectedImage = this.render.createElement('img');
    const c = this;

    canvas.height = 400;
    canvas.width = 400;

    this.render.setAttribute(selectedImage, 'src', this.slectedImageBase64);

    selectedImage.onload = function () {

      const nauturalSize = {
        width: this.width,
        height: this.height
      };

      if (nauturalSize.width < nauturalSize.height) {
        const widthToDraw = 400 * nauturalSize.width / nauturalSize.height;

        const paddingLeft = (400 - widthToDraw) / 2;
        context.drawImage(selectedImage, paddingLeft, 0, widthToDraw, 400);

      } else {
        const heightToDraw = 400 * nauturalSize.height / nauturalSize.width;
        const paddingTop = (400 - heightToDraw) / 2;

        context.drawImage(selectedImage, 0, paddingTop, 400, heightToDraw);
      }
      const resultAsBase64 = canvas.toDataURL('img/png').replace(/^data:image\/[a-z]+;base64,/, '');
      c.onSquerePhotoReady.emit(resultAsBase64);
      ;
    };
  }

  ngOnInit() {
    this.render.setAttribute(this.fileInputElemet, 'type', 'file');
    this.render.setAttribute(this.fileInputElemet, 'accept', 'image/*');
  }

}
