import {Directive, EventEmitter, Output, HostListener, Renderer2, ElementRef, OnInit} from '@angular/core';

@Directive({
  selector: '[appBase64FilePicker]'
})
export class Base64FilePickerDirective implements OnInit {
  public inputElem;
  @Output() onBase64Ready = new EventEmitter();

  constructor(public el: ElementRef, public rendere: Renderer2) {
    this.inputElem = el.nativeElement;
    this.rendere.setStyle(this.inputElem, 'display', 'none');
  }

  @HostListener('change', ['$event.target.files[0]']) readFile(file: any) {
    const myReader: FileReader = new FileReader();
    myReader.onloadend = e => {
      this.onBase64Ready.emit(myReader.result.replace(/^data:image\/[a-z]+;base64,/, ''));
    };
    myReader.readAsDataURL(file);

  }

  ngOnInit() {
    this.rendere.setAttribute(this.inputElem, 'type', 'file');
    this.rendere.setAttribute(this.inputElem, 'accept', 'image/*');
  }
}
