import { ECalendarValue } from '../common/types/calendar-value-enum';
import { SingleCalendarValue } from '../common/types/single-calendar-value';
import { ChangeDetectorRef, EventEmitter, OnChanges, OnInit, SimpleChanges } from '@angular/core';
import { TimeSelectService, TimeUnit } from './time-select.service';
import { Moment } from 'jalali-moment';
import { ITimeSelectConfig, ITimeSelectConfigInternal } from './time-select-config.model';
import { ControlValueAccessor, FormControl, ValidationErrors, Validator } from '@angular/forms';
import { CalendarValue } from '../common/types/calendar-value';
import { UtilsService } from '../common/services/utils/utils.service';
import { IDate } from '../common/models/date.model';
import { DateValidator } from '../common/types/validator.type';
export declare class TimeSelectComponent implements OnInit, OnChanges, ControlValueAccessor, Validator {
    timeSelectService: TimeSelectService;
    utilsService: UtilsService;
    cd: ChangeDetectorRef;
    config: ITimeSelectConfig;
    displayDate: SingleCalendarValue;
    minDate: SingleCalendarValue;
    maxDate: SingleCalendarValue;
    minTime: SingleCalendarValue;
    maxTime: SingleCalendarValue;
    theme: string;
    onChange: EventEmitter<IDate>;
    isInited: boolean;
    componentConfig: ITimeSelectConfigInternal;
    _selected: Moment;
    inputValue: CalendarValue;
    inputValueType: ECalendarValue;
    validateFn: DateValidator;
    hours: string;
    minutes: string;
    seconds: string;
    meridiem: string;
    showDecHour: boolean;
    showDecMinute: boolean;
    showDecSecond: boolean;
    showIncHour: boolean;
    showIncMinute: boolean;
    showIncSecond: boolean;
    showToggleMeridiem: boolean;
    selected: Moment;
    api: {
        triggerChange: any;
    };
    constructor(timeSelectService: TimeSelectService, utilsService: UtilsService, cd: ChangeDetectorRef);
    ngOnInit(): void;
    init(): void;
    ngOnChanges(changes: SimpleChanges): void;
    writeValue(value: CalendarValue): void;
    registerOnChange(fn: any): void;
    onChangeCallback(_: any): void;
    registerOnTouched(fn: any): void;
    validate(formControl: FormControl): ValidationErrors | any;
    processOnChangeCallback(value: Moment): CalendarValue;
    initValidators(): void;
    decrease(unit: TimeUnit): void;
    increase(unit: TimeUnit): void;
    toggleMeridiem(): void;
    emitChange(): void;
    calculateTimeParts(time: Moment): void;
}
