var assert = require('assert');
var compare = require('..');

describe('greater than', function () {
    it('should evaluate to greater than (1)', function () {
        [
            ['0.1.20', '0.1.5'],
            ['0.6.1-1', '0.6.1-0'],
            ['0.7.x', '0.6.0'],
            ['0.7.x', '0.6.0-asdf'],
            ['0.7.x', '0.6.2'],
            ['0.7.x', '0.7.0-asdf'],
            ['1', '0.0.0-beta'],
            ['1', '0.2.3'],
            ['1', '0.2.4'],
            ['1', '1.0.0-0'],
            ['1', '1.0.0-beta'],
            ['1.0', '0.0.0'],
            ['1.0', '0.1.0'],
            ['1.0', '0.1.2'],
            ['1.0.0', '0.0.0'],
            ['1.0.0', '0.0.1'],
            ['1.0.0', '0.2.3'],
            ['1.0.0-beta.2', '1.0.0-beta.1'],
            ['1.2.*', '1.1.3'],
            ['1.2.*', '1.1.9999'],
            ['1.2.2', '1.2.1'],
            ['1.2.x', '1.0.0'],
            ['1.2.x', '1.1.0'],
            ['1.2.x', '1.1.3'],
            ['2', '1.0.0'],
            ['2', '1.0.0-beta'],
            ['2', '1.9999.9999'],
            ['2.*.*', '1.0.1'],
            ['2.*.*', '1.1.3'],
            ['2.0.0', '1.0.0'],
            ['2.0.0', '1.1.1'],
            ['2.0.0', '1.2.9'],
            ['2.0.0', '1.9999.9999'],
            ['2.3', '2.2.1'],
            ['2.3', '2.2.2'],
            ['2.4', '2.3.0'],
            ['2.4', '2.3.5'],
            ['2.x.x', '1.0.0'],
            ['2.x.x', '1.1.3'],
            ['3.2.1', '2.3.2'],
            ['3.2.1', '3.2.0'],
            ['v0.5.4-pre', '0.5.4-alpha'],
            ['v3.2.1', 'v2.3.2']
        ].forEach(function (tuple) {
            var v1 = tuple[0];
            var v2 = tuple[1];
            var msg = 'compare(' + v1 + ', ' + v2 + ')';
            assert.equal(compare(v1, v2), 1, msg);
        });
    });
});