import { Observable } from 'rxjs/Observable';
import { ShareButtonRef } from './share.models';
/**
 * Meta tags operator - Serialize meta tags into the sharer URL
 */
export declare const metaTagsOperators: ((source: Observable<ShareButtonRef>) => Observable<string>)[];
/**
 * Print button operator
 */
export declare const printOperators: ((source: Observable<{}>) => Observable<void>)[];
/**
 * Copy link to clipboard, used for copy button
 */
export declare const copyOperators: (((source: Observable<{}>) => Observable<{}>) | ((source: Observable<ShareButtonRef>) => Observable<void>))[];
/**
 * Add the share URL to message body, used for WhatsApp and Email buttons
 */
export declare const urlInMessageOperators: ((source: Observable<ShareButtonRef>) => Observable<any>)[];
export declare const FacebookCountOperators: ((source: Observable<any>) => Observable<number>)[];
export declare const PinterestCountOperators: ((source: Observable<string>) => Observable<any>)[];
export declare const TumblrCountOperators: ((source: Observable<any>) => Observable<number>)[];
export declare const RedditCountOperators: ((source: Observable<any>) => Observable<number>)[];
