(function (global, factory) {
	typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('@angular/core'), require('rxjs/operators/map'), require('rxjs/operators/delay'), require('@fortawesome/free-brands-svg-icons'), require('@fortawesome/free-solid-svg-icons'), require('rxjs/BehaviorSubject'), require('@angular/common'), require('@angular/common/http'), require('rxjs/operators/catchError'), require('rxjs/operators/take'), require('rxjs/operators/switchMap'), require('rxjs/operators/tap'), require('rxjs/operators/filter'), require('rxjs/observable/empty'), require('rxjs/observable/of')) :
	typeof define === 'function' && define.amd ? define('@ngx-share/core', ['exports', '@angular/core', 'rxjs/operators/map', 'rxjs/operators/delay', '@fortawesome/free-brands-svg-icons', '@fortawesome/free-solid-svg-icons', 'rxjs/BehaviorSubject', '@angular/common', '@angular/common/http', 'rxjs/operators/catchError', 'rxjs/operators/take', 'rxjs/operators/switchMap', 'rxjs/operators/tap', 'rxjs/operators/filter', 'rxjs/observable/empty', 'rxjs/observable/of'], factory) :
	(factory((global['ngx-share'] = global['ngx-share'] || {}, global['ngx-share'].core = {}),global.ng.core,global.Rx.Observable.prototype,global.Rx.Observable.prototype,global.freeBrandsSvgIcons,global.freeSolidSvgIcons,global.Rx,global.ng.common,global.ng.common.http,global.Rx.Observable.prototype,global.Rx.Observable.prototype,global.Rx.Observable.prototype,global.Rx.Observable.prototype,global.Rx.Observable.prototype,global.Rx.Observable,global.Rx.Observable));
}(this, (function (exports,core,map,delay,freeBrandsSvgIcons,freeSolidSvgIcons,BehaviorSubject,common,http,catchError,take,switchMap,tap,filter,empty,of) { 'use strict';

/*! *****************************************************************************
Copyright (c) Microsoft Corporation. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License"); you may not use
this file except in compliance with the License. You may obtain a copy of the
License at http://www.apache.org/licenses/LICENSE-2.0
THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED
WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,
MERCHANTABLITY OR NON-INFRINGEMENT.
See the Apache Version 2.0 License for specific language governing permissions
and limitations under the License.
***************************************************************************** */
/* global Reflect, Promise */










function __read(o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
}
function __spread() {
    for (var ar = [], i = 0; i < arguments.length; i++)
        ar = ar.concat(__read(arguments[i]));
    return ar;
}

var CONFIG = new core.InjectionToken('CONFIG');
function isObject(item) {
    return (item && typeof item === 'object' && !Array.isArray(item));
}
function mergeDeep(target) {
    var sources = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        sources[_i - 1] = arguments[_i];
    }
    if (!sources.length) {
        return target;
    }
    var source = sources.shift();
    if (isObject(target) && isObject(source)) {
        for (var key in source) {
            if (isObject(source[key])) {
                if (!target[key]) {
                    Object.assign(target, (_a = {}, _a[key] = {}, _a));
                }
                mergeDeep(target[key], source[key]);
            }
            else {
                Object.assign(target, (_b = {}, _b[key] = source[key], _b));
            }
        }
    }
    return mergeDeep.apply(void 0, __spread([target], sources));
    var _a, _b;
}
function shareCountFormatter(num, digits) {
    var si = [
        { value: 1E9, symbol: 'B' },
        { value: 1E6, symbol: 'M' },
        { value: 1E3, symbol: 'K' }
    ], rx = /\.0+$|(\.[0-9]*[1-9])0+$/;
    for (var i = 0; i < si.length; i++) {
        if (num >= si[i].value) {
            return (num / si[i].value).toFixed(digits).replace(rx, '$1') + si[i].symbol;
        }
    }
    return num.toFixed(digits).replace(rx, '$1');
}
function copyToClipboard(text, ios) {
    return new Promise(function (resolve) {
        var textArea = document.createElement('textarea');
        textArea.value = text;
        document.body.appendChild(textArea);
        if (ios) {
            var range = document.createRange();
            range.selectNodeContents(textArea);
            var selection = window.getSelection();
            selection.removeAllRanges();
            selection.addRange(range);
            textArea.readOnly = true;
            textArea.setSelectionRange(0, 999999);
        }
        else {
            textArea.select();
        }
        document.execCommand('copy');
        document.body.removeChild(textArea);
        resolve();
    });
}
function getMetaContent(key) {
    var metaTag = document.querySelector("meta[property=\"" + key + "\"]");
    return metaTag ? metaTag.getAttribute('content') : undefined;
}
function getOS() {
    var userAgent = navigator.userAgent || navigator.vendor || ((window)).opera;
    if (/android/i.test(userAgent)) {
        return 'android';
    }
    if (/iPad|iPhone|iPod/.test(userAgent) && !((window)).MSStream) {
        return 'ios';
    }
    return 'desktop';
}
function getValidUrl(url, fallbackUrl) {
    if (url) {
        var r = /(http|https):\/\/(\w+:{0,1}\w*@)?(\S+)(:[0-9]+)?(\/|\/([\w#!:.?+=&%@!\-\/]))?/;
        if (r.test(url)) {
            return url;
        }
        console.warn("[ShareButtons]: Sharing link '" + url + "' is invalid!");
    }
    return fallbackUrl;
}
var metaTagsOperators = [
    map.map(function (ref) {
        var SharerURL = ref.prop.share[ref.os];
        if (SharerURL) {
            var metaTags = ref.prop.share.metaTags;
            var metaTagsValues_1 = ref.metaTags;
            var link = '';
            if (metaTags) {
                link = Object.entries(metaTags).map(function (_a) {
                    var _b = __read(_a, 2), key = _b[0], metaTag = _b[1];
                    return metaTagsValues_1[key] ? metaTag + "=" + encodeURIComponent(metaTagsValues_1[key]) : '';
                }).join('&');
            }
            return SharerURL + link;
        }
        return;
    })
];
var printOperators = [
    map.map(function () { return window.print(); })
];
var copyOperators = [
    map.map(function (ref) {
        ref.renderer.setStyle(ref.el, 'pointer-events', 'none');
        ref.temp = { text: ref.prop.text, icon: ref.prop.icon };
        var link = decodeURIComponent(ref.metaTags.url);
        copyToClipboard(link, ref.os === 'ios')
            .then(function () {
            ref.prop.text = ref.prop.successText;
            ref.prop.icon = ref.prop.successIcon;
        })
            .catch(function () {
            ref.prop.text = ref.prop.failText;
            ref.prop.icon = ref.prop.failIcon;
        })
            .then(function () { return ref.cd.markForCheck(); });
        return ref;
    }),
    delay.delay(2000),
    map.map(function (ref) {
        ref.renderer.setStyle(ref.el, 'pointer-events', 'auto');
        ref.prop.text = ref.temp.text;
        ref.prop.icon = ref.temp.icon;
        ref.cd.markForCheck();
    })
];
var urlInMessageOperators = [
    map.map(function (ref) {
        var description = ref.metaTags.description;
        var url = ref.metaTags.url;
        var newRef = {
            metaTags: {
                description: description ? description + "\r\n" + url : url
            }
        };
        return mergeDeep(ref, newRef);
    })
];
var FacebookCountOperators = [
    map.map(function (res) { return +res.share.share_count; })
];
var PinterestCountOperators = [
    map.map(function (text) { return JSON.parse(text.replace(/^receiveCount\((.*)\)/, '$1')); }),
    map.map(function (res) { return +res.count; })
];
var TumblrCountOperators = [
    map.map(function (res) { return +res.response.note_count; })
];
var RedditCountOperators = [
    map.map(function (res) { return +res.data.children[0].data.score; })
];
var shareButtonsProp = {
    facebook: {
        type: 'facebook',
        text: 'Facebook',
        icon: freeBrandsSvgIcons.faFacebookF,
        color: '#4267B2',
        share: {
            desktop: 'https://www.facebook.com/sharer/sharer.php?',
            android: 'https://www.facebook.com/sharer/sharer.php?',
            ios: 'https://www.facebook.com/sharer/sharer.php?',
            operators: metaTagsOperators,
            metaTags: {
                url: 'u'
            }
        },
        count: {
            request: 'http',
            url: 'https://graph.facebook.com?id=',
            operators: FacebookCountOperators
        }
    },
    twitter: {
        type: 'twitter',
        text: 'Twitter',
        icon: freeBrandsSvgIcons.faTwitter,
        color: '#00acee',
        share: {
            desktop: 'https://twitter.com/intent/tweet?',
            android: 'https://twitter.com/intent/tweet?',
            ios: 'https://twitter.com/intent/tweet?',
            operators: metaTagsOperators,
            metaTags: {
                url: 'url',
                description: 'text',
                tags: 'hashtags',
                via: 'via'
            }
        }
    },
    google: {
        type: 'google',
        text: 'Google+',
        icon: freeBrandsSvgIcons.faGooglePlusG,
        color: '#DB4437',
        share: {
            desktop: 'https://plus.google.com/share?',
            android: 'https://plus.google.com/share?',
            ios: 'https://plus.google.com/share?',
            metaTags: {
                url: 'url',
            },
            operators: metaTagsOperators
        }
    },
    linkedin: {
        type: 'linkedin',
        text: 'LinkedIn',
        icon: freeBrandsSvgIcons.faLinkedinIn,
        color: '#006fa6',
        share: {
            desktop: 'http://www.linkedin.com/shareArticle?',
            android: 'http://www.linkedin.com/shareArticle?',
            ios: 'http://www.linkedin.com/shareArticle?',
            operators: metaTagsOperators,
            metaTags: {
                url: 'url',
                title: 'title',
                description: 'summary'
            },
        }
    },
    pinterest: {
        type: 'pinterest',
        text: 'Pinterest',
        icon: freeBrandsSvgIcons.faPinterestP,
        color: '#BD091D',
        share: {
            desktop: 'https://in.pinterest.com/pin/create/button/?',
            android: 'https://in.pinterest.com/pin/create/button/?',
            ios: 'https://in.pinterest.com/pin/create/button/?',
            operators: metaTagsOperators,
            metaTags: {
                url: 'url',
                description: 'description',
                image: 'media'
            }
        },
        count: {
            request: 'http',
            url: 'https://api.pinterest.com/v1/urls/count.json?url=',
            args: { responseType: 'text' },
            operators: PinterestCountOperators
        }
    },
    reddit: {
        type: 'reddit',
        text: 'Reddit',
        icon: freeBrandsSvgIcons.faRedditAlien,
        color: '#FF4006',
        share: {
            desktop: 'http://www.reddit.com/submit?',
            android: 'http://www.reddit.com/submit?',
            ios: 'http://www.reddit.com/submit?',
            operators: metaTagsOperators,
            metaTags: {
                url: 'url',
                title: 'title'
            },
        },
        count: {
            request: 'http',
            url: 'https://buttons.reddit.com/button_info.json?url=',
            operators: RedditCountOperators
        },
    },
    tumblr: {
        type: 'tumblr',
        text: 'Tumblr',
        icon: freeBrandsSvgIcons.faTumblr,
        color: '#36465D',
        share: {
            desktop: 'http://tumblr.com/widgets/share/tool?',
            android: 'http://tumblr.com/widgets/share/tool?',
            ios: 'http://tumblr.com/widgets/share/tool?',
            operators: metaTagsOperators,
            metaTags: {
                url: 'canonicalUrl',
                description: 'caption',
                tags: 'tags'
            }
        },
        count: {
            request: 'jsonp',
            url: 'https://api.tumblr.com/v2/share/stats?url=',
            operators: TumblrCountOperators
        }
    },
    whatsapp: {
        type: 'whatsapp',
        text: 'WhatsApp',
        icon: freeBrandsSvgIcons.faWhatsapp,
        color: '#25D366',
        share: {
            desktop: 'https://web.whatsapp.com/send?',
            android: 'whatsapp://send?',
            ios: 'whatsapp://send?',
            operators: __spread(urlInMessageOperators, metaTagsOperators),
            metaTags: {
                description: 'text'
            }
        }
    },
    messenger: {
        type: 'messenger',
        text: 'Messenger',
        icon: freeBrandsSvgIcons.faFacebookMessenger,
        color: '#0080FF',
        share: {
            android: 'fb-messenger://share/?',
            ios: 'fb-messenger://share/?',
            operators: metaTagsOperators,
            metaTags: {
                url: 'link'
            }
        }
    },
    telegram: {
        type: 'telegram',
        text: 'Telegram',
        icon: freeBrandsSvgIcons.faTelegramPlane,
        color: '#0088cc',
        share: {
            desktop: 'https://t.me/share/url?',
            android: 'https://t.me/share/url?',
            ios: 'https://t.me/share/url?',
            operators: metaTagsOperators,
            metaTags: {
                url: 'url',
                description: 'text'
            }
        }
    },
    vk: {
        type: 'vk',
        text: 'VKontakte',
        icon: freeBrandsSvgIcons.faVk,
        color: '#4C75A3',
        share: {
            desktop: 'http://vk.com/share.php?',
            android: 'http://vk.com/share.php?',
            ios: 'http://vk.com/share.php?',
            operators: metaTagsOperators,
            metaTags: {
                url: 'url'
            }
        }
    },
    stumble: {
        type: 'stumble',
        text: 'Stumble',
        icon: freeBrandsSvgIcons.faStumbleupon,
        color: '#eb4924',
        share: {
            desktop: 'http://www.stumbleupon.com/submit?',
            android: 'http://www.stumbleupon.com/submit?',
            ios: 'http://www.stumbleupon.com/submit?',
            operators: metaTagsOperators,
            metaTags: {
                url: 'url'
            }
        }
    },
    xing: {
        type: 'xing',
        text: 'Xing',
        icon: freeBrandsSvgIcons.faXing,
        color: '#006567',
        share: {
            desktop: 'https://www.xing.com/app/user?op=share&',
            android: 'https://www.xing.com/app/user?op=share&',
            ios: 'https://www.xing.com/app/user?op=share&',
            operators: metaTagsOperators,
            metaTags: {
                url: 'url'
            }
        }
    },
    sms: {
        type: 'sms',
        text: 'SMS',
        icon: freeSolidSvgIcons.faCommentAlt,
        color: '#20c16c',
        share: {
            desktop: 'sms:?',
            android: 'sms:?',
            ios: 'sms:?',
            metaTags: {
                description: 'body'
            },
            operators: __spread(urlInMessageOperators, metaTagsOperators)
        }
    },
    email: {
        type: 'email',
        text: 'Email',
        icon: freeSolidSvgIcons.faEnvelope,
        color: '#FF961C',
        share: {
            desktop: 'mailto:?',
            android: 'mailto:?',
            ios: 'mailto:?',
            operators: __spread(urlInMessageOperators, metaTagsOperators),
            metaTags: {
                title: 'subject',
                description: 'body'
            }
        }
    },
    copy: {
        type: 'copy',
        text: 'Copy link',
        successText: 'Copied',
        successIcon: freeSolidSvgIcons.faCheck,
        failText: 'Error',
        failIcon: freeSolidSvgIcons.faExclamation,
        icon: freeSolidSvgIcons.faLink,
        color: '#607D8B',
        share: {
            operators: copyOperators
        }
    },
    print: {
        type: 'print',
        text: 'Print',
        icon: freeSolidSvgIcons.faPrint,
        color: '#765AA2',
        share: {
            operators: printOperators
        }
    }
};
var ShareButtons = (function () {
    function ShareButtons(config) {
        this.config = {
            prop: shareButtonsProp,
            options: {
                theme: 'default',
                include: [],
                exclude: [],
                size: 0,
                url: undefined,
                title: undefined,
                description: undefined,
                image: undefined,
                tags: undefined,
                twitterAccount: undefined,
                autoSetMeta: true,
                gaTracking: false,
                windowWidth: 800,
                windowHeight: 500
            }
        };
        this.config$ = new BehaviorSubject.BehaviorSubject(this.config);
        if (config) {
            this.setConfig(config);
        }
    }
    Object.defineProperty(ShareButtons.prototype, "prop", {
        get: function () {
            return this.config.prop;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ShareButtons.prototype, "twitterAccount", {
        get: function () {
            return this.config.options.twitterAccount;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ShareButtons.prototype, "theme", {
        get: function () {
            return this.config.options.theme;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ShareButtons.prototype, "windowSize", {
        get: function () {
            return "width=" + this.config.options.windowWidth + ", height=" + this.config.options.windowHeight;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ShareButtons.prototype, "url", {
        get: function () {
            return this.config.options.url;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ShareButtons.prototype, "title", {
        get: function () {
            return this.config.options.title;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ShareButtons.prototype, "description", {
        get: function () {
            return this.config.options.description;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ShareButtons.prototype, "image", {
        get: function () {
            return this.config.options.image;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ShareButtons.prototype, "tags", {
        get: function () {
            return this.config.options.tags;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ShareButtons.prototype, "autoSetMeta", {
        get: function () {
            return this.config.options.autoSetMeta;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ShareButtons.prototype, "gaTracking", {
        get: function () {
            return this.config.options.gaTracking;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ShareButtons.prototype, "size", {
        get: function () {
            return this.config.options.size;
        },
        enumerable: true,
        configurable: true
    });
    ShareButtons.prototype.setConfig = function (config) {
        this.config = mergeDeep(this.config, config);
        this.config$.next(this.config);
    };
    ShareButtons.prototype.addButton = function (name, data) {
        var config = {
            prop: Object.assign({}, shareButtonsProp, (_a = {}, _a[name] = data, _a))
        };
        this.setConfig(config);
        var _a;
    };
    return ShareButtons;
}());
ShareButtons.decorators = [
    { type: core.Injectable },
];
ShareButtons.ctorParameters = function () { return [
    { type: undefined, decorators: [{ type: core.Inject, args: [CONFIG,] },] },
]; };
var ShareButtonDirective = (function () {
    function ShareButtonDirective(shareService, http$$1, renderer, cd, el, platform) {
        this.shareService = shareService;
        this.http = http$$1;
        this.renderer = renderer;
        this.cd = cd;
        this.el = el;
        this.platform = platform;
        this.getCount = false;
        this.autoSetMeta = this.shareService.autoSetMeta;
        this.url = this.shareService.url;
        this.title = this.shareService.title;
        this.description = this.shareService.description;
        this.image = this.shareService.image;
        this.tags = this.shareService.tags;
        this.count = new core.EventEmitter();
        this.opened = new core.EventEmitter();
        this.closed = new core.EventEmitter();
    }
    ShareButtonDirective.prototype.onClick = function () {
        var _this = this;
        if (common.isPlatformBrowser(this.platform)) {
            var metaTags = this.autoSetMeta ? {
                url: this.url,
                title: this.title || getMetaContent('og:title'),
                description: this.description || getMetaContent('og:description'),
                image: this.image || getMetaContent('og:image'),
                via: this.shareService.twitterAccount || getMetaContent('twitter:site'),
                tags: this.tags,
            } : {
                url: this.url,
                title: this.title,
                description: this.description,
                image: this.image,
                tags: this.tags,
                via: this.shareService.twitterAccount,
            };
            var ref = {
                cd: this.cd,
                renderer: this.renderer,
                prop: this.prop,
                el: this.el.nativeElement,
                os: getOS(),
                metaTags: metaTags
            };
            (_a = of.of(ref)).pipe.apply(_a, __spread(this.prop.share.operators, [tap.tap(function (sharerURL) { return _this.share(sharerURL); }), take.take(1)])).subscribe();
        }
        var _a;
    };
    ShareButtonDirective.prototype.ngOnChanges = function (changes) {
        var _this = this;
        if (common.isPlatformBrowser(this.platform)) {
            if (changes['shareButton'] && (changes['shareButton'].firstChange || changes['shareButton'].previousValue !== this.shareButton)) {
                this.createShareButton(this.shareButton);
            }
            if (!this.url || (changes['url'] && changes['url'].previousValue !== this.url)) {
                of.of(null).pipe(map.map(function () {
                    _this.url = getValidUrl(_this.autoSetMeta ? _this.url || getMetaContent('og:url') : _this.url, window.location.href);
                    return _this.url;
                }), filter.filter(function () { return _this.prop.count && _this.getCount; }), switchMap.switchMap(function (url) { return _this.shareCount(url); }), tap.tap(function (shareCount) { return _this.count.emit(shareCount); }), take.take(1)).subscribe();
            }
        }
    };
    ShareButtonDirective.prototype.share = function (url) {
        var _this = this;
        if (url) {
            if (this.shareService.gaTracking && typeof ga !== 'undefined') {
                ga('send', 'social', this.prop.type, 'click', this.url);
            }
            this.opened.emit(this.prop.type);
            var popUp_1 = window.open(url, 'newwindow', this.shareService.windowSize);
            if (popUp_1) {
                var pollTimer_1 = window.setInterval(function () {
                    if (popUp_1.closed) {
                        window.clearInterval(pollTimer_1);
                        _this.closed.emit(_this.prop.type);
                    }
                }, 200);
            }
        }
    };
    ShareButtonDirective.prototype.shareCount = function (url) {
        if (this.prop.count.request === 'jsonp') {
            return (_a = this.http.jsonp(this.prop.count.url + url, 'callback')).pipe.apply(_a, __spread(this.prop.count.operators, [catchError.catchError(function () { return empty.empty(); })]));
        }
        else {
            return (_b = this.http.get(this.prop.count.url + url, this.prop.count.args)).pipe.apply(_b, __spread(this.prop.count.operators, [catchError.catchError(function () { return empty.empty(); })]));
        }
        var _a, _b;
    };
    ShareButtonDirective.prototype.createShareButton = function (buttonsName) {
        var button = Object.assign({}, this.shareService.prop[buttonsName]);
        if (button) {
            this.prop = button;
            this.renderer.removeClass(this.el.nativeElement, "sb-" + this.buttonClass);
            this.renderer.addClass(this.el.nativeElement, "sb-" + button.type);
            this.el.nativeElement.style.setProperty('--button-color', this.prop.color);
            this.buttonClass = button.type;
        }
        else {
            throw new Error("[ShareButtons]: The share button '" + buttonsName + "' does not exist!");
        }
    };
    return ShareButtonDirective;
}());
ShareButtonDirective.decorators = [
    { type: core.Directive, args: [{
                selector: '[shareButton]'
            },] },
];
ShareButtonDirective.ctorParameters = function () { return [
    { type: ShareButtons, },
    { type: http.HttpClient, },
    { type: core.Renderer2, },
    { type: core.ChangeDetectorRef, },
    { type: core.ElementRef, },
    { type: Object, decorators: [{ type: core.Inject, args: [core.PLATFORM_ID,] },] },
]; };
ShareButtonDirective.propDecorators = {
    "shareButton": [{ type: core.Input },],
    "getCount": [{ type: core.Input },],
    "autoSetMeta": [{ type: core.Input },],
    "url": [{ type: core.Input },],
    "title": [{ type: core.Input },],
    "description": [{ type: core.Input },],
    "image": [{ type: core.Input },],
    "tags": [{ type: core.Input },],
    "count": [{ type: core.Output },],
    "opened": [{ type: core.Output },],
    "closed": [{ type: core.Output },],
    "onClick": [{ type: core.HostListener, args: ['click',] },],
};
var ShareCountPipe = (function () {
    function ShareCountPipe() {
    }
    ShareCountPipe.prototype.transform = function (num, digits) {
        return shareCountFormatter(num, digits);
    };
    return ShareCountPipe;
}());
ShareCountPipe.decorators = [
    { type: core.Pipe, args: [{
                name: 'shareCount'
            },] },
];
ShareCountPipe.ctorParameters = function () { return []; };
function ShareButtonsFactory(config) {
    return new ShareButtons(config);
}
var ShareModule = (function () {
    function ShareModule() {
    }
    ShareModule.forRoot = function (config) {
        return {
            ngModule: ShareModule,
            providers: [
                { provide: CONFIG, useValue: config },
                {
                    provide: ShareButtons,
                    useFactory: ShareButtonsFactory,
                    deps: [CONFIG]
                }
            ]
        };
    };
    return ShareModule;
}());
ShareModule.decorators = [
    { type: core.NgModule, args: [{
                declarations: [
                    ShareButtonDirective,
                    ShareCountPipe
                ],
                exports: [
                    ShareButtonDirective,
                    ShareCountPipe
                ]
            },] },
];
ShareModule.ctorParameters = function () { return []; };

exports.ShareButtonsFactory = ShareButtonsFactory;
exports.ShareModule = ShareModule;
exports.CONFIG = CONFIG;
exports.ShareButtons = ShareButtons;
exports.ShareButtonDirective = ShareButtonDirective;
exports.ShareCountPipe = ShareCountPipe;
exports.shareButtonsProp = shareButtonsProp;
exports.metaTagsOperators = metaTagsOperators;
exports.printOperators = printOperators;
exports.copyOperators = copyOperators;
exports.urlInMessageOperators = urlInMessageOperators;
exports.FacebookCountOperators = FacebookCountOperators;
exports.PinterestCountOperators = PinterestCountOperators;
exports.TumblrCountOperators = TumblrCountOperators;
exports.RedditCountOperators = RedditCountOperators;

Object.defineProperty(exports, '__esModule', { value: true });

})));
//# sourceMappingURL=ngx-share-core.umd.js.map
