import { Component, Input, Output, EventEmitter, ChangeDetectionStrategy, ViewChild, HostBinding, NgModule } from '@angular/core';
import { ShareButtons, ShareButtonDirective, ShareModule, CONFIG } from '@ngx-share/core';
import { CommonModule } from '@angular/common';
import { FontAwesomeModule } from '@fortawesome/angular-fontawesome';

var ShareButtonComponent = (function () {
    function ShareButtonComponent(share) {
        this.share = share;
        this.showIcon = true;
        this.showText = false;
        this.showCount = false;
        this.size = this.share.size;
        this.theme = this.share.theme;
        this.count = new EventEmitter();
        this.opened = new EventEmitter();
        this.closed = new EventEmitter();
    }
    Object.defineProperty(ShareButtonComponent.prototype, "createButton", {
        set: function (button) {
            this.shareCount = 0;
            this.button = button;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ShareButtonComponent.prototype, "setUrl", {
        set: function (url) {
            this.shareCount = 0;
            this.url = url;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ShareButtonComponent.prototype, "buttonClass", {
        get: function () {
            return "sb-button sb-" + this.theme;
        },
        enumerable: true,
        configurable: true
    });
    ShareButtonComponent.prototype.onCount = function (count) {
        this.shareCount = count;
        this.count.emit(count);
    };
    return ShareButtonComponent;
}());
ShareButtonComponent.decorators = [
    { type: Component, args: [{
                selector: 'share-button',
                template: "<button class=\"sb-wrapper\"\n        [shareButton]=\"button\"\n        [url]=\"url\"\n        [image]=\"image\"\n        [title]=\"title\"\n        [description]=\"description\"\n        [tags]=\"tags\"\n        [autoSetMeta]=\"autoSetMeta\"\n        [getCount]=\"showCount\"\n        (opened)=\"opened.emit($event)\"\n        (closed)=\"closed.emit($event)\"\n        (count)=\"onCount($event)\"\n        [class.sb-show-icon]=\"showIcon\"\n        [class.sb-show-text]=\"showText\"\n        [class.sb-show-count]=\"showCount && shareCount\"\n        [style.fontSize.px]=\"(1 + size/20) * 14\">\n  <div class=\"sb-inner\">\n    <div class=\"sb-content\">\n      <!-- BUTTON ICON -->\n      <div *ngIf=\"showIcon && ref.prop\" class=\"sb-icon\">\n        <fa-icon [icon]=\"icon || ref.prop.icon\"></fa-icon>\n      </div>\n      <!-- BUTTON TEXT -->\n      <div *ngIf=\"showText && ref.prop\" class=\"sb-text\">\n        {{ text || ref.prop.text }}\n      </div>\n    </div>\n    <!-- BUTTON COUNT -->\n    <div *ngIf=\"showCount && shareCount\" class=\"sb-count\">\n      <span>{{ shareCount | shareCount }}</span>\n    </div>\n  </div>\n</button>\n",
                changeDetection: ChangeDetectionStrategy.OnPush,
                preserveWhitespaces: false
            },] },
];
ShareButtonComponent.ctorParameters = function () { return [
    { type: ShareButtons, },
]; };
ShareButtonComponent.propDecorators = {
    "createButton": [{ type: Input, args: ['button',] },],
    "setUrl": [{ type: Input, args: ['url',] },],
    "title": [{ type: Input },],
    "description": [{ type: Input },],
    "image": [{ type: Input },],
    "tags": [{ type: Input },],
    "autoSetMeta": [{ type: Input },],
    "showIcon": [{ type: Input },],
    "showText": [{ type: Input },],
    "showCount": [{ type: Input },],
    "text": [{ type: Input },],
    "icon": [{ type: Input },],
    "size": [{ type: Input },],
    "theme": [{ type: Input },],
    "count": [{ type: Output },],
    "opened": [{ type: Output },],
    "closed": [{ type: Output },],
    "buttonClass": [{ type: HostBinding, args: ['class',] },],
    "ref": [{ type: ViewChild, args: [ShareButtonDirective,] },],
};
function ShareButtonsFactory(config) {
    return new ShareButtons(config);
}
var ShareButtonModule = (function () {
    function ShareButtonModule() {
    }
    ShareButtonModule.forRoot = function (config) {
        return {
            ngModule: ShareButtonModule,
            providers: [
                { provide: CONFIG, useValue: config },
                {
                    provide: ShareButtons,
                    useFactory: ShareButtonsFactory,
                    deps: [CONFIG]
                }
            ]
        };
    };
    return ShareButtonModule;
}());
ShareButtonModule.decorators = [
    { type: NgModule, args: [{
                declarations: [
                    ShareButtonComponent
                ],
                imports: [
                    ShareModule,
                    FontAwesomeModule,
                    CommonModule
                ],
                exports: [
                    ShareModule,
                    FontAwesomeModule,
                    ShareButtonComponent
                ]
            },] },
];
ShareButtonModule.ctorParameters = function () { return []; };

export { ShareButtonsFactory, ShareButtonModule, ShareButtonComponent };
//# sourceMappingURL=ngx-share-button.js.map
