import { Component, Input, Output, EventEmitter, ChangeDetectionStrategy, ViewChild, HostBinding, NgModule } from '@angular/core';
import { ShareButtons, ShareButtonDirective, ShareModule, CONFIG } from '@ngx-share/core';
import { CommonModule } from '@angular/common';
import { FontAwesomeModule } from '@fortawesome/angular-fontawesome';

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
class ShareButtonComponent {
    /**
     * @param {?} share
     */
    constructor(share) {
        this.share = share;
        /**
         * Show button icon
         */
        this.showIcon = true;
        /**
         * Show button text
         */
        this.showText = false;
        /**
         * Button share count
         */
        this.showCount = false;
        /**
         * Button size
         */
        this.size = this.share.size;
        /**
         * Button theme
         */
        this.theme = this.share.theme;
        /**
         * Stream that emits when share count is fetched
         */
        this.count = new EventEmitter();
        /**
         * Stream that emits when share dialog is opened
         */
        this.opened = new EventEmitter();
        /**
         * Stream that emits when share dialog is closed
         */
        this.closed = new EventEmitter();
    }
    /**
     * @param {?} button
     * @return {?}
     */
    set createButton(button) {
        this.shareCount = 0;
        this.button = button;
    }
    /**
     * Share URL
     * @param {?} url
     * @return {?}
     */
    set setUrl(url) {
        this.shareCount = 0;
        this.url = url;
    }
    /**
     * Set theme as button class
     * @return {?}
     */
    get buttonClass() {
        return `sb-button sb-${this.theme}`;
    }
    /**
     * @param {?} count
     * @return {?}
     */
    onCount(count) {
        this.shareCount = count;
        this.count.emit(count);
    }
}
ShareButtonComponent.decorators = [
    { type: Component, args: [{
                selector: 'share-button',
                template: `<button class="sb-wrapper"
        [shareButton]="button"
        [url]="url"
        [image]="image"
        [title]="title"
        [description]="description"
        [tags]="tags"
        [autoSetMeta]="autoSetMeta"
        [getCount]="showCount"
        (opened)="opened.emit($event)"
        (closed)="closed.emit($event)"
        (count)="onCount($event)"
        [class.sb-show-icon]="showIcon"
        [class.sb-show-text]="showText"
        [class.sb-show-count]="showCount && shareCount"
        [style.fontSize.px]="(1 + size/20) * 14">
  <div class="sb-inner">
    <div class="sb-content">
      <!-- BUTTON ICON -->
      <div *ngIf="showIcon && ref.prop" class="sb-icon">
        <fa-icon [icon]="icon || ref.prop.icon"></fa-icon>
      </div>
      <!-- BUTTON TEXT -->
      <div *ngIf="showText && ref.prop" class="sb-text">
        {{ text || ref.prop.text }}
      </div>
    </div>
    <!-- BUTTON COUNT -->
    <div *ngIf="showCount && shareCount" class="sb-count">
      <span>{{ shareCount | shareCount }}</span>
    </div>
  </div>
</button>
`,
                changeDetection: ChangeDetectionStrategy.OnPush,
                preserveWhitespaces: false
            },] },
];
/** @nocollapse */
ShareButtonComponent.ctorParameters = () => [
    { type: ShareButtons, },
];
ShareButtonComponent.propDecorators = {
    "createButton": [{ type: Input, args: ['button',] },],
    "setUrl": [{ type: Input, args: ['url',] },],
    "title": [{ type: Input },],
    "description": [{ type: Input },],
    "image": [{ type: Input },],
    "tags": [{ type: Input },],
    "autoSetMeta": [{ type: Input },],
    "showIcon": [{ type: Input },],
    "showText": [{ type: Input },],
    "showCount": [{ type: Input },],
    "text": [{ type: Input },],
    "icon": [{ type: Input },],
    "size": [{ type: Input },],
    "theme": [{ type: Input },],
    "count": [{ type: Output },],
    "opened": [{ type: Output },],
    "closed": [{ type: Output },],
    "buttonClass": [{ type: HostBinding, args: ['class',] },],
    "ref": [{ type: ViewChild, args: [ShareButtonDirective,] },],
};

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
/**
 * @param {?} config
 * @return {?}
 */
function ShareButtonsFactory(config) {
    return new ShareButtons(config);
}
class ShareButtonModule {
    /**
     * @param {?=} config
     * @return {?}
     */
    static forRoot(config) {
        return {
            ngModule: ShareButtonModule,
            providers: [
                { provide: CONFIG, useValue: config },
                {
                    provide: ShareButtons,
                    useFactory: ShareButtonsFactory,
                    deps: [CONFIG]
                }
            ]
        };
    }
}
ShareButtonModule.decorators = [
    { type: NgModule, args: [{
                declarations: [
                    ShareButtonComponent
                ],
                imports: [
                    ShareModule,
                    FontAwesomeModule,
                    CommonModule
                ],
                exports: [
                    ShareModule,
                    FontAwesomeModule,
                    ShareButtonComponent
                ]
            },] },
];
/** @nocollapse */
ShareButtonModule.ctorParameters = () => [];

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
/**
 * Generated bundle index. Do not edit.
 */

export { ShareButtonsFactory, ShareButtonModule, ShareButtonComponent };
//# sourceMappingURL=ngx-share-button.js.map
