(function (global, factory) {
	typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('@angular/core'), require('@ngx-share/core'), require('@angular/common'), require('@fortawesome/angular-fontawesome')) :
	typeof define === 'function' && define.amd ? define('@ngx-share/button', ['exports', '@angular/core', '@ngx-share/core', '@angular/common', '@fortawesome/angular-fontawesome'], factory) :
	(factory((global['ngx-share'] = global['ngx-share'] || {}, global['ngx-share'].button = {}),global.ng.core,global.core$1,global.ng.common,global.angularFontawesome));
}(this, (function (exports,core,core$1,common,angularFontawesome) { 'use strict';

var ShareButtonComponent = (function () {
    function ShareButtonComponent(share) {
        this.share = share;
        this.showIcon = true;
        this.showText = false;
        this.showCount = false;
        this.size = this.share.size;
        this.theme = this.share.theme;
        this.count = new core.EventEmitter();
        this.opened = new core.EventEmitter();
        this.closed = new core.EventEmitter();
    }
    Object.defineProperty(ShareButtonComponent.prototype, "createButton", {
        set: function (button) {
            this.shareCount = 0;
            this.button = button;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ShareButtonComponent.prototype, "setUrl", {
        set: function (url) {
            this.shareCount = 0;
            this.url = url;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ShareButtonComponent.prototype, "buttonClass", {
        get: function () {
            return "sb-button sb-" + this.theme;
        },
        enumerable: true,
        configurable: true
    });
    ShareButtonComponent.prototype.onCount = function (count) {
        this.shareCount = count;
        this.count.emit(count);
    };
    return ShareButtonComponent;
}());
ShareButtonComponent.decorators = [
    { type: core.Component, args: [{
                selector: 'share-button',
                template: "<button class=\"sb-wrapper\"\n        [shareButton]=\"button\"\n        [url]=\"url\"\n        [image]=\"image\"\n        [title]=\"title\"\n        [description]=\"description\"\n        [tags]=\"tags\"\n        [autoSetMeta]=\"autoSetMeta\"\n        [getCount]=\"showCount\"\n        (opened)=\"opened.emit($event)\"\n        (closed)=\"closed.emit($event)\"\n        (count)=\"onCount($event)\"\n        [class.sb-show-icon]=\"showIcon\"\n        [class.sb-show-text]=\"showText\"\n        [class.sb-show-count]=\"showCount && shareCount\"\n        [style.fontSize.px]=\"(1 + size/20) * 14\">\n  <div class=\"sb-inner\">\n    <div class=\"sb-content\">\n      <!-- BUTTON ICON -->\n      <div *ngIf=\"showIcon && ref.prop\" class=\"sb-icon\">\n        <fa-icon [icon]=\"icon || ref.prop.icon\"></fa-icon>\n      </div>\n      <!-- BUTTON TEXT -->\n      <div *ngIf=\"showText && ref.prop\" class=\"sb-text\">\n        {{ text || ref.prop.text }}\n      </div>\n    </div>\n    <!-- BUTTON COUNT -->\n    <div *ngIf=\"showCount && shareCount\" class=\"sb-count\">\n      <span>{{ shareCount | shareCount }}</span>\n    </div>\n  </div>\n</button>\n",
                changeDetection: core.ChangeDetectionStrategy.OnPush,
                preserveWhitespaces: false
            },] },
];
ShareButtonComponent.ctorParameters = function () { return [
    { type: core$1.ShareButtons, },
]; };
ShareButtonComponent.propDecorators = {
    "createButton": [{ type: core.Input, args: ['button',] },],
    "setUrl": [{ type: core.Input, args: ['url',] },],
    "title": [{ type: core.Input },],
    "description": [{ type: core.Input },],
    "image": [{ type: core.Input },],
    "tags": [{ type: core.Input },],
    "autoSetMeta": [{ type: core.Input },],
    "showIcon": [{ type: core.Input },],
    "showText": [{ type: core.Input },],
    "showCount": [{ type: core.Input },],
    "text": [{ type: core.Input },],
    "icon": [{ type: core.Input },],
    "size": [{ type: core.Input },],
    "theme": [{ type: core.Input },],
    "count": [{ type: core.Output },],
    "opened": [{ type: core.Output },],
    "closed": [{ type: core.Output },],
    "buttonClass": [{ type: core.HostBinding, args: ['class',] },],
    "ref": [{ type: core.ViewChild, args: [core$1.ShareButtonDirective,] },],
};
function ShareButtonsFactory(config) {
    return new core$1.ShareButtons(config);
}
var ShareButtonModule = (function () {
    function ShareButtonModule() {
    }
    ShareButtonModule.forRoot = function (config) {
        return {
            ngModule: ShareButtonModule,
            providers: [
                { provide: core$1.CONFIG, useValue: config },
                {
                    provide: core$1.ShareButtons,
                    useFactory: ShareButtonsFactory,
                    deps: [core$1.CONFIG]
                }
            ]
        };
    };
    return ShareButtonModule;
}());
ShareButtonModule.decorators = [
    { type: core.NgModule, args: [{
                declarations: [
                    ShareButtonComponent
                ],
                imports: [
                    core$1.ShareModule,
                    angularFontawesome.FontAwesomeModule,
                    common.CommonModule
                ],
                exports: [
                    core$1.ShareModule,
                    angularFontawesome.FontAwesomeModule,
                    ShareButtonComponent
                ]
            },] },
];
ShareButtonModule.ctorParameters = function () { return []; };

exports.ShareButtonsFactory = ShareButtonsFactory;
exports.ShareButtonModule = ShareButtonModule;
exports.ShareButtonComponent = ShareButtonComponent;

Object.defineProperty(exports, '__esModule', { value: true });

})));
//# sourceMappingURL=ngx-share-button.umd.js.map
