import { Directive } from '@angular/core';

import { BaseMapDirective } from './base-map-directive';
import { NguiMapComponent } from '../components/ngui-map.component';

const INPUTS = [
  'clickable', 'draggable', 'editable', 'fillColor', 'fillOpacity', 'geodesic', 'paths',
  'strokeColor', 'strokeOpacity', 'strokePosition', 'strokeWeight', 'visible', 'zIndex', 'options',
];
const OUTPUTS = [
  'click', 'dblclick', 'drag', 'dragend', 'dragstart', 'mousedown',
  'mousemove', 'mouseout', 'mouseover', 'mouseup', 'rightclick',
];

@Directive({
  selector: 'ngui-map>polygon, ngui-map>map-polygon',
  inputs: INPUTS,
  outputs: OUTPUTS,
})
export class Polygon extends BaseMapDirective {
  // declare INPUTS for AOT compiler
  public clickable: any; // generated by ngc-pre-compiler.js
  public draggable: any; // generated by ngc-pre-compiler.js
  public editable: any; // generated by ngc-pre-compiler.js
  public fillColor: any; // generated by ngc-pre-compiler.js
  public fillOpacity: any; // generated by ngc-pre-compiler.js
  public geodesic: any; // generated by ngc-pre-compiler.js
  public paths: any; // generated by ngc-pre-compiler.js
  public strokeColor: any; // generated by ngc-pre-compiler.js
  public strokeOpacity: any; // generated by ngc-pre-compiler.js
  public strokePosition: any; // generated by ngc-pre-compiler.js
  public strokeWeight: any; // generated by ngc-pre-compiler.js
  public visible: any; // generated by ngc-pre-compiler.js
  public zIndex: any; // generated by ngc-pre-compiler.js
  public options: any; // generated by ngc-pre-compiler.js

  // declare OUTPUTS for AOT compiler
  public click: any; // generated by ngc-pre-compiler.js
  public dblclick: any; // generated by ngc-pre-compiler.js
  public drag: any; // generated by ngc-pre-compiler.js
  public dragend: any; // generated by ngc-pre-compiler.js
  public dragstart: any; // generated by ngc-pre-compiler.js
  public mousedown: any; // generated by ngc-pre-compiler.js
  public mousemove: any; // generated by ngc-pre-compiler.js
  public mouseout: any; // generated by ngc-pre-compiler.js
  public mouseover: any; // generated by ngc-pre-compiler.js
  public mouseup: any; // generated by ngc-pre-compiler.js
  public rightclick: any; // generated by ngc-pre-compiler.js

  constructor(nguiMapComp: NguiMapComponent) {
    super(nguiMapComp, 'Polygon', INPUTS, OUTPUTS);
  }
}
