import {Directive, OnInit} from '@angular/core';

import { BaseMapDirective } from './base-map-directive';
import { NguiMapComponent } from '../components/ngui-map.component';

const INPUTS = [
  'anchorPoint', 'animation', 'clickable', 'cursor', 'draggable', 'icon', 'label', 'opacity',
  'optimized', 'place', 'position', 'shape', 'title', 'visible', 'zIndex', 'options',
  // ngui-map specific inputs
  'geoFallbackPosition'
];
const OUTPUTS = [
  'animationChanged', 'click', 'clickableChanged', 'cursorChanged', 'dblclick', 'drag', 'dragend', 'draggableChanged',
  'dragstart', 'flatChanged', 'iconChanged', 'mousedown', 'mouseout', 'mouseover', 'mouseup', 'positionChanged', 'rightclick',
  'shapeChanged', 'titleChanged', 'visibleChanged', 'zindexChanged'
];

@Directive({
  selector: 'ngui-map > marker',
  inputs: INPUTS,
  outputs: OUTPUTS,
})
export class Marker extends BaseMapDirective implements OnInit {
  // declare INPUTS for AOT compiler
  public anchorPoint: any; // generated by ngc-pre-compiler.js
  public animation: any; // generated by ngc-pre-compiler.js
  public clickable: any; // generated by ngc-pre-compiler.js
  public cursor: any; // generated by ngc-pre-compiler.js
  public draggable: any; // generated by ngc-pre-compiler.js
  public icon: any; // generated by ngc-pre-compiler.js
  public label: any; // generated by ngc-pre-compiler.js
  public opacity: any; // generated by ngc-pre-compiler.js
  public optimized: any; // generated by ngc-pre-compiler.js
  public place: any; // generated by ngc-pre-compiler.js
  public position: any; // generated by ngc-pre-compiler.js
  public shape: any; // generated by ngc-pre-compiler.js
  public title: any; // generated by ngc-pre-compiler.js
  public visible: any; // generated by ngc-pre-compiler.js
  public zIndex: any; // generated by ngc-pre-compiler.js
  public options: any; // generated by ngc-pre-compiler.js
  public geoFallbackPosition: any; // generated by ngc-pre-compiler.js

  // declare OUTPUTS for AOT compiler
  public animationChanged: any; // generated by ngc-pre-compiler.js
  public click: any; // generated by ngc-pre-compiler.js
  public clickableChanged: any; // generated by ngc-pre-compiler.js
  public cursorChanged: any; // generated by ngc-pre-compiler.js
  public dblclick: any; // generated by ngc-pre-compiler.js
  public drag: any; // generated by ngc-pre-compiler.js
  public dragend: any; // generated by ngc-pre-compiler.js
  public draggableChanged: any; // generated by ngc-pre-compiler.js
  public dragstart: any; // generated by ngc-pre-compiler.js
  public flatChanged: any; // generated by ngc-pre-compiler.js
  public iconChanged: any; // generated by ngc-pre-compiler.js
  public mousedown: any; // generated by ngc-pre-compiler.js
  public mouseout: any; // generated by ngc-pre-compiler.js
  public mouseover: any; // generated by ngc-pre-compiler.js
  public mouseup: any; // generated by ngc-pre-compiler.js
  public positionChanged: any; // generated by ngc-pre-compiler.js
  public rightclick: any; // generated by ngc-pre-compiler.js
  public shapeChanged: any; // generated by ngc-pre-compiler.js
  public titleChanged: any; // generated by ngc-pre-compiler.js
  public visibleChanged: any; // generated by ngc-pre-compiler.js
  public zindexChanged: any; // generated by ngc-pre-compiler.js

  public mapObject: google.maps.Marker;
  public objectOptions: google.maps.MarkerOptions = <google.maps.MarkerOptions>{};

  constructor(private nguiMapComp: NguiMapComponent) {
    super(nguiMapComp, 'Marker', INPUTS, OUTPUTS);

  }

  // Initialize this map object when map is ready
  ngOnInit() {
    if (this.nguiMapComponent.mapIdledOnce) { // map is ready already
      this.initialize();
    } else {
      this.nguiMapComponent.mapReady$.subscribe(map => this.initialize());
    }
  }

  initialize(): void {
    super.initialize();
    this.setPosition();
  }

  setPosition(): void {
    if (!this['position']) {
      this._subscriptions.push(this.nguiMapComp.geolocation.getCurrentPosition().subscribe(
        position => {

          let latLng = new google.maps.LatLng(position.coords.latitude, position.coords.longitude);
          this.mapObject.setPosition(latLng);
        },
        error => {
          console.error('ngui-map, error finding the current location');
          this.mapObject.setPosition(this.objectOptions['geoFallbackPosition'] || new google.maps.LatLng(0, 0));
        }
      ));
    } else if (typeof this['position'] === 'string') {
      this._subscriptions.push(this.nguiMapComp.geoCoder.geocode({address: this['position']}).subscribe(
        results => {

          this.mapObject.setPosition(results[0].geometry.location);
        },
        error => {
          console.error('ngui-map, error finding the location from', this['position']);
          this.mapObject.setPosition(this.objectOptions['geoFallbackPosition'] || new google.maps.LatLng(0, 0));
        }
      ));
    }
  }
}
