import { Directive } from '@angular/core';

import { BaseMapDirective } from './base-map-directive';
import { NguiMapComponent } from '../components/ngui-map.component';

const INPUTS = [ 'clickable', 'preserveViewport', 'screenOverlays', 'suppressInfoWindows', 'url', 'zIndex', 'options' ];
const OUTPUTS = [ 'click', 'defaultviewport_changed', 'status_changed' ];

@Directive({
  selector: 'ngui-map > kml-layer',
  inputs: INPUTS,
  outputs: OUTPUTS,
})
export class KmlLayer extends BaseMapDirective {
  // declare INPUTS for AOT compiler
  public clickable: any; // generated by ngc-pre-compiler.js
  public preserveViewport: any; // generated by ngc-pre-compiler.js
  public screenOverlays: any; // generated by ngc-pre-compiler.js
  public suppressInfoWindows: any; // generated by ngc-pre-compiler.js
  public url: any; // generated by ngc-pre-compiler.js
  public zIndex: any; // generated by ngc-pre-compiler.js
  public options: any; // generated by ngc-pre-compiler.js

  // declare OUTPUTS for AOT compiler
  public click: any; // generated by ngc-pre-compiler.js
  public defaultviewport_changed: any; // generated by ngc-pre-compiler.js
  public status_changed: any; // generated by ngc-pre-compiler.js

  constructor(nguiMapComp: NguiMapComponent) {
    super(nguiMapComp, 'KmlLayer', INPUTS, OUTPUTS);
  }
}
