import { Directive } from '@angular/core';

import { BaseMapDirective } from './base-map-directive';
import { NguiMapComponent } from '../components/ngui-map.component';

const INPUTS = [ 'data', 'dissipating', 'gradient', 'maxIntensity', 'opacity', 'radius', 'options' ];
const OUTPUTS = [];

@Directive({
  selector: 'ngui-map > heatmap-layer',
  inputs: INPUTS,
  outputs: OUTPUTS,
})
export class HeatmapLayer extends BaseMapDirective {
  // declare INPUTS for AOT compiler
  public data: any; // generated by ngc-pre-compiler.js
  public dissipating: any; // generated by ngc-pre-compiler.js
  public gradient: any; // generated by ngc-pre-compiler.js
  public maxIntensity: any; // generated by ngc-pre-compiler.js
  public opacity: any; // generated by ngc-pre-compiler.js
  public radius: any; // generated by ngc-pre-compiler.js
  public options: any; // generated by ngc-pre-compiler.js

  // declare OUTPUTS for AOT compiler


  public libraryName = 'visualization';

  constructor(nguiMapComp: NguiMapComponent) {
    super(nguiMapComp, 'HeatmapLayer', INPUTS, OUTPUTS);
  }
}
