import { Directive } from '@angular/core';

import { BaseMapDirective } from './base-map-directive';
import { NguiMapComponent } from '../components/ngui-map.component';

const INPUTS = [
  'options',
  'circleOptions', 'drawingControl', 'drawingControlOptions', 'drawingMode',
  'map', 'markerOptions', 'polygonOptions', 'polylineOptions', 'rectangleOptions'
];
const OUTPUTS = [
  'circlecomplete', 'markercomplete', 'overlaycomplete',
  'polygoncomplete', 'polylinecomplete', 'rectanglecomplete'
];

@Directive({
  selector: 'ngui-map > drawing-manager',
  inputs: INPUTS,
  outputs: OUTPUTS,
})
export class DrawingManager extends BaseMapDirective {
  // declare INPUTS for AOT compiler
  public options: any; // generated by ngc-pre-compiler.js
  public circleOptions: any; // generated by ngc-pre-compiler.js
  public drawingControl: any; // generated by ngc-pre-compiler.js
  public drawingControlOptions: any; // generated by ngc-pre-compiler.js
  public drawingMode: any; // generated by ngc-pre-compiler.js
  public map: any; // generated by ngc-pre-compiler.js
  public markerOptions: any; // generated by ngc-pre-compiler.js
  public polygonOptions: any; // generated by ngc-pre-compiler.js
  public polylineOptions: any; // generated by ngc-pre-compiler.js
  public rectangleOptions: any; // generated by ngc-pre-compiler.js

  // declare OUTPUTS for AOT compiler
  public circlecomplete: any; // generated by ngc-pre-compiler.js
  public markercomplete: any; // generated by ngc-pre-compiler.js
  public overlaycomplete: any; // generated by ngc-pre-compiler.js
  public polygoncomplete: any; // generated by ngc-pre-compiler.js
  public polylinecomplete: any; // generated by ngc-pre-compiler.js
  public rectanglecomplete: any; // generated by ngc-pre-compiler.js

  constructor(nguiMapComp: NguiMapComponent) {
    super(nguiMapComp, 'DrawingManager', INPUTS, OUTPUTS);
    this.libraryName = 'drawing';
  }
}
