import { Input, Directive, SimpleChanges, OnChanges, OnDestroy } from '@angular/core';

import { BaseMapDirective } from './base-map-directive';
import { NguiMapComponent } from '../components/ngui-map.component';
import { NavigatorGeolocation } from '../services/navigator-geolocation';

const INPUTS = [
  'directions', 'draggable', 'hideRouteList', 'infoWindow', 'panel', 'markerOptions',
  'polylineOptions', 'preserveViewport', 'routeIndex', 'suppressBicyclingLayer',
  'suppressInfoWindows', 'suppressMarkers', 'suppressPolylines'
];
const OUTPUTS = ['directions_changed'];

@Directive({
  selector: 'ngui-map > directions-renderer',
  inputs: INPUTS,
  outputs: OUTPUTS,
})
export class DirectionsRenderer extends BaseMapDirective implements OnChanges, OnDestroy {
  // declare INPUTS for AOT compiler
  public directions: any; // generated by ngc-pre-compiler.js
  public draggable: any; // generated by ngc-pre-compiler.js
  public hideRouteList: any; // generated by ngc-pre-compiler.js
  public infoWindow: any; // generated by ngc-pre-compiler.js
  public panel: any; // generated by ngc-pre-compiler.js
  public markerOptions: any; // generated by ngc-pre-compiler.js
  public polylineOptions: any; // generated by ngc-pre-compiler.js
  public preserveViewport: any; // generated by ngc-pre-compiler.js
  public routeIndex: any; // generated by ngc-pre-compiler.js
  public suppressBicyclingLayer: any; // generated by ngc-pre-compiler.js
  public suppressInfoWindows: any; // generated by ngc-pre-compiler.js
  public suppressMarkers: any; // generated by ngc-pre-compiler.js
  public suppressPolylines: any; // generated by ngc-pre-compiler.js

  // declare OUTPUTS for AOT compiler
  public directions_changed: any; // generated by ngc-pre-compiler.js

  // tslint:disable-next-line
  @Input('directions-request') directionsRequest: google.maps.DirectionsRequest;

  directionsService: google.maps.DirectionsService;
  directionsRenderer: google.maps.DirectionsRenderer;

  constructor(
    nguiMapComponent: NguiMapComponent,
    public geolocation: NavigatorGeolocation
  ) {
    super(nguiMapComponent, 'DirectionsRenderer', INPUTS, OUTPUTS);
  }

  // only called when map is ready
  initialize(): void {
    this.objectOptions = this.optionBuilder.googlizeAllInputs(this.inputs, this);
    if (typeof this.objectOptions['panel'] === 'string') { // find a Node for panel
      this.objectOptions['panel'] = document.querySelector(this.objectOptions['panel']);
    }



    this.directionsService = new google.maps.DirectionsService();
    this.directionsRenderer = new google.maps.DirectionsRenderer(this.objectOptions);

    this.directionsRenderer.setMap(this.nguiMapComponent.map);

    // set google events listeners and emidirectionsRenderer to this outputs listeners
    this.showDirections(this.directionsRequest);

    this.nguiMap.setObjectEvents(this.outputs, this, 'directionsRenderer');

    this.nguiMapComponent.addToMapObjectGroup(this.mapObjectName, this.mapObject);
    this.initialized$.emit(this.directionsRenderer);
  }


  ngOnChanges(changes: SimpleChanges) {
    let newOptions = {};
    for (let key in changes) {
      if (this.inputs.indexOf(key) !== -1) {
        newOptions[key] = this.optionBuilder.googlize(changes[key].currentValue);
      }
    }
    if (changes['directionsRequest'] && this.directionsRenderer) {
      this.directionsService && this.showDirections(this.directionsRequest);
    }
  }

  showDirections(directionsRequest: google.maps.DirectionsRequest) {
    this.directionsService.route(directionsRequest,
      (response: any, status: any) =>  {
        // in some-case the callback is called during destroy component,
        // we should make sure directionsRenderer is still defined (cancelling `route` callback is not possible).
        if (!this.directionsRenderer) {
          return;
        }

        if (status === google.maps.DirectionsStatus.OK) {
          this.directionsRenderer.setDirections(response);
        } else {
          console.error('Directions request failed due to ' + status);
        }
      }
    );
  }

  ngOnDestroy() {
    super.ngOnDestroy();
    this.nguiMap.clearObjectEvents(this.outputs, this, 'directionsRenderer');
  }
}