import { Directive } from '@angular/core';

import { BaseMapDirective } from './base-map-directive';
import { NguiMapComponent } from '../components/ngui-map.component';

const INPUTS = ['controlPosition', 'controls', 'drawingMode', 'featureFactory', 'style', 'geoJson', 'geoJsonUrl'];
const OUTPUTS = [
  'addfeature', 'click', 'dblclick', 'mousedown', 'mouseout', 'mouseover',
  'mouseup', 'removefeature', 'removeproperty', 'rightclick', 'setgeometry', 'setproperty'
];

@Directive({
  selector: 'ngui-map > data-layer',
  inputs: INPUTS,
  outputs: OUTPUTS,
})
export class DataLayer extends BaseMapDirective {
  // declare INPUTS for AOT compiler
  public controlPosition: any; // generated by ngc-pre-compiler.js
  public controls: any; // generated by ngc-pre-compiler.js
  public drawingMode: any; // generated by ngc-pre-compiler.js
  public featureFactory: any; // generated by ngc-pre-compiler.js
  public style: any; // generated by ngc-pre-compiler.js
  public geoJson: any; // generated by ngc-pre-compiler.js
  public geoJsonUrl: any; // generated by ngc-pre-compiler.js

  // declare OUTPUTS for AOT compiler
  public addfeature: any; // generated by ngc-pre-compiler.js
  public click: any; // generated by ngc-pre-compiler.js
  public dblclick: any; // generated by ngc-pre-compiler.js
  public mousedown: any; // generated by ngc-pre-compiler.js
  public mouseout: any; // generated by ngc-pre-compiler.js
  public mouseover: any; // generated by ngc-pre-compiler.js
  public mouseup: any; // generated by ngc-pre-compiler.js
  public removefeature: any; // generated by ngc-pre-compiler.js
  public removeproperty: any; // generated by ngc-pre-compiler.js
  public rightclick: any; // generated by ngc-pre-compiler.js
  public setgeometry: any; // generated by ngc-pre-compiler.js
  public setproperty: any; // generated by ngc-pre-compiler.js

  constructor(nguiMapComponent: NguiMapComponent) {
    super(nguiMapComponent, 'Data', INPUTS, OUTPUTS);
  }

  // only called when map is ready
  initialize(): void {
    if (this['geoJson']) {
      // addGeoJson from an object

      this.nguiMapComponent.map.data.addGeoJson(this['geoJson']);
    } else if (this['geoJsonUrl']) {
      // loadGeoJson from a URL

      this.nguiMapComponent.map.data.loadGeoJson(this['geoJsonUrl']);
    }
    else {
      this.objectOptions = this.optionBuilder.googlizeAllInputs(this.inputs, this);

      this.nguiMapComponent.map.data.add(this.objectOptions);
    }

    // unlike others, data belongs to map. e.g., map.data.loadGeoJson(), map.data.add()
    this.mapObject = this.nguiMapComponent.map.data;

    // set google events listeners and emits to this outputs listeners
    this.nguiMap.setObjectEvents(this.outputs, this, 'mapObject');

    this.nguiMapComponent.addToMapObjectGroup(this.mapObjectName, this.mapObject);
    this.initialized$.emit(this.mapObject);
  }
}