#!/usr/bin/env node

'use strict';
/**
 * this is to declare all INPUTS as a public variable for components and directives
 * Without declaring all INPUTS variable, there will be an error in AoT compilation
 * https://github.com/ng2-ui/map/pull/64
 */
var path = require("path");
var fs = require('fs-extra');

var tmpDir = path.join('tmp');
fs.ensureDirSync(tmpDir);
fs.emptyDirSync(tmpDir);
fs.copySync('src', tmpDir);

['components', 'directives', 'services'].forEach(dirName => {
  let dirPath = path.join(tmpDir, dirName);
  let files = fs.readdirSync(dirPath);
  let js;
  files.forEach(fileName => {
    let jsPath = path.join(dirPath, fileName);

    js = fs.readFileSync(jsPath, 'utf8');
    // https://github.com/yahoo/strip-loader/blob/master/lib/index.js#L17
    let regexPattern = new RegExp('(?:^|\\n)[ \\t]*(console.log)\\(((\\"[^\\"]*\\")|(\\\'[^\\\']*\\\')|[^\\);]|\\([^\\);]*\\))*\\)[ \\t]*(?:$|[;\\n])', 'g');
    fs.writeFileSync(jsPath, js.replace(regexPattern, '\n'));

    js = fs.readFileSync(jsPath, 'utf8');
    let outputMatches = js.match(/OUTPUTS\s*=\s*(\[[^\]]*?\])/m);
    if (outputMatches) {
      let outputs = eval(outputMatches[1]);
      let outputsJs = '\n  // declare OUTPUTS for AOT compiler\n' +
          outputs.map(input => '  public ' + input + ': any; // generated by '+path.basename(__filename)).join('\n') + '\n';
      let replaceMatches = js.match(/(@Component|@Directive)\([\s\S]+?OUTPUTS[\s\S]+? class [\s\S]+?\{/m);
      if (replaceMatches) {
        let jsToReplace = js.replace(replaceMatches[0], $0 => $0 + outputsJs);
        fs.writeFileSync(jsPath, jsToReplace);
      }
    }

    js = fs.readFileSync(jsPath, 'utf8');
    let inputMatches = js.match(/INPUTS\s*=\s*(\[[^\]]*?\])/m);
    if (inputMatches) {
      let inputs = eval(inputMatches[1]);
      let inputsJs = '\n  // declare INPUTS for AOT compiler\n'+
          inputs.map(input => '  public ' + input + ': any; // generated by '+path.basename(__filename)).join('\n') +
          '\n';
      let replaceMatches = js.match(/(@Component|@Directive)\([\s\S]+?INPUTS[\s\S]+? class [\s\S]+?\{/m);
      if (replaceMatches) {
        let jsToReplace = js.replace(replaceMatches[0], $0 => $0 + inputsJs);
        fs.writeFileSync(jsPath, jsToReplace);
      }
    }
  });
});
