/// <reference types="googlemaps" />
import { ElementRef, EventEmitter, SimpleChanges, NgZone, AfterViewInit, AfterViewChecked, OnChanges, OnDestroy } from '@angular/core';
import { OptionBuilder } from '../services/option-builder';
import { NavigatorGeolocation } from '../services/navigator-geolocation';
import { GeoCoder } from '../services/geo-coder';
import { NguiMap } from '../services/ngui-map';
import { NgMapApiLoader } from '../services/api-loader';
import { InfoWindow } from './info-window';
import { Subject } from 'rxjs/Subject';
export declare class NguiMapComponent implements OnChanges, OnDestroy, AfterViewInit, AfterViewChecked {
    optionBuilder: OptionBuilder;
    elementRef: ElementRef;
    geolocation: NavigatorGeolocation;
    geoCoder: GeoCoder;
    nguiMap: NguiMap;
    apiLoader: NgMapApiLoader;
    zone: NgZone;
    backgroundColor: any;
    center: any;
    disableDefaultUI: any;
    disableDoubleClickZoom: any;
    draggable: any;
    draggableCursor: any;
    draggingCursor: any;
    heading: any;
    keyboardShortcuts: any;
    mapMaker: any;
    mapTypeControl: any;
    mapTypeId: any;
    maxZoom: any;
    minZoom: any;
    noClear: any;
    overviewMapControl: any;
    panControl: any;
    panControlOptions: any;
    rotateControl: any;
    scaleControl: any;
    scrollwheel: any;
    streetView: any;
    styles: any;
    tilt: any;
    zoom: any;
    streetViewControl: any;
    zoomControl: any;
    zoomControlOptions: any;
    mapTypeControlOptions: any;
    overviewMapControlOptions: any;
    rotateControlOptions: any;
    scaleControlOptions: any;
    streetViewControlOptions: any;
    fullscreenControl: any;
    fullscreenControlOptions: any;
    options: any;
    geoFallbackCenter: any;
    bounds_changed: any;
    center_changed: any;
    click: any;
    dblclick: any;
    drag: any;
    dragend: any;
    dragstart: any;
    heading_changed: any;
    idle: any;
    typeid_changed: any;
    mousemove: any;
    mouseout: any;
    mouseover: any;
    projection_changed: any;
    resize: any;
    rightclick: any;
    tilesloaded: any;
    tile_changed: any;
    zoom_changed: any;
    mapClick: any;
    mapMouseover: any;
    mapMouseout: any;
    mapMousemove: any;
    mapDrag: any;
    mapDragend: any;
    mapDragstart: any;
    mapReady$: EventEmitter<any>;
    el: HTMLElement;
    map: google.maps.Map;
    mapOptions: google.maps.MapOptions;
    inputChanges$: Subject<{}>;
    infoWindows: {
        [id: string]: InfoWindow;
    };
    mapIdledOnce: boolean;
    private initializeMapAfterDisplayed;
    private apiLoaderSub;
    constructor(optionBuilder: OptionBuilder, elementRef: ElementRef, geolocation: NavigatorGeolocation, geoCoder: GeoCoder, nguiMap: NguiMap, apiLoader: NgMapApiLoader, zone: NgZone);
    ngAfterViewInit(): void;
    ngAfterViewChecked(): void;
    ngOnChanges(changes: SimpleChanges): void;
    initializeMap(): void;
    setCenter(): void;
    openInfoWindow(id: string, anchor: google.maps.MVCObject): void;
    closeInfoWindow(id: string): void;
    ngOnDestroy(): void;
    addToMapObjectGroup(mapObjectName: string, mapObject: any): void;
    removeFromMapObjectGroup(mapObjectName: string, mapObject: any): void;
}
