(function (global, factory) {
	typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('@angular/core'), require('@angular/common'), require('@fortawesome/fontawesome-svg-core'), require('@angular/platform-browser')) :
	typeof define === 'function' && define.amd ? define(['exports', '@angular/core', '@angular/common', '@fortawesome/fontawesome-svg-core', '@angular/platform-browser'], factory) :
	(factory((global.angularFontAwesome = {}),global.ng.core,global.ng.common,global['fontawesome-svg-core'],global.ng.platformBrowser));
}(this, (function (exports,core,common,fontawesomeSvgCore,platformBrowser) { 'use strict';

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
/**
 * Returns if is IconLookup or not.
 * @return IconLookup
 */
var isIconLookup = function (i) {
    return (/** @type {?} */ (i)).prefix !== undefined && (/** @type {?} */ (i)).iconName !== undefined;
};

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
/**
 * Normalizing icon spec.
 * @return IconLookup
 */
var faNormalizeIconSpec = function (iconSpec) {
    var /** @type {?} */ defaultPrefix = 'fas';
    if (typeof iconSpec === 'undefined' || iconSpec === null) {
        return null;
    }
    if (isIconLookup(iconSpec)) {
        return iconSpec;
    }
    if (Array.isArray(iconSpec) && (/** @type {?} */ (iconSpec)).length === 2) {
        return { prefix: iconSpec[0], iconName: iconSpec[1] };
    }
    if (typeof iconSpec === 'string') {
        return { prefix: defaultPrefix, iconName: iconSpec };
    }
};

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
/**
 * @param T value
 */
var objectWithKey = function (key, value) {
    return (Array.isArray(value) && value.length > 0) || (!Array.isArray(value) && value) ? (_a = {}, _a[key] = value, _a) : {};
    var _a;
};

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
/**
 * Fontawesome class list.
 * Returns classes array by props.
 * @return string[]
 */
var faClassList = function (props) {
    var /** @type {?} */ classes = (_a = {
            'fa-spin': props.spin,
            'fa-pulse': props.pulse,
            'fa-fw': props.fixedWidth,
            'fa-border': props.border,
            'fa-li': props.listItem,
            'fa-inverse': props.inverse,
            'fa-layers-counter': props.counter,
            'fa-flip-horizontal': props.flip === 'horizontal' || props.flip === 'both',
            'fa-flip-vertical': props.flip === 'vertical' || props.flip === 'both'
        }, _a["fa-" + props.size] = props.size !== null, _a["fa-rotate-" + props.rotate] = props.rotate !== null, _a["fa-pull-" + props.pull] = props.pull !== null, _a);
    return Object.keys(classes)
        .map(function (key) { return (classes[key] ? key : null); })
        .filter(function (key) { return key; });
    var _a;
};

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
var faWarnIfIconHtmlMissing = function (iconObj, iconSpec) {
    if (iconSpec && !iconObj) {
        console.error("FontAwesome: Could not find icon with iconName=" + iconSpec.iconName + " and prefix=" + iconSpec.prefix);
    }
};

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
var faWarnIfIconSpecMissing = function (iconSpec) {
    if (!iconSpec) {
        console.error('FontAwesome: Could not find icon. ' +
            "It looks like you've provided a null or undefined icon object to this component.");
    }
};

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
var faNotFoundIconHtml = "<svg class=\"" + fontawesomeSvgCore.config.replacementClass + "\" viewBox=\"0 0 448 512\"></svg><!--icon not found-->";

var __assign = (undefined && undefined.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
/**
 * Fontawesome icon.
 */
var FaIconComponent = (function () {
    function FaIconComponent(sanitizer) {
        this.sanitizer = sanitizer;
        this.classes = [];
    }
    /**
     * @param {?} changes
     * @return {?}
     */
    FaIconComponent.prototype.ngOnChanges = /**
     * @param {?} changes
     * @return {?}
     */
    function (changes) {
        if (changes) {
            this.updateIconSpec();
            this.updateParams();
            this.updateIcon();
            this.renderIcon();
        }
    };
    /**
     * Updating icon spec.
     * @return {?}
     */
    FaIconComponent.prototype.updateIconSpec = /**
     * Updating icon spec.
     * @return {?}
     */
    function () {
        this.iconSpec = faNormalizeIconSpec(this.iconProp);
    };
    /**
     * Updating params by component props.
     * @return {?}
     */
    FaIconComponent.prototype.updateParams = /**
     * Updating params by component props.
     * @return {?}
     */
    function () {
        var /** @type {?} */ classOpts = {
            flip: this.flip,
            spin: this.spin,
            pulse: this.pulse,
            border: this.border,
            inverse: this.inverse,
            listItem: this.listItem,
            size: this.size || null,
            pull: this.pull || null,
            rotate: this.rotate || null,
            fixedWidth: this.fixedWidth
        };
        var /** @type {?} */ classes = objectWithKey('classes', faClassList(classOpts).concat(this.classes));
        var /** @type {?} */ mask = objectWithKey('mask', faNormalizeIconSpec(this.mask));
        var /** @type {?} */ parsedTransform = typeof this.transform === 'string' ? fontawesomeSvgCore.parse.transform(this.transform) : this.transform;
        var /** @type {?} */ transform = objectWithKey('transform', parsedTransform);
        this.params = __assign({ title: this.title }, transform, classes, mask, { styles: this.styles, symbol: this.symbol });
    };
    /**
     * Updating icon by params and icon spec.
     * @return {?}
     */
    FaIconComponent.prototype.updateIcon = /**
     * Updating icon by params and icon spec.
     * @return {?}
     */
    function () {
        this.icon = fontawesomeSvgCore.icon(this.iconSpec, this.params);
    };
    /**
     * Rendering icon.
     * @return {?}
     */
    FaIconComponent.prototype.renderIcon = /**
     * Rendering icon.
     * @return {?}
     */
    function () {
        faWarnIfIconSpecMissing(this.iconSpec);
        faWarnIfIconHtmlMissing(this.icon, this.iconSpec);
        this.renderedIconHTML = this.sanitizer.bypassSecurityTrustHtml(this.icon ? this.icon.html.join('\n') : faNotFoundIconHtml);
    };
    FaIconComponent.decorators = [
        { type: core.Component, args: [{
                    selector: 'fa-icon',
                    template: "",
                    host: {
                        class: 'ng-fa-icon',
                    }
                },] },
    ];
    /** @nocollapse */
    FaIconComponent.ctorParameters = function () { return [
        { type: platformBrowser.DomSanitizer, },
    ]; };
    FaIconComponent.propDecorators = {
        "renderedIconHTML": [{ type: core.HostBinding, args: ['innerHTML',] },],
        "iconProp": [{ type: core.Input, args: ['icon',] },],
        "title": [{ type: core.Input },],
        "spin": [{ type: core.Input },],
        "pulse": [{ type: core.Input },],
        "mask": [{ type: core.Input },],
        "styles": [{ type: core.Input },],
        "flip": [{ type: core.Input },],
        "size": [{ type: core.Input },],
        "pull": [{ type: core.Input },],
        "border": [{ type: core.Input },],
        "inverse": [{ type: core.Input },],
        "symbol": [{ type: core.Input },],
        "listItem": [{ type: core.Input },],
        "rotate": [{ type: core.Input },],
        "fixedWidth": [{ type: core.Input },],
        "classes": [{ type: core.Input },],
        "transform": [{ type: core.Input },],
    };
    return FaIconComponent;
}());

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
/**
 * Fontawesome layers.
 */
var FaLayersComponent = (function () {
    function FaLayersComponent() {
    }
    FaLayersComponent.decorators = [
        { type: core.Component, args: [{
                    selector: 'fa-layers',
                    template: "<ng-content select=\"fa-icon, fa-layers-text, fa-layers-counter\"></ng-content>",
                    host: {
                        class: 'fa-layers'
                    }
                },] },
    ];
    /** @nocollapse */
    FaLayersComponent.ctorParameters = function () { return []; };
    return FaLayersComponent;
}());

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
/**
 * Warns if parent component not existing.
 */
var faWarnIfParentNotExist = function (parent, parentName, childName) {
    if (!parent) {
        console.error("FontAwesome: " + childName + " should be used as child of " + parentName + " only.");
    }
};

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
/**
 * @abstract
 */
var FaLayersTextBaseComponent = (function () {
    function FaLayersTextBaseComponent(parent, sanitizer) {
        this.parent = parent;
        this.sanitizer = sanitizer;
        this.classes = [];
        faWarnIfParentNotExist(this.parent, 'FaLayersComponent', this.constructor.name);
    }
    /**
     * @param {?} changes
     * @return {?}
     */
    FaLayersTextBaseComponent.prototype.ngOnChanges = /**
     * @param {?} changes
     * @return {?}
     */
    function (changes) {
        if (changes) {
            this.updateParams();
            this.updateContent();
        }
    };
    /**
     * Updating content by params and content.
     * @return {?}
     */
    FaLayersTextBaseComponent.prototype.updateContent = /**
     * Updating content by params and content.
     * @return {?}
     */
    function () {
        this.renderedHTML = this.sanitizer.bypassSecurityTrustHtml(this.renderFontawesomeObject(this.content || '', this.params).html.join('\n'));
    };
    FaLayersTextBaseComponent.decorators = [
        { type: core.Injectable },
    ];
    /** @nocollapse */
    FaLayersTextBaseComponent.ctorParameters = function () { return [
        { type: FaLayersComponent, decorators: [{ type: core.Inject, args: [core.forwardRef(function () { return FaLayersComponent; }),] }, { type: core.Optional },] },
        { type: platformBrowser.DomSanitizer, },
    ]; };
    FaLayersTextBaseComponent.propDecorators = {
        "renderedHTML": [{ type: core.HostBinding, args: ['innerHTML',] },],
        "content": [{ type: core.Input },],
        "title": [{ type: core.Input },],
        "styles": [{ type: core.Input },],
        "classes": [{ type: core.Input },],
    };
    return FaLayersTextBaseComponent;
}());

var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign$1 = (undefined && undefined.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
/**
 * Fontawesome layers text.
 */
var FaLayersTextComponent = (function (_super) {
    __extends(FaLayersTextComponent, _super);
    function FaLayersTextComponent() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * Updating params by component props.
     */
    /**
     * Updating params by component props.
     * @return {?}
     */
    FaLayersTextComponent.prototype.updateParams = /**
     * Updating params by component props.
     * @return {?}
     */
    function () {
        var /** @type {?} */ classOpts = {
            flip: this.flip,
            spin: this.spin,
            pulse: this.pulse,
            border: this.border,
            inverse: this.inverse,
            listItem: this.listItem,
            size: this.size || null,
            pull: this.pull || null,
            rotate: this.rotate || null,
            fixedWidth: this.fixedWidth
        };
        var /** @type {?} */ classes = objectWithKey('classes', faClassList(classOpts).concat(this.classes));
        var /** @type {?} */ parsedTransform = typeof this.transform === 'string' ? fontawesomeSvgCore.parse.transform(this.transform) : this.transform;
        var /** @type {?} */ transform = objectWithKey('transform', parsedTransform);
        this.params = __assign$1({}, transform, classes, { title: this.title, styles: this.styles });
    };
    /**
     * @param {?} content
     * @param {?=} params
     * @return {?}
     */
    FaLayersTextComponent.prototype.renderFontawesomeObject = /**
     * @param {?} content
     * @param {?=} params
     * @return {?}
     */
    function (content, params) {
        return fontawesomeSvgCore.text(content, params);
    };
    FaLayersTextComponent.decorators = [
        { type: core.Component, args: [{
                    selector: 'fa-layers-text',
                    template: '',
                    host: {
                        class: 'ng-fa-layers-text'
                    }
                },] },
    ];
    /** @nocollapse */
    FaLayersTextComponent.ctorParameters = function () { return []; };
    FaLayersTextComponent.propDecorators = {
        "spin": [{ type: core.Input },],
        "pulse": [{ type: core.Input },],
        "flip": [{ type: core.Input },],
        "size": [{ type: core.Input },],
        "pull": [{ type: core.Input },],
        "border": [{ type: core.Input },],
        "inverse": [{ type: core.Input },],
        "listItem": [{ type: core.Input },],
        "rotate": [{ type: core.Input },],
        "fixedWidth": [{ type: core.Input },],
        "transform": [{ type: core.Input },],
    };
    return FaLayersTextComponent;
}(FaLayersTextBaseComponent));

var __extends$1 = (undefined && undefined.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
/**
 * Fontawesome layers counter.
 */
var FaLayersCounterComponent = (function (_super) {
    __extends$1(FaLayersCounterComponent, _super);
    function FaLayersCounterComponent() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * Updating params by component props.
     */
    /**
     * Updating params by component props.
     * @return {?}
     */
    FaLayersCounterComponent.prototype.updateParams = /**
     * Updating params by component props.
     * @return {?}
     */
    function () {
        this.params = {
            title: this.title,
            classes: this.classes,
            styles: this.styles,
        };
    };
    /**
     * @param {?} content
     * @param {?=} params
     * @return {?}
     */
    FaLayersCounterComponent.prototype.renderFontawesomeObject = /**
     * @param {?} content
     * @param {?=} params
     * @return {?}
     */
    function (content, params) {
        return fontawesomeSvgCore.counter(content, params);
    };
    FaLayersCounterComponent.decorators = [
        { type: core.Component, args: [{
                    selector: 'fa-layers-counter',
                    template: '',
                    host: {
                        class: 'ng-fa-layers-counter'
                    }
                },] },
    ];
    /** @nocollapse */
    FaLayersCounterComponent.ctorParameters = function () { return []; };
    return FaLayersCounterComponent;
}(FaLayersTextBaseComponent));

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
var FontAwesomeModule = (function () {
    function FontAwesomeModule() {
    }
    FontAwesomeModule.decorators = [
        { type: core.NgModule, args: [{
                    imports: [common.CommonModule],
                    declarations: [
                        FaIconComponent,
                        FaLayersComponent,
                        FaLayersTextComponent,
                        FaLayersCounterComponent
                    ],
                    exports: [
                        FaIconComponent,
                        FaLayersComponent,
                        FaLayersTextComponent,
                        FaLayersCounterComponent
                    ],
                },] },
    ];
    /** @nocollapse */
    FontAwesomeModule.ctorParameters = function () { return []; };
    return FontAwesomeModule;
}());

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
/**
 * Generated bundle index. Do not edit.
 */

exports.FaIconComponent = FaIconComponent;
exports.FaLayersComponent = FaLayersComponent;
exports.FaLayersTextComponent = FaLayersTextComponent;
exports.FaLayersCounterComponent = FaLayersCounterComponent;
exports.FontAwesomeModule = FontAwesomeModule;
exports.ɵa = FaLayersTextBaseComponent;

Object.defineProperty(exports, '__esModule', { value: true });

})));
//# sourceMappingURL=angular-fontawesome.umd.js.map
