/**
 * @license Angular v5.2.10
 * (c) 2010-2018 Google, Inc. https://angular.io/
 * License: MIT
 */
!function(global,factory){"object"==typeof exports&&"undefined"!=typeof module?factory(exports):"function"==typeof define&&define.amd?define("@angular/compiler",["exports"],factory):factory((global.ng=global.ng||{},global.ng.compiler={}))}(this,function(exports){"use strict";function __extends(d,b){function __(){this.constructor=d}extendStatics(d,b),d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)}/**
 * @license Angular v5.2.10
 * (c) 2010-2018 Google, Inc. https://angular.io/
 * License: MIT
 */
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
function Inject(){}function Attribute(){}function Query(){}function Directive(){}function Component(){}function Pipe(){}function Input(){}function Output(){}function HostBinding(){}function HostListener(){}function NgModule(){}function ModuleWithProviders(){}function SchemaMetadata(){}function MetadataFactory(){}function makeMetadataFactory(name,props){var factory=function(){for(var args=[],_i=0;_i<arguments.length;_i++)args[_i]=arguments[_i];var values=props?props.apply(void 0,args):{};return __assign({ngMetadataName:name},values)};return factory.isTypeOf=function(obj){return obj&&obj.ngMetadataName===name},factory.ngMetadataName=name,factory}function Route(){}function dashCaseToCamelCase(input){return input.replace(DASH_CASE_REGEXP,function(){for(var m=[],_i=0;_i<arguments.length;_i++)m[_i]=arguments[_i];return m[1].toUpperCase()})}function splitAtColon(input,defaultValues){return _splitAt(input,":",defaultValues)}function splitAtPeriod(input,defaultValues){return _splitAt(input,".",defaultValues)}function _splitAt(input,character,defaultValues){var characterIndex=input.indexOf(character);return-1==characterIndex?defaultValues:[input.slice(0,characterIndex).trim(),input.slice(characterIndex+1).trim()]}function visitValue(value,visitor,context){return Array.isArray(value)?visitor.visitArray(value,context):isStrictStringMap(value)?visitor.visitStringMap(value,context):null==value||"string"==typeof value||"number"==typeof value||"boolean"==typeof value?visitor.visitPrimitive(value,context):visitor.visitOther(value,context)}function isDefined(val){return null!==val&&void 0!==val}function noUndefined(val){return void 0===val?null:val}function syntaxError(msg,parseErrors){var error=Error(msg);return error[ERROR_SYNTAX_ERROR]=!0,parseErrors&&(error[ERROR_PARSE_ERRORS]=parseErrors),error}function isSyntaxError(error){return error[ERROR_SYNTAX_ERROR]}function getParseErrors(error){return error[ERROR_PARSE_ERRORS]||[]}function escapeRegExp(s){return s.replace(/([.*+?^=!:${}()|[\]\/\\])/g,"\\$1")}function isStrictStringMap(obj){return"object"==typeof obj&&null!==obj&&Object.getPrototypeOf(obj)===STRING_MAP_PROTO}function utf8Encode(str){for(var encoded="",index=0;index<str.length;index++){var codePoint=str.charCodeAt(index);if(codePoint>=55296&&codePoint<=56319&&str.length>index+1){var low=str.charCodeAt(index+1);low>=56320&&low<=57343&&(index++,codePoint=(codePoint-55296<<10)+low-56320+65536)}codePoint<=127?encoded+=String.fromCharCode(codePoint):codePoint<=2047?encoded+=String.fromCharCode(codePoint>>6&31|192,63&codePoint|128):codePoint<=65535?encoded+=String.fromCharCode(codePoint>>12|224,codePoint>>6&63|128,63&codePoint|128):codePoint<=2097151&&(encoded+=String.fromCharCode(codePoint>>18&7|240,codePoint>>12&63|128,codePoint>>6&63|128,63&codePoint|128))}return encoded}function stringify(token){if("string"==typeof token)return token;if(token instanceof Array)return"["+token.map(stringify).join(", ")+"]";if(null==token)return""+token;if(token.overriddenName)return""+token.overriddenName;if(token.name)return""+token.name;var res=token.toString();if(null==res)return""+res;var newLineIndex=res.indexOf("\n");return-1===newLineIndex?res:res.substring(0,newLineIndex)}function resolveForwardRef(type){return"function"==typeof type&&type.hasOwnProperty("__forward_ref__")?type():type}function isPromise(obj){return!!obj&&"function"==typeof obj.then}function templateVisitAll(visitor,asts,context){void 0===context&&(context=null);var result=[],visit=visitor.visit?function(ast){return visitor.visit(ast,context)||ast.visit(visitor,context)}:function(ast){return ast.visit(visitor,context)};return asts.forEach(function(ast){var astResult=visit(ast);astResult&&result.push(astResult)}),result}function preserveWhitespacesDefault(preserveWhitespacesOption,defaultSetting){return void 0===defaultSetting&&(defaultSetting=!0),null===preserveWhitespacesOption?defaultSetting:preserveWhitespacesOption}function _sanitizeIdentifier(name){return name.replace(/\W/g,"_")}function identifierName(compileIdentifier){if(!compileIdentifier||!compileIdentifier.reference)return null;var ref=compileIdentifier.reference;if(ref instanceof StaticSymbol)return ref.name;if(ref.__anonymousType)return ref.__anonymousType;var identifier=stringify(ref);return identifier.indexOf("(")>=0?(identifier="anonymous_"+_anonymousTypeIndex++,ref.__anonymousType=identifier):identifier=_sanitizeIdentifier(identifier),identifier}function identifierModuleUrl(compileIdentifier){var ref=compileIdentifier.reference;return ref instanceof StaticSymbol?ref.filePath:"./"+stringify(ref)}function viewClassName(compType,embeddedTemplateIndex){return"View_"+identifierName({reference:compType})+"_"+embeddedTemplateIndex}function rendererTypeName(compType){return"RenderType_"+identifierName({reference:compType})}function hostViewClassName(compType){return"HostView_"+identifierName({reference:compType})}function componentFactoryName(compType){return identifierName({reference:compType})+"NgFactory"}function tokenName(token){return null!=token.value?_sanitizeIdentifier(token.value):identifierName(token.identifier)}function tokenReference(token){return null!=token.identifier?token.identifier.reference:token.value}function _normalizeArray(obj){return obj||[]}function flatten(list){return list.reduce(function(flat,item){var flatItem=Array.isArray(item)?flatten(item):item;return flat.concat(flatItem)},[])}function jitSourceUrl(url){return url.replace(/(\w+:\/\/[\w:-]+)?(\/+)?/,"ng:///")}function templateSourceUrl(ngModuleType,compMeta,templateMeta){var url;return url=templateMeta.isInline?compMeta.type.reference instanceof StaticSymbol?compMeta.type.reference.filePath+"."+compMeta.type.reference.name+".html":identifierName(ngModuleType)+"/"+identifierName(compMeta.type)+".html":templateMeta.templateUrl,compMeta.type.reference instanceof StaticSymbol?url:jitSourceUrl(url)}function sharedStylesheetJitUrl(meta,id){var pathParts=meta.moduleUrl.split(/\/\\/g);return jitSourceUrl("css/"+id+pathParts[pathParts.length-1]+".ngstyle.js")}function ngModuleJitUrl(moduleMeta){return jitSourceUrl(identifierName(moduleMeta.type)+"/module.ngfactory.js")}function templateJitUrl(ngModuleType,compMeta){return jitSourceUrl(identifierName(ngModuleType)+"/"+identifierName(compMeta.type)+".ngfactory.js")}function visitAll(visitor,nodes,context){void 0===context&&(context=null);var result=[],visit=visitor.visit?function(ast){return visitor.visit(ast,context)||ast.visit(visitor,context)}:function(ast){return ast.visit(visitor,context)};return nodes.forEach(function(ast){var astResult=visit(ast);astResult&&result.push(astResult)}),result}function spanOf(ast){var start=ast.sourceSpan.start.offset,end=ast.sourceSpan.end.offset;return ast instanceof Element&&(ast.endSourceSpan?end=ast.endSourceSpan.end.offset:ast.children&&ast.children.length&&(end=spanOf(ast.children[ast.children.length-1]).end)),{start:start,end:end}}function findNode(nodes,position){var path=[];return visitAll(new(function(_super){function class_1(){return null!==_super&&_super.apply(this,arguments)||this}return __extends(class_1,_super),class_1.prototype.visit=function(ast,context){var span=spanOf(ast);if(!(span.start<=position&&position<span.end))return!0;path.push(ast)},class_1}(RecursiveVisitor)),nodes),new AstPath(path,position)}/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
function assertArrayOfStrings(identifier,value){if(null!=value){if(!Array.isArray(value))throw new Error("Expected '"+identifier+"' to be an array of strings.");for(var i=0;i<value.length;i+=1)if("string"!=typeof value[i])throw new Error("Expected '"+identifier+"' to be an array of strings.")}}function assertInterpolationSymbols(identifier,value){if(!(null==value||Array.isArray(value)&&2==value.length))throw new Error("Expected '"+identifier+"' to be an array, [start, end].");if(null!=value){var start_1=value[0],end_1=value[1];INTERPOLATION_BLACKLIST_REGEXPS.forEach(function(regexp){if(regexp.test(start_1)||regexp.test(end_1))throw new Error("['"+start_1+"', '"+end_1+"'] contains unusable interpolation symbol.")})}}function isStyleUrlResolvable(url){if(null==url||0===url.length||"/"==url[0])return!1;var schemeMatch=url.match(URL_WITH_SCHEMA_REGEXP);return null===schemeMatch||"package"==schemeMatch[1]||"asset"==schemeMatch[1]}function extractStyleUrls(resolver,baseUrl,cssText){var foundUrls=[],modifiedCssText=cssText.replace(CSS_STRIPPABLE_COMMENT_REGEXP,"").replace(CSS_IMPORT_REGEXP,function(){for(var m=[],_i=0;_i<arguments.length;_i++)m[_i]=arguments[_i];var url=m[1]||m[2];return isStyleUrlResolvable(url)?(foundUrls.push(resolver.resolve(baseUrl,url)),""):m[0]});return new StyleWithImports(modifiedCssText,foundUrls)}function splitNsName(elementName){if(":"!=elementName[0])return[null,elementName];var colonIndex=elementName.indexOf(":",1);if(-1==colonIndex)throw new Error('Unsupported format "'+elementName+'" expecting ":namespace:name"');return[elementName.slice(1,colonIndex),elementName.slice(colonIndex+1)]}function isNgContainer(tagName){return"ng-container"===splitNsName(tagName)[1]}function isNgContent(tagName){return"ng-content"===splitNsName(tagName)[1]}function isNgTemplate(tagName){return"ng-template"===splitNsName(tagName)[1]}function getNsPrefix(fullName){return null===fullName?null:splitNsName(fullName)[0]}function mergeNsAndName(prefix,localName){return prefix?":"+prefix+":"+localName:localName}function preparseElement(ast){var selectAttr=null,hrefAttr=null,relAttr=null,nonBindable=!1,projectAs=null;ast.attrs.forEach(function(attr){var lcAttrName=attr.name.toLowerCase();lcAttrName==NG_CONTENT_SELECT_ATTR?selectAttr=attr.value:lcAttrName==LINK_STYLE_HREF_ATTR?hrefAttr=attr.value:lcAttrName==LINK_STYLE_REL_ATTR?relAttr=attr.value:attr.name==NG_NON_BINDABLE_ATTR?nonBindable=!0:attr.name==NG_PROJECT_AS&&attr.value.length>0&&(projectAs=attr.value)}),selectAttr=normalizeNgContentSelect(selectAttr);var nodeName=ast.name.toLowerCase(),type=PreparsedElementType.OTHER;return isNgContent(nodeName)?type=PreparsedElementType.NG_CONTENT:nodeName==STYLE_ELEMENT?type=PreparsedElementType.STYLE:nodeName==SCRIPT_ELEMENT?type=PreparsedElementType.SCRIPT:nodeName==LINK_ELEMENT&&relAttr==LINK_STYLE_REL_VALUE&&(type=PreparsedElementType.STYLESHEET),new PreparsedElement(type,selectAttr,hrefAttr,nonBindable,projectAs)}function normalizeNgContentSelect(selectAttr){return null===selectAttr||0===selectAttr.length?"*":selectAttr}function isDirectiveMetadata(type){return createDirective.isTypeOf(type)||createComponent.isTypeOf(type)}function findLast(arr,condition){for(var i=arr.length-1;i>=0;i--)if(condition(arr[i]))return arr[i];return null}function isWhitespace(code){return code>=$TAB&&code<=$SPACE||code==$NBSP}function isDigit(code){return $0<=code&&code<=$9}function isAsciiLetter(code){return code>=$a&&code<=$z||code>=$A&&code<=$Z}function isAsciiHexDigit(code){return code>=$a&&code<=$f||code>=$A&&code<=$F||isDigit(code)}function newCharacterToken(index,code){return new Token(index,TokenType.Character,code,String.fromCharCode(code))}function newIdentifierToken(index,text){return new Token(index,TokenType.Identifier,0,text)}function newKeywordToken(index,text){return new Token(index,TokenType.Keyword,0,text)}function newOperatorToken(index,text){return new Token(index,TokenType.Operator,0,text)}function newStringToken(index,text){return new Token(index,TokenType.String,0,text)}function newNumberToken(index,n){return new Token(index,TokenType.Number,n,"")}function newErrorToken(index,message){return new Token(index,TokenType.Error,0,message)}function isIdentifierStart(code){return $a<=code&&code<=$z||$A<=code&&code<=$Z||code==$_||code==$$}function isIdentifier(input){if(0==input.length)return!1;var scanner=new _Scanner(input);if(!isIdentifierStart(scanner.peek))return!1;for(scanner.advance();scanner.peek!==$EOF;){if(!isIdentifierPart(scanner.peek))return!1;scanner.advance()}return!0}function isIdentifierPart(code){return isAsciiLetter(code)||isDigit(code)||code==$_||code==$$}function isExponentStart(code){return code==$e||code==$E}function isExponentSign(code){return code==$MINUS||code==$PLUS}function isQuote(code){return code===$SQ||code===$DQ||code===$BT}function unescape(code){switch(code){case $n:return $LF;case $f:return $FF;case $r:return $CR;case $t:return $TAB;case $v:return $VTAB;default:return code}}function parseIntAutoRadix(text){var result=parseInt(text);if(isNaN(result))throw new Error("Invalid integer literal when parsing "+text);return result}function visitAstChildren(ast,visitor,context){function visit(ast){visitor.visit&&visitor.visit(ast,context)||ast.visit(visitor,context)}function visitAll(asts){asts.forEach(visit)}ast.visit({visitBinary:function(ast){visit(ast.left),visit(ast.right)},visitChain:function(ast){visitAll(ast.expressions)},visitConditional:function(ast){visit(ast.condition),visit(ast.trueExp),visit(ast.falseExp)},visitFunctionCall:function(ast){ast.target&&visit(ast.target),visitAll(ast.args)},visitImplicitReceiver:function(ast){},visitInterpolation:function(ast){visitAll(ast.expressions)},visitKeyedRead:function(ast){visit(ast.obj),visit(ast.key)},visitKeyedWrite:function(ast){visit(ast.obj),visit(ast.key),visit(ast.obj)},visitLiteralArray:function(ast){visitAll(ast.expressions)},visitLiteralMap:function(ast){},visitLiteralPrimitive:function(ast){},visitMethodCall:function(ast){visit(ast.receiver),visitAll(ast.args)},visitPipe:function(ast){visit(ast.exp),visitAll(ast.args)},visitPrefixNot:function(ast){visit(ast.expression)},visitNonNullAssert:function(ast){visit(ast.expression)},visitPropertyRead:function(ast){visit(ast.receiver)},visitPropertyWrite:function(ast){visit(ast.receiver),visit(ast.value)},visitQuote:function(ast){},visitSafeMethodCall:function(ast){visit(ast.receiver),visitAll(ast.args)},visitSafePropertyRead:function(ast){visit(ast.receiver)}})}function _createInterpolateRegExp(config){var pattern=escapeRegExp(config.start)+"([\\s\\S]*?)"+escapeRegExp(config.end);return new RegExp(pattern,"g")}function typeSourceSpan(kind,type){var moduleUrl=identifierModuleUrl(type),sourceFileName=null!=moduleUrl?"in "+kind+" "+identifierName(type)+" in "+moduleUrl:"in "+kind+" "+identifierName(type),sourceFile=new ParseSourceFile("",sourceFileName);return new ParseSourceSpan(new ParseLocation(sourceFile,-1,-1,-1),new ParseLocation(sourceFile,-1,-1,-1))}function tokenize(source,url,getTagDefinition,tokenizeExpansionForms,interpolationConfig){return void 0===tokenizeExpansionForms&&(tokenizeExpansionForms=!1),void 0===interpolationConfig&&(interpolationConfig=DEFAULT_INTERPOLATION_CONFIG),new _Tokenizer(new ParseSourceFile(source,url),getTagDefinition,tokenizeExpansionForms,interpolationConfig).tokenize()}function _unexpectedCharacterErrorMsg(charCode){return'Unexpected character "'+(charCode===$EOF?"EOF":String.fromCharCode(charCode))+'"'}function _unknownEntityErrorMsg(entitySrc){return'Unknown entity "'+entitySrc+'" - use the "&#<decimal>;" or  "&#x<hex>;" syntax'}function isNotWhitespace(code){return!isWhitespace(code)||code===$EOF}function isNameEnd(code){return isWhitespace(code)||code===$GT||code===$SLASH||code===$SQ||code===$DQ||code===$EQ}function isPrefixEnd(code){return(code<$a||$z<code)&&(code<$A||$Z<code)&&(code<$0||code>$9)}function isDigitEntityEnd(code){return code==$SEMICOLON||code==$EOF||!isAsciiHexDigit(code)}function isNamedEntityEnd(code){return code==$SEMICOLON||code==$EOF||!isAsciiLetter(code)}function isExpansionFormStart(input,offset,interpolationConfig){var isInterpolationStart=!!interpolationConfig&&input.indexOf(interpolationConfig.start,offset)==offset;return input.charCodeAt(offset)==$LBRACE&&!isInterpolationStart}function isExpansionCaseStart(peek){return peek===$EQ||isAsciiLetter(peek)||isDigit(peek)}function compareCharCodeCaseInsensitive(code1,code2){return toUpperCaseCharCode(code1)==toUpperCaseCharCode(code2)}function toUpperCaseCharCode(code){return code>=$a&&code<=$z?code-$a+$A:code}function mergeTextTokens(srcTokens){for(var dstTokens=[],lastDstToken=void 0,i=0;i<srcTokens.length;i++){var token=srcTokens[i];lastDstToken&&lastDstToken.type==TokenType$1.TEXT&&token.type==TokenType$1.TEXT?(lastDstToken.parts[0]+=token.parts[0],lastDstToken.sourceSpan.end=token.sourceSpan.end):(lastDstToken=token,dstTokens.push(lastDstToken))}return dstTokens}function lastOnStack(stack,element){return stack.length>0&&stack[stack.length-1]===element}/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
function digest(message){return message.id||sha1(serializeNodes(message.nodes).join("")+"["+message.meaning+"]")}function decimalDigest(message){if(message.id)return message.id;var visitor=new _SerializerIgnoreIcuExpVisitor;return computeMsgId(message.nodes.map(function(a){return a.visit(visitor,null)}).join(""),message.meaning)}function serializeNodes(nodes){return nodes.map(function(a){return a.visit(serializerVisitor,null)})}function sha1(str){var utf8=utf8Encode(str),words32=stringToWords32(utf8,Endian.Big),len=8*utf8.length,w=new Array(80),_a=[1732584193,4023233417,2562383102,271733878,3285377520],a=_a[0],b=_a[1],c=_a[2],d=_a[3],e=_a[4];words32[len>>5]|=128<<24-len%32,words32[15+(len+64>>9<<4)]=len;for(var i=0;i<words32.length;i+=16){for(var _b=[a,b,c,d,e],h0=_b[0],h1=_b[1],h2=_b[2],h3=_b[3],h4=_b[4],j=0;j<80;j++){w[j]=j<16?words32[i+j]:rol32(w[j-3]^w[j-8]^w[j-14]^w[j-16],1);var _c=fk(j,b,c,d),f=_c[0],k=_c[1],temp=[rol32(a,5),f,e,k,w[j]].reduce(add32);_d=[d,c,rol32(b,30),a,temp],e=_d[0],d=_d[1],c=_d[2],b=_d[3],a=_d[4]}_e=[add32(a,h0),add32(b,h1),add32(c,h2),add32(d,h3),add32(e,h4)],a=_e[0],b=_e[1],c=_e[2],d=_e[3],e=_e[4]}return byteStringToHexString(words32ToByteString([a,b,c,d,e]));var _d,_e}function fk(index,b,c,d){return index<20?[b&c|~b&d,1518500249]:index<40?[b^c^d,1859775393]:index<60?[b&c|b&d|c&d,2400959708]:[b^c^d,3395469782]}function fingerprint(str){var utf8=utf8Encode(str),_a=[hash32(utf8,0),hash32(utf8,102072)],hi=_a[0],lo=_a[1];return 0!=hi||0!=lo&&1!=lo||(hi^=319790063,lo^=-1801410264),[hi,lo]}function computeMsgId(msg,meaning){var _a=fingerprint(msg),hi=_a[0],lo=_a[1];if(meaning){var _b=fingerprint(meaning),him=_b[0],lom=_b[1];_c=add64(rol64([hi,lo],1),[him,lom]),hi=_c[0],lo=_c[1]}return byteStringToDecString(words32ToByteString([2147483647&hi,lo]));var _c}function hash32(str,c){var i,_a=[2654435769,2654435769],a=_a[0],b=_a[1],len=str.length;for(i=0;i+12<=len;i+=12)a=add32(a,wordAt(str,i,Endian.Little)),b=add32(b,wordAt(str,i+4,Endian.Little)),c=add32(c,wordAt(str,i+8,Endian.Little)),_b=mix([a,b,c]),a=_b[0],b=_b[1],c=_b[2];return a=add32(a,wordAt(str,i,Endian.Little)),b=add32(b,wordAt(str,i+4,Endian.Little)),c=add32(c,len),c=add32(c,wordAt(str,i+8,Endian.Little)<<8),mix([a,b,c])[2];var _b}function mix(_a){var a=_a[0],b=_a[1],c=_a[2];return a=sub32(a,b),a=sub32(a,c),a^=c>>>13,b=sub32(b,c),b=sub32(b,a),b^=a<<8,c=sub32(c,a),c=sub32(c,b),c^=b>>>13,a=sub32(a,b),a=sub32(a,c),a^=c>>>12,b=sub32(b,c),b=sub32(b,a),b^=a<<16,c=sub32(c,a),c=sub32(c,b),c^=b>>>5,a=sub32(a,b),a=sub32(a,c),a^=c>>>3,b=sub32(b,c),b=sub32(b,a),b^=a<<10,c=sub32(c,a),c=sub32(c,b),c^=b>>>15,[a,b,c]}function add32(a,b){return add32to64(a,b)[1]}function add32to64(a,b){var low=(65535&a)+(65535&b),high=(a>>>16)+(b>>>16)+(low>>>16);return[high>>>16,high<<16|65535&low]}function add64(_a,_b){var ah=_a[0],al=_a[1],bh=_b[0],bl=_b[1],_c=add32to64(al,bl),carry=_c[0],l=_c[1];return[add32(add32(ah,bh),carry),l]}function sub32(a,b){var low=(65535&a)-(65535&b);return(a>>16)-(b>>16)+(low>>16)<<16|65535&low}function rol32(a,count){return a<<count|a>>>32-count}function rol64(_a,count){var hi=_a[0],lo=_a[1];return[hi<<count|lo>>>32-count,lo<<count|hi>>>32-count]}function stringToWords32(str,endian){for(var words32=Array(str.length+3>>>2),i=0;i<words32.length;i++)words32[i]=wordAt(str,4*i,endian);return words32}function byteAt(str,index){return index>=str.length?0:255&str.charCodeAt(index)}function wordAt(str,index,endian){var word=0;if(endian===Endian.Big)for(var i=0;i<4;i++)word+=byteAt(str,index+i)<<24-8*i;else for(var i=0;i<4;i++)word+=byteAt(str,index+i)<<8*i;return word}function words32ToByteString(words32){return words32.reduce(function(str,word){return str+word32ToByteString(word)},"")}function word32ToByteString(word){for(var str="",i=0;i<4;i++)str+=String.fromCharCode(word>>>8*(3-i)&255);return str}function byteStringToHexString(str){for(var hex="",i=0;i<str.length;i++){var b=byteAt(str,i);hex+=(b>>>4).toString(16)+(15&b).toString(16)}return hex.toLowerCase()}function byteStringToDecString(str){for(var decimal="",toThePower="1",i=str.length-1;i>=0;i--)decimal=addBigInt(decimal,numberTimesBigInt(byteAt(str,i),toThePower)),toThePower=numberTimesBigInt(256,toThePower);return decimal.split("").reverse().join("")}function addBigInt(x,y){for(var sum="",len=Math.max(x.length,y.length),i=0,carry=0;i<len||carry;i++){var tmpSum=carry+ +(x[i]||0)+ +(y[i]||0);tmpSum>=10?(carry=1,sum+=tmpSum-10):(carry=0,sum+=tmpSum)}return sum}function numberTimesBigInt(num,b){for(var product="",bToThePower=b;0!==num;num>>>=1)1&num&&(product=addBigInt(product,bToThePower)),bToThePower=addBigInt(bToThePower,bToThePower);return product}function getHtmlTagDefinition(tagName){return TAG_DEFINITIONS[tagName.toLowerCase()]||_DEFAULT_TAG_DEFINITION}function createI18nMessageFactory(interpolationConfig){var visitor=new _I18nVisitor(_expParser,interpolationConfig);return function(nodes,meaning,description,id){return visitor.toI18nMessage(nodes,meaning,description,id)}}function _extractPlaceholderName(input){return input.split(_CUSTOM_PH_EXP)[2]}function extractMessages(nodes,interpolationConfig,implicitTags,implicitAttrs){return new _Visitor(implicitTags,implicitAttrs).extract(nodes,interpolationConfig)}function mergeTranslations(nodes,translations,interpolationConfig,implicitTags,implicitAttrs){return new _Visitor(implicitTags,implicitAttrs).merge(nodes,translations,interpolationConfig)}function _isOpeningComment(n){return!!(n instanceof Comment&&n.value&&n.value.startsWith("i18n"))}function _isClosingComment(n){return!!(n instanceof Comment&&n.value&&"/i18n"===n.value)}function _getI18nAttr(p){return p.attrs.find(function(attr){return attr.name===_I18N_ATTR})||null}function _parseMessageMeta(i18n){if(!i18n)return{meaning:"",description:"",id:""};var idIndex=i18n.indexOf(ID_SEPARATOR),descIndex=i18n.indexOf(MEANING_SEPARATOR),_a=idIndex>-1?[i18n.slice(0,idIndex),i18n.slice(idIndex+2)]:[i18n,""],meaningAndDesc=_a[0],id=_a[1],_b=descIndex>-1?[meaningAndDesc.slice(0,descIndex),meaningAndDesc.slice(descIndex+1)]:["",meaningAndDesc];return{meaning:_b[0],description:_b[1],id:id}}function getXmlTagDefinition(tagName){return _TAG_DEFINITION}function serialize(nodes){return nodes.map(function(node){return node.visit(_visitor)}).join("")}function escapeXml(text){return _ESCAPED_CHARS.reduce(function(text,entry){return text.replace(entry[0],entry[1])},text)}function getCtypeForTag(tag){switch(tag.toLowerCase()){case"br":return"lb";case"img":return"image";default:return"x-"+tag}}function getTypeForTag(tag){switch(tag.toLowerCase()){case"br":case"b":case"i":case"u":return"fmt";case"img":return"image";case"a":return"link";default:return"other"}}function digest$1(message){return decimalDigest(message)}function toPublicName(internalName){return internalName.toUpperCase().replace(/[^A-Z0-9_]/g,"_")}function createLazyProperty(messages,id,valueFn){Object.defineProperty(messages,id,{configurable:!0,enumerable:!0,get:function(){var value=valueFn();return Object.defineProperty(messages,id,{enumerable:!0,value:value}),value},set:function(_){throw new Error("Could not overwrite an XTB translation")}})}function createSerializer(format){switch(format=(format||"xlf").toLowerCase()){case"xmb":return new Xmb;case"xtb":return new Xtb;case"xliff2":case"xlf2":return new Xliff2;case"xliff":case"xlf":default:return new Xliff}}function ngfactoryFilePath(filePath,forceSourceFile){void 0===forceSourceFile&&(forceSourceFile=!1);var urlWithSuffix=splitTypescriptSuffix(filePath,forceSourceFile);return urlWithSuffix[0]+".ngfactory"+normalizeGenFileSuffix(urlWithSuffix[1])}function stripGeneratedFileSuffix(filePath){return filePath.replace(GENERATED_FILE,".")}function isGeneratedFile(filePath){return GENERATED_FILE.test(filePath)}function splitTypescriptSuffix(path,forceSourceFile){if(void 0===forceSourceFile&&(forceSourceFile=!1),path.endsWith(".d.ts"))return[path.slice(0,-5),forceSourceFile?".ts":".d.ts"];var lastDot=path.lastIndexOf(".");return-1!==lastDot?[path.substring(0,lastDot),path.substring(lastDot)]:[path,""]}function normalizeGenFileSuffix(srcFileSuffix){return".tsx"===srcFileSuffix?".ts":srcFileSuffix}function summaryFileName(fileName){return fileName.replace(STRIP_SRC_FILE_SUFFIXES,"")+".ngsummary.json"}function summaryForJitFileName(fileName,forceSourceFile){void 0===forceSourceFile&&(forceSourceFile=!1);var urlWithSuffix=splitTypescriptSuffix(stripGeneratedFileSuffix(fileName),forceSourceFile);return urlWithSuffix[0]+".ngsummary"+urlWithSuffix[1]}function stripSummaryForJitFileSuffix(filePath){return filePath.replace(JIT_SUMMARY_FILE,".")}function summaryForJitName(symbolName){return symbolName+"NgSummary"}function stripSummaryForJitNameSuffix(symbolName){return symbolName.replace(JIT_SUMMARY_NAME,"")}function isLoweredSymbol(name){return LOWERED_SYMBOL.test(name)}function createLoweredSymbol(id){return"ɵ"+id}function createTokenForReference(reference){return{identifier:{reference:reference}}}function createTokenForExternalReference(reflector,reference){return createTokenForReference(reflector.resolveExternalReference(reference))}function hasLifecycleHook(reflector,hook,token){return reflector.hasLifecycleHook(token,getHookName(hook))}function getAllLifecycleHooks(reflector,token){return LIFECYCLE_HOOKS_VALUES.filter(function(hook){return hasLifecycleHook(reflector,hook,token)})}function getHookName(hook){switch(hook){case LifecycleHooks.OnInit:return"ngOnInit";case LifecycleHooks.OnDestroy:return"ngOnDestroy";case LifecycleHooks.DoCheck:return"ngDoCheck";case LifecycleHooks.OnChanges:return"ngOnChanges";case LifecycleHooks.AfterContentInit:return"ngAfterContentInit";case LifecycleHooks.AfterContentChecked:return"ngAfterContentChecked";case LifecycleHooks.AfterViewInit:return"ngAfterViewInit";case LifecycleHooks.AfterViewChecked:return"ngAfterViewChecked"}}function flattenArray(tree,out){if(void 0===out&&(out=[]),tree)for(var i=0;i<tree.length;i++){var item=resolveForwardRef(tree[i]);Array.isArray(item)?flattenArray(item,out):out.push(item)}return out}function dedupeArray(array){return array?Array.from(new Set(array)):[]}function flattenAndDedupeArray(tree){return dedupeArray(flattenArray(tree))}function isValidType(value){return value instanceof StaticSymbol||value instanceof Type}function extractIdentifiers(value,targetIdentifiers){visitValue(value,new _CompileValueConverter,targetIdentifiers)}function stringifyType(type){return type instanceof StaticSymbol?type.name+" in "+type.filePath:stringify(type)}function componentStillLoadingError(compType){var error=Error("Can't compile synchronously as "+stringify(compType)+" is still being loaded!");return error[ERROR_COMPONENT_TYPE]=compType,error}function nullSafeIsEquivalent(base,other){return null==base||null==other?base==other:base.isEquivalent(other)}function areAllEquivalent(base,other){var len=base.length;if(len!==other.length)return!1;for(var i=0;i<len;i++)if(!base[i].isEquivalent(other[i]))return!1;return!0}function findReadVarNames(stmts){var visitor=new _ReadVarVisitor;return visitor.visitAllStatements(stmts,null),visitor.varNames}function collectExternalReferences(stmts){var visitor=new _FindExternalReferencesVisitor;return visitor.visitAllStatements(stmts,null),visitor.externalReferences}function applySourceSpanToStatementIfNeeded(stmt,sourceSpan){if(!sourceSpan)return stmt;var transformer=new _ApplySourceSpanTransformer(sourceSpan);return stmt.visitStatement(transformer,null)}function applySourceSpanToExpressionIfNeeded(expr,sourceSpan){if(!sourceSpan)return expr;var transformer=new _ApplySourceSpanTransformer(sourceSpan);return expr.visitExpression(transformer,null)}function variable(name,type,sourceSpan){return new ReadVarExpr(name,type,sourceSpan)}function importExpr(id,typeParams,sourceSpan){return void 0===typeParams&&(typeParams=null),new ExternalExpr(id,null,typeParams,sourceSpan)}function importType(id,typeParams,typeModifiers){return void 0===typeParams&&(typeParams=null),void 0===typeModifiers&&(typeModifiers=null),null!=id?expressionType(importExpr(id,typeParams,null),typeModifiers):null}function expressionType(expr,typeModifiers){return void 0===typeModifiers&&(typeModifiers=null),new ExpressionType(expr,typeModifiers)}function literalArr(values,type,sourceSpan){return new LiteralArrayExpr(values,type,sourceSpan)}function literalMap(values,type){return void 0===type&&(type=null),new LiteralMapExpr(values.map(function(e){return new LiteralMapEntry(e.key,e.value,e.quoted)}),type,null)}function not(expr,sourceSpan){return new NotExpr(expr,sourceSpan)}function assertNotNull(expr,sourceSpan){return new AssertNotNull(expr,sourceSpan)}function fn(params,body,type,sourceSpan){return new FunctionExpr(params,body,type,sourceSpan)}function literal(value,type,sourceSpan){return new LiteralExpr(value,type,sourceSpan)}function _transformProvider(provider,_a){var useExisting=_a.useExisting,useValue=_a.useValue,deps=_a.deps;return{token:provider.token,useClass:provider.useClass,useExisting:useExisting,useFactory:provider.useFactory,useValue:useValue,deps:deps,multi:provider.multi}}function _transformProviderAst(provider,_a){var eager=_a.eager,providers=_a.providers;return new ProviderAst(provider.token,provider.multiProvider,provider.eager||eager,providers,provider.providerType,provider.lifecycleHooks,provider.sourceSpan)}function _resolveProvidersFromDirectives(directives,sourceSpan,targetErrors){var providersByToken=new Map;return directives.forEach(function(directive){_resolveProviders([{token:{identifier:directive.type},useClass:directive.type}],directive.isComponent?ProviderAstType.Component:ProviderAstType.Directive,!0,sourceSpan,targetErrors,providersByToken)}),directives.filter(function(dir){return dir.isComponent}).concat(directives.filter(function(dir){return!dir.isComponent})).forEach(function(directive){_resolveProviders(directive.providers,ProviderAstType.PublicService,!1,sourceSpan,targetErrors,providersByToken),_resolveProviders(directive.viewProviders,ProviderAstType.PrivateService,!1,sourceSpan,targetErrors,providersByToken)}),providersByToken}function _resolveProviders(providers,providerType,eager,sourceSpan,targetErrors,targetProvidersByToken){providers.forEach(function(provider){var resolvedProvider=targetProvidersByToken.get(tokenReference(provider.token));if(null!=resolvedProvider&&!!resolvedProvider.multiProvider!=!!provider.multi&&targetErrors.push(new ProviderError("Mixing multi and non multi provider is not possible for token "+tokenName(resolvedProvider.token),sourceSpan)),resolvedProvider)provider.multi||(resolvedProvider.providers.length=0),resolvedProvider.providers.push(provider);else{var lifecycleHooks=provider.token.identifier&&provider.token.identifier.lifecycleHooks?provider.token.identifier.lifecycleHooks:[],isUseValue=!(provider.useClass||provider.useExisting||provider.useFactory);resolvedProvider=new ProviderAst(provider.token,!!provider.multi,eager||isUseValue,[provider],providerType,lifecycleHooks,sourceSpan),targetProvidersByToken.set(tokenReference(provider.token),resolvedProvider)}})}function _getViewQueries(component){var viewQueryId=1,viewQueries=new Map;return component.viewQueries&&component.viewQueries.forEach(function(query){return _addQueryToTokenMap(viewQueries,{meta:query,queryId:viewQueryId++})}),viewQueries}function _getContentQueries(contentQueryStartId,directives){var contentQueryId=contentQueryStartId,contentQueries=new Map;return directives.forEach(function(directive,directiveIndex){directive.queries&&directive.queries.forEach(function(query){return _addQueryToTokenMap(contentQueries,{meta:query,queryId:contentQueryId++})})}),contentQueries}function _addQueryToTokenMap(map,query){query.meta.selectors.forEach(function(token){var entry=map.get(tokenReference(token));entry||(entry=[],map.set(tokenReference(token),entry)),entry.push(query)})}function convertValueToOutputAst(ctx,value,type){return void 0===type&&(type=null),visitValue(value,new _ValueOutputAstTransformer(ctx),type)}/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
function providerDef(ctx,providerAst){var flags=0;providerAst.eager||(flags|=4096),providerAst.providerType===ProviderAstType.PrivateService&&(flags|=8192),providerAst.lifecycleHooks.forEach(function(lifecycleHook){lifecycleHook!==LifecycleHooks.OnDestroy&&providerAst.providerType!==ProviderAstType.Directive&&providerAst.providerType!==ProviderAstType.Component||(flags|=lifecycleHookToNodeFlag(lifecycleHook))});var _a=providerAst.multiProvider?multiProviderDef(ctx,flags,providerAst.providers):singleProviderDef(ctx,flags,providerAst.providerType,providerAst.providers[0]);return{providerExpr:_a.providerExpr,flags:_a.flags,depsExpr:_a.depsExpr,tokenExpr:tokenExpr(ctx,providerAst.token)}}function multiProviderDef(ctx,flags,providers){function convertDeps(providerIndex,deps){return deps.map(function(dep,depIndex){var paramName="p"+providerIndex+"_"+depIndex;return allParams.push(new FnParam(paramName,DYNAMIC_TYPE)),allDepDefs.push(depDef(ctx,dep)),variable(paramName)})}var allDepDefs=[],allParams=[],exprs=providers.map(function(provider,providerIndex){var expr;if(provider.useClass){var depExprs=convertDeps(providerIndex,provider.deps||provider.useClass.diDeps);expr=ctx.importExpr(provider.useClass.reference).instantiate(depExprs)}else if(provider.useFactory){var depExprs=convertDeps(providerIndex,provider.deps||provider.useFactory.diDeps);expr=ctx.importExpr(provider.useFactory.reference).callFn(depExprs)}else if(provider.useExisting){var depExprs=convertDeps(providerIndex,[{token:provider.useExisting}]);expr=depExprs[0]}else expr=convertValueToOutputAst(ctx,provider.useValue);return expr});return{providerExpr:fn(allParams,[new ReturnStatement(literalArr(exprs))],INFERRED_TYPE),flags:1024|flags,depsExpr:literalArr(allDepDefs)}}function singleProviderDef(ctx,flags,providerType,providerMeta){var providerExpr,deps;return providerType===ProviderAstType.Directive||providerType===ProviderAstType.Component?(providerExpr=ctx.importExpr(providerMeta.useClass.reference),flags|=16384,deps=providerMeta.deps||providerMeta.useClass.diDeps):providerMeta.useClass?(providerExpr=ctx.importExpr(providerMeta.useClass.reference),flags|=512,deps=providerMeta.deps||providerMeta.useClass.diDeps):providerMeta.useFactory?(providerExpr=ctx.importExpr(providerMeta.useFactory.reference),flags|=1024,deps=providerMeta.deps||providerMeta.useFactory.diDeps):providerMeta.useExisting?(providerExpr=NULL_EXPR,flags|=2048,deps=[{token:providerMeta.useExisting}]):(providerExpr=convertValueToOutputAst(ctx,providerMeta.useValue),flags|=256,deps=[]),{providerExpr:providerExpr,flags:flags,depsExpr:literalArr(deps.map(function(dep){return depDef(ctx,dep)}))}}function tokenExpr(ctx,tokenMeta){return tokenMeta.identifier?ctx.importExpr(tokenMeta.identifier.reference):literal(tokenMeta.value)}function depDef(ctx,dep){var expr=dep.isValue?convertValueToOutputAst(ctx,dep.value):tokenExpr(ctx,dep.token),flags=0;return dep.isSkipSelf&&(flags|=1),dep.isOptional&&(flags|=2),dep.isValue&&(flags|=8),0===flags?expr:literalArr([literal(flags),expr])}function lifecycleHookToNodeFlag(lifecycleHook){var nodeFlag=0;switch(lifecycleHook){case LifecycleHooks.AfterContentChecked:nodeFlag=2097152;break;case LifecycleHooks.AfterContentInit:nodeFlag=1048576;break;case LifecycleHooks.AfterViewChecked:nodeFlag=8388608;break;case LifecycleHooks.AfterViewInit:nodeFlag=4194304;break;case LifecycleHooks.DoCheck:nodeFlag=262144;break;case LifecycleHooks.OnChanges:nodeFlag=524288;break;case LifecycleHooks.OnDestroy:nodeFlag=131072;break;case LifecycleHooks.OnInit:nodeFlag=65536}return nodeFlag}function componentFactoryResolverProviderDef(reflector,ctx,flags,entryComponents){var entryComponentFactories=entryComponents.map(function(entryComponent){return ctx.importExpr(entryComponent.componentFactory)}),token=createTokenForExternalReference(reflector,Identifiers.ComponentFactoryResolver),classMeta={diDeps:[{isValue:!0,value:literalArr(entryComponentFactories)},{token:token,isSkipSelf:!0,isOptional:!0},{token:createTokenForExternalReference(reflector,Identifiers.NgModuleRef)}],lifecycleHooks:[],reference:reflector.resolveExternalReference(Identifiers.CodegenComponentFactoryResolver)},_a=singleProviderDef(ctx,flags,ProviderAstType.PrivateService,{token:token,multi:!1,useClass:classMeta});return{providerExpr:_a.providerExpr,flags:_a.flags,depsExpr:_a.depsExpr,tokenExpr:tokenExpr(ctx,token)}}function toBase64String(value){var b64="";value=utf8Encode(value);for(var i=0;i<value.length;){var i1=value.charCodeAt(i++),i2=value.charCodeAt(i++),i3=value.charCodeAt(i++);b64+=toBase64Digit(i1>>2),b64+=toBase64Digit((3&i1)<<4|(isNaN(i2)?0:i2>>4)),b64+=isNaN(i2)?"=":toBase64Digit((15&i2)<<2|i3>>6),b64+=isNaN(i2)||isNaN(i3)?"=":toBase64Digit(63&i3)}return b64}function toBase64VLQ(value){value=value<0?1+(-value<<1):value<<1;var out="";do{var digit=31&value;value>>=5,value>0&&(digit|=32),out+=toBase64Digit(digit)}while(value>0);return out}function toBase64Digit(value){if(value<0||value>=64)throw new Error("Can only encode value in the range [0, 63]");return B64_DIGITS[value]}function escapeIdentifier(input,escapeDollar,alwaysQuote){if(void 0===alwaysQuote&&(alwaysQuote=!0),null==input)return null;var body=input.replace(_SINGLE_QUOTE_ESCAPE_STRING_RE,function(){for(var match=[],_i=0;_i<arguments.length;_i++)match[_i]=arguments[_i];return"$"==match[0]?escapeDollar?"\\$":"$":"\n"==match[0]?"\\n":"\r"==match[0]?"\\r":"\\"+match[0]});return alwaysQuote||!_LEGAL_IDENTIFIER_RE.test(body)?"'"+body+"'":body}function _createIndent(count){for(var res="",i=0;i<count;i++)res+=_INDENT_WITH;return res}/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
function debugOutputAstAsTypeScript(ast){var converter=new _TsEmitterVisitor,ctx=EmitterVisitorContext.createRoot();return(Array.isArray(ast)?ast:[ast]).forEach(function(ast){if(ast instanceof Statement)ast.visitStatement(converter,ctx);else if(ast instanceof Expression)ast.visitExpression(converter,ctx);else{if(!(ast instanceof Type$1))throw new Error("Don't know how to print debug info for "+ast);ast.visitType(converter,ctx)}}),ctx.toSource()}function registerContext(ctx,specs){for(var _i=0,specs_1=specs;_i<specs_1.length;_i++){var spec=specs_1[_i];SECURITY_SCHEMA[spec.toLowerCase()]=ctx}}function _isPixelDimensionStyle(prop){switch(prop){case"width":case"height":case"minWidth":case"minHeight":case"maxWidth":case"maxHeight":case"left":case"top":case"bottom":case"right":case"fontSize":case"outlineWidth":case"outlineOffset":case"paddingTop":case"paddingLeft":case"paddingBottom":case"paddingRight":case"marginTop":case"marginLeft":case"marginBottom":case"marginRight":case"borderRadius":case"borderWidth":case"borderTopWidth":case"borderLeftWidth":case"borderRightWidth":case"borderBottomWidth":case"textIndent":return!0;default:return!1}}function stripComments(input){return input.replace(_commentRe,"")}function extractCommentsWithHash(input){return input.match(_commentWithHashRe)||[]}function processRules(input,ruleCallback){var inputWithEscapedBlocks=escapeBlocks(input),nextBlockIndex=0;return inputWithEscapedBlocks.escapedString.replace(_ruleRe,function(){for(var m=[],_i=0;_i<arguments.length;_i++)m[_i]=arguments[_i];var selector=m[2],content="",suffix=m[4],contentPrefix="";suffix&&suffix.startsWith("{"+BLOCK_PLACEHOLDER)&&(content=inputWithEscapedBlocks.blocks[nextBlockIndex++],suffix=suffix.substring(BLOCK_PLACEHOLDER.length+1),contentPrefix="{");var rule=ruleCallback(new CssRule(selector,content));return""+m[1]+rule.selector+m[3]+contentPrefix+rule.content+suffix})}function escapeBlocks(input){for(var inputParts=input.split(_curlyRe),resultParts=[],escapedBlocks=[],bracketCount=0,currentBlockParts=[],partIndex=0;partIndex<inputParts.length;partIndex++){var part=inputParts[partIndex];part==CLOSE_CURLY&&bracketCount--,bracketCount>0?currentBlockParts.push(part):(currentBlockParts.length>0&&(escapedBlocks.push(currentBlockParts.join("")),resultParts.push(BLOCK_PLACEHOLDER),currentBlockParts=[]),resultParts.push(part)),part==OPEN_CURLY&&bracketCount++}return currentBlockParts.length>0&&(escapedBlocks.push(currentBlockParts.join("")),resultParts.push(BLOCK_PLACEHOLDER)),new StringWithEscapedBlocks(resultParts.join(""),escapedBlocks)}function getStylesVarName(component){var result="styles";return component&&(result+="_"+identifierName(component.type)),result}function hasPreserveWhitespacesAttr(attrs){return attrs.some(function(attr){return attr.name===PRESERVE_WS_ATTR_NAME})}function replaceNgsp(value){return value.replace(new RegExp(NGSP_UNICODE,"g")," ")}function removeWhitespaces(htmlAstWithErrors){return new ParseTreeResult(visitAll(new WhitespaceVisitor,htmlAstWithErrors.rootNodes),htmlAstWithErrors.errors)}function expandNodes(nodes){var expander=new _Expander;return new ExpansionResult(visitAll(expander,nodes),expander.isExpanded,expander.errors)}function _expandPluralForm(ast,errors){var children=ast.cases.map(function(c){-1!=PLURAL_CASES.indexOf(c.value)||c.value.match(/^=\d+$/)||errors.push(new ExpansionError(c.valueSourceSpan,'Plural cases should be "=<number>" or one of '+PLURAL_CASES.join(", ")));var expansionResult=expandNodes(c.expression);return errors.push.apply(errors,expansionResult.errors),new Element("ng-template",[new Attribute$1("ngPluralCase",""+c.value,c.valueSourceSpan)],expansionResult.nodes,c.sourceSpan,c.sourceSpan,c.sourceSpan)}),switchAttr=new Attribute$1("[ngPlural]",ast.switchValue,ast.switchValueSourceSpan);return new Element("ng-container",[switchAttr],children,ast.sourceSpan,ast.sourceSpan,ast.sourceSpan)}function _expandDefaultForm(ast,errors){var children=ast.cases.map(function(c){var expansionResult=expandNodes(c.expression);return errors.push.apply(errors,expansionResult.errors),"other"===c.value?new Element("ng-template",[new Attribute$1("ngSwitchDefault","",c.valueSourceSpan)],expansionResult.nodes,c.sourceSpan,c.sourceSpan,c.sourceSpan):new Element("ng-template",[new Attribute$1("ngSwitchCase",""+c.value,c.valueSourceSpan)],expansionResult.nodes,c.sourceSpan,c.sourceSpan,c.sourceSpan)}),switchAttr=new Attribute$1("[ngSwitch]",ast.switchValue,ast.switchValueSourceSpan);return new Element("ng-container",[switchAttr],children,ast.sourceSpan,ast.sourceSpan,ast.sourceSpan)}function _isAnimationLabel(name){return"@"==name[0]}function calcPossibleSecurityContexts(registry,selector,propName,isAttribute){var ctxs=[];return CssSelector.parse(selector).forEach(function(selector){var elementNames=selector.element?[selector.element]:registry.allKnownElementNames(),notElementNames=new Set(selector.notSelectors.filter(function(selector){return selector.isElementSelector()}).map(function(selector){return selector.element})),possibleElementNames=elementNames.filter(function(elementName){return!notElementNames.has(elementName)});ctxs.push.apply(ctxs,possibleElementNames.map(function(elementName){return registry.securityContext(elementName,propName,isAttribute)}))}),0===ctxs.length?[SecurityContext.NONE]:Array.from(new Set(ctxs)).sort()}function warnOnlyOnce(warnings){return function(error){return-1===warnings.indexOf(error.msg)||(warningCounts[error.msg]=(warningCounts[error.msg]||0)+1,warningCounts[error.msg]<=1)}}function splitExportAs(exportAs){return exportAs?exportAs.split(",").map(function(e){return e.trim()}):[]}function splitClasses(classAttrValue){return classAttrValue.trim().split(/\s+/g)}function createElementCssSelector(elementName,attributes){var cssSelector=new CssSelector,elNameNoNs=splitNsName(elementName)[1];cssSelector.setElement(elNameNoNs);for(var i=0;i<attributes.length;i++){var attrName=attributes[i][0],attrNameNoNs=splitNsName(attrName)[1],attrValue=attributes[i][1];if(cssSelector.addAttribute(attrNameNoNs,attrValue),attrName.toLowerCase()==CLASS_ATTR){splitClasses(attrValue).forEach(function(className){return cssSelector.addClassName(className)})}}return cssSelector}function _isEmptyTextNode(node){return node instanceof Text&&0==node.value.trim().length}function removeSummaryDuplicates(items){var map=new Map;return items.forEach(function(item){map.get(item.type.reference)||map.set(item.type.reference,item)}),Array.from(map.values())}function isEmptyExpression(ast){return ast instanceof ASTWithSource&&(ast=ast.ast),ast instanceof EmptyExpr}function isTemplate(el,enableLegacyTemplate,reportDeprecation){if(isNgTemplate(el.name))return!0;var tagNoNs=splitNsName(el.name)[1];return!(tagNoNs.toLowerCase()!==TEMPLATE_ELEMENT||!enableLegacyTemplate||tagNoNs.toLowerCase()!==TEMPLATE_ELEMENT)&&(reportDeprecation(TEMPLATE_ELEMENT_DEPRECATION_WARNING,el.sourceSpan),!0)}function convertActionBinding(localResolver,implicitReceiver,action,bindingId){localResolver||(localResolver=new DefaultLocalResolver);var actionWithoutBuiltins=convertPropertyBindingBuiltins({createLiteralArrayConverter:function(argCount){return function(args){return literalArr(args)}},createLiteralMapConverter:function(keys){return function(values){return literalMap(keys.map(function(k,i){return{key:k.key,value:values[i],quoted:k.quoted}}))}},createPipeConverter:function(name){throw new Error("Illegal State: Actions are not allowed to contain pipes. Pipe: "+name)}},action),visitor=new _AstToIrVisitor(localResolver,implicitReceiver,bindingId),actionStmts=[];flattenStatements(actionWithoutBuiltins.visit(visitor,_Mode.Statement),actionStmts),prependTemporaryDecls(visitor.temporaryCount,bindingId,actionStmts);var lastIndex=actionStmts.length-1,preventDefaultVar=null;if(lastIndex>=0){var lastStatement=actionStmts[lastIndex],returnExpr=convertStmtIntoExpression(lastStatement);returnExpr&&(preventDefaultVar=createPreventDefaultVar(bindingId),actionStmts[lastIndex]=preventDefaultVar.set(returnExpr.cast(DYNAMIC_TYPE).notIdentical(literal(!1))).toDeclStmt(null,[StmtModifier.Final]))}return new ConvertActionBindingResult(actionStmts,preventDefaultVar)}function convertPropertyBindingBuiltins(converterFactory,ast){return convertBuiltins(converterFactory,ast)}function convertPropertyBinding(localResolver,implicitReceiver,expressionWithoutBuiltins,bindingId,form){localResolver||(localResolver=new DefaultLocalResolver);var currValExpr=createCurrValueExpr(bindingId),stmts=[],visitor=new _AstToIrVisitor(localResolver,implicitReceiver,bindingId),outputExpr=expressionWithoutBuiltins.visit(visitor,_Mode.Expression);if(visitor.temporaryCount)for(var i=0;i<visitor.temporaryCount;i++)stmts.push(temporaryDeclaration(bindingId,i));else if(form==BindingForm.TrySimple)return new ConvertPropertyBindingResult([],outputExpr);return stmts.push(currValExpr.set(outputExpr).toDeclStmt(DYNAMIC_TYPE,[StmtModifier.Final])),new ConvertPropertyBindingResult(stmts,currValExpr)}function convertBuiltins(converterFactory,ast){var visitor=new _BuiltinAstConverter(converterFactory);return ast.visit(visitor)}function temporaryName(bindingId,temporaryNumber){return"tmp_"+bindingId+"_"+temporaryNumber}function temporaryDeclaration(bindingId,temporaryNumber){return new DeclareVarStmt(temporaryName(bindingId,temporaryNumber),NULL_EXPR)}function prependTemporaryDecls(temporaryCount,bindingId,statements){for(var i=temporaryCount-1;i>=0;i--)statements.unshift(temporaryDeclaration(bindingId,i))}function ensureStatementMode(mode,ast){if(mode!==_Mode.Statement)throw new Error("Expected a statement, but saw "+ast)}function ensureExpressionMode(mode,ast){if(mode!==_Mode.Expression)throw new Error("Expected an expression, but saw "+ast)}function convertToStatementIfNeeded(mode,expr){return mode===_Mode.Statement?expr.toStmt():expr}function flattenStatements(arg,output){Array.isArray(arg)?arg.forEach(function(entry){return flattenStatements(entry,output)}):output.push(arg)}function createCurrValueExpr(bindingId){return variable("currVal_"+bindingId)}function createPreventDefaultVar(bindingId){return variable("pd_"+bindingId)}function convertStmtIntoExpression(stmt){return stmt instanceof ExpressionStatement?stmt.expr:stmt instanceof ReturnStatement?stmt.value:null}function needsAdditionalRootNode(astNodes){var lastAstNode=astNodes[astNodes.length-1];return lastAstNode instanceof EmbeddedTemplateAst?lastAstNode.hasViewContainer:lastAstNode instanceof ElementAst?isNgContainer(lastAstNode.name)&&lastAstNode.children.length?needsAdditionalRootNode(lastAstNode.children):lastAstNode.hasViewContainer:lastAstNode instanceof NgContentAst}function elementBindingDef(inputAst,dirAst){switch(inputAst.type){case PropertyBindingType.Attribute:return literalArr([literal(1),literal(inputAst.name),literal(inputAst.securityContext)]);case PropertyBindingType.Property:return literalArr([literal(8),literal(inputAst.name),literal(inputAst.securityContext)]);case PropertyBindingType.Animation:return literalArr([literal(8|(dirAst&&dirAst.directive.isComponent?32:16)),literal("@"+inputAst.name),literal(inputAst.securityContext)]);case PropertyBindingType.Class:return literalArr([literal(2),literal(inputAst.name),NULL_EXPR]);case PropertyBindingType.Style:return literalArr([literal(4),literal(inputAst.name),literal(inputAst.unit)])}}function fixedAttrsDef(elementAst){var mapResult=Object.create(null);return elementAst.attrs.forEach(function(attrAst){mapResult[attrAst.name]=attrAst.value}),elementAst.directives.forEach(function(dirAst){Object.keys(dirAst.directive.hostAttributes).forEach(function(name){var value=dirAst.directive.hostAttributes[name],prevValue=mapResult[name];mapResult[name]=null!=prevValue?mergeAttributeValue(name,prevValue,value):value})}),literalArr(Object.keys(mapResult).sort().map(function(attrName){return literalArr([literal(attrName),literal(mapResult[attrName])])}))}function mergeAttributeValue(attrName,attrValue1,attrValue2){return attrName==CLASS_ATTR$1||attrName==STYLE_ATTR?attrValue1+" "+attrValue2:attrValue2}function callCheckStmt(nodeIndex,exprs){return exprs.length>10?CHECK_VAR.callFn([VIEW_VAR,literal(nodeIndex),literal(1),literalArr(exprs)]):CHECK_VAR.callFn([VIEW_VAR,literal(nodeIndex),literal(0)].concat(exprs))}function callUnwrapValue(nodeIndex,bindingIdx,expr){return importExpr(Identifiers.unwrapValue).callFn([VIEW_VAR,literal(nodeIndex),literal(bindingIdx),expr])}function findStaticQueryIds(nodes,result){return void 0===result&&(result=new Map),nodes.forEach(function(node){var staticQueryIds=new Set,dynamicQueryIds=new Set,queryMatches=void 0;node instanceof ElementAst?(findStaticQueryIds(node.children,result),node.children.forEach(function(child){var childData=result.get(child);childData.staticQueryIds.forEach(function(queryId){return staticQueryIds.add(queryId)}),childData.dynamicQueryIds.forEach(function(queryId){return dynamicQueryIds.add(queryId)})}),queryMatches=node.queryMatches):node instanceof EmbeddedTemplateAst&&(findStaticQueryIds(node.children,result),node.children.forEach(function(child){var childData=result.get(child);childData.staticQueryIds.forEach(function(queryId){return dynamicQueryIds.add(queryId)}),childData.dynamicQueryIds.forEach(function(queryId){return dynamicQueryIds.add(queryId)})}),queryMatches=node.queryMatches),queryMatches&&queryMatches.forEach(function(match){return staticQueryIds.add(match.queryId)}),dynamicQueryIds.forEach(function(queryId){return staticQueryIds.delete(queryId)}),result.set(node,{staticQueryIds:staticQueryIds,dynamicQueryIds:dynamicQueryIds})}),result}function staticViewQueryIds(nodeStaticQueryIds){var staticQueryIds=new Set,dynamicQueryIds=new Set;return Array.from(nodeStaticQueryIds.values()).forEach(function(entry){entry.staticQueryIds.forEach(function(queryId){return staticQueryIds.add(queryId)}),entry.dynamicQueryIds.forEach(function(queryId){return dynamicQueryIds.add(queryId)})}),dynamicQueryIds.forEach(function(queryId){return staticQueryIds.delete(queryId)}),{staticQueryIds:staticQueryIds,dynamicQueryIds:dynamicQueryIds}}function elementEventNameAndTarget(eventAst,dirAst){return eventAst.isAnimation?{name:"@"+eventAst.name+"."+eventAst.phase,target:dirAst&&dirAst.directive.isComponent?"component":null}:eventAst}function calcStaticDynamicQueryFlags(queryIds,queryId,isFirst){var flags=0;return!isFirst||!queryIds.staticQueryIds.has(queryId)&&queryIds.dynamicQueryIds.has(queryId)?flags|=536870912:flags|=268435456,flags}function elementEventFullName(target,name){return target?target+":"+name:name}function toTypeScript(file,preamble){if(void 0===preamble&&(preamble=""),!file.stmts)throw new Error("Illegal state: No stmts present on GeneratedFile "+file.genFileUrl);return(new TypeScriptEmitter).emitStatements(file.genFileUrl,file.stmts,preamble)}/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
function listLazyRoutes(moduleMeta,reflector){for(var allLazyRoutes=[],_i=0,_a=moduleMeta.transitiveModule.providers;_i<_a.length;_i++){var _b=_a[_i],provider=_b.provider,module=_b.module;if(tokenReference(provider.token)===reflector.ROUTES)for(var loadChildren=_collectLoadChildren(provider.useValue),_c=0,loadChildren_1=loadChildren;_c<loadChildren_1.length;_c++){var route=loadChildren_1[_c];allLazyRoutes.push(parseLazyRoute(route,reflector,module.reference))}}return allLazyRoutes}function _collectLoadChildren(routes,target){if(void 0===target&&(target=[]),"string"==typeof routes)target.push(routes);else if(Array.isArray(routes))for(var _i=0,routes_1=routes;_i<routes_1.length;_i++){var route=routes_1[_i];_collectLoadChildren(route,target)}else routes.loadChildren?_collectLoadChildren(routes.loadChildren,target):routes.children&&_collectLoadChildren(routes.children,target);return target}function parseLazyRoute(route,reflector,module){var _a=route.split("#"),routePath=_a[0],routeName=_a[1],referencedModule=reflector.resolveExternalReference({moduleName:routePath,name:routeName},module?module.filePath:void 0);return{route:route,module:module||referencedModule,referencedModule:referencedModule}}function unescapeIdentifier(identifier){return identifier.startsWith("___")?identifier.substr(1):identifier}function unwrapResolvedMetadata(metadata){return metadata&&"resolved"===metadata.__symbolic?metadata.symbol:metadata}function serializeSummaries(srcFileName,forJitCtx,summaryResolver,symbolResolver,symbols,types){var toJsonSerializer=new ToJsonSerializer(symbolResolver,summaryResolver,srcFileName);symbols.forEach(function(resolvedSymbol){return toJsonSerializer.addSummary({symbol:resolvedSymbol.symbol,metadata:resolvedSymbol.metadata})}),types.forEach(function(_a){var summary=_a.summary;_a.metadata;toJsonSerializer.addSummary({symbol:summary.type.reference,metadata:void 0,type:summary})});var _a=toJsonSerializer.serialize(),json=_a.json,exportAs=_a.exportAs;if(forJitCtx){var forJitSerializer_1=new ForJitSerializer(forJitCtx,symbolResolver,summaryResolver);types.forEach(function(_a){var summary=_a.summary,metadata=_a.metadata;forJitSerializer_1.addSourceType(summary,metadata)}),toJsonSerializer.unprocessedSymbolSummariesBySymbol.forEach(function(summary){summaryResolver.isLibraryFile(summary.symbol.filePath)&&summary.type&&forJitSerializer_1.addLibType(summary.type)}),forJitSerializer_1.serialize(exportAs)}return{json:json,exportAs:exportAs}}function deserializeSummaries(symbolCache,summaryResolver,libraryFileName,json){return new FromJsonDeserializer(symbolCache,summaryResolver).deserialize(libraryFileName,json)}function createForJitStub(outputCtx,reference){return createSummaryForJitFunction(outputCtx,reference,NULL_EXPR)}function createSummaryForJitFunction(outputCtx,reference,value){var fnName=summaryForJitName(reference.name);outputCtx.statements.push(fn([],[new ReturnStatement(value)],new ArrayType(DYNAMIC_TYPE)).toDeclStmt(fnName,[StmtModifier.Final,StmtModifier.Exported]))}function isCall(metadata){return metadata&&"call"===metadata.__symbolic}function isFunctionCall(metadata){return isCall(metadata)&&unwrapResolvedMetadata(metadata.expression)instanceof StaticSymbol}function isMethodCallOnVariable(metadata){return isCall(metadata)&&metadata.expression&&"select"===metadata.expression.__symbolic&&unwrapResolvedMetadata(metadata.expression.expression)instanceof StaticSymbol}function _createEmptyStub(outputCtx){outputCtx.statements.push(importExpr(Identifiers.ComponentFactory).toStmt())}function _resolveStyleStatements(symbolResolver,compileResult,needsShim,fileSuffix){compileResult.dependencies.forEach(function(dep){dep.setValue(symbolResolver.getStaticSymbol(_stylesModuleUrl(dep.moduleUrl,needsShim,fileSuffix),dep.name))})}function _stylesModuleUrl(stylesheetUrl,shim,suffix){return stylesheetUrl+(shim?".shim":"")+".ngstyle"+suffix}function analyzeNgModules(fileNames,host,staticSymbolResolver,metadataResolver){return mergeAnalyzedFiles(_analyzeFilesIncludingNonProgramFiles(fileNames,host,staticSymbolResolver,metadataResolver))}function analyzeAndValidateNgModules(fileNames,host,staticSymbolResolver,metadataResolver){return validateAnalyzedModules(analyzeNgModules(fileNames,host,staticSymbolResolver,metadataResolver))}function validateAnalyzedModules(analyzedModules){if(analyzedModules.symbolsMissingModule&&analyzedModules.symbolsMissingModule.length){throw syntaxError(analyzedModules.symbolsMissingModule.map(function(s){return"Cannot determine the module for class "+s.name+" in "+s.filePath+"! Add "+s.name+" to the NgModule to fix it."}).join("\n"))}return analyzedModules}function _analyzeFilesIncludingNonProgramFiles(fileNames,host,staticSymbolResolver,metadataResolver){var seenFiles=new Set,files=[],visitFile=function(fileName){if(seenFiles.has(fileName)||!host.isSourceFile(fileName))return!1;seenFiles.add(fileName);var analyzedFile=analyzeFile(host,staticSymbolResolver,metadataResolver,fileName);files.push(analyzedFile),analyzedFile.ngModules.forEach(function(ngModule){ngModule.transitiveModule.modules.forEach(function(modMeta){return visitFile(modMeta.reference.filePath)})})};return fileNames.forEach(function(fileName){return visitFile(fileName)}),files}function analyzeFile(host,staticSymbolResolver,metadataResolver,fileName){var directives=[],pipes=[],injectables=[],ngModules=[],hasDecorators=staticSymbolResolver.hasDecorators(fileName),exportsNonSourceFiles=!1;return fileName.endsWith(".d.ts")&&!hasDecorators||staticSymbolResolver.getSymbolsOf(fileName).forEach(function(symbol){var resolvedSymbol=staticSymbolResolver.resolveSymbol(symbol),symbolMeta=resolvedSymbol.metadata;if(symbolMeta&&"error"!==symbolMeta.__symbolic){var isNgSymbol=!1;if("class"===symbolMeta.__symbolic)if(metadataResolver.isDirective(symbol))isNgSymbol=!0,directives.push(symbol);else if(metadataResolver.isPipe(symbol))isNgSymbol=!0,pipes.push(symbol);else if(metadataResolver.isNgModule(symbol)){var ngModule=metadataResolver.getNgModuleMetadata(symbol,!1);ngModule&&(isNgSymbol=!0,ngModules.push(ngModule))}else metadataResolver.isInjectable(symbol)&&(isNgSymbol=!0,injectables.push(symbol));isNgSymbol||(exportsNonSourceFiles=exportsNonSourceFiles||isValueExportingNonSourceFile(host,symbolMeta))}}),{fileName:fileName,directives:directives,pipes:pipes,ngModules:ngModules,injectables:injectables,exportsNonSourceFiles:exportsNonSourceFiles}}function isValueExportingNonSourceFile(host,metadata){var exportsNonSourceFiles=!1;return visitValue(metadata,new(function(){function Visitor(){}return Visitor.prototype.visitArray=function(arr,context){var _this=this;arr.forEach(function(v){return visitValue(v,_this,context)})},Visitor.prototype.visitStringMap=function(map,context){var _this=this;Object.keys(map).forEach(function(key){return visitValue(map[key],_this,context)})},Visitor.prototype.visitPrimitive=function(value,context){},Visitor.prototype.visitOther=function(value,context){value instanceof StaticSymbol&&!host.isSourceFile(value.filePath)&&(exportsNonSourceFiles=!0)},Visitor}()),null),exportsNonSourceFiles}function mergeAnalyzedFiles(analyzedFiles){var allNgModules=[],ngModuleByPipeOrDirective=new Map,allPipesAndDirectives=new Set;analyzedFiles.forEach(function(af){af.ngModules.forEach(function(ngModule){allNgModules.push(ngModule),ngModule.declaredDirectives.forEach(function(d){return ngModuleByPipeOrDirective.set(d.reference,ngModule)}),ngModule.declaredPipes.forEach(function(p){return ngModuleByPipeOrDirective.set(p.reference,ngModule)})}),af.directives.forEach(function(d){return allPipesAndDirectives.add(d)}),af.pipes.forEach(function(p){return allPipesAndDirectives.add(p)})});var symbolsMissingModule=[];return allPipesAndDirectives.forEach(function(ref){ngModuleByPipeOrDirective.has(ref)||symbolsMissingModule.push(ref)}),{ngModules:allNgModules,ngModuleByPipeOrDirective:ngModuleByPipeOrDirective,symbolsMissingModule:symbolsMissingModule,files:analyzedFiles}}function mergeAndValidateNgFiles(files){return validateAnalyzedModules(mergeAnalyzedFiles(files))}function indentStr(level){if(level<=0)return"";if(level<6)return[""," ","  ","   ","    ","     "][level];var half=indentStr(Math.floor(level/2));return half+half+(level%2==1?" ":"")}function formatChain(chain,indent){if(void 0===indent&&(indent=0),!chain)return"";var position=chain.position?chain.position.fileName+"("+(chain.position.line+1)+","+(chain.position.column+1)+")":"",prefix=position&&0===indent?position+": ":"",postfix=position&&0!==indent?" at "+position:"",message=""+prefix+chain.message+postfix;return""+indentStr(indent)+message+(chain.next&&"\n"+formatChain(chain.next,indent+2)||"")}function formattedError(chain){var message=formatChain(chain)+".",error=syntaxError(message);return error[FORMATTED_MESSAGE]=!0,error.chain=chain,error.position=chain.position,error}function isFormattedError(error){return!!error[FORMATTED_MESSAGE]}function shouldIgnore(value){return value&&"ignore"==value.__symbolic}function metadataError(message,summary,advise,position,symbol,context,chain){var error=syntaxError(message);return error[METADATA_ERROR]=!0,advise&&(error.advise=advise),position&&(error.position=position),summary&&(error.summary=summary),context&&(error.context=context),chain&&(error.chain=chain),symbol&&(error.symbol=symbol),error}function isMetadataError(error){return!!error[METADATA_ERROR]}function expandedMessage(message,context){switch(message){case REFERENCE_TO_NONEXPORTED_CLASS:if(context&&context.className)return"References to a non-exported class are not supported in decorators but "+context.className+" was referenced.";break;case VARIABLE_NOT_INITIALIZED:return"Only initialized variables and constants can be referenced in decorators because the value of this variable is needed by the template compiler";case DESTRUCTURE_NOT_SUPPORTED:return"Referencing an exported destructured variable or constant is not supported in decorators and this value is needed by the template compiler";case COULD_NOT_RESOLVE_TYPE:if(context&&context.typeName)return"Could not resolve type "+context.typeName;break;case FUNCTION_CALL_NOT_SUPPORTED:return context&&context.name?"Function calls are not supported in decorators but '"+context.name+"' was called":"Function calls are not supported in decorators";case REFERENCE_TO_LOCAL_SYMBOL:if(context&&context.name)return"Reference to a local (non-exported) symbols are not supported in decorators but '"+context.name+"' was referenced";break;case LAMBDA_NOT_SUPPORTED:return"Function expressions are not supported in decorators"}return message}function messageAdvise(message,context){switch(message){case REFERENCE_TO_NONEXPORTED_CLASS:if(context&&context.className)return"Consider exporting '"+context.className+"'";break;case DESTRUCTURE_NOT_SUPPORTED:return"Consider simplifying to avoid destructuring";case REFERENCE_TO_LOCAL_SYMBOL:if(context&&context.name)return"Consider exporting '"+context.name+"'";break;case LAMBDA_NOT_SUPPORTED:return"Consider changing the function expression into an exported function"}}function errorSummary(error){if(error.summary)return error.summary;switch(error.message){case REFERENCE_TO_NONEXPORTED_CLASS:if(error.context&&error.context.className)return"references non-exported class "+error.context.className;break;case VARIABLE_NOT_INITIALIZED:return"is not initialized";case DESTRUCTURE_NOT_SUPPORTED:return"is a destructured variable";case COULD_NOT_RESOLVE_TYPE:return"could not be resolved";case FUNCTION_CALL_NOT_SUPPORTED:return error.context&&error.context.name?"calls '"+error.context.name+"'":"calls a function";case REFERENCE_TO_LOCAL_SYMBOL:return error.context&&error.context.name?"references local variable "+error.context.name:"references a local variable"}return"contains the error"}function mapStringMap(input,transform){if(!input)return{};var result={};return Object.keys(input).forEach(function(key){var value=transform(input[key],key);shouldIgnore(value)||(HIDDEN_KEY.test(key)?Object.defineProperty(result,key,{enumerable:!1,configurable:!0,value:value}):result[key]=value)}),result}function isPrimitive(o){return null===o||"function"!=typeof o&&"object"!=typeof o}function formatMetadataMessageChain(chain,advise){return{message:expandedMessage(chain.message,chain.context)+(chain.symbol?" in '"+chain.symbol.name+"'":""),position:chain.position,next:chain.next?formatMetadataMessageChain(chain.next,advise):advise?{message:advise}:void 0}}function formatMetadataError(e,context){if(isMetadataError(e)){var position=e.position;return formattedError(formatMetadataMessageChain({message:"Error during template compile of '"+context.name+"'",position:position,next:{message:e.message,next:e.chain,context:e.context,symbol:e.symbol}},e.advise||messageAdvise(e.message,e.context)))}return e}/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
function createAotUrlResolver(host){return{resolve:function(basePath,url){var filePath=host.resourceNameToFileName(url,basePath);if(!filePath)throw syntaxError("Couldn't resolve resource "+url+" from "+basePath);return filePath}}}function createAotCompiler(compilerHost,options,errorCollector){var translations=options.translations||"",urlResolver=createAotUrlResolver(compilerHost),symbolCache=new StaticSymbolCache,summaryResolver=new AotSummaryResolver(compilerHost,symbolCache),symbolResolver=new StaticSymbolResolver(compilerHost,symbolCache,summaryResolver),staticReflector=new StaticReflector(summaryResolver,symbolResolver,[],[],errorCollector),htmlParser=new I18NHtmlParser(new HtmlParser,translations,options.i18nFormat,options.missingTranslation,console),config=new CompilerConfig({defaultEncapsulation:ViewEncapsulation.Emulated,useJit:!1,enableLegacyTemplate:!0===options.enableLegacyTemplate,missingTranslation:options.missingTranslation,preserveWhitespaces:options.preserveWhitespaces,strictInjectionParameters:options.strictInjectionParameters}),normalizer=new DirectiveNormalizer({get:function(url){return compilerHost.loadResource(url)}},urlResolver,htmlParser,config),expressionParser=new Parser(new Lexer),elementSchemaRegistry=new DomElementSchemaRegistry,tmplParser=new TemplateParser(config,staticReflector,expressionParser,elementSchemaRegistry,htmlParser,console,[]),resolver=new CompileMetadataResolver(config,htmlParser,new NgModuleResolver(staticReflector),new DirectiveResolver(staticReflector),new PipeResolver(staticReflector),summaryResolver,elementSchemaRegistry,normalizer,console,symbolCache,staticReflector,errorCollector),viewCompiler=new ViewCompiler(staticReflector),typeCheckCompiler=new TypeCheckCompiler(options,staticReflector);return{compiler:new AotCompiler(config,options,compilerHost,staticReflector,resolver,tmplParser,new StyleCompiler(urlResolver),viewCompiler,typeCheckCompiler,new NgModuleCompiler(staticReflector),new TypeScriptEmitter,summaryResolver,symbolResolver),reflector:staticReflector}}/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
function interpretStatements(statements,reflector){var ctx=new _ExecutionContext(null,null,null,new Map);new StatementInterpreter(reflector).visitAllStatements(statements,ctx);var result={};return ctx.exports.forEach(function(exportName){result[exportName]=ctx.vars.get(exportName)}),result}function _executeFunctionStatements(varNames,varValues,statements,ctx,visitor){for(var childCtx=ctx.createChildWihtLocalVars(),i=0;i<varNames.length;i++)childCtx.vars.set(varNames[i],varValues[i]);var result=visitor.visitAllStatements(statements,childCtx);return result?result.value:null}function createDynamicClass(_classStmt,_ctx,_visitor){var propertyDescriptors={};_classStmt.getters.forEach(function(getter){propertyDescriptors[getter.name]={configurable:!1,get:function(){var instanceCtx=new _ExecutionContext(_ctx,this,_classStmt.name,_ctx.vars);return _executeFunctionStatements([],[],getter.body,instanceCtx,_visitor)}}}),_classStmt.methods.forEach(function(method){var paramNames=method.params.map(function(param){return param.name});propertyDescriptors[method.name]={writable:!1,configurable:!1,value:function(){for(var args=[],_i=0;_i<arguments.length;_i++)args[_i]=arguments[_i];var instanceCtx=new _ExecutionContext(_ctx,this,_classStmt.name,_ctx.vars);return _executeFunctionStatements(paramNames,args,method.body,instanceCtx,_visitor)}}});var ctorParamNames=_classStmt.constructorMethod.params.map(function(param){return param.name}),ctor=function(){for(var _this=this,args=[],_i=0;_i<arguments.length;_i++)args[_i]=arguments[_i];var instanceCtx=new _ExecutionContext(_ctx,this,_classStmt.name,_ctx.vars);_classStmt.fields.forEach(function(field){_this[field.name]=void 0}),_executeFunctionStatements(ctorParamNames,args,_classStmt.constructorMethod.body,instanceCtx,_visitor)},superClass=_classStmt.parent?_classStmt.parent.visitExpression(_visitor,_ctx):Object;return ctor.prototype=Object.create(superClass.prototype,propertyDescriptors),ctor}function _declareFn(varNames,statements,ctx,visitor){return function(){for(var args=[],_i=0;_i<arguments.length;_i++)args[_i]=arguments[_i];return _executeFunctionStatements(varNames,args,statements,ctx,visitor)}}/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
function evalExpression(sourceUrl,ctx,vars,createSourceMap){var fnBody=ctx.toSource()+"\n//# sourceURL="+sourceUrl,fnArgNames=[],fnArgValues=[];for(var argName in vars)fnArgNames.push(argName),fnArgValues.push(vars[argName]);if(createSourceMap){var emptyFn=(new(Function.bind.apply(Function,[void 0].concat(fnArgNames.concat("return null;"))))).toString(),headerLines=emptyFn.slice(0,emptyFn.indexOf("return null;")).split("\n").length-1;fnBody+="\n"+ctx.toSourceMapGenerator(sourceUrl,headerLines).toJsComment()}return(new(Function.bind.apply(Function,[void 0].concat(fnArgNames.concat(fnBody))))).apply(void 0,fnArgValues)}function jitStatements(sourceUrl,statements,reflector,createSourceMaps){var converter=new JitEmitterVisitor(reflector),ctx=EmitterVisitorContext.createRoot();return converter.visitAllStatements(statements,ctx),converter.createReturnStmt(ctx),evalExpression(sourceUrl,ctx,converter.getArgs(),createSourceMaps)}function assertComponent(meta){if(!meta.isComponent)throw new Error("Could not compile '"+identifierName(meta.type)+"' because it is not a component.")}function createOutputContext(){return{statements:[],genFilePath:"",importExpr:function(symbol){return importExpr({name:identifierName(symbol),moduleName:null,runtime:symbol})}}}/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
function createUrlResolverWithoutPackagePrefix(){return new UrlResolver}function createOfflineCompileUrlResolver(){return new UrlResolver(".")}function getUrlScheme(url){var match=_split(url);return match&&match[_ComponentIndex.Scheme]||""}function _buildFromEncodedParts(opt_scheme,opt_userInfo,opt_domain,opt_port,opt_path,opt_queryData,opt_fragment){var out=[];return null!=opt_scheme&&out.push(opt_scheme+":"),null!=opt_domain&&(out.push("//"),null!=opt_userInfo&&out.push(opt_userInfo+"@"),out.push(opt_domain),null!=opt_port&&out.push(":"+opt_port)),null!=opt_path&&out.push(opt_path),null!=opt_queryData&&out.push("?"+opt_queryData),null!=opt_fragment&&out.push("#"+opt_fragment),out.join("")}function _split(uri){return uri.match(_splitRe)}function _removeDotSegments(path){if("/"==path)return"/";for(var leadingSlash="/"==path[0]?"/":"",trailingSlash="/"===path[path.length-1]?"/":"",segments=path.split("/"),out=[],up=0,pos=0;pos<segments.length;pos++){var segment=segments[pos];switch(segment){case"":case".":break;case"..":out.length>0?out.pop():up++;break;default:out.push(segment)}}if(""==leadingSlash){for(;up-- >0;)out.unshift("..");0===out.length&&out.push(".")}return leadingSlash+out.join("/")+trailingSlash}function _joinAndCanonicalizePath(parts){var path=parts[_ComponentIndex.Path];return path=null==path?"":_removeDotSegments(path),parts[_ComponentIndex.Path]=path,_buildFromEncodedParts(parts[_ComponentIndex.Scheme],parts[_ComponentIndex.UserInfo],parts[_ComponentIndex.Domain],parts[_ComponentIndex.Port],path,parts[_ComponentIndex.QueryData],parts[_ComponentIndex.Fragment])}function _resolveUrl(base,url){var parts=_split(encodeURI(url)),baseParts=_split(base);if(null!=parts[_ComponentIndex.Scheme])return _joinAndCanonicalizePath(parts);parts[_ComponentIndex.Scheme]=baseParts[_ComponentIndex.Scheme];for(var i=_ComponentIndex.Scheme;i<=_ComponentIndex.Port;i++)null==parts[i]&&(parts[i]=baseParts[i]);if("/"==parts[_ComponentIndex.Path][0])return _joinAndCanonicalizePath(parts);var path=baseParts[_ComponentIndex.Path];null==path&&(path="/");var index=path.lastIndexOf("/");return path=path.substring(0,index+1)+parts[_ComponentIndex.Path],parts[_ComponentIndex.Path]=path,_joinAndCanonicalizePath(parts)}var extendStatics=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(d,b){d.__proto__=b}||function(d,b){for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p])},__assign=Object.assign||function(t){for(var s,i=1,n=arguments.length;i<n;i++){s=arguments[i];for(var p in s)Object.prototype.hasOwnProperty.call(s,p)&&(t[p]=s[p])}return t},createInject=makeMetadataFactory("Inject",function(token){return{token:token}}),createInjectionToken=makeMetadataFactory("InjectionToken",function(desc){return{_desc:desc}}),createAttribute=makeMetadataFactory("Attribute",function(attributeName){return{attributeName:attributeName}}),createContentChildren=makeMetadataFactory("ContentChildren",function(selector,data){return void 0===data&&(data={}),__assign({selector:selector,first:!1,isViewQuery:!1,descendants:!1},data)}),createContentChild=makeMetadataFactory("ContentChild",function(selector,data){return void 0===data&&(data={}),__assign({selector:selector,first:!0,isViewQuery:!1,descendants:!0},data)}),createViewChildren=makeMetadataFactory("ViewChildren",function(selector,data){return void 0===data&&(data={}),__assign({selector:selector,first:!1,isViewQuery:!0,descendants:!0},data)}),createViewChild=makeMetadataFactory("ViewChild",function(selector,data){return __assign({selector:selector,first:!0,isViewQuery:!0,descendants:!0},data)}),createDirective=makeMetadataFactory("Directive",function(dir){return void 0===dir&&(dir={}),dir}),ViewEncapsulation={Emulated:0,Native:1,None:2};ViewEncapsulation[ViewEncapsulation.Emulated]="Emulated",ViewEncapsulation[ViewEncapsulation.Native]="Native",ViewEncapsulation[ViewEncapsulation.None]="None";var ChangeDetectionStrategy={OnPush:0,Default:1};ChangeDetectionStrategy[ChangeDetectionStrategy.OnPush]="OnPush",ChangeDetectionStrategy[ChangeDetectionStrategy.Default]="Default";var createComponent=makeMetadataFactory("Component",function(c){return void 0===c&&(c={}),__assign({changeDetection:ChangeDetectionStrategy.Default},c)}),createPipe=makeMetadataFactory("Pipe",function(p){return __assign({pure:!0},p)}),createInput=makeMetadataFactory("Input",function(bindingPropertyName){return{bindingPropertyName:bindingPropertyName}}),createOutput=makeMetadataFactory("Output",function(bindingPropertyName){return{bindingPropertyName:bindingPropertyName}}),createHostBinding=makeMetadataFactory("HostBinding",function(hostPropertyName){return{hostPropertyName:hostPropertyName}}),createHostListener=makeMetadataFactory("HostListener",function(eventName,args){return{eventName:eventName,args:args}}),createNgModule=makeMetadataFactory("NgModule",function(ngModule){return ngModule}),CUSTOM_ELEMENTS_SCHEMA={name:"custom-elements"},NO_ERRORS_SCHEMA={name:"no-errors-schema"},createOptional=makeMetadataFactory("Optional"),createInjectable=makeMetadataFactory("Injectable"),createSelf=makeMetadataFactory("Self"),createSkipSelf=makeMetadataFactory("SkipSelf"),createHost=makeMetadataFactory("Host"),Type=Function,SecurityContext={NONE:0,HTML:1,STYLE:2,SCRIPT:3,URL:4,RESOURCE_URL:5};SecurityContext[SecurityContext.NONE]="NONE",SecurityContext[SecurityContext.HTML]="HTML",SecurityContext[SecurityContext.STYLE]="STYLE",SecurityContext[SecurityContext.SCRIPT]="SCRIPT",SecurityContext[SecurityContext.URL]="URL",SecurityContext[SecurityContext.RESOURCE_URL]="RESOURCE_URL";var NodeFlags={None:0,TypeElement:1,TypeText:2,ProjectedTemplate:4,CatRenderNode:3,TypeNgContent:8,TypePipe:16,TypePureArray:32,TypePureObject:64,TypePurePipe:128,CatPureExpression:224,TypeValueProvider:256,TypeClassProvider:512,TypeFactoryProvider:1024,TypeUseExistingProvider:2048,LazyProvider:4096,PrivateProvider:8192,TypeDirective:16384,Component:32768,CatProviderNoDirective:3840,CatProvider:20224,OnInit:65536,OnDestroy:131072,DoCheck:262144,OnChanges:524288,AfterContentInit:1048576,AfterContentChecked:2097152,AfterViewInit:4194304,AfterViewChecked:8388608,EmbeddedViews:16777216,ComponentView:33554432,TypeContentQuery:67108864,TypeViewQuery:134217728,StaticQuery:268435456,DynamicQuery:536870912,CatQuery:201326592,Types:201347067},DepFlags={None:0,SkipSelf:1,Optional:2,Value:8},ArgumentType={Inline:0,Dynamic:1},BindingFlags={TypeElementAttribute:1,TypeElementClass:2,TypeElementStyle:4,TypeProperty:8,SyntheticProperty:16,SyntheticHostProperty:32,CatSyntheticProperty:48,Types:15},QueryBindingType={First:0,All:1},QueryValueType={ElementRef:0,RenderElement:1,TemplateRef:2,ViewContainerRef:3,Provider:4},ViewFlags={None:0,OnPush:2},MissingTranslationStrategy={Error:0,Warning:1,Ignore:2};MissingTranslationStrategy[MissingTranslationStrategy.Error]="Error",MissingTranslationStrategy[MissingTranslationStrategy.Warning]="Warning",MissingTranslationStrategy[MissingTranslationStrategy.Ignore]="Ignore";var core=Object.freeze({Inject:Inject,createInject:createInject,createInjectionToken:createInjectionToken,Attribute:Attribute,createAttribute:createAttribute,Query:Query,createContentChildren:createContentChildren,createContentChild:createContentChild,createViewChildren:createViewChildren,createViewChild:createViewChild,Directive:Directive,createDirective:createDirective,Component:Component,ViewEncapsulation:ViewEncapsulation,ChangeDetectionStrategy:ChangeDetectionStrategy,createComponent:createComponent,Pipe:Pipe,createPipe:createPipe,Input:Input,createInput:createInput,Output:Output,createOutput:createOutput,HostBinding:HostBinding,createHostBinding:createHostBinding,HostListener:HostListener,createHostListener:createHostListener,NgModule:NgModule,createNgModule:createNgModule,ModuleWithProviders:ModuleWithProviders,SchemaMetadata:SchemaMetadata,CUSTOM_ELEMENTS_SCHEMA:CUSTOM_ELEMENTS_SCHEMA,NO_ERRORS_SCHEMA:NO_ERRORS_SCHEMA,createOptional:createOptional,createInjectable:createInjectable,createSelf:createSelf,createSkipSelf:createSkipSelf,createHost:createHost,Type:Type,SecurityContext:SecurityContext,NodeFlags:NodeFlags,DepFlags:DepFlags,ArgumentType:ArgumentType,BindingFlags:BindingFlags,QueryBindingType:QueryBindingType,QueryValueType:QueryValueType,ViewFlags:ViewFlags,MissingTranslationStrategy:MissingTranslationStrategy,MetadataFactory:MetadataFactory,Route:Route}),DASH_CASE_REGEXP=/-+([a-z0-9])/g,ValueTransformer=function(){function ValueTransformer(){}return ValueTransformer.prototype.visitArray=function(arr,context){var _this=this;return arr.map(function(value){return visitValue(value,_this,context)})},ValueTransformer.prototype.visitStringMap=function(map,context){var _this=this,result={};return Object.keys(map).forEach(function(key){result[key]=visitValue(map[key],_this,context)}),result},ValueTransformer.prototype.visitPrimitive=function(value,context){return value},ValueTransformer.prototype.visitOther=function(value,context){return value},ValueTransformer}(),SyncAsync={assertSync:function(value){if(isPromise(value))throw new Error("Illegal state: value cannot be a promise");return value},then:function(value,cb){return isPromise(value)?value.then(cb):cb(value)},all:function(syncAsyncValues){return syncAsyncValues.some(isPromise)?Promise.all(syncAsyncValues):syncAsyncValues}},ERROR_SYNTAX_ERROR="ngSyntaxError",ERROR_PARSE_ERRORS="ngParseErrors",STRING_MAP_PROTO=Object.getPrototypeOf({}),Version=function(){function Version(full){this.full=full;var splits=full.split(".");this.major=splits[0],this.minor=splits[1],this.patch=splits.slice(2).join(".")}return Version}(),VERSION=new Version("5.2.10"),TextAst=function(){function TextAst(value,ngContentIndex,sourceSpan){this.value=value,this.ngContentIndex=ngContentIndex,this.sourceSpan=sourceSpan}return TextAst.prototype.visit=function(visitor,context){return visitor.visitText(this,context)},TextAst}(),BoundTextAst=function(){function BoundTextAst(value,ngContentIndex,sourceSpan){this.value=value,this.ngContentIndex=ngContentIndex,this.sourceSpan=sourceSpan}return BoundTextAst.prototype.visit=function(visitor,context){return visitor.visitBoundText(this,context)},BoundTextAst}(),AttrAst=function(){function AttrAst(name,value,sourceSpan){this.name=name,this.value=value,this.sourceSpan=sourceSpan}return AttrAst.prototype.visit=function(visitor,context){return visitor.visitAttr(this,context)},AttrAst}(),BoundElementPropertyAst=function(){function BoundElementPropertyAst(name,type,securityContext,value,unit,sourceSpan){this.name=name,this.type=type,this.securityContext=securityContext,this.value=value,this.unit=unit,this.sourceSpan=sourceSpan,this.isAnimation=this.type===PropertyBindingType.Animation}return BoundElementPropertyAst.prototype.visit=function(visitor,context){return visitor.visitElementProperty(this,context)},BoundElementPropertyAst}(),BoundEventAst=function(){function BoundEventAst(name,target,phase,handler,sourceSpan){this.name=name,this.target=target,this.phase=phase,this.handler=handler,this.sourceSpan=sourceSpan,this.fullName=BoundEventAst.calcFullName(this.name,this.target,this.phase),this.isAnimation=!!this.phase}return BoundEventAst.calcFullName=function(name,target,phase){return target?target+":"+name:phase?"@"+name+"."+phase:name},BoundEventAst.prototype.visit=function(visitor,context){return visitor.visitEvent(this,context)},BoundEventAst}(),ReferenceAst=function(){function ReferenceAst(name,value,sourceSpan){this.name=name,this.value=value,this.sourceSpan=sourceSpan}return ReferenceAst.prototype.visit=function(visitor,context){return visitor.visitReference(this,context)},ReferenceAst}(),VariableAst=function(){function VariableAst(name,value,sourceSpan){this.name=name,this.value=value,this.sourceSpan=sourceSpan}return VariableAst.prototype.visit=function(visitor,context){return visitor.visitVariable(this,context)},VariableAst}(),ElementAst=function(){function ElementAst(name,attrs,inputs,outputs,references,directives,providers,hasViewContainer,queryMatches,children,ngContentIndex,sourceSpan,endSourceSpan){this.name=name,this.attrs=attrs,this.inputs=inputs,this.outputs=outputs,this.references=references,this.directives=directives,this.providers=providers,this.hasViewContainer=hasViewContainer,this.queryMatches=queryMatches,this.children=children,this.ngContentIndex=ngContentIndex,this.sourceSpan=sourceSpan,this.endSourceSpan=endSourceSpan}return ElementAst.prototype.visit=function(visitor,context){return visitor.visitElement(this,context)},ElementAst}(),EmbeddedTemplateAst=function(){function EmbeddedTemplateAst(attrs,outputs,references,variables,directives,providers,hasViewContainer,queryMatches,children,ngContentIndex,sourceSpan){this.attrs=attrs,this.outputs=outputs,this.references=references,this.variables=variables,this.directives=directives,this.providers=providers,this.hasViewContainer=hasViewContainer,this.queryMatches=queryMatches,this.children=children,this.ngContentIndex=ngContentIndex,this.sourceSpan=sourceSpan}return EmbeddedTemplateAst.prototype.visit=function(visitor,context){return visitor.visitEmbeddedTemplate(this,context)},EmbeddedTemplateAst}(),BoundDirectivePropertyAst=function(){function BoundDirectivePropertyAst(directiveName,templateName,value,sourceSpan){this.directiveName=directiveName,this.templateName=templateName,this.value=value,this.sourceSpan=sourceSpan}return BoundDirectivePropertyAst.prototype.visit=function(visitor,context){return visitor.visitDirectiveProperty(this,context)},BoundDirectivePropertyAst}(),DirectiveAst=function(){function DirectiveAst(directive,inputs,hostProperties,hostEvents,contentQueryStartId,sourceSpan){this.directive=directive,this.inputs=inputs,this.hostProperties=hostProperties,this.hostEvents=hostEvents,this.contentQueryStartId=contentQueryStartId,this.sourceSpan=sourceSpan}return DirectiveAst.prototype.visit=function(visitor,context){return visitor.visitDirective(this,context)},DirectiveAst}(),ProviderAst=function(){function ProviderAst(token,multiProvider,eager,providers,providerType,lifecycleHooks,sourceSpan){this.token=token,this.multiProvider=multiProvider,this.eager=eager,this.providers=providers,this.providerType=providerType,this.lifecycleHooks=lifecycleHooks,this.sourceSpan=sourceSpan}return ProviderAst.prototype.visit=function(visitor,context){return null},ProviderAst}(),ProviderAstType={PublicService:0,PrivateService:1,Component:2,Directive:3,Builtin:4};ProviderAstType[ProviderAstType.PublicService]="PublicService",ProviderAstType[ProviderAstType.PrivateService]="PrivateService",ProviderAstType[ProviderAstType.Component]="Component",ProviderAstType[ProviderAstType.Directive]="Directive",ProviderAstType[ProviderAstType.Builtin]="Builtin";var NgContentAst=function(){function NgContentAst(index,ngContentIndex,sourceSpan){this.index=index,this.ngContentIndex=ngContentIndex,this.sourceSpan=sourceSpan}return NgContentAst.prototype.visit=function(visitor,context){return visitor.visitNgContent(this,context)},NgContentAst}(),PropertyBindingType={Property:0,Attribute:1,Class:2,Style:3,Animation:4};PropertyBindingType[PropertyBindingType.Property]="Property",PropertyBindingType[PropertyBindingType.Attribute]="Attribute",PropertyBindingType[PropertyBindingType.Class]="Class",PropertyBindingType[PropertyBindingType.Style]="Style",PropertyBindingType[PropertyBindingType.Animation]="Animation";var NullTemplateVisitor=function(){function NullTemplateVisitor(){}return NullTemplateVisitor.prototype.visitNgContent=function(ast,context){},NullTemplateVisitor.prototype.visitEmbeddedTemplate=function(ast,context){},NullTemplateVisitor.prototype.visitElement=function(ast,context){},NullTemplateVisitor.prototype.visitReference=function(ast,context){},NullTemplateVisitor.prototype.visitVariable=function(ast,context){},NullTemplateVisitor.prototype.visitEvent=function(ast,context){},NullTemplateVisitor.prototype.visitElementProperty=function(ast,context){},NullTemplateVisitor.prototype.visitAttr=function(ast,context){},NullTemplateVisitor.prototype.visitBoundText=function(ast,context){},NullTemplateVisitor.prototype.visitText=function(ast,context){},NullTemplateVisitor.prototype.visitDirective=function(ast,context){},NullTemplateVisitor.prototype.visitDirectiveProperty=function(ast,context){},NullTemplateVisitor}(),RecursiveTemplateAstVisitor=function(_super){function RecursiveTemplateAstVisitor(){return _super.call(this)||this}return __extends(RecursiveTemplateAstVisitor,_super),RecursiveTemplateAstVisitor.prototype.visitEmbeddedTemplate=function(ast,context){return this.visitChildren(context,function(visit){visit(ast.attrs),visit(ast.references),visit(ast.variables),visit(ast.directives),visit(ast.providers),visit(ast.children)})},RecursiveTemplateAstVisitor.prototype.visitElement=function(ast,context){return this.visitChildren(context,function(visit){visit(ast.attrs),visit(ast.inputs),visit(ast.outputs),visit(ast.references),visit(ast.directives),visit(ast.providers),visit(ast.children)})},RecursiveTemplateAstVisitor.prototype.visitDirective=function(ast,context){return this.visitChildren(context,function(visit){visit(ast.inputs),visit(ast.hostProperties),visit(ast.hostEvents)})},RecursiveTemplateAstVisitor.prototype.visitChildren=function(context,cb){function visit(children){children&&children.length&&results.push(templateVisitAll(t,children,context))}var results=[],t=this;return cb(visit),[].concat.apply([],results)},RecursiveTemplateAstVisitor}(NullTemplateVisitor),CompilerConfig=function(){function CompilerConfig(_a){var _b=void 0===_a?{}:_a,_c=_b.defaultEncapsulation,defaultEncapsulation=void 0===_c?ViewEncapsulation.Emulated:_c,_d=_b.useJit,useJit=void 0===_d||_d,_e=_b.jitDevMode,jitDevMode=void 0!==_e&&_e,_f=_b.missingTranslation,missingTranslation=void 0===_f?null:_f,enableLegacyTemplate=_b.enableLegacyTemplate,preserveWhitespaces=_b.preserveWhitespaces,strictInjectionParameters=_b.strictInjectionParameters;this.defaultEncapsulation=defaultEncapsulation,this.useJit=!!useJit,this.jitDevMode=!!jitDevMode,this.missingTranslation=missingTranslation,this.enableLegacyTemplate=!0===enableLegacyTemplate,this.preserveWhitespaces=preserveWhitespacesDefault(noUndefined(preserveWhitespaces)),this.strictInjectionParameters=!0===strictInjectionParameters}return CompilerConfig}(),StaticSymbol=function(){function StaticSymbol(filePath,name,members){this.filePath=filePath,this.name=name,this.members=members}return StaticSymbol.prototype.assertNoMembers=function(){if(this.members.length)throw new Error("Illegal state: symbol without members expected, but got "+JSON.stringify(this)+".")},StaticSymbol}(),StaticSymbolCache=function(){function StaticSymbolCache(){this.cache=new Map}return StaticSymbolCache.prototype.get=function(declarationFile,name,members){members=members||[];var memberSuffix=members.length?"."+members.join("."):"",key='"'+declarationFile+'".'+name+memberSuffix,result=this.cache.get(key);return result||(result=new StaticSymbol(declarationFile,name,members),this.cache.set(key,result)),result},StaticSymbolCache}(),HOST_REG_EXP=/^(?:(?:\[([^\]]+)\])|(?:\(([^\)]+)\)))|(\@[-\w]+)$/,_anonymousTypeIndex=0,CompileSummaryKind={Pipe:0,Directive:1,NgModule:2,Injectable:3};CompileSummaryKind[CompileSummaryKind.Pipe]="Pipe",CompileSummaryKind[CompileSummaryKind.Directive]="Directive",CompileSummaryKind[CompileSummaryKind.NgModule]="NgModule",CompileSummaryKind[CompileSummaryKind.Injectable]="Injectable";var CompileStylesheetMetadata=function(){function CompileStylesheetMetadata(_a){var _b=void 0===_a?{}:_a,moduleUrl=_b.moduleUrl,styles=_b.styles,styleUrls=_b.styleUrls;this.moduleUrl=moduleUrl||null,this.styles=_normalizeArray(styles),this.styleUrls=_normalizeArray(styleUrls)}return CompileStylesheetMetadata}(),CompileTemplateMetadata=function(){function CompileTemplateMetadata(_a){var encapsulation=_a.encapsulation,template=_a.template,templateUrl=_a.templateUrl,htmlAst=_a.htmlAst,styles=_a.styles,styleUrls=_a.styleUrls,externalStylesheets=_a.externalStylesheets,animations=_a.animations,ngContentSelectors=_a.ngContentSelectors,interpolation=_a.interpolation,isInline=_a.isInline,preserveWhitespaces=_a.preserveWhitespaces;if(this.encapsulation=encapsulation,this.template=template,this.templateUrl=templateUrl,this.htmlAst=htmlAst,this.styles=_normalizeArray(styles),this.styleUrls=_normalizeArray(styleUrls),this.externalStylesheets=_normalizeArray(externalStylesheets),this.animations=animations?flatten(animations):[],this.ngContentSelectors=ngContentSelectors||[],interpolation&&2!=interpolation.length)throw new Error("'interpolation' should have a start and an end symbol.");this.interpolation=interpolation,this.isInline=isInline,this.preserveWhitespaces=preserveWhitespaces}return CompileTemplateMetadata.prototype.toSummary=function(){return{ngContentSelectors:this.ngContentSelectors,encapsulation:this.encapsulation}},CompileTemplateMetadata}(),CompileDirectiveMetadata=function(){function CompileDirectiveMetadata(_a){var isHost=_a.isHost,type=_a.type,isComponent=_a.isComponent,selector=_a.selector,exportAs=_a.exportAs,changeDetection=_a.changeDetection,inputs=_a.inputs,outputs=_a.outputs,hostListeners=_a.hostListeners,hostProperties=_a.hostProperties,hostAttributes=_a.hostAttributes,providers=_a.providers,viewProviders=_a.viewProviders,queries=_a.queries,guards=_a.guards,viewQueries=_a.viewQueries,entryComponents=_a.entryComponents,template=_a.template,componentViewType=_a.componentViewType,rendererType=_a.rendererType,componentFactory=_a.componentFactory;this.isHost=!!isHost,this.type=type,this.isComponent=isComponent,this.selector=selector,this.exportAs=exportAs,this.changeDetection=changeDetection,this.inputs=inputs,this.outputs=outputs,this.hostListeners=hostListeners,this.hostProperties=hostProperties,this.hostAttributes=hostAttributes,this.providers=_normalizeArray(providers),this.viewProviders=_normalizeArray(viewProviders),this.queries=_normalizeArray(queries),this.guards=guards,this.viewQueries=_normalizeArray(viewQueries),this.entryComponents=_normalizeArray(entryComponents),this.template=template,this.componentViewType=componentViewType,this.rendererType=rendererType,this.componentFactory=componentFactory}return CompileDirectiveMetadata.create=function(_a){var isHost=_a.isHost,type=_a.type,isComponent=_a.isComponent,selector=_a.selector,exportAs=_a.exportAs,changeDetection=_a.changeDetection,inputs=_a.inputs,outputs=_a.outputs,host=_a.host,providers=_a.providers,viewProviders=_a.viewProviders,queries=_a.queries,guards=_a.guards,viewQueries=_a.viewQueries,entryComponents=_a.entryComponents,template=_a.template,componentViewType=_a.componentViewType,rendererType=_a.rendererType,componentFactory=_a.componentFactory,hostListeners={},hostProperties={},hostAttributes={};null!=host&&Object.keys(host).forEach(function(key){var value=host[key],matches=key.match(HOST_REG_EXP);null===matches?hostAttributes[key]=value:null!=matches[1]?hostProperties[matches[1]]=value:null!=matches[2]&&(hostListeners[matches[2]]=value)});var inputsMap={};null!=inputs&&inputs.forEach(function(bindConfig){var parts=splitAtColon(bindConfig,[bindConfig,bindConfig]);inputsMap[parts[0]]=parts[1]});var outputsMap={};return null!=outputs&&outputs.forEach(function(bindConfig){var parts=splitAtColon(bindConfig,[bindConfig,bindConfig]);outputsMap[parts[0]]=parts[1]}),new CompileDirectiveMetadata({isHost:isHost,type:type,isComponent:!!isComponent,selector:selector,exportAs:exportAs,changeDetection:changeDetection,inputs:inputsMap,outputs:outputsMap,hostListeners:hostListeners,hostProperties:hostProperties,hostAttributes:hostAttributes,providers:providers,viewProviders:viewProviders,queries:queries,guards:guards,viewQueries:viewQueries,entryComponents:entryComponents,template:template,componentViewType:componentViewType,rendererType:rendererType,componentFactory:componentFactory})},CompileDirectiveMetadata.prototype.toSummary=function(){return{summaryKind:CompileSummaryKind.Directive,type:this.type,isComponent:this.isComponent,selector:this.selector,exportAs:this.exportAs,inputs:this.inputs,outputs:this.outputs,hostListeners:this.hostListeners,hostProperties:this.hostProperties,hostAttributes:this.hostAttributes,providers:this.providers,viewProviders:this.viewProviders,queries:this.queries,guards:this.guards,viewQueries:this.viewQueries,entryComponents:this.entryComponents,changeDetection:this.changeDetection,template:this.template&&this.template.toSummary(),componentViewType:this.componentViewType,rendererType:this.rendererType,componentFactory:this.componentFactory}},CompileDirectiveMetadata}(),CompilePipeMetadata=function(){function CompilePipeMetadata(_a){var type=_a.type,name=_a.name,pure=_a.pure;this.type=type,this.name=name,this.pure=!!pure}return CompilePipeMetadata.prototype.toSummary=function(){return{summaryKind:CompileSummaryKind.Pipe,type:this.type,name:this.name,pure:this.pure}},CompilePipeMetadata}(),CompileNgModuleMetadata=function(){function CompileNgModuleMetadata(_a){var type=_a.type,providers=_a.providers,declaredDirectives=_a.declaredDirectives,exportedDirectives=_a.exportedDirectives,declaredPipes=_a.declaredPipes,exportedPipes=_a.exportedPipes,entryComponents=_a.entryComponents,bootstrapComponents=_a.bootstrapComponents,importedModules=_a.importedModules,exportedModules=_a.exportedModules,schemas=_a.schemas,transitiveModule=_a.transitiveModule,id=_a.id;this.type=type||null,this.declaredDirectives=_normalizeArray(declaredDirectives),this.exportedDirectives=_normalizeArray(exportedDirectives),this.declaredPipes=_normalizeArray(declaredPipes),this.exportedPipes=_normalizeArray(exportedPipes),this.providers=_normalizeArray(providers),this.entryComponents=_normalizeArray(entryComponents),this.bootstrapComponents=_normalizeArray(bootstrapComponents),this.importedModules=_normalizeArray(importedModules),this.exportedModules=_normalizeArray(exportedModules),this.schemas=_normalizeArray(schemas),this.id=id||null,this.transitiveModule=transitiveModule||null}return CompileNgModuleMetadata.prototype.toSummary=function(){var module=this.transitiveModule;return{summaryKind:CompileSummaryKind.NgModule,type:this.type,entryComponents:module.entryComponents,providers:module.providers,modules:module.modules,exportedDirectives:module.exportedDirectives,exportedPipes:module.exportedPipes}},CompileNgModuleMetadata}(),TransitiveCompileNgModuleMetadata=function(){function TransitiveCompileNgModuleMetadata(){this.directivesSet=new Set,this.directives=[],this.exportedDirectivesSet=new Set,this.exportedDirectives=[],this.pipesSet=new Set,this.pipes=[],this.exportedPipesSet=new Set,this.exportedPipes=[],this.modulesSet=new Set,this.modules=[],this.entryComponentsSet=new Set,this.entryComponents=[],this.providers=[]}return TransitiveCompileNgModuleMetadata.prototype.addProvider=function(provider,module){this.providers.push({provider:provider,module:module})},TransitiveCompileNgModuleMetadata.prototype.addDirective=function(id){this.directivesSet.has(id.reference)||(this.directivesSet.add(id.reference),this.directives.push(id))},TransitiveCompileNgModuleMetadata.prototype.addExportedDirective=function(id){this.exportedDirectivesSet.has(id.reference)||(this.exportedDirectivesSet.add(id.reference),this.exportedDirectives.push(id))},TransitiveCompileNgModuleMetadata.prototype.addPipe=function(id){this.pipesSet.has(id.reference)||(this.pipesSet.add(id.reference),this.pipes.push(id))},TransitiveCompileNgModuleMetadata.prototype.addExportedPipe=function(id){this.exportedPipesSet.has(id.reference)||(this.exportedPipesSet.add(id.reference),this.exportedPipes.push(id))},TransitiveCompileNgModuleMetadata.prototype.addModule=function(id){this.modulesSet.has(id.reference)||(this.modulesSet.add(id.reference),this.modules.push(id))},TransitiveCompileNgModuleMetadata.prototype.addEntryComponent=function(ec){this.entryComponentsSet.has(ec.componentType)||(this.entryComponentsSet.add(ec.componentType),this.entryComponents.push(ec))},TransitiveCompileNgModuleMetadata}(),ProviderMeta=function(){function ProviderMeta(token,_a){var useClass=_a.useClass,useValue=_a.useValue,useExisting=_a.useExisting,useFactory=_a.useFactory,deps=_a.deps,multi=_a.multi;this.token=token,this.useClass=useClass||null,this.useValue=useValue,this.useExisting=useExisting,this.useFactory=useFactory||null,this.dependencies=deps||null,this.multi=!!multi}return ProviderMeta}(),AstPath=function(){function AstPath(path,position){void 0===position&&(position=-1),this.path=path,this.position=position}return Object.defineProperty(AstPath.prototype,"empty",{get:function(){return!this.path||!this.path.length},enumerable:!0,configurable:!0}),Object.defineProperty(AstPath.prototype,"head",{get:function(){return this.path[0]},enumerable:!0,configurable:!0}),Object.defineProperty(AstPath.prototype,"tail",{get:function(){return this.path[this.path.length-1]},enumerable:!0,configurable:!0}),AstPath.prototype.parentOf=function(node){return node&&this.path[this.path.indexOf(node)-1]},AstPath.prototype.childOf=function(node){return this.path[this.path.indexOf(node)+1]},AstPath.prototype.first=function(ctor){for(var i=this.path.length-1;i>=0;i--){var item=this.path[i];if(item instanceof ctor)return item}},AstPath.prototype.push=function(node){this.path.push(node)},AstPath.prototype.pop=function(){return this.path.pop()},AstPath}(),Text=function(){function Text(value,sourceSpan){this.value=value,this.sourceSpan=sourceSpan}return Text.prototype.visit=function(visitor,context){return visitor.visitText(this,context)},Text}(),Expansion=function(){function Expansion(switchValue,type,cases,sourceSpan,switchValueSourceSpan){this.switchValue=switchValue,this.type=type,this.cases=cases,this.sourceSpan=sourceSpan,this.switchValueSourceSpan=switchValueSourceSpan}return Expansion.prototype.visit=function(visitor,context){return visitor.visitExpansion(this,context)},Expansion}(),ExpansionCase=function(){function ExpansionCase(value,expression,sourceSpan,valueSourceSpan,expSourceSpan){this.value=value,this.expression=expression,this.sourceSpan=sourceSpan,this.valueSourceSpan=valueSourceSpan,this.expSourceSpan=expSourceSpan}return ExpansionCase.prototype.visit=function(visitor,context){return visitor.visitExpansionCase(this,context)},ExpansionCase}(),Attribute$1=function(){function Attribute(name,value,sourceSpan,valueSpan){this.name=name,this.value=value,this.sourceSpan=sourceSpan,this.valueSpan=valueSpan}return Attribute.prototype.visit=function(visitor,context){return visitor.visitAttribute(this,context)},Attribute}(),Element=function(){function Element(name,attrs,children,sourceSpan,startSourceSpan,endSourceSpan){void 0===startSourceSpan&&(startSourceSpan=null),void 0===endSourceSpan&&(endSourceSpan=null),this.name=name,this.attrs=attrs,this.children=children,this.sourceSpan=sourceSpan,this.startSourceSpan=startSourceSpan,this.endSourceSpan=endSourceSpan}return Element.prototype.visit=function(visitor,context){return visitor.visitElement(this,context)},Element}(),Comment=function(){function Comment(value,sourceSpan){this.value=value,this.sourceSpan=sourceSpan}return Comment.prototype.visit=function(visitor,context){return visitor.visitComment(this,context)},Comment}(),RecursiveVisitor=function(){function RecursiveVisitor(){}return RecursiveVisitor.prototype.visitElement=function(ast,context){this.visitChildren(context,function(visit){visit(ast.attrs),visit(ast.children)})},RecursiveVisitor.prototype.visitAttribute=function(ast,context){},RecursiveVisitor.prototype.visitText=function(ast,context){},RecursiveVisitor.prototype.visitComment=function(ast,context){},RecursiveVisitor.prototype.visitExpansion=function(ast,context){return this.visitChildren(context,function(visit){visit(ast.cases)})},RecursiveVisitor.prototype.visitExpansionCase=function(ast,context){},RecursiveVisitor.prototype.visitChildren=function(context,cb){function visit(children){children&&results.push(visitAll(t,children,context))}var results=[],t=this;return cb(visit),
[].concat.apply([],results)},RecursiveVisitor}(),INTERPOLATION_BLACKLIST_REGEXPS=[/^\s*$/,/[<>]/,/^[{}]$/,/&(#|[a-z])/i,/^\/\//],InterpolationConfig=function(){function InterpolationConfig(start,end){this.start=start,this.end=end}return InterpolationConfig.fromArray=function(markers){return markers?(assertInterpolationSymbols("interpolation",markers),new InterpolationConfig(markers[0],markers[1])):DEFAULT_INTERPOLATION_CONFIG},InterpolationConfig}(),DEFAULT_INTERPOLATION_CONFIG=new InterpolationConfig("{{","}}"),StyleWithImports=function(){function StyleWithImports(style,styleUrls){this.style=style,this.styleUrls=styleUrls}return StyleWithImports}(),CSS_IMPORT_REGEXP=/@import\s+(?:url\()?\s*(?:(?:['"]([^'"]*))|([^;\)\s]*))[^;]*;?/g,CSS_STRIPPABLE_COMMENT_REGEXP=/\/\*(?!#\s*(?:sourceURL|sourceMappingURL)=)[\s\S]+?\*\//g,URL_WITH_SCHEMA_REGEXP=/^([^:\/?#]+):/,TagContentType={RAW_TEXT:0,ESCAPABLE_RAW_TEXT:1,PARSABLE_DATA:2};TagContentType[TagContentType.RAW_TEXT]="RAW_TEXT",TagContentType[TagContentType.ESCAPABLE_RAW_TEXT]="ESCAPABLE_RAW_TEXT",TagContentType[TagContentType.PARSABLE_DATA]="PARSABLE_DATA";var NAMED_ENTITIES={Aacute:"Á",aacute:"á",Acirc:"Â",acirc:"â",acute:"´",AElig:"Æ",aelig:"æ",Agrave:"À",agrave:"à",alefsym:"ℵ",Alpha:"Α",alpha:"α",amp:"&",and:"∧",ang:"∠",apos:"'",Aring:"Å",aring:"å",asymp:"≈",Atilde:"Ã",atilde:"ã",Auml:"Ä",auml:"ä",bdquo:"„",Beta:"Β",beta:"β",brvbar:"¦",bull:"•",cap:"∩",Ccedil:"Ç",ccedil:"ç",cedil:"¸",cent:"¢",Chi:"Χ",chi:"χ",circ:"ˆ",clubs:"♣",cong:"≅",copy:"©",crarr:"↵",cup:"∪",curren:"¤",dagger:"†",Dagger:"‡",darr:"↓",dArr:"⇓",deg:"°",Delta:"Δ",delta:"δ",diams:"♦",divide:"÷",Eacute:"É",eacute:"é",Ecirc:"Ê",ecirc:"ê",Egrave:"È",egrave:"è",empty:"∅",emsp:" ",ensp:" ",Epsilon:"Ε",epsilon:"ε",equiv:"≡",Eta:"Η",eta:"η",ETH:"Ð",eth:"ð",Euml:"Ë",euml:"ë",euro:"€",exist:"∃",fnof:"ƒ",forall:"∀",frac12:"½",frac14:"¼",frac34:"¾",frasl:"⁄",Gamma:"Γ",gamma:"γ",ge:"≥",gt:">",harr:"↔",hArr:"⇔",hearts:"♥",hellip:"…",Iacute:"Í",iacute:"í",Icirc:"Î",icirc:"î",iexcl:"¡",Igrave:"Ì",igrave:"ì",image:"ℑ",infin:"∞",int:"∫",Iota:"Ι",iota:"ι",iquest:"¿",isin:"∈",Iuml:"Ï",iuml:"ï",Kappa:"Κ",kappa:"κ",Lambda:"Λ",lambda:"λ",lang:"⟨",laquo:"«",larr:"←",lArr:"⇐",lceil:"⌈",ldquo:"“",le:"≤",lfloor:"⌊",lowast:"∗",loz:"◊",lrm:"‎",lsaquo:"‹",lsquo:"‘",lt:"<",macr:"¯",mdash:"—",micro:"µ",middot:"·",minus:"−",Mu:"Μ",mu:"μ",nabla:"∇",nbsp:" ",ndash:"–",ne:"≠",ni:"∋",not:"¬",notin:"∉",nsub:"⊄",Ntilde:"Ñ",ntilde:"ñ",Nu:"Ν",nu:"ν",Oacute:"Ó",oacute:"ó",Ocirc:"Ô",ocirc:"ô",OElig:"Œ",oelig:"œ",Ograve:"Ò",ograve:"ò",oline:"‾",Omega:"Ω",omega:"ω",Omicron:"Ο",omicron:"ο",oplus:"⊕",or:"∨",ordf:"ª",ordm:"º",Oslash:"Ø",oslash:"ø",Otilde:"Õ",otilde:"õ",otimes:"⊗",Ouml:"Ö",ouml:"ö",para:"¶",permil:"‰",perp:"⊥",Phi:"Φ",phi:"φ",Pi:"Π",pi:"π",piv:"ϖ",plusmn:"±",pound:"£",prime:"′",Prime:"″",prod:"∏",prop:"∝",Psi:"Ψ",psi:"ψ",quot:'"',radic:"√",rang:"⟩",raquo:"»",rarr:"→",rArr:"⇒",rceil:"⌉",rdquo:"”",real:"ℜ",reg:"®",rfloor:"⌋",Rho:"Ρ",rho:"ρ",rlm:"‏",rsaquo:"›",rsquo:"’",sbquo:"‚",Scaron:"Š",scaron:"š",sdot:"⋅",sect:"§",shy:"­",Sigma:"Σ",sigma:"σ",sigmaf:"ς",sim:"∼",spades:"♠",sub:"⊂",sube:"⊆",sum:"∑",sup:"⊃",sup1:"¹",sup2:"²",sup3:"³",supe:"⊇",szlig:"ß",Tau:"Τ",tau:"τ",there4:"∴",Theta:"Θ",theta:"θ",thetasym:"ϑ",thinsp:" ",THORN:"Þ",thorn:"þ",tilde:"˜",times:"×",trade:"™",Uacute:"Ú",uacute:"ú",uarr:"↑",uArr:"⇑",Ucirc:"Û",ucirc:"û",Ugrave:"Ù",ugrave:"ù",uml:"¨",upsih:"ϒ",Upsilon:"Υ",upsilon:"υ",Uuml:"Ü",uuml:"ü",weierp:"℘",Xi:"Ξ",xi:"ξ",Yacute:"Ý",yacute:"ý",yen:"¥",yuml:"ÿ",Yuml:"Ÿ",Zeta:"Ζ",zeta:"ζ",zwj:"‍",zwnj:"‌"},NGSP_UNICODE="";NAMED_ENTITIES.ngsp=NGSP_UNICODE;/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
var NG_CONTENT_SELECT_ATTR="select",LINK_ELEMENT="link",LINK_STYLE_REL_ATTR="rel",LINK_STYLE_HREF_ATTR="href",LINK_STYLE_REL_VALUE="stylesheet",STYLE_ELEMENT="style",SCRIPT_ELEMENT="script",NG_NON_BINDABLE_ATTR="ngNonBindable",NG_PROJECT_AS="ngProjectAs",PreparsedElementType={NG_CONTENT:0,STYLE:1,STYLESHEET:2,SCRIPT:3,OTHER:4};PreparsedElementType[PreparsedElementType.NG_CONTENT]="NG_CONTENT",PreparsedElementType[PreparsedElementType.STYLE]="STYLE",PreparsedElementType[PreparsedElementType.STYLESHEET]="STYLESHEET",PreparsedElementType[PreparsedElementType.SCRIPT]="SCRIPT",PreparsedElementType[PreparsedElementType.OTHER]="OTHER";var PreparsedElement=function(){function PreparsedElement(type,selectAttr,hrefAttr,nonBindable,projectAs){this.type=type,this.selectAttr=selectAttr,this.hrefAttr=hrefAttr,this.nonBindable=nonBindable,this.projectAs=projectAs}return PreparsedElement}(),DirectiveNormalizer=function(){function DirectiveNormalizer(_resourceLoader,_urlResolver,_htmlParser,_config){this._resourceLoader=_resourceLoader,this._urlResolver=_urlResolver,this._htmlParser=_htmlParser,this._config=_config,this._resourceLoaderCache=new Map}return DirectiveNormalizer.prototype.clearCache=function(){this._resourceLoaderCache.clear()},DirectiveNormalizer.prototype.clearCacheFor=function(normalizedDirective){var _this=this;if(normalizedDirective.isComponent){var template=normalizedDirective.template;this._resourceLoaderCache.delete(template.templateUrl),template.externalStylesheets.forEach(function(stylesheet){_this._resourceLoaderCache.delete(stylesheet.moduleUrl)})}},DirectiveNormalizer.prototype._fetch=function(url){var result=this._resourceLoaderCache.get(url);return result||(result=this._resourceLoader.get(url),this._resourceLoaderCache.set(url,result)),result},DirectiveNormalizer.prototype.normalizeTemplate=function(prenormData){var _this=this;if(isDefined(prenormData.template)){if(isDefined(prenormData.templateUrl))throw syntaxError("'"+stringify(prenormData.componentType)+"' component cannot define both template and templateUrl");if("string"!=typeof prenormData.template)throw syntaxError("The template specified for component "+stringify(prenormData.componentType)+" is not a string")}else{if(!isDefined(prenormData.templateUrl))throw syntaxError("No template specified for component "+stringify(prenormData.componentType));if("string"!=typeof prenormData.templateUrl)throw syntaxError("The templateUrl specified for component "+stringify(prenormData.componentType)+" is not a string")}if(isDefined(prenormData.preserveWhitespaces)&&"boolean"!=typeof prenormData.preserveWhitespaces)throw syntaxError("The preserveWhitespaces option for component "+stringify(prenormData.componentType)+" must be a boolean");return SyncAsync.then(this._preParseTemplate(prenormData),function(preparsedTemplate){return _this._normalizeTemplateMetadata(prenormData,preparsedTemplate)})},DirectiveNormalizer.prototype._preParseTemplate=function(prenomData){var template,templateUrl,_this=this;return null!=prenomData.template?(template=prenomData.template,templateUrl=prenomData.moduleUrl):(templateUrl=this._urlResolver.resolve(prenomData.moduleUrl,prenomData.templateUrl),template=this._fetch(templateUrl)),SyncAsync.then(template,function(template){return _this._preparseLoadedTemplate(prenomData,template,templateUrl)})},DirectiveNormalizer.prototype._preparseLoadedTemplate=function(prenormData,template,templateAbsUrl){var isInline=!!prenormData.template,interpolationConfig=InterpolationConfig.fromArray(prenormData.interpolation),rootNodesAndErrors=this._htmlParser.parse(template,templateSourceUrl({reference:prenormData.ngModuleType},{type:{reference:prenormData.componentType}},{isInline:isInline,templateUrl:templateAbsUrl}),!0,interpolationConfig);if(rootNodesAndErrors.errors.length>0){throw syntaxError("Template parse errors:\n"+rootNodesAndErrors.errors.join("\n"))}var templateMetadataStyles=this._normalizeStylesheet(new CompileStylesheetMetadata({styles:prenormData.styles,moduleUrl:prenormData.moduleUrl})),visitor=new TemplatePreparseVisitor;visitAll(visitor,rootNodesAndErrors.rootNodes);var templateStyles=this._normalizeStylesheet(new CompileStylesheetMetadata({styles:visitor.styles,styleUrls:visitor.styleUrls,moduleUrl:templateAbsUrl}));return{template:template,templateUrl:templateAbsUrl,isInline:isInline,htmlAst:rootNodesAndErrors,styles:templateMetadataStyles.styles.concat(templateStyles.styles),inlineStyleUrls:templateMetadataStyles.styleUrls.concat(templateStyles.styleUrls),styleUrls:this._normalizeStylesheet(new CompileStylesheetMetadata({styleUrls:prenormData.styleUrls,moduleUrl:prenormData.moduleUrl})).styleUrls,ngContentSelectors:visitor.ngContentSelectors}},DirectiveNormalizer.prototype._normalizeTemplateMetadata=function(prenormData,preparsedTemplate){var _this=this;return SyncAsync.then(this._loadMissingExternalStylesheets(preparsedTemplate.styleUrls.concat(preparsedTemplate.inlineStyleUrls)),function(externalStylesheets){return _this._normalizeLoadedTemplateMetadata(prenormData,preparsedTemplate,externalStylesheets)})},DirectiveNormalizer.prototype._normalizeLoadedTemplateMetadata=function(prenormData,preparsedTemplate,stylesheets){var _this=this,styles=preparsedTemplate.styles.slice();this._inlineStyles(preparsedTemplate.inlineStyleUrls,stylesheets,styles);var styleUrls=preparsedTemplate.styleUrls,externalStylesheets=styleUrls.map(function(styleUrl){var stylesheet=stylesheets.get(styleUrl),styles=stylesheet.styles.slice();return _this._inlineStyles(stylesheet.styleUrls,stylesheets,styles),new CompileStylesheetMetadata({moduleUrl:styleUrl,styles:styles})}),encapsulation=prenormData.encapsulation;return null==encapsulation&&(encapsulation=this._config.defaultEncapsulation),encapsulation===ViewEncapsulation.Emulated&&0===styles.length&&0===styleUrls.length&&(encapsulation=ViewEncapsulation.None),new CompileTemplateMetadata({encapsulation:encapsulation,template:preparsedTemplate.template,templateUrl:preparsedTemplate.templateUrl,htmlAst:preparsedTemplate.htmlAst,styles:styles,styleUrls:styleUrls,ngContentSelectors:preparsedTemplate.ngContentSelectors,animations:prenormData.animations,interpolation:prenormData.interpolation,isInline:preparsedTemplate.isInline,externalStylesheets:externalStylesheets,preserveWhitespaces:preserveWhitespacesDefault(prenormData.preserveWhitespaces,this._config.preserveWhitespaces)})},DirectiveNormalizer.prototype._inlineStyles=function(styleUrls,stylesheets,targetStyles){var _this=this;styleUrls.forEach(function(styleUrl){var stylesheet=stylesheets.get(styleUrl);stylesheet.styles.forEach(function(style){return targetStyles.push(style)}),_this._inlineStyles(stylesheet.styleUrls,stylesheets,targetStyles)})},DirectiveNormalizer.prototype._loadMissingExternalStylesheets=function(styleUrls,loadedStylesheets){var _this=this;return void 0===loadedStylesheets&&(loadedStylesheets=new Map),SyncAsync.then(SyncAsync.all(styleUrls.filter(function(styleUrl){return!loadedStylesheets.has(styleUrl)}).map(function(styleUrl){return SyncAsync.then(_this._fetch(styleUrl),function(loadedStyle){var stylesheet=_this._normalizeStylesheet(new CompileStylesheetMetadata({styles:[loadedStyle],moduleUrl:styleUrl}));return loadedStylesheets.set(styleUrl,stylesheet),_this._loadMissingExternalStylesheets(stylesheet.styleUrls,loadedStylesheets)})})),function(_){return loadedStylesheets})},DirectiveNormalizer.prototype._normalizeStylesheet=function(stylesheet){var _this=this,moduleUrl=stylesheet.moduleUrl,allStyleUrls=stylesheet.styleUrls.filter(isStyleUrlResolvable).map(function(url){return _this._urlResolver.resolve(moduleUrl,url)}),allStyles=stylesheet.styles.map(function(style){var styleWithImports=extractStyleUrls(_this._urlResolver,moduleUrl,style);return allStyleUrls.push.apply(allStyleUrls,styleWithImports.styleUrls),styleWithImports.style});return new CompileStylesheetMetadata({styles:allStyles,styleUrls:allStyleUrls,moduleUrl:moduleUrl})},DirectiveNormalizer}(),TemplatePreparseVisitor=function(){function TemplatePreparseVisitor(){this.ngContentSelectors=[],this.styles=[],this.styleUrls=[],this.ngNonBindableStackCount=0}return TemplatePreparseVisitor.prototype.visitElement=function(ast,context){var preparsedElement=preparseElement(ast);switch(preparsedElement.type){case PreparsedElementType.NG_CONTENT:0===this.ngNonBindableStackCount&&this.ngContentSelectors.push(preparsedElement.selectAttr);break;case PreparsedElementType.STYLE:var textContent_1="";ast.children.forEach(function(child){child instanceof Text&&(textContent_1+=child.value)}),this.styles.push(textContent_1);break;case PreparsedElementType.STYLESHEET:this.styleUrls.push(preparsedElement.hrefAttr)}return preparsedElement.nonBindable&&this.ngNonBindableStackCount++,visitAll(this,ast.children),preparsedElement.nonBindable&&this.ngNonBindableStackCount--,null},TemplatePreparseVisitor.prototype.visitExpansion=function(ast,context){visitAll(this,ast.cases)},TemplatePreparseVisitor.prototype.visitExpansionCase=function(ast,context){visitAll(this,ast.expression)},TemplatePreparseVisitor.prototype.visitComment=function(ast,context){return null},TemplatePreparseVisitor.prototype.visitAttribute=function(ast,context){return null},TemplatePreparseVisitor.prototype.visitText=function(ast,context){return null},TemplatePreparseVisitor}(),QUERY_METADATA_IDENTIFIERS=[createViewChild,createViewChildren,createContentChild,createContentChildren],DirectiveResolver=function(){function DirectiveResolver(_reflector){this._reflector=_reflector}return DirectiveResolver.prototype.isDirective=function(type){var typeMetadata=this._reflector.annotations(resolveForwardRef(type));return typeMetadata&&typeMetadata.some(isDirectiveMetadata)},DirectiveResolver.prototype.resolve=function(type,throwIfNotFound){void 0===throwIfNotFound&&(throwIfNotFound=!0);var typeMetadata=this._reflector.annotations(resolveForwardRef(type));if(typeMetadata){var metadata=findLast(typeMetadata,isDirectiveMetadata);if(metadata){var propertyMetadata=this._reflector.propMetadata(type),guards=this._reflector.guards(type);return this._mergeWithPropertyMetadata(metadata,propertyMetadata,guards,type)}}if(throwIfNotFound)throw new Error("No Directive annotation found on "+stringify(type));return null},DirectiveResolver.prototype._mergeWithPropertyMetadata=function(dm,propertyMetadata,guards,directiveType){var inputs=[],outputs=[],host={},queries={};return Object.keys(propertyMetadata).forEach(function(propName){var input=findLast(propertyMetadata[propName],function(a){return createInput.isTypeOf(a)});input&&(input.bindingPropertyName?inputs.push(propName+": "+input.bindingPropertyName):inputs.push(propName));var output=findLast(propertyMetadata[propName],function(a){return createOutput.isTypeOf(a)});output&&(output.bindingPropertyName?outputs.push(propName+": "+output.bindingPropertyName):outputs.push(propName)),propertyMetadata[propName].filter(function(a){return createHostBinding.isTypeOf(a)}).forEach(function(hostBinding){if(hostBinding.hostPropertyName){var startWith=hostBinding.hostPropertyName[0];if("("===startWith)throw new Error("@HostBinding can not bind to events. Use @HostListener instead.");if("["===startWith)throw new Error("@HostBinding parameter should be a property name, 'class.<name>', or 'attr.<name>'.");host["["+hostBinding.hostPropertyName+"]"]=propName}else host["["+propName+"]"]=propName}),propertyMetadata[propName].filter(function(a){return createHostListener.isTypeOf(a)}).forEach(function(hostListener){var args=hostListener.args||[];host["("+hostListener.eventName+")"]=propName+"("+args.join(",")+")"});var query=findLast(propertyMetadata[propName],function(a){return QUERY_METADATA_IDENTIFIERS.some(function(i){return i.isTypeOf(a)})});query&&(queries[propName]=query)}),this._merge(dm,inputs,outputs,host,queries,guards,directiveType)},DirectiveResolver.prototype._extractPublicName=function(def){return splitAtColon(def,[null,def])[1].trim()},DirectiveResolver.prototype._dedupeBindings=function(bindings){for(var names=new Set,publicNames=new Set,reversedResult=[],i=bindings.length-1;i>=0;i--){var binding=bindings[i],name_1=this._extractPublicName(binding);publicNames.add(name_1),names.has(name_1)||(names.add(name_1),reversedResult.push(binding))}return reversedResult.reverse()},DirectiveResolver.prototype._merge=function(directive,inputs,outputs,host,queries,guards,directiveType){var mergedInputs=this._dedupeBindings(directive.inputs?directive.inputs.concat(inputs):inputs),mergedOutputs=this._dedupeBindings(directive.outputs?directive.outputs.concat(outputs):outputs),mergedHost=directive.host?__assign({},directive.host,host):host,mergedQueries=directive.queries?__assign({},directive.queries,queries):queries;if(createComponent.isTypeOf(directive)){var comp=directive;return createComponent({selector:comp.selector,inputs:mergedInputs,outputs:mergedOutputs,host:mergedHost,exportAs:comp.exportAs,moduleId:comp.moduleId,queries:mergedQueries,changeDetection:comp.changeDetection,providers:comp.providers,viewProviders:comp.viewProviders,entryComponents:comp.entryComponents,template:comp.template,templateUrl:comp.templateUrl,styles:comp.styles,styleUrls:comp.styleUrls,encapsulation:comp.encapsulation,animations:comp.animations,interpolation:comp.interpolation,preserveWhitespaces:directive.preserveWhitespaces})}return createDirective({selector:directive.selector,inputs:mergedInputs,outputs:mergedOutputs,host:mergedHost,exportAs:directive.exportAs,queries:mergedQueries,providers:directive.providers,guards:guards})},DirectiveResolver}(),$EOF=0,$TAB=9,$LF=10,$VTAB=11,$FF=12,$CR=13,$SPACE=32,$DQ=34,$$=36,$SQ=39,$PLUS=43,$MINUS=45,$SLASH=47,$SEMICOLON=59,$EQ=61,$GT=62,$0=48,$9=57,$A=65,$E=69,$F=70,$Z=90,$_=95,$a=97,$e=101,$f=102,$n=110,$r=114,$t=116,$v=118,$z=122,$LBRACE=123,$NBSP=160,$BT=96,TokenType={Character:0,Identifier:1,Keyword:2,String:3,Operator:4,Number:5,Error:6};TokenType[TokenType.Character]="Character",TokenType[TokenType.Identifier]="Identifier",TokenType[TokenType.Keyword]="Keyword",TokenType[TokenType.String]="String",TokenType[TokenType.Operator]="Operator",TokenType[TokenType.Number]="Number",TokenType[TokenType.Error]="Error";var KEYWORDS=["var","let","as","null","undefined","true","false","if","else","this"],Lexer=function(){function Lexer(){}return Lexer.prototype.tokenize=function(text){for(var scanner=new _Scanner(text),tokens=[],token=scanner.scanToken();null!=token;)tokens.push(token),token=scanner.scanToken();return tokens},Lexer}(),Token=function(){function Token(index,type,numValue,strValue){this.index=index,this.type=type,this.numValue=numValue,this.strValue=strValue}return Token.prototype.isCharacter=function(code){return this.type==TokenType.Character&&this.numValue==code},Token.prototype.isNumber=function(){return this.type==TokenType.Number},Token.prototype.isString=function(){return this.type==TokenType.String},Token.prototype.isOperator=function(operater){return this.type==TokenType.Operator&&this.strValue==operater},Token.prototype.isIdentifier=function(){return this.type==TokenType.Identifier},Token.prototype.isKeyword=function(){return this.type==TokenType.Keyword},Token.prototype.isKeywordLet=function(){return this.type==TokenType.Keyword&&"let"==this.strValue},Token.prototype.isKeywordAs=function(){return this.type==TokenType.Keyword&&"as"==this.strValue},Token.prototype.isKeywordNull=function(){return this.type==TokenType.Keyword&&"null"==this.strValue},Token.prototype.isKeywordUndefined=function(){return this.type==TokenType.Keyword&&"undefined"==this.strValue},Token.prototype.isKeywordTrue=function(){return this.type==TokenType.Keyword&&"true"==this.strValue},Token.prototype.isKeywordFalse=function(){return this.type==TokenType.Keyword&&"false"==this.strValue},Token.prototype.isKeywordThis=function(){return this.type==TokenType.Keyword&&"this"==this.strValue},Token.prototype.isError=function(){return this.type==TokenType.Error},Token.prototype.toNumber=function(){return this.type==TokenType.Number?this.numValue:-1},Token.prototype.toString=function(){switch(this.type){case TokenType.Character:case TokenType.Identifier:case TokenType.Keyword:case TokenType.Operator:case TokenType.String:case TokenType.Error:return this.strValue;case TokenType.Number:return this.numValue.toString();default:return null}},Token}(),EOF=new Token(-1,TokenType.Character,0,""),_Scanner=function(){function _Scanner(input){this.input=input,this.peek=0,this.index=-1,this.length=input.length,this.advance()}return _Scanner.prototype.advance=function(){this.peek=++this.index>=this.length?$EOF:this.input.charCodeAt(this.index)},_Scanner.prototype.scanToken=function(){for(var input=this.input,length=this.length,peek=this.peek,index=this.index;peek<=$SPACE;){if(++index>=length){peek=$EOF;break}peek=input.charCodeAt(index)}if(this.peek=peek,this.index=index,index>=length)return null;if(isIdentifierStart(peek))return this.scanIdentifier();if(isDigit(peek))return this.scanNumber(index);var start=index;switch(peek){case 46:return this.advance(),isDigit(this.peek)?this.scanNumber(start):newCharacterToken(start,46);case 40:case 41:case $LBRACE:case 125:case 91:case 93:case 44:case 58:case $SEMICOLON:return this.scanCharacter(start,peek);case $SQ:case $DQ:return this.scanString();case 35:case $PLUS:case $MINUS:case 42:case $SLASH:case 37:case 94:return this.scanOperator(start,String.fromCharCode(peek));case 63:return this.scanComplexOperator(start,"?",46,".");case 60:case $GT:return this.scanComplexOperator(start,String.fromCharCode(peek),$EQ,"=");case 33:case $EQ:return this.scanComplexOperator(start,String.fromCharCode(peek),$EQ,"=",$EQ,"=");case 38:return this.scanComplexOperator(start,"&",38,"&");case 124:return this.scanComplexOperator(start,"|",124,"|");case $NBSP:for(;isWhitespace(this.peek);)this.advance();return this.scanToken()}return this.advance(),this.error("Unexpected character ["+String.fromCharCode(peek)+"]",0)},_Scanner.prototype.scanCharacter=function(start,code){return this.advance(),newCharacterToken(start,code)},_Scanner.prototype.scanOperator=function(start,str){return this.advance(),newOperatorToken(start,str)},_Scanner.prototype.scanComplexOperator=function(start,one,twoCode,two,threeCode,three){this.advance();var str=one;return this.peek==twoCode&&(this.advance(),str+=two),null!=threeCode&&this.peek==threeCode&&(this.advance(),str+=three),newOperatorToken(start,str)},_Scanner.prototype.scanIdentifier=function(){var start=this.index;for(this.advance();isIdentifierPart(this.peek);)this.advance();var str=this.input.substring(start,this.index);return KEYWORDS.indexOf(str)>-1?newKeywordToken(start,str):newIdentifierToken(start,str)},_Scanner.prototype.scanNumber=function(start){var simple=this.index===start;for(this.advance();;){if(isDigit(this.peek));else if(46==this.peek)simple=!1;else{if(!isExponentStart(this.peek))break;if(this.advance(),isExponentSign(this.peek)&&this.advance(),!isDigit(this.peek))return this.error("Invalid exponent",-1);simple=!1}this.advance()}var str=this.input.substring(start,this.index);return newNumberToken(start,simple?parseIntAutoRadix(str):parseFloat(str))},_Scanner.prototype.scanString=function(){var start=this.index,quote=this.peek;this.advance();for(var buffer="",marker=this.index,input=this.input;this.peek!=quote;)if(92==this.peek){buffer+=input.substring(marker,this.index),this.advance();var unescapedCode=void 0;if(this.peek=this.peek,117==this.peek){var hex=input.substring(this.index+1,this.index+5);if(!/^[0-9a-f]+$/i.test(hex))return this.error("Invalid unicode escape [\\u"+hex+"]",0);unescapedCode=parseInt(hex,16);for(var i=0;i<5;i++)this.advance()}else unescapedCode=unescape(this.peek),this.advance();buffer+=String.fromCharCode(unescapedCode),marker=this.index}else{if(this.peek==$EOF)return this.error("Unterminated quote",0);this.advance()}var last=input.substring(marker,this.index);return this.advance(),newStringToken(start,buffer+last)},_Scanner.prototype.error=function(message,offset){var position=this.index+offset;return newErrorToken(position,"Lexer Error: "+message+" at column "+position+" in expression ["+this.input+"]")},_Scanner}(),ParserError=function(){function ParserError(message,input,errLocation,ctxLocation){this.input=input,this.errLocation=errLocation,this.ctxLocation=ctxLocation,this.message="Parser Error: "+message+" "+errLocation+" ["+input+"] in "+ctxLocation}return ParserError}(),ParseSpan=function(){function ParseSpan(start,end){this.start=start,this.end=end}return ParseSpan}(),AST=function(){function AST(span){this.span=span}return AST.prototype.visit=function(visitor,context){return void 0===context&&(context=null),null},AST.prototype.toString=function(){return"AST"},AST}(),Quote=function(_super){function Quote(span,prefix,uninterpretedExpression,location){var _this=_super.call(this,span)||this;return _this.prefix=prefix,_this.uninterpretedExpression=uninterpretedExpression,_this.location=location,_this}return __extends(Quote,_super),Quote.prototype.visit=function(visitor,context){return void 0===context&&(context=null),visitor.visitQuote(this,context)},Quote.prototype.toString=function(){return"Quote"},Quote}(AST),EmptyExpr=function(_super){function EmptyExpr(){return null!==_super&&_super.apply(this,arguments)||this}return __extends(EmptyExpr,_super),EmptyExpr.prototype.visit=function(visitor,context){void 0===context&&(context=null)},EmptyExpr}(AST),ImplicitReceiver=function(_super){function ImplicitReceiver(){return null!==_super&&_super.apply(this,arguments)||this}return __extends(ImplicitReceiver,_super),ImplicitReceiver.prototype.visit=function(visitor,context){return void 0===context&&(context=null),visitor.visitImplicitReceiver(this,context)},ImplicitReceiver}(AST),Chain=function(_super){function Chain(span,expressions){var _this=_super.call(this,span)||this;return _this.expressions=expressions,_this}return __extends(Chain,_super),Chain.prototype.visit=function(visitor,context){return void 0===context&&(context=null),visitor.visitChain(this,context)},Chain}(AST),Conditional=function(_super){function Conditional(span,condition,trueExp,falseExp){var _this=_super.call(this,span)||this;return _this.condition=condition,_this.trueExp=trueExp,_this.falseExp=falseExp,_this}return __extends(Conditional,_super),Conditional.prototype.visit=function(visitor,context){return void 0===context&&(context=null),visitor.visitConditional(this,context)},Conditional}(AST),PropertyRead=function(_super){function PropertyRead(span,receiver,name){var _this=_super.call(this,span)||this;return _this.receiver=receiver,_this.name=name,_this}return __extends(PropertyRead,_super),PropertyRead.prototype.visit=function(visitor,context){return void 0===context&&(context=null),visitor.visitPropertyRead(this,context)},PropertyRead}(AST),PropertyWrite=function(_super){function PropertyWrite(span,receiver,name,value){var _this=_super.call(this,span)||this;return _this.receiver=receiver,_this.name=name,_this.value=value,_this}return __extends(PropertyWrite,_super),PropertyWrite.prototype.visit=function(visitor,context){return void 0===context&&(context=null),visitor.visitPropertyWrite(this,context)},PropertyWrite}(AST),SafePropertyRead=function(_super){function SafePropertyRead(span,receiver,name){var _this=_super.call(this,span)||this;return _this.receiver=receiver,_this.name=name,_this}return __extends(SafePropertyRead,_super),SafePropertyRead.prototype.visit=function(visitor,context){return void 0===context&&(context=null),visitor.visitSafePropertyRead(this,context)},SafePropertyRead}(AST),KeyedRead=function(_super){function KeyedRead(span,obj,key){var _this=_super.call(this,span)||this;return _this.obj=obj,_this.key=key,_this}return __extends(KeyedRead,_super),KeyedRead.prototype.visit=function(visitor,context){return void 0===context&&(context=null),visitor.visitKeyedRead(this,context)},KeyedRead}(AST),KeyedWrite=function(_super){function KeyedWrite(span,obj,key,value){var _this=_super.call(this,span)||this;return _this.obj=obj,_this.key=key,_this.value=value,_this}return __extends(KeyedWrite,_super),KeyedWrite.prototype.visit=function(visitor,context){return void 0===context&&(context=null),visitor.visitKeyedWrite(this,context)},KeyedWrite}(AST),BindingPipe=function(_super){function BindingPipe(span,exp,name,args){var _this=_super.call(this,span)||this;return _this.exp=exp,_this.name=name,_this.args=args,_this}return __extends(BindingPipe,_super),BindingPipe.prototype.visit=function(visitor,context){return void 0===context&&(context=null),visitor.visitPipe(this,context)},BindingPipe}(AST),LiteralPrimitive=function(_super){function LiteralPrimitive(span,value){var _this=_super.call(this,span)||this;return _this.value=value,_this}return __extends(LiteralPrimitive,_super),LiteralPrimitive.prototype.visit=function(visitor,context){return void 0===context&&(context=null),visitor.visitLiteralPrimitive(this,context)},LiteralPrimitive}(AST),LiteralArray=function(_super){function LiteralArray(span,expressions){var _this=_super.call(this,span)||this;return _this.expressions=expressions,_this}return __extends(LiteralArray,_super),LiteralArray.prototype.visit=function(visitor,context){return void 0===context&&(context=null),visitor.visitLiteralArray(this,context)},LiteralArray}(AST),LiteralMap=function(_super){function LiteralMap(span,keys,values){var _this=_super.call(this,span)||this;return _this.keys=keys,_this.values=values,_this}return __extends(LiteralMap,_super),LiteralMap.prototype.visit=function(visitor,context){return void 0===context&&(context=null),visitor.visitLiteralMap(this,context)},LiteralMap}(AST),Interpolation=function(_super){function Interpolation(span,strings,expressions){var _this=_super.call(this,span)||this;return _this.strings=strings,_this.expressions=expressions,_this}return __extends(Interpolation,_super),Interpolation.prototype.visit=function(visitor,context){return void 0===context&&(context=null),visitor.visitInterpolation(this,context)},Interpolation}(AST),Binary=function(_super){function Binary(span,operation,left,right){var _this=_super.call(this,span)||this;return _this.operation=operation,_this.left=left,_this.right=right,_this}return __extends(Binary,_super),Binary.prototype.visit=function(visitor,context){return void 0===context&&(context=null),visitor.visitBinary(this,context)},Binary}(AST),PrefixNot=function(_super){function PrefixNot(span,expression){var _this=_super.call(this,span)||this;return _this.expression=expression,_this}return __extends(PrefixNot,_super),PrefixNot.prototype.visit=function(visitor,context){return void 0===context&&(context=null),visitor.visitPrefixNot(this,context)},PrefixNot}(AST),NonNullAssert=function(_super){function NonNullAssert(span,expression){var _this=_super.call(this,span)||this;return _this.expression=expression,_this}return __extends(NonNullAssert,_super),NonNullAssert.prototype.visit=function(visitor,context){return void 0===context&&(context=null),visitor.visitNonNullAssert(this,context)},NonNullAssert}(AST),MethodCall=function(_super){function MethodCall(span,receiver,name,args){var _this=_super.call(this,span)||this;return _this.receiver=receiver,_this.name=name,_this.args=args,_this}return __extends(MethodCall,_super),MethodCall.prototype.visit=function(visitor,context){return void 0===context&&(context=null),visitor.visitMethodCall(this,context)},MethodCall}(AST),SafeMethodCall=function(_super){function SafeMethodCall(span,receiver,name,args){var _this=_super.call(this,span)||this;return _this.receiver=receiver,_this.name=name,_this.args=args,_this}return __extends(SafeMethodCall,_super),SafeMethodCall.prototype.visit=function(visitor,context){return void 0===context&&(context=null),visitor.visitSafeMethodCall(this,context)},SafeMethodCall}(AST),FunctionCall=function(_super){function FunctionCall(span,target,args){var _this=_super.call(this,span)||this;return _this.target=target,_this.args=args,_this}return __extends(FunctionCall,_super),FunctionCall.prototype.visit=function(visitor,context){return void 0===context&&(context=null),visitor.visitFunctionCall(this,context)},FunctionCall}(AST),ASTWithSource=function(_super){function ASTWithSource(ast,source,location,errors){var _this=_super.call(this,new ParseSpan(0,null==source?0:source.length))||this;return _this.ast=ast,_this.source=source,_this.location=location,_this.errors=errors,_this}return __extends(ASTWithSource,_super),ASTWithSource.prototype.visit=function(visitor,context){return void 0===context&&(context=null),this.ast.visit(visitor,context)},ASTWithSource.prototype.toString=function(){return this.source+" in "+this.location},ASTWithSource}(AST),TemplateBinding=function(){function TemplateBinding(span,key,keyIsVar,name,expression){this.span=span,this.key=key,this.keyIsVar=keyIsVar,this.name=name,this.expression=expression}return TemplateBinding}(),NullAstVisitor=function(){function NullAstVisitor(){}return NullAstVisitor.prototype.visitBinary=function(ast,context){},NullAstVisitor.prototype.visitChain=function(ast,context){},NullAstVisitor.prototype.visitConditional=function(ast,context){},NullAstVisitor.prototype.visitFunctionCall=function(ast,context){},NullAstVisitor.prototype.visitImplicitReceiver=function(ast,context){},NullAstVisitor.prototype.visitInterpolation=function(ast,context){},NullAstVisitor.prototype.visitKeyedRead=function(ast,context){},NullAstVisitor.prototype.visitKeyedWrite=function(ast,context){},NullAstVisitor.prototype.visitLiteralArray=function(ast,context){},NullAstVisitor.prototype.visitLiteralMap=function(ast,context){},NullAstVisitor.prototype.visitLiteralPrimitive=function(ast,context){},NullAstVisitor.prototype.visitMethodCall=function(ast,context){},NullAstVisitor.prototype.visitPipe=function(ast,context){},NullAstVisitor.prototype.visitPrefixNot=function(ast,context){},NullAstVisitor.prototype.visitNonNullAssert=function(ast,context){},NullAstVisitor.prototype.visitPropertyRead=function(ast,context){},NullAstVisitor.prototype.visitPropertyWrite=function(ast,context){},NullAstVisitor.prototype.visitQuote=function(ast,context){},NullAstVisitor.prototype.visitSafeMethodCall=function(ast,context){},NullAstVisitor.prototype.visitSafePropertyRead=function(ast,context){},NullAstVisitor}(),RecursiveAstVisitor=function(){function RecursiveAstVisitor(){}return RecursiveAstVisitor.prototype.visitBinary=function(ast,context){return ast.left.visit(this),ast.right.visit(this),null},RecursiveAstVisitor.prototype.visitChain=function(ast,context){return this.visitAll(ast.expressions,context)},RecursiveAstVisitor.prototype.visitConditional=function(ast,context){return ast.condition.visit(this),ast.trueExp.visit(this),ast.falseExp.visit(this),null},RecursiveAstVisitor.prototype.visitPipe=function(ast,context){return ast.exp.visit(this),this.visitAll(ast.args,context),null},RecursiveAstVisitor.prototype.visitFunctionCall=function(ast,context){return ast.target.visit(this),this.visitAll(ast.args,context),null},RecursiveAstVisitor.prototype.visitImplicitReceiver=function(ast,context){return null},RecursiveAstVisitor.prototype.visitInterpolation=function(ast,context){return this.visitAll(ast.expressions,context)},RecursiveAstVisitor.prototype.visitKeyedRead=function(ast,context){return ast.obj.visit(this),ast.key.visit(this),null},RecursiveAstVisitor.prototype.visitKeyedWrite=function(ast,context){return ast.obj.visit(this),ast.key.visit(this),ast.value.visit(this),null},RecursiveAstVisitor.prototype.visitLiteralArray=function(ast,context){return this.visitAll(ast.expressions,context)},RecursiveAstVisitor.prototype.visitLiteralMap=function(ast,context){return this.visitAll(ast.values,context)},RecursiveAstVisitor.prototype.visitLiteralPrimitive=function(ast,context){return null},RecursiveAstVisitor.prototype.visitMethodCall=function(ast,context){return ast.receiver.visit(this),this.visitAll(ast.args,context)},RecursiveAstVisitor.prototype.visitPrefixNot=function(ast,context){
return ast.expression.visit(this),null},RecursiveAstVisitor.prototype.visitNonNullAssert=function(ast,context){return ast.expression.visit(this),null},RecursiveAstVisitor.prototype.visitPropertyRead=function(ast,context){return ast.receiver.visit(this),null},RecursiveAstVisitor.prototype.visitPropertyWrite=function(ast,context){return ast.receiver.visit(this),ast.value.visit(this),null},RecursiveAstVisitor.prototype.visitSafePropertyRead=function(ast,context){return ast.receiver.visit(this),null},RecursiveAstVisitor.prototype.visitSafeMethodCall=function(ast,context){return ast.receiver.visit(this),this.visitAll(ast.args,context)},RecursiveAstVisitor.prototype.visitAll=function(asts,context){var _this=this;return asts.forEach(function(ast){return ast.visit(_this,context)}),null},RecursiveAstVisitor.prototype.visitQuote=function(ast,context){return null},RecursiveAstVisitor}(),AstTransformer=function(){function AstTransformer(){}return AstTransformer.prototype.visitImplicitReceiver=function(ast,context){return ast},AstTransformer.prototype.visitInterpolation=function(ast,context){return new Interpolation(ast.span,ast.strings,this.visitAll(ast.expressions))},AstTransformer.prototype.visitLiteralPrimitive=function(ast,context){return new LiteralPrimitive(ast.span,ast.value)},AstTransformer.prototype.visitPropertyRead=function(ast,context){return new PropertyRead(ast.span,ast.receiver.visit(this),ast.name)},AstTransformer.prototype.visitPropertyWrite=function(ast,context){return new PropertyWrite(ast.span,ast.receiver.visit(this),ast.name,ast.value.visit(this))},AstTransformer.prototype.visitSafePropertyRead=function(ast,context){return new SafePropertyRead(ast.span,ast.receiver.visit(this),ast.name)},AstTransformer.prototype.visitMethodCall=function(ast,context){return new MethodCall(ast.span,ast.receiver.visit(this),ast.name,this.visitAll(ast.args))},AstTransformer.prototype.visitSafeMethodCall=function(ast,context){return new SafeMethodCall(ast.span,ast.receiver.visit(this),ast.name,this.visitAll(ast.args))},AstTransformer.prototype.visitFunctionCall=function(ast,context){return new FunctionCall(ast.span,ast.target.visit(this),this.visitAll(ast.args))},AstTransformer.prototype.visitLiteralArray=function(ast,context){return new LiteralArray(ast.span,this.visitAll(ast.expressions))},AstTransformer.prototype.visitLiteralMap=function(ast,context){return new LiteralMap(ast.span,ast.keys,this.visitAll(ast.values))},AstTransformer.prototype.visitBinary=function(ast,context){return new Binary(ast.span,ast.operation,ast.left.visit(this),ast.right.visit(this))},AstTransformer.prototype.visitPrefixNot=function(ast,context){return new PrefixNot(ast.span,ast.expression.visit(this))},AstTransformer.prototype.visitNonNullAssert=function(ast,context){return new NonNullAssert(ast.span,ast.expression.visit(this))},AstTransformer.prototype.visitConditional=function(ast,context){return new Conditional(ast.span,ast.condition.visit(this),ast.trueExp.visit(this),ast.falseExp.visit(this))},AstTransformer.prototype.visitPipe=function(ast,context){return new BindingPipe(ast.span,ast.exp.visit(this),ast.name,this.visitAll(ast.args))},AstTransformer.prototype.visitKeyedRead=function(ast,context){return new KeyedRead(ast.span,ast.obj.visit(this),ast.key.visit(this))},AstTransformer.prototype.visitKeyedWrite=function(ast,context){return new KeyedWrite(ast.span,ast.obj.visit(this),ast.key.visit(this),ast.value.visit(this))},AstTransformer.prototype.visitAll=function(asts){for(var res=new Array(asts.length),i=0;i<asts.length;++i)res[i]=asts[i].visit(this);return res},AstTransformer.prototype.visitChain=function(ast,context){return new Chain(ast.span,this.visitAll(ast.expressions))},AstTransformer.prototype.visitQuote=function(ast,context){return new Quote(ast.span,ast.prefix,ast.uninterpretedExpression,ast.location)},AstTransformer}(),SplitInterpolation=function(){function SplitInterpolation(strings,expressions,offsets){this.strings=strings,this.expressions=expressions,this.offsets=offsets}return SplitInterpolation}(),TemplateBindingParseResult=function(){function TemplateBindingParseResult(templateBindings,warnings,errors){this.templateBindings=templateBindings,this.warnings=warnings,this.errors=errors}return TemplateBindingParseResult}(),Parser=function(){function Parser(_lexer){this._lexer=_lexer,this.errors=[]}return Parser.prototype.parseAction=function(input,location,interpolationConfig){void 0===interpolationConfig&&(interpolationConfig=DEFAULT_INTERPOLATION_CONFIG),this._checkNoInterpolation(input,location,interpolationConfig);var sourceToLex=this._stripComments(input),tokens=this._lexer.tokenize(this._stripComments(input)),ast=new _ParseAST(input,location,tokens,sourceToLex.length,!0,this.errors,input.length-sourceToLex.length).parseChain();return new ASTWithSource(ast,input,location,this.errors)},Parser.prototype.parseBinding=function(input,location,interpolationConfig){void 0===interpolationConfig&&(interpolationConfig=DEFAULT_INTERPOLATION_CONFIG);var ast=this._parseBindingAst(input,location,interpolationConfig);return new ASTWithSource(ast,input,location,this.errors)},Parser.prototype.parseSimpleBinding=function(input,location,interpolationConfig){void 0===interpolationConfig&&(interpolationConfig=DEFAULT_INTERPOLATION_CONFIG);var ast=this._parseBindingAst(input,location,interpolationConfig),errors=SimpleExpressionChecker.check(ast);return errors.length>0&&this._reportError("Host binding expression cannot contain "+errors.join(" "),input,location),new ASTWithSource(ast,input,location,this.errors)},Parser.prototype._reportError=function(message,input,errLocation,ctxLocation){this.errors.push(new ParserError(message,input,errLocation,ctxLocation))},Parser.prototype._parseBindingAst=function(input,location,interpolationConfig){var quote=this._parseQuote(input,location);if(null!=quote)return quote;this._checkNoInterpolation(input,location,interpolationConfig);var sourceToLex=this._stripComments(input),tokens=this._lexer.tokenize(sourceToLex);return new _ParseAST(input,location,tokens,sourceToLex.length,!1,this.errors,input.length-sourceToLex.length).parseChain()},Parser.prototype._parseQuote=function(input,location){if(null==input)return null;var prefixSeparatorIndex=input.indexOf(":");if(-1==prefixSeparatorIndex)return null;var prefix=input.substring(0,prefixSeparatorIndex).trim();if(!isIdentifier(prefix))return null;var uninterpretedExpression=input.substring(prefixSeparatorIndex+1);return new Quote(new ParseSpan(0,input.length),prefix,uninterpretedExpression,location)},Parser.prototype.parseTemplateBindings=function(prefixToken,input,location){var tokens=this._lexer.tokenize(input);if(prefixToken){var prefixTokens=this._lexer.tokenize(prefixToken).map(function(t){return t.index=0,t});tokens.unshift.apply(tokens,prefixTokens)}return new _ParseAST(input,location,tokens,input.length,!1,this.errors,0).parseTemplateBindings()},Parser.prototype.parseInterpolation=function(input,location,interpolationConfig){void 0===interpolationConfig&&(interpolationConfig=DEFAULT_INTERPOLATION_CONFIG);var split=this.splitInterpolation(input,location,interpolationConfig);if(null==split)return null;for(var expressions=[],i=0;i<split.expressions.length;++i){var expressionText=split.expressions[i],sourceToLex=this._stripComments(expressionText),tokens=this._lexer.tokenize(sourceToLex),ast=new _ParseAST(input,location,tokens,sourceToLex.length,!1,this.errors,split.offsets[i]+(expressionText.length-sourceToLex.length)).parseChain();expressions.push(ast)}return new ASTWithSource(new Interpolation(new ParseSpan(0,null==input?0:input.length),split.strings,expressions),input,location,this.errors)},Parser.prototype.splitInterpolation=function(input,location,interpolationConfig){void 0===interpolationConfig&&(interpolationConfig=DEFAULT_INTERPOLATION_CONFIG);var regexp=_createInterpolateRegExp(interpolationConfig),parts=input.split(regexp);if(parts.length<=1)return null;for(var strings=[],expressions=[],offsets=[],offset=0,i=0;i<parts.length;i++){var part=parts[i];i%2==0?(strings.push(part),offset+=part.length):part.trim().length>0?(offset+=interpolationConfig.start.length,expressions.push(part),offsets.push(offset),offset+=part.length+interpolationConfig.end.length):(this._reportError("Blank expressions are not allowed in interpolated strings",input,"at column "+this._findInterpolationErrorColumn(parts,i,interpolationConfig)+" in",location),expressions.push("$implict"),offsets.push(offset))}return new SplitInterpolation(strings,expressions,offsets)},Parser.prototype.wrapLiteralPrimitive=function(input,location){return new ASTWithSource(new LiteralPrimitive(new ParseSpan(0,null==input?0:input.length),input),input,location,this.errors)},Parser.prototype._stripComments=function(input){var i=this._commentStart(input);return null!=i?input.substring(0,i).trim():input},Parser.prototype._commentStart=function(input){for(var outerQuote=null,i=0;i<input.length-1;i++){var char=input.charCodeAt(i),nextChar=input.charCodeAt(i+1);if(char===$SLASH&&nextChar==$SLASH&&null==outerQuote)return i;outerQuote===char?outerQuote=null:null==outerQuote&&isQuote(char)&&(outerQuote=char)}return null},Parser.prototype._checkNoInterpolation=function(input,location,interpolationConfig){var regexp=_createInterpolateRegExp(interpolationConfig),parts=input.split(regexp);parts.length>1&&this._reportError("Got interpolation ("+interpolationConfig.start+interpolationConfig.end+") where expression was expected",input,"at column "+this._findInterpolationErrorColumn(parts,1,interpolationConfig)+" in",location)},Parser.prototype._findInterpolationErrorColumn=function(parts,partInErrIdx,interpolationConfig){for(var errLocation="",j=0;j<partInErrIdx;j++)errLocation+=j%2==0?parts[j]:""+interpolationConfig.start+parts[j]+interpolationConfig.end;return errLocation.length},Parser}(),_ParseAST=function(){function _ParseAST(input,location,tokens,inputLength,parseAction,errors,offset){this.input=input,this.location=location,this.tokens=tokens,this.inputLength=inputLength,this.parseAction=parseAction,this.errors=errors,this.offset=offset,this.rparensExpected=0,this.rbracketsExpected=0,this.rbracesExpected=0,this.index=0}return _ParseAST.prototype.peek=function(offset){var i=this.index+offset;return i<this.tokens.length?this.tokens[i]:EOF},Object.defineProperty(_ParseAST.prototype,"next",{get:function(){return this.peek(0)},enumerable:!0,configurable:!0}),Object.defineProperty(_ParseAST.prototype,"inputIndex",{get:function(){return this.index<this.tokens.length?this.next.index+this.offset:this.inputLength+this.offset},enumerable:!0,configurable:!0}),_ParseAST.prototype.span=function(start){return new ParseSpan(start,this.inputIndex)},_ParseAST.prototype.advance=function(){this.index++},_ParseAST.prototype.optionalCharacter=function(code){return!!this.next.isCharacter(code)&&(this.advance(),!0)},_ParseAST.prototype.peekKeywordLet=function(){return this.next.isKeywordLet()},_ParseAST.prototype.peekKeywordAs=function(){return this.next.isKeywordAs()},_ParseAST.prototype.expectCharacter=function(code){this.optionalCharacter(code)||this.error("Missing expected "+String.fromCharCode(code))},_ParseAST.prototype.optionalOperator=function(op){return!!this.next.isOperator(op)&&(this.advance(),!0)},_ParseAST.prototype.expectOperator=function(operator){this.optionalOperator(operator)||this.error("Missing expected operator "+operator)},_ParseAST.prototype.expectIdentifierOrKeyword=function(){var n=this.next;return n.isIdentifier()||n.isKeyword()?(this.advance(),n.toString()):(this.error("Unexpected token "+n+", expected identifier or keyword"),"")},_ParseAST.prototype.expectIdentifierOrKeywordOrString=function(){var n=this.next;return n.isIdentifier()||n.isKeyword()||n.isString()?(this.advance(),n.toString()):(this.error("Unexpected token "+n+", expected identifier, keyword, or string"),"")},_ParseAST.prototype.parseChain=function(){for(var exprs=[],start=this.inputIndex;this.index<this.tokens.length;){var expr=this.parsePipe();if(exprs.push(expr),this.optionalCharacter($SEMICOLON))for(this.parseAction||this.error("Binding expression cannot contain chained expression");this.optionalCharacter($SEMICOLON););else this.index<this.tokens.length&&this.error("Unexpected token '"+this.next+"'")}return 0==exprs.length?new EmptyExpr(this.span(start)):1==exprs.length?exprs[0]:new Chain(this.span(start),exprs)},_ParseAST.prototype.parsePipe=function(){var result=this.parseExpression();if(this.optionalOperator("|")){this.parseAction&&this.error("Cannot have a pipe in an action expression");do{for(var name_1=this.expectIdentifierOrKeyword(),args=[];this.optionalCharacter(58);)args.push(this.parseExpression());result=new BindingPipe(this.span(result.span.start),result,name_1,args)}while(this.optionalOperator("|"))}return result},_ParseAST.prototype.parseExpression=function(){return this.parseConditional()},_ParseAST.prototype.parseConditional=function(){var start=this.inputIndex,result=this.parseLogicalOr();if(this.optionalOperator("?")){var yes=this.parsePipe(),no=void 0;if(this.optionalCharacter(58))no=this.parsePipe();else{var end=this.inputIndex,expression=this.input.substring(start,end);this.error("Conditional expression "+expression+" requires all 3 expressions"),no=new EmptyExpr(this.span(start))}return new Conditional(this.span(start),result,yes,no)}return result},_ParseAST.prototype.parseLogicalOr=function(){for(var result=this.parseLogicalAnd();this.optionalOperator("||");){var right=this.parseLogicalAnd();result=new Binary(this.span(result.span.start),"||",result,right)}return result},_ParseAST.prototype.parseLogicalAnd=function(){for(var result=this.parseEquality();this.optionalOperator("&&");){var right=this.parseEquality();result=new Binary(this.span(result.span.start),"&&",result,right)}return result},_ParseAST.prototype.parseEquality=function(){for(var result=this.parseRelational();this.next.type==TokenType.Operator;){var operator=this.next.strValue;switch(operator){case"==":case"===":case"!=":case"!==":this.advance();var right=this.parseRelational();result=new Binary(this.span(result.span.start),operator,result,right);continue}break}return result},_ParseAST.prototype.parseRelational=function(){for(var result=this.parseAdditive();this.next.type==TokenType.Operator;){var operator=this.next.strValue;switch(operator){case"<":case">":case"<=":case">=":this.advance();var right=this.parseAdditive();result=new Binary(this.span(result.span.start),operator,result,right);continue}break}return result},_ParseAST.prototype.parseAdditive=function(){for(var result=this.parseMultiplicative();this.next.type==TokenType.Operator;){var operator=this.next.strValue;switch(operator){case"+":case"-":this.advance();var right=this.parseMultiplicative();result=new Binary(this.span(result.span.start),operator,result,right);continue}break}return result},_ParseAST.prototype.parseMultiplicative=function(){for(var result=this.parsePrefix();this.next.type==TokenType.Operator;){var operator=this.next.strValue;switch(operator){case"*":case"%":case"/":this.advance();var right=this.parsePrefix();result=new Binary(this.span(result.span.start),operator,result,right);continue}break}return result},_ParseAST.prototype.parsePrefix=function(){if(this.next.type==TokenType.Operator){var start=this.inputIndex,operator=this.next.strValue,result=void 0;switch(operator){case"+":return this.advance(),result=this.parsePrefix(),new Binary(this.span(start),"-",result,new LiteralPrimitive(new ParseSpan(start,start),0));case"-":return this.advance(),result=this.parsePrefix(),new Binary(this.span(start),operator,new LiteralPrimitive(new ParseSpan(start,start),0),result);case"!":return this.advance(),result=this.parsePrefix(),new PrefixNot(this.span(start),result)}}return this.parseCallChain()},_ParseAST.prototype.parseCallChain=function(){for(var result=this.parsePrimary();;)if(this.optionalCharacter(46))result=this.parseAccessMemberOrMethodCall(result,!1);else if(this.optionalOperator("?."))result=this.parseAccessMemberOrMethodCall(result,!0);else if(this.optionalCharacter(91)){this.rbracketsExpected++;var key=this.parsePipe();if(this.rbracketsExpected--,this.expectCharacter(93),this.optionalOperator("=")){var value=this.parseConditional();result=new KeyedWrite(this.span(result.span.start),result,key,value)}else result=new KeyedRead(this.span(result.span.start),result,key)}else if(this.optionalCharacter(40)){this.rparensExpected++;var args=this.parseCallArguments();this.rparensExpected--,this.expectCharacter(41),result=new FunctionCall(this.span(result.span.start),result,args)}else{if(!this.optionalOperator("!"))return result;result=new NonNullAssert(this.span(result.span.start),result)}},_ParseAST.prototype.parsePrimary=function(){var start=this.inputIndex;if(this.optionalCharacter(40)){this.rparensExpected++;var result=this.parsePipe();return this.rparensExpected--,this.expectCharacter(41),result}if(this.next.isKeywordNull())return this.advance(),new LiteralPrimitive(this.span(start),null);if(this.next.isKeywordUndefined())return this.advance(),new LiteralPrimitive(this.span(start),void 0);if(this.next.isKeywordTrue())return this.advance(),new LiteralPrimitive(this.span(start),!0);if(this.next.isKeywordFalse())return this.advance(),new LiteralPrimitive(this.span(start),!1);if(this.next.isKeywordThis())return this.advance(),new ImplicitReceiver(this.span(start));if(this.optionalCharacter(91)){this.rbracketsExpected++;var elements=this.parseExpressionList(93);return this.rbracketsExpected--,this.expectCharacter(93),new LiteralArray(this.span(start),elements)}if(this.next.isCharacter($LBRACE))return this.parseLiteralMap();if(this.next.isIdentifier())return this.parseAccessMemberOrMethodCall(new ImplicitReceiver(this.span(start)),!1);if(this.next.isNumber()){var value=this.next.toNumber();return this.advance(),new LiteralPrimitive(this.span(start),value)}if(this.next.isString()){var literalValue=this.next.toString();return this.advance(),new LiteralPrimitive(this.span(start),literalValue)}return this.index>=this.tokens.length?(this.error("Unexpected end of expression: "+this.input),new EmptyExpr(this.span(start))):(this.error("Unexpected token "+this.next),new EmptyExpr(this.span(start)))},_ParseAST.prototype.parseExpressionList=function(terminator){var result=[];if(!this.next.isCharacter(terminator))do{result.push(this.parsePipe())}while(this.optionalCharacter(44));return result},_ParseAST.prototype.parseLiteralMap=function(){var keys=[],values=[],start=this.inputIndex;if(this.expectCharacter($LBRACE),!this.optionalCharacter(125)){this.rbracesExpected++;do{var quoted=this.next.isString(),key=this.expectIdentifierOrKeywordOrString();keys.push({key:key,quoted:quoted}),this.expectCharacter(58),values.push(this.parsePipe())}while(this.optionalCharacter(44));this.rbracesExpected--,this.expectCharacter(125)}return new LiteralMap(this.span(start),keys,values)},_ParseAST.prototype.parseAccessMemberOrMethodCall=function(receiver,isSafe){void 0===isSafe&&(isSafe=!1);var start=receiver.span.start,id=this.expectIdentifierOrKeyword();if(this.optionalCharacter(40)){this.rparensExpected++;var args=this.parseCallArguments();this.expectCharacter(41),this.rparensExpected--;var span=this.span(start);return isSafe?new SafeMethodCall(span,receiver,id,args):new MethodCall(span,receiver,id,args)}if(isSafe)return this.optionalOperator("=")?(this.error("The '?.' operator cannot be used in the assignment"),new EmptyExpr(this.span(start))):new SafePropertyRead(this.span(start),receiver,id);if(this.optionalOperator("=")){if(!this.parseAction)return this.error("Bindings cannot contain assignments"),new EmptyExpr(this.span(start));var value=this.parseConditional();return new PropertyWrite(this.span(start),receiver,id,value)}return new PropertyRead(this.span(start),receiver,id)},_ParseAST.prototype.parseCallArguments=function(){if(this.next.isCharacter(41))return[];var positionals=[];do{positionals.push(this.parsePipe())}while(this.optionalCharacter(44));return positionals},_ParseAST.prototype.expectTemplateBindingKey=function(){var result="",operatorFound=!1;do{result+=this.expectIdentifierOrKeywordOrString(),(operatorFound=this.optionalOperator("-"))&&(result+="-")}while(operatorFound);return result.toString()},_ParseAST.prototype.parseTemplateBindings=function(){for(var bindings=[],prefix=null,warnings=[];this.index<this.tokens.length;){var start=this.inputIndex,keyIsVar=this.peekKeywordLet();keyIsVar&&this.advance();var rawKey=this.expectTemplateBindingKey(),key=rawKey;keyIsVar||(null==prefix?prefix=key:key=prefix+key[0].toUpperCase()+key.substring(1)),this.optionalCharacter(58);var name_2=null,expression=null;if(keyIsVar)name_2=this.optionalOperator("=")?this.expectTemplateBindingKey():"$implicit";else if(this.peekKeywordAs()){var letStart=this.inputIndex;this.advance(),name_2=rawKey,key=this.expectTemplateBindingKey(),keyIsVar=!0}else if(this.next!==EOF&&!this.peekKeywordLet()){var start_1=this.inputIndex,ast=this.parsePipe(),source=this.input.substring(start_1-this.offset,this.inputIndex-this.offset);expression=new ASTWithSource(ast,source,this.location,this.errors)}if(bindings.push(new TemplateBinding(this.span(start),key,keyIsVar,name_2,expression)),this.peekKeywordAs()&&!keyIsVar){var letStart=this.inputIndex;this.advance();var letName=this.expectTemplateBindingKey();bindings.push(new TemplateBinding(this.span(letStart),letName,!0,key,null))}this.optionalCharacter($SEMICOLON)||this.optionalCharacter(44)}return new TemplateBindingParseResult(bindings,warnings,this.errors)},_ParseAST.prototype.error=function(message,index){void 0===index&&(index=null),this.errors.push(new ParserError(message,this.input,this.locationText(index),this.location)),this.skip()},_ParseAST.prototype.locationText=function(index){return void 0===index&&(index=null),null==index&&(index=this.index),index<this.tokens.length?"at column "+(this.tokens[index].index+1)+" in":"at the end of the expression"},_ParseAST.prototype.skip=function(){for(var n=this.next;this.index<this.tokens.length&&!n.isCharacter($SEMICOLON)&&(this.rparensExpected<=0||!n.isCharacter(41))&&(this.rbracesExpected<=0||!n.isCharacter(125))&&(this.rbracketsExpected<=0||!n.isCharacter(93));)this.next.isError()&&this.errors.push(new ParserError(this.next.toString(),this.input,this.locationText(),this.location)),this.advance(),n=this.next},_ParseAST}(),SimpleExpressionChecker=function(){function SimpleExpressionChecker(){this.errors=[]}return SimpleExpressionChecker.check=function(ast){var s=new SimpleExpressionChecker;return ast.visit(s),s.errors},SimpleExpressionChecker.prototype.visitImplicitReceiver=function(ast,context){},SimpleExpressionChecker.prototype.visitInterpolation=function(ast,context){},SimpleExpressionChecker.prototype.visitLiteralPrimitive=function(ast,context){},SimpleExpressionChecker.prototype.visitPropertyRead=function(ast,context){},SimpleExpressionChecker.prototype.visitPropertyWrite=function(ast,context){},SimpleExpressionChecker.prototype.visitSafePropertyRead=function(ast,context){},SimpleExpressionChecker.prototype.visitMethodCall=function(ast,context){},SimpleExpressionChecker.prototype.visitSafeMethodCall=function(ast,context){},SimpleExpressionChecker.prototype.visitFunctionCall=function(ast,context){},SimpleExpressionChecker.prototype.visitLiteralArray=function(ast,context){this.visitAll(ast.expressions)},SimpleExpressionChecker.prototype.visitLiteralMap=function(ast,context){this.visitAll(ast.values)},SimpleExpressionChecker.prototype.visitBinary=function(ast,context){},SimpleExpressionChecker.prototype.visitPrefixNot=function(ast,context){},SimpleExpressionChecker.prototype.visitNonNullAssert=function(ast,context){},SimpleExpressionChecker.prototype.visitConditional=function(ast,context){},SimpleExpressionChecker.prototype.visitPipe=function(ast,context){this.errors.push("pipes")},SimpleExpressionChecker.prototype.visitKeyedRead=function(ast,context){},SimpleExpressionChecker.prototype.visitKeyedWrite=function(ast,context){},SimpleExpressionChecker.prototype.visitAll=function(asts){var _this=this;return asts.map(function(node){return node.visit(_this)})},SimpleExpressionChecker.prototype.visitChain=function(ast,context){},SimpleExpressionChecker.prototype.visitQuote=function(ast,context){},SimpleExpressionChecker}(),ParseLocation=function(){function ParseLocation(file,offset,line,col){this.file=file,this.offset=offset,this.line=line,this.col=col}return ParseLocation.prototype.toString=function(){return null!=this.offset?this.file.url+"@"+this.line+":"+this.col:this.file.url},ParseLocation.prototype.moveBy=function(delta){for(var source=this.file.content,len=source.length,offset=this.offset,line=this.line,col=this.col;offset>0&&delta<0;){offset--,delta++;var ch=source.charCodeAt(offset);if(ch==$LF){line--;var priorLine=source.substr(0,offset-1).lastIndexOf(String.fromCharCode($LF));col=priorLine>0?offset-priorLine:offset}else col--}for(;offset<len&&delta>0;){var ch=source.charCodeAt(offset);offset++,delta--,ch==$LF?(line++,col=0):col++}return new ParseLocation(this.file,offset,line,col)},ParseLocation.prototype.getContext=function(maxChars,maxLines){var content=this.file.content,startOffset=this.offset;if(null!=startOffset){startOffset>content.length-1&&(startOffset=content.length-1);for(var endOffset=startOffset,ctxChars=0,ctxLines=0;ctxChars<maxChars&&startOffset>0&&(startOffset--,ctxChars++,"\n"!=content[startOffset]||++ctxLines!=maxLines););for(ctxChars=0,ctxLines=0;ctxChars<maxChars&&endOffset<content.length-1&&(endOffset++,ctxChars++,"\n"!=content[endOffset]||++ctxLines!=maxLines););return{before:content.substring(startOffset,this.offset),after:content.substring(this.offset,endOffset+1)}}return null},ParseLocation}(),ParseSourceFile=function(){function ParseSourceFile(content,url){this.content=content,this.url=url}return ParseSourceFile}(),ParseSourceSpan=function(){function ParseSourceSpan(start,end,details){void 0===details&&(details=null),this.start=start,this.end=end,this.details=details}return ParseSourceSpan.prototype.toString=function(){return this.start.file.content.substring(this.start.offset,this.end.offset)},ParseSourceSpan}(),ParseErrorLevel={WARNING:0,ERROR:1};ParseErrorLevel[ParseErrorLevel.WARNING]="WARNING",ParseErrorLevel[ParseErrorLevel.ERROR]="ERROR";var ParseError=function(){function ParseError(span,msg,level){void 0===level&&(level=ParseErrorLevel.ERROR),this.span=span,this.msg=msg,this.level=level}return ParseError.prototype.contextualMessage=function(){var ctx=this.span.start.getContext(100,3);return ctx?this.msg+' ("'+ctx.before+"["+ParseErrorLevel[this.level]+" ->]"+ctx.after+'")':this.msg},ParseError.prototype.toString=function(){var details=this.span.details?", "+this.span.details:"";return this.contextualMessage()+": "+this.span.start+details},ParseError}(),TokenType$1={TAG_OPEN_START:0,TAG_OPEN_END:1,TAG_OPEN_END_VOID:2,TAG_CLOSE:3,TEXT:4,ESCAPABLE_RAW_TEXT:5,RAW_TEXT:6,COMMENT_START:7,COMMENT_END:8,CDATA_START:9,CDATA_END:10,ATTR_NAME:11,ATTR_VALUE:12,DOC_TYPE:13,EXPANSION_FORM_START:14,EXPANSION_CASE_VALUE:15,EXPANSION_CASE_EXP_START:16,EXPANSION_CASE_EXP_END:17,EXPANSION_FORM_END:18,EOF:19};TokenType$1[TokenType$1.TAG_OPEN_START]="TAG_OPEN_START",TokenType$1[TokenType$1.TAG_OPEN_END]="TAG_OPEN_END",TokenType$1[TokenType$1.TAG_OPEN_END_VOID]="TAG_OPEN_END_VOID",TokenType$1[TokenType$1.TAG_CLOSE]="TAG_CLOSE",TokenType$1[TokenType$1.TEXT]="TEXT",TokenType$1[TokenType$1.ESCAPABLE_RAW_TEXT]="ESCAPABLE_RAW_TEXT",TokenType$1[TokenType$1.RAW_TEXT]="RAW_TEXT",TokenType$1[TokenType$1.COMMENT_START]="COMMENT_START",TokenType$1[TokenType$1.COMMENT_END]="COMMENT_END",TokenType$1[TokenType$1.CDATA_START]="CDATA_START",TokenType$1[TokenType$1.CDATA_END]="CDATA_END",TokenType$1[TokenType$1.ATTR_NAME]="ATTR_NAME",TokenType$1[TokenType$1.ATTR_VALUE]="ATTR_VALUE",TokenType$1[TokenType$1.DOC_TYPE]="DOC_TYPE",TokenType$1[TokenType$1.EXPANSION_FORM_START]="EXPANSION_FORM_START",TokenType$1[TokenType$1.EXPANSION_CASE_VALUE]="EXPANSION_CASE_VALUE",TokenType$1[TokenType$1.EXPANSION_CASE_EXP_START]="EXPANSION_CASE_EXP_START",TokenType$1[TokenType$1.EXPANSION_CASE_EXP_END]="EXPANSION_CASE_EXP_END",TokenType$1[TokenType$1.EXPANSION_FORM_END]="EXPANSION_FORM_END",TokenType$1[TokenType$1.EOF]="EOF";var Token$1=function(){function Token(type,parts,sourceSpan){this.type=type,this.parts=parts,this.sourceSpan=sourceSpan}return Token}(),TokenError=function(_super){function TokenError(errorMsg,tokenType,span){var _this=_super.call(this,span,errorMsg)||this;return _this.tokenType=tokenType,_this}return __extends(TokenError,_super),TokenError}(ParseError),TokenizeResult=function(){function TokenizeResult(tokens,errors){this.tokens=tokens,this.errors=errors}return TokenizeResult}(),_CR_OR_CRLF_REGEXP=/\r\n?/g,_ControlFlowError=function(){function _ControlFlowError(error){this.error=error}return _ControlFlowError}(),_Tokenizer=function(){function _Tokenizer(_file,_getTagDefinition,_tokenizeIcu,_interpolationConfig){void 0===_interpolationConfig&&(_interpolationConfig=DEFAULT_INTERPOLATION_CONFIG),this._file=_file,this._getTagDefinition=_getTagDefinition,this._tokenizeIcu=_tokenizeIcu,this._interpolationConfig=_interpolationConfig,this._peek=-1,this._nextPeek=-1,this._index=-1,this._line=0,this._column=-1,this._expansionCaseStack=[],this._inInterpolation=!1,this.tokens=[],this.errors=[],this._input=_file.content,this._length=_file.content.length,this._advance()}return _Tokenizer.prototype._processCarriageReturns=function(content){return content.replace(_CR_OR_CRLF_REGEXP,"\n")},_Tokenizer.prototype.tokenize=function(){for(;this._peek!==$EOF;){var start=this._getLocation();try{this._attemptCharCode(60)?this._attemptCharCode(33)?this._attemptCharCode(91)?this._consumeCdata(start):this._attemptCharCode($MINUS)?this._consumeComment(start):this._consumeDocType(start):this._attemptCharCode($SLASH)?this._consumeTagClose(start):this._consumeTagOpen(start):this._tokenizeIcu&&this._tokenizeExpansionForm()||this._consumeText()}catch(e){if(!(e instanceof _ControlFlowError))throw e;this.errors.push(e.error)}}return this._beginToken(TokenType$1.EOF),this._endToken([]),new TokenizeResult(mergeTextTokens(this.tokens),this.errors)},_Tokenizer.prototype._tokenizeExpansionForm=function(){if(isExpansionFormStart(this._input,this._index,this._interpolationConfig))return this._consumeExpansionFormStart(),!0;if(isExpansionCaseStart(this._peek)&&this._isInExpansionForm())return this._consumeExpansionCaseStart(),!0;if(125===this._peek){if(this._isInExpansionCase())return this._consumeExpansionCaseEnd(),!0;if(this._isInExpansionForm())return this._consumeExpansionFormEnd(),!0}return!1},_Tokenizer.prototype._getLocation=function(){return new ParseLocation(this._file,this._index,this._line,this._column)},_Tokenizer.prototype._getSpan=function(start,end){return void 0===start&&(start=this._getLocation()),void 0===end&&(end=this._getLocation()),new ParseSourceSpan(start,end)},_Tokenizer.prototype._beginToken=function(type,start){void 0===start&&(start=this._getLocation()),this._currentTokenStart=start,this._currentTokenType=type},_Tokenizer.prototype._endToken=function(parts,end){void 0===end&&(end=this._getLocation());var token=new Token$1(this._currentTokenType,parts,new ParseSourceSpan(this._currentTokenStart,end));return this.tokens.push(token),this._currentTokenStart=null,this._currentTokenType=null,token},_Tokenizer.prototype._createError=function(msg,span){this._isInExpansionForm()&&(msg+=' (Do you have an unescaped "{" in your template? Use "{{ \'{\' }}") to escape it.)');var error=new TokenError(msg,this._currentTokenType,span);return this._currentTokenStart=null,this._currentTokenType=null,new _ControlFlowError(error)},_Tokenizer.prototype._advance=function(){if(this._index>=this._length)throw this._createError(_unexpectedCharacterErrorMsg($EOF),this._getSpan());this._peek===$LF?(this._line++,
this._column=0):this._peek!==$LF&&this._peek!==$CR&&this._column++,this._index++,this._peek=this._index>=this._length?$EOF:this._input.charCodeAt(this._index),this._nextPeek=this._index+1>=this._length?$EOF:this._input.charCodeAt(this._index+1)},_Tokenizer.prototype._attemptCharCode=function(charCode){return this._peek===charCode&&(this._advance(),!0)},_Tokenizer.prototype._attemptCharCodeCaseInsensitive=function(charCode){return!!compareCharCodeCaseInsensitive(this._peek,charCode)&&(this._advance(),!0)},_Tokenizer.prototype._requireCharCode=function(charCode){var location=this._getLocation();if(!this._attemptCharCode(charCode))throw this._createError(_unexpectedCharacterErrorMsg(this._peek),this._getSpan(location,location))},_Tokenizer.prototype._attemptStr=function(chars){var len=chars.length;if(this._index+len>this._length)return!1;for(var initialPosition=this._savePosition(),i=0;i<len;i++)if(!this._attemptCharCode(chars.charCodeAt(i)))return this._restorePosition(initialPosition),!1;return!0},_Tokenizer.prototype._attemptStrCaseInsensitive=function(chars){for(var i=0;i<chars.length;i++)if(!this._attemptCharCodeCaseInsensitive(chars.charCodeAt(i)))return!1;return!0},_Tokenizer.prototype._requireStr=function(chars){var location=this._getLocation();if(!this._attemptStr(chars))throw this._createError(_unexpectedCharacterErrorMsg(this._peek),this._getSpan(location))},_Tokenizer.prototype._attemptCharCodeUntilFn=function(predicate){for(;!predicate(this._peek);)this._advance()},_Tokenizer.prototype._requireCharCodeUntilFn=function(predicate,len){var start=this._getLocation();if(this._attemptCharCodeUntilFn(predicate),this._index-start.offset<len)throw this._createError(_unexpectedCharacterErrorMsg(this._peek),this._getSpan(start,start))},_Tokenizer.prototype._attemptUntilChar=function(char){for(;this._peek!==char;)this._advance()},_Tokenizer.prototype._readChar=function(decodeEntities){if(decodeEntities&&38===this._peek)return this._decodeEntity();var index=this._index;return this._advance(),this._input[index]},_Tokenizer.prototype._decodeEntity=function(){var start=this._getLocation();if(this._advance(),!this._attemptCharCode(35)){var startPosition=this._savePosition();if(this._attemptCharCodeUntilFn(isNamedEntityEnd),this._peek!=$SEMICOLON)return this._restorePosition(startPosition),"&";this._advance();var name_1=this._input.substring(start.offset+1,this._index-1),char=NAMED_ENTITIES[name_1];if(!char)throw this._createError(_unknownEntityErrorMsg(name_1),this._getSpan(start));return char}var isHex=this._attemptCharCode(120)||this._attemptCharCode(88),numberStart=this._getLocation().offset;if(this._attemptCharCodeUntilFn(isDigitEntityEnd),this._peek!=$SEMICOLON)throw this._createError(_unexpectedCharacterErrorMsg(this._peek),this._getSpan());this._advance();var strNum=this._input.substring(numberStart,this._index-1);try{var charCode=parseInt(strNum,isHex?16:10);return String.fromCharCode(charCode)}catch(e){var entity=this._input.substring(start.offset+1,this._index-1);throw this._createError(_unknownEntityErrorMsg(entity),this._getSpan(start))}},_Tokenizer.prototype._consumeRawText=function(decodeEntities,firstCharOfEnd,attemptEndRest){var tagCloseStart,textStart=this._getLocation();this._beginToken(decodeEntities?TokenType$1.ESCAPABLE_RAW_TEXT:TokenType$1.RAW_TEXT,textStart);for(var parts=[];;){if(tagCloseStart=this._getLocation(),this._attemptCharCode(firstCharOfEnd)&&attemptEndRest())break;for(this._index>tagCloseStart.offset&&parts.push(this._input.substring(tagCloseStart.offset,this._index));this._peek!==firstCharOfEnd;)parts.push(this._readChar(decodeEntities))}return this._endToken([this._processCarriageReturns(parts.join(""))],tagCloseStart)},_Tokenizer.prototype._consumeComment=function(start){var _this=this;this._beginToken(TokenType$1.COMMENT_START,start),this._requireCharCode($MINUS),this._endToken([]);var textToken=this._consumeRawText(!1,$MINUS,function(){return _this._attemptStr("->")});this._beginToken(TokenType$1.COMMENT_END,textToken.sourceSpan.end),this._endToken([])},_Tokenizer.prototype._consumeCdata=function(start){var _this=this;this._beginToken(TokenType$1.CDATA_START,start),this._requireStr("CDATA["),this._endToken([]);var textToken=this._consumeRawText(!1,93,function(){return _this._attemptStr("]>")});this._beginToken(TokenType$1.CDATA_END,textToken.sourceSpan.end),this._endToken([])},_Tokenizer.prototype._consumeDocType=function(start){this._beginToken(TokenType$1.DOC_TYPE,start),this._attemptUntilChar($GT),this._advance(),this._endToken([this._input.substring(start.offset+2,this._index-1)])},_Tokenizer.prototype._consumePrefixAndName=function(){for(var nameOrPrefixStart=this._index,prefix=null;58!==this._peek&&!isPrefixEnd(this._peek);)this._advance();var nameStart;return 58===this._peek?(this._advance(),prefix=this._input.substring(nameOrPrefixStart,this._index-1),nameStart=this._index):nameStart=nameOrPrefixStart,this._requireCharCodeUntilFn(isNameEnd,this._index===nameStart?1:0),[prefix,this._input.substring(nameStart,this._index)]},_Tokenizer.prototype._consumeTagOpen=function(start){var tagName,lowercaseTagName,savedPos=this._savePosition();try{if(!isAsciiLetter(this._peek))throw this._createError(_unexpectedCharacterErrorMsg(this._peek),this._getSpan());var nameStart=this._index;for(this._consumeTagOpenStart(start),tagName=this._input.substring(nameStart,this._index),lowercaseTagName=tagName.toLowerCase(),this._attemptCharCodeUntilFn(isNotWhitespace);this._peek!==$SLASH&&this._peek!==$GT;)this._consumeAttributeName(),this._attemptCharCodeUntilFn(isNotWhitespace),this._attemptCharCode($EQ)&&(this._attemptCharCodeUntilFn(isNotWhitespace),this._consumeAttributeValue()),this._attemptCharCodeUntilFn(isNotWhitespace);this._consumeTagOpenEnd()}catch(e){if(e instanceof _ControlFlowError)return this._restorePosition(savedPos),this._beginToken(TokenType$1.TEXT,start),void this._endToken(["<"]);throw e}var contentTokenType=this._getTagDefinition(tagName).contentType;contentTokenType===TagContentType.RAW_TEXT?this._consumeRawTextWithTagClose(lowercaseTagName,!1):contentTokenType===TagContentType.ESCAPABLE_RAW_TEXT&&this._consumeRawTextWithTagClose(lowercaseTagName,!0)},_Tokenizer.prototype._consumeRawTextWithTagClose=function(lowercaseTagName,decodeEntities){var _this=this,textToken=this._consumeRawText(decodeEntities,60,function(){return!!_this._attemptCharCode($SLASH)&&(_this._attemptCharCodeUntilFn(isNotWhitespace),!!_this._attemptStrCaseInsensitive(lowercaseTagName)&&(_this._attemptCharCodeUntilFn(isNotWhitespace),_this._attemptCharCode($GT)))});this._beginToken(TokenType$1.TAG_CLOSE,textToken.sourceSpan.end),this._endToken([null,lowercaseTagName])},_Tokenizer.prototype._consumeTagOpenStart=function(start){this._beginToken(TokenType$1.TAG_OPEN_START,start);var parts=this._consumePrefixAndName();this._endToken(parts)},_Tokenizer.prototype._consumeAttributeName=function(){this._beginToken(TokenType$1.ATTR_NAME);var prefixAndName=this._consumePrefixAndName();this._endToken(prefixAndName)},_Tokenizer.prototype._consumeAttributeValue=function(){this._beginToken(TokenType$1.ATTR_VALUE);var value;if(this._peek===$SQ||this._peek===$DQ){var quoteChar=this._peek;this._advance();for(var parts=[];this._peek!==quoteChar;)parts.push(this._readChar(!0));value=parts.join(""),this._advance()}else{var valueStart=this._index;this._requireCharCodeUntilFn(isNameEnd,1),value=this._input.substring(valueStart,this._index)}this._endToken([this._processCarriageReturns(value)])},_Tokenizer.prototype._consumeTagOpenEnd=function(){var tokenType=this._attemptCharCode($SLASH)?TokenType$1.TAG_OPEN_END_VOID:TokenType$1.TAG_OPEN_END;this._beginToken(tokenType),this._requireCharCode($GT),this._endToken([])},_Tokenizer.prototype._consumeTagClose=function(start){this._beginToken(TokenType$1.TAG_CLOSE,start),this._attemptCharCodeUntilFn(isNotWhitespace);var prefixAndName=this._consumePrefixAndName();this._attemptCharCodeUntilFn(isNotWhitespace),this._requireCharCode($GT),this._endToken(prefixAndName)},_Tokenizer.prototype._consumeExpansionFormStart=function(){this._beginToken(TokenType$1.EXPANSION_FORM_START,this._getLocation()),this._requireCharCode($LBRACE),this._endToken([]),this._expansionCaseStack.push(TokenType$1.EXPANSION_FORM_START),this._beginToken(TokenType$1.RAW_TEXT,this._getLocation());var condition=this._readUntil(44);this._endToken([condition],this._getLocation()),this._requireCharCode(44),this._attemptCharCodeUntilFn(isNotWhitespace),this._beginToken(TokenType$1.RAW_TEXT,this._getLocation());var type=this._readUntil(44);this._endToken([type],this._getLocation()),this._requireCharCode(44),this._attemptCharCodeUntilFn(isNotWhitespace)},_Tokenizer.prototype._consumeExpansionCaseStart=function(){this._beginToken(TokenType$1.EXPANSION_CASE_VALUE,this._getLocation());var value=this._readUntil($LBRACE).trim();this._endToken([value],this._getLocation()),this._attemptCharCodeUntilFn(isNotWhitespace),this._beginToken(TokenType$1.EXPANSION_CASE_EXP_START,this._getLocation()),this._requireCharCode($LBRACE),this._endToken([],this._getLocation()),this._attemptCharCodeUntilFn(isNotWhitespace),this._expansionCaseStack.push(TokenType$1.EXPANSION_CASE_EXP_START)},_Tokenizer.prototype._consumeExpansionCaseEnd=function(){this._beginToken(TokenType$1.EXPANSION_CASE_EXP_END,this._getLocation()),this._requireCharCode(125),this._endToken([],this._getLocation()),this._attemptCharCodeUntilFn(isNotWhitespace),this._expansionCaseStack.pop()},_Tokenizer.prototype._consumeExpansionFormEnd=function(){this._beginToken(TokenType$1.EXPANSION_FORM_END,this._getLocation()),this._requireCharCode(125),this._endToken([]),this._expansionCaseStack.pop()},_Tokenizer.prototype._consumeText=function(){var start=this._getLocation();this._beginToken(TokenType$1.TEXT,start);var parts=[];do{this._interpolationConfig&&this._attemptStr(this._interpolationConfig.start)?(parts.push(this._interpolationConfig.start),this._inInterpolation=!0):this._interpolationConfig&&this._inInterpolation&&this._attemptStr(this._interpolationConfig.end)?(parts.push(this._interpolationConfig.end),this._inInterpolation=!1):parts.push(this._readChar(!0))}while(!this._isTextEnd());this._endToken([this._processCarriageReturns(parts.join(""))])},_Tokenizer.prototype._isTextEnd=function(){if(60===this._peek||this._peek===$EOF)return!0;if(this._tokenizeIcu&&!this._inInterpolation){if(isExpansionFormStart(this._input,this._index,this._interpolationConfig))return!0;if(125===this._peek&&this._isInExpansionCase())return!0}return!1},_Tokenizer.prototype._savePosition=function(){return[this._peek,this._index,this._column,this._line,this.tokens.length]},_Tokenizer.prototype._readUntil=function(char){var start=this._index;return this._attemptUntilChar(char),this._input.substring(start,this._index)},_Tokenizer.prototype._restorePosition=function(position){this._peek=position[0],this._index=position[1],this._column=position[2],this._line=position[3];var nbTokens=position[4];nbTokens<this.tokens.length&&(this.tokens=this.tokens.slice(0,nbTokens))},_Tokenizer.prototype._isInExpansionCase=function(){return this._expansionCaseStack.length>0&&this._expansionCaseStack[this._expansionCaseStack.length-1]===TokenType$1.EXPANSION_CASE_EXP_START},_Tokenizer.prototype._isInExpansionForm=function(){return this._expansionCaseStack.length>0&&this._expansionCaseStack[this._expansionCaseStack.length-1]===TokenType$1.EXPANSION_FORM_START},_Tokenizer}(),TreeError=function(_super){function TreeError(elementName,span,msg){var _this=_super.call(this,span,msg)||this;return _this.elementName=elementName,_this}return __extends(TreeError,_super),TreeError.create=function(elementName,span,msg){return new TreeError(elementName,span,msg)},TreeError}(ParseError),ParseTreeResult=function(){function ParseTreeResult(rootNodes,errors){this.rootNodes=rootNodes,this.errors=errors}return ParseTreeResult}(),Parser$1=function(){function Parser(getTagDefinition){this.getTagDefinition=getTagDefinition}return Parser.prototype.parse=function(source,url,parseExpansionForms,interpolationConfig){void 0===parseExpansionForms&&(parseExpansionForms=!1),void 0===interpolationConfig&&(interpolationConfig=DEFAULT_INTERPOLATION_CONFIG);var tokensAndErrors=tokenize(source,url,this.getTagDefinition,parseExpansionForms,interpolationConfig),treeAndErrors=new _TreeBuilder(tokensAndErrors.tokens,this.getTagDefinition).build();return new ParseTreeResult(treeAndErrors.rootNodes,tokensAndErrors.errors.concat(treeAndErrors.errors))},Parser}(),_TreeBuilder=function(){function _TreeBuilder(tokens,getTagDefinition){this.tokens=tokens,this.getTagDefinition=getTagDefinition,this._index=-1,this._rootNodes=[],this._errors=[],this._elementStack=[],this._advance()}return _TreeBuilder.prototype.build=function(){for(;this._peek.type!==TokenType$1.EOF;)this._peek.type===TokenType$1.TAG_OPEN_START?this._consumeStartTag(this._advance()):this._peek.type===TokenType$1.TAG_CLOSE?this._consumeEndTag(this._advance()):this._peek.type===TokenType$1.CDATA_START?(this._closeVoidElement(),this._consumeCdata(this._advance())):this._peek.type===TokenType$1.COMMENT_START?(this._closeVoidElement(),this._consumeComment(this._advance())):this._peek.type===TokenType$1.TEXT||this._peek.type===TokenType$1.RAW_TEXT||this._peek.type===TokenType$1.ESCAPABLE_RAW_TEXT?(this._closeVoidElement(),this._consumeText(this._advance())):this._peek.type===TokenType$1.EXPANSION_FORM_START?this._consumeExpansion(this._advance()):this._advance();return new ParseTreeResult(this._rootNodes,this._errors)},_TreeBuilder.prototype._advance=function(){var prev=this._peek;return this._index<this.tokens.length-1&&this._index++,this._peek=this.tokens[this._index],prev},_TreeBuilder.prototype._advanceIf=function(type){return this._peek.type===type?this._advance():null},_TreeBuilder.prototype._consumeCdata=function(startToken){this._consumeText(this._advance()),this._advanceIf(TokenType$1.CDATA_END)},_TreeBuilder.prototype._consumeComment=function(token){var text=this._advanceIf(TokenType$1.RAW_TEXT);this._advanceIf(TokenType$1.COMMENT_END);var value=null!=text?text.parts[0].trim():null;this._addToParent(new Comment(value,token.sourceSpan))},_TreeBuilder.prototype._consumeExpansion=function(token){for(var switchValue=this._advance(),type=this._advance(),cases=[];this._peek.type===TokenType$1.EXPANSION_CASE_VALUE;){var expCase=this._parseExpansionCase();if(!expCase)return;cases.push(expCase)}if(this._peek.type!==TokenType$1.EXPANSION_FORM_END)return void this._errors.push(TreeError.create(null,this._peek.sourceSpan,"Invalid ICU message. Missing '}'."));var sourceSpan=new ParseSourceSpan(token.sourceSpan.start,this._peek.sourceSpan.end);this._addToParent(new Expansion(switchValue.parts[0],type.parts[0],cases,sourceSpan,switchValue.sourceSpan)),this._advance()},_TreeBuilder.prototype._parseExpansionCase=function(){var value=this._advance();if(this._peek.type!==TokenType$1.EXPANSION_CASE_EXP_START)return this._errors.push(TreeError.create(null,this._peek.sourceSpan,"Invalid ICU message. Missing '{'.")),null;var start=this._advance(),exp=this._collectExpansionExpTokens(start);if(!exp)return null;var end=this._advance();exp.push(new Token$1(TokenType$1.EOF,[],end.sourceSpan));var parsedExp=new _TreeBuilder(exp,this.getTagDefinition).build();if(parsedExp.errors.length>0)return this._errors=this._errors.concat(parsedExp.errors),null;var sourceSpan=new ParseSourceSpan(value.sourceSpan.start,end.sourceSpan.end),expSourceSpan=new ParseSourceSpan(start.sourceSpan.start,end.sourceSpan.end);return new ExpansionCase(value.parts[0],parsedExp.rootNodes,sourceSpan,value.sourceSpan,expSourceSpan)},_TreeBuilder.prototype._collectExpansionExpTokens=function(start){for(var exp=[],expansionFormStack=[TokenType$1.EXPANSION_CASE_EXP_START];;){if(this._peek.type!==TokenType$1.EXPANSION_FORM_START&&this._peek.type!==TokenType$1.EXPANSION_CASE_EXP_START||expansionFormStack.push(this._peek.type),this._peek.type===TokenType$1.EXPANSION_CASE_EXP_END){if(!lastOnStack(expansionFormStack,TokenType$1.EXPANSION_CASE_EXP_START))return this._errors.push(TreeError.create(null,start.sourceSpan,"Invalid ICU message. Missing '}'.")),null;if(expansionFormStack.pop(),0==expansionFormStack.length)return exp}if(this._peek.type===TokenType$1.EXPANSION_FORM_END){if(!lastOnStack(expansionFormStack,TokenType$1.EXPANSION_FORM_START))return this._errors.push(TreeError.create(null,start.sourceSpan,"Invalid ICU message. Missing '}'.")),null;expansionFormStack.pop()}if(this._peek.type===TokenType$1.EOF)return this._errors.push(TreeError.create(null,start.sourceSpan,"Invalid ICU message. Missing '}'.")),null;exp.push(this._advance())}},_TreeBuilder.prototype._consumeText=function(token){var text=token.parts[0];if(text.length>0&&"\n"==text[0]){var parent_1=this._getParentElement();null!=parent_1&&0==parent_1.children.length&&this.getTagDefinition(parent_1.name).ignoreFirstLf&&(text=text.substring(1))}text.length>0&&this._addToParent(new Text(text,token.sourceSpan))},_TreeBuilder.prototype._closeVoidElement=function(){var el=this._getParentElement();el&&this.getTagDefinition(el.name).isVoid&&this._elementStack.pop()},_TreeBuilder.prototype._consumeStartTag=function(startTagToken){for(var prefix=startTagToken.parts[0],name=startTagToken.parts[1],attrs=[];this._peek.type===TokenType$1.ATTR_NAME;)attrs.push(this._consumeAttr(this._advance()));var fullName=this._getElementFullName(prefix,name,this._getParentElement()),selfClosing=!1;if(this._peek.type===TokenType$1.TAG_OPEN_END_VOID){this._advance(),selfClosing=!0;var tagDef=this.getTagDefinition(fullName);tagDef.canSelfClose||null!==getNsPrefix(fullName)||tagDef.isVoid||this._errors.push(TreeError.create(fullName,startTagToken.sourceSpan,'Only void and foreign elements can be self closed "'+startTagToken.parts[1]+'"'))}else this._peek.type===TokenType$1.TAG_OPEN_END&&(this._advance(),selfClosing=!1);var end=this._peek.sourceSpan.start,span=new ParseSourceSpan(startTagToken.sourceSpan.start,end),el=new Element(fullName,attrs,[],span,span,void 0);this._pushElement(el),selfClosing&&(this._popElement(fullName),el.endSourceSpan=span)},_TreeBuilder.prototype._pushElement=function(el){var parentEl=this._getParentElement();parentEl&&this.getTagDefinition(parentEl.name).isClosedByChild(el.name)&&this._elementStack.pop();var tagDef=this.getTagDefinition(el.name),_a=this._getParentElementSkippingContainers(),parent=_a.parent,container=_a.container;if(parent&&tagDef.requireExtraParent(parent.name)){var newParent=new Element(tagDef.parentToAdd,[],[],el.sourceSpan,el.startSourceSpan,el.endSourceSpan);this._insertBeforeContainer(parent,container,newParent)}this._addToParent(el),this._elementStack.push(el)},_TreeBuilder.prototype._consumeEndTag=function(endTagToken){var fullName=this._getElementFullName(endTagToken.parts[0],endTagToken.parts[1],this._getParentElement());if(this._getParentElement()&&(this._getParentElement().endSourceSpan=endTagToken.sourceSpan),this.getTagDefinition(fullName).isVoid)this._errors.push(TreeError.create(fullName,endTagToken.sourceSpan,'Void elements do not have end tags "'+endTagToken.parts[1]+'"'));else if(!this._popElement(fullName)){var errMsg='Unexpected closing tag "'+fullName+'". It may happen when the tag has already been closed by another tag. For more info see https://www.w3.org/TR/html5/syntax.html#closing-elements-that-have-implied-end-tags';this._errors.push(TreeError.create(fullName,endTagToken.sourceSpan,errMsg))}},_TreeBuilder.prototype._popElement=function(fullName){for(var stackIndex=this._elementStack.length-1;stackIndex>=0;stackIndex--){var el=this._elementStack[stackIndex];if(el.name==fullName)return this._elementStack.splice(stackIndex,this._elementStack.length-stackIndex),!0;if(!this.getTagDefinition(el.name).closedByParent)return!1}return!1},_TreeBuilder.prototype._consumeAttr=function(attrName){var fullName=mergeNsAndName(attrName.parts[0],attrName.parts[1]),end=attrName.sourceSpan.end,value="",valueSpan=void 0;if(this._peek.type===TokenType$1.ATTR_VALUE){var valueToken=this._advance();value=valueToken.parts[0],end=valueToken.sourceSpan.end,valueSpan=valueToken.sourceSpan}return new Attribute$1(fullName,value,new ParseSourceSpan(attrName.sourceSpan.start,end),valueSpan)},_TreeBuilder.prototype._getParentElement=function(){return this._elementStack.length>0?this._elementStack[this._elementStack.length-1]:null},_TreeBuilder.prototype._getParentElementSkippingContainers=function(){for(var container=null,i=this._elementStack.length-1;i>=0;i--){if(!isNgContainer(this._elementStack[i].name))return{parent:this._elementStack[i],container:container};container=this._elementStack[i]}return{parent:null,container:container}},_TreeBuilder.prototype._addToParent=function(node){var parent=this._getParentElement();null!=parent?parent.children.push(node):this._rootNodes.push(node)},_TreeBuilder.prototype._insertBeforeContainer=function(parent,container,node){if(container){if(parent){var index=parent.children.indexOf(container);parent.children[index]=node}else this._rootNodes.push(node);node.children.push(container),this._elementStack.splice(this._elementStack.indexOf(container),0,node)}else this._addToParent(node),this._elementStack.push(node)},_TreeBuilder.prototype._getElementFullName=function(prefix,localName,parentElement){return null==prefix&&null==(prefix=this.getTagDefinition(localName).implicitNamespacePrefix)&&null!=parentElement&&(prefix=getNsPrefix(parentElement.name)),mergeNsAndName(prefix,localName)},_TreeBuilder}(),_SerializerVisitor=function(){function _SerializerVisitor(){}return _SerializerVisitor.prototype.visitText=function(text,context){return text.value},_SerializerVisitor.prototype.visitContainer=function(container,context){var _this=this;return"["+container.children.map(function(child){return child.visit(_this)}).join(", ")+"]"},_SerializerVisitor.prototype.visitIcu=function(icu,context){var _this=this,strCases=Object.keys(icu.cases).map(function(k){return k+" {"+icu.cases[k].visit(_this)+"}"});return"{"+icu.expression+", "+icu.type+", "+strCases.join(", ")+"}"},_SerializerVisitor.prototype.visitTagPlaceholder=function(ph,context){var _this=this;return ph.isVoid?'<ph tag name="'+ph.startName+'"/>':'<ph tag name="'+ph.startName+'">'+ph.children.map(function(child){return child.visit(_this)}).join(", ")+'</ph name="'+ph.closeName+'">'},_SerializerVisitor.prototype.visitPlaceholder=function(ph,context){return ph.value?'<ph name="'+ph.name+'">'+ph.value+"</ph>":'<ph name="'+ph.name+'"/>'},_SerializerVisitor.prototype.visitIcuPlaceholder=function(ph,context){return'<ph icu name="'+ph.name+'">'+ph.value.visit(this)+"</ph>"},_SerializerVisitor}(),serializerVisitor=new _SerializerVisitor,_SerializerIgnoreIcuExpVisitor=function(_super){function _SerializerIgnoreIcuExpVisitor(){return null!==_super&&_super.apply(this,arguments)||this}return __extends(_SerializerIgnoreIcuExpVisitor,_super),_SerializerIgnoreIcuExpVisitor.prototype.visitIcu=function(icu,context){var _this=this,strCases=Object.keys(icu.cases).map(function(k){return k+" {"+icu.cases[k].visit(_this)+"}"});return"{"+icu.type+", "+strCases.join(", ")+"}"},_SerializerIgnoreIcuExpVisitor}(_SerializerVisitor),Endian={Little:0,Big:1};Endian[Endian.Little]="Little",Endian[Endian.Big]="Big";/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
var Message=function(){function Message(nodes,placeholders,placeholderToMessage,meaning,description,id){this.nodes=nodes,this.placeholders=placeholders,this.placeholderToMessage=placeholderToMessage,this.meaning=meaning,this.description=description,this.id=id,nodes.length?this.sources=[{filePath:nodes[0].sourceSpan.start.file.url,startLine:nodes[0].sourceSpan.start.line+1,startCol:nodes[0].sourceSpan.start.col+1,endLine:nodes[nodes.length-1].sourceSpan.end.line+1,endCol:nodes[0].sourceSpan.start.col+1}]:this.sources=[]}return Message}(),Text$1=function(){function Text(value,sourceSpan){this.value=value,this.sourceSpan=sourceSpan}return Text.prototype.visit=function(visitor,context){return visitor.visitText(this,context)},Text}(),Container=function(){function Container(children,sourceSpan){this.children=children,this.sourceSpan=sourceSpan}return Container.prototype.visit=function(visitor,context){return visitor.visitContainer(this,context)},Container}(),Icu=function(){function Icu(expression,type,cases,sourceSpan){this.expression=expression,this.type=type,this.cases=cases,this.sourceSpan=sourceSpan}return Icu.prototype.visit=function(visitor,context){return visitor.visitIcu(this,context)},Icu}(),TagPlaceholder=function(){function TagPlaceholder(tag,attrs,startName,closeName,children,isVoid,sourceSpan){this.tag=tag,this.attrs=attrs,this.startName=startName,this.closeName=closeName,this.children=children,this.isVoid=isVoid,this.sourceSpan=sourceSpan}return TagPlaceholder.prototype.visit=function(visitor,context){return visitor.visitTagPlaceholder(this,context)},TagPlaceholder}(),Placeholder=function(){function Placeholder(value,name,sourceSpan){this.value=value,this.name=name,this.sourceSpan=sourceSpan}return Placeholder.prototype.visit=function(visitor,context){return visitor.visitPlaceholder(this,context)},Placeholder}(),IcuPlaceholder=function(){function IcuPlaceholder(value,name,sourceSpan){this.value=value,this.name=name,this.sourceSpan=sourceSpan}return IcuPlaceholder.prototype.visit=function(visitor,context){return visitor.visitIcuPlaceholder(this,context)},IcuPlaceholder}(),CloneVisitor=function(){function CloneVisitor(){}return CloneVisitor.prototype.visitText=function(text,context){return new Text$1(text.value,text.sourceSpan)},CloneVisitor.prototype.visitContainer=function(container,context){var _this=this,children=container.children.map(function(n){return n.visit(_this,context)});return new Container(children,container.sourceSpan)},CloneVisitor.prototype.visitIcu=function(icu,context){var _this=this,cases={};Object.keys(icu.cases).forEach(function(key){return cases[key]=icu.cases[key].visit(_this,context)});var msg=new Icu(icu.expression,icu.type,cases,icu.sourceSpan);return msg.expressionPlaceholder=icu.expressionPlaceholder,msg},CloneVisitor.prototype.visitTagPlaceholder=function(ph,context){var _this=this,children=ph.children.map(function(n){return n.visit(_this,context)});return new TagPlaceholder(ph.tag,ph.attrs,ph.startName,ph.closeName,children,ph.isVoid,ph.sourceSpan)},CloneVisitor.prototype.visitPlaceholder=function(ph,context){return new Placeholder(ph.value,ph.name,ph.sourceSpan)},CloneVisitor.prototype.visitIcuPlaceholder=function(ph,context){return new IcuPlaceholder(ph.value,ph.name,ph.sourceSpan)},CloneVisitor}(),RecurseVisitor=function(){function RecurseVisitor(){}return RecurseVisitor.prototype.visitText=function(text,context){},RecurseVisitor.prototype.visitContainer=function(container,context){var _this=this;container.children.forEach(function(child){return child.visit(_this)})},RecurseVisitor.prototype.visitIcu=function(icu,context){var _this=this;Object.keys(icu.cases).forEach(function(k){icu.cases[k].visit(_this)})},RecurseVisitor.prototype.visitTagPlaceholder=function(ph,context){var _this=this;ph.children.forEach(function(child){return child.visit(_this)})},RecurseVisitor.prototype.visitPlaceholder=function(ph,context){},RecurseVisitor.prototype.visitIcuPlaceholder=function(ph,context){},RecurseVisitor}(),HtmlTagDefinition=function(){function HtmlTagDefinition(_a){var _b=void 0===_a?{}:_a,closedByChildren=_b.closedByChildren,requiredParents=_b.requiredParents,implicitNamespacePrefix=_b.implicitNamespacePrefix,_c=_b.contentType,contentType=void 0===_c?TagContentType.PARSABLE_DATA:_c,_d=_b.closedByParent,closedByParent=void 0!==_d&&_d,_e=_b.isVoid,isVoid=void 0!==_e&&_e,_f=_b.ignoreFirstLf,ignoreFirstLf=void 0!==_f&&_f,_this=this;this.closedByChildren={},this.closedByParent=!1,this.canSelfClose=!1,closedByChildren&&closedByChildren.length>0&&closedByChildren.forEach(function(tagName){return _this.closedByChildren[tagName]=!0}),this.isVoid=isVoid,this.closedByParent=closedByParent||isVoid,requiredParents&&requiredParents.length>0&&(this.requiredParents={},this.parentToAdd=requiredParents[0],requiredParents.forEach(function(tagName){return _this.requiredParents[tagName]=!0})),this.implicitNamespacePrefix=implicitNamespacePrefix||null,this.contentType=contentType,this.ignoreFirstLf=ignoreFirstLf}return HtmlTagDefinition.prototype.requireExtraParent=function(currentParent){if(!this.requiredParents)return!1;if(!currentParent)return!0;var lcParent=currentParent.toLowerCase();return!("template"===lcParent||"ng-template"===currentParent)&&1!=this.requiredParents[lcParent]},HtmlTagDefinition.prototype.isClosedByChild=function(name){return this.isVoid||name.toLowerCase()in this.closedByChildren},HtmlTagDefinition}(),TAG_DEFINITIONS={base:new HtmlTagDefinition({isVoid:!0}),meta:new HtmlTagDefinition({isVoid:!0}),area:new HtmlTagDefinition({isVoid:!0}),embed:new HtmlTagDefinition({isVoid:!0}),link:new HtmlTagDefinition({isVoid:!0}),img:new HtmlTagDefinition({isVoid:!0}),input:new HtmlTagDefinition({isVoid:!0}),param:new HtmlTagDefinition({isVoid:!0}),hr:new HtmlTagDefinition({isVoid:!0}),br:new HtmlTagDefinition({isVoid:!0}),source:new HtmlTagDefinition({isVoid:!0}),track:new HtmlTagDefinition({isVoid:!0}),wbr:new HtmlTagDefinition({isVoid:!0}),p:new HtmlTagDefinition({closedByChildren:["address","article","aside","blockquote","div","dl","fieldset","footer","form","h1","h2","h3","h4","h5","h6","header","hgroup","hr","main","nav","ol","p","pre","section","table","ul"],closedByParent:!0}),thead:new HtmlTagDefinition({closedByChildren:["tbody","tfoot"]}),tbody:new HtmlTagDefinition({closedByChildren:["tbody","tfoot"],closedByParent:!0}),tfoot:new HtmlTagDefinition({closedByChildren:["tbody"],closedByParent:!0}),tr:new HtmlTagDefinition({closedByChildren:["tr"],requiredParents:["tbody","tfoot","thead"],closedByParent:!0}),td:new HtmlTagDefinition({closedByChildren:["td","th"],closedByParent:!0}),th:new HtmlTagDefinition({closedByChildren:["td","th"],closedByParent:!0}),col:new HtmlTagDefinition({requiredParents:["colgroup"],isVoid:!0}),svg:new HtmlTagDefinition({implicitNamespacePrefix:"svg"}),math:new HtmlTagDefinition({implicitNamespacePrefix:"math"}),li:new HtmlTagDefinition({closedByChildren:["li"],closedByParent:!0}),dt:new HtmlTagDefinition({closedByChildren:["dt","dd"]}),dd:new HtmlTagDefinition({closedByChildren:["dt","dd"],closedByParent:!0}),rb:new HtmlTagDefinition({closedByChildren:["rb","rt","rtc","rp"],closedByParent:!0}),rt:new HtmlTagDefinition({closedByChildren:["rb","rt","rtc","rp"],closedByParent:!0}),rtc:new HtmlTagDefinition({closedByChildren:["rb","rtc","rp"],closedByParent:!0}),rp:new HtmlTagDefinition({closedByChildren:["rb","rt","rtc","rp"],closedByParent:!0}),optgroup:new HtmlTagDefinition({closedByChildren:["optgroup"],closedByParent:!0}),option:new HtmlTagDefinition({closedByChildren:["option","optgroup"],closedByParent:!0}),pre:new HtmlTagDefinition({ignoreFirstLf:!0}),listing:new HtmlTagDefinition({ignoreFirstLf:!0}),style:new HtmlTagDefinition({contentType:TagContentType.RAW_TEXT}),script:new HtmlTagDefinition({contentType:TagContentType.RAW_TEXT}),title:new HtmlTagDefinition({contentType:TagContentType.ESCAPABLE_RAW_TEXT}),textarea:new HtmlTagDefinition({contentType:TagContentType.ESCAPABLE_RAW_TEXT,ignoreFirstLf:!0})},_DEFAULT_TAG_DEFINITION=new HtmlTagDefinition,TAG_TO_PLACEHOLDER_NAMES={A:"LINK",B:"BOLD_TEXT",BR:"LINE_BREAK",EM:"EMPHASISED_TEXT",H1:"HEADING_LEVEL1",H2:"HEADING_LEVEL2",H3:"HEADING_LEVEL3",H4:"HEADING_LEVEL4",H5:"HEADING_LEVEL5",H6:"HEADING_LEVEL6",HR:"HORIZONTAL_RULE",I:"ITALIC_TEXT",LI:"LIST_ITEM",LINK:"MEDIA_LINK",OL:"ORDERED_LIST",P:"PARAGRAPH",Q:"QUOTATION",S:"STRIKETHROUGH_TEXT",SMALL:"SMALL_TEXT",SUB:"SUBSTRIPT",SUP:"SUPERSCRIPT",TBODY:"TABLE_BODY",TD:"TABLE_CELL",TFOOT:"TABLE_FOOTER",TH:"TABLE_HEADER_CELL",THEAD:"TABLE_HEADER",TR:"TABLE_ROW",TT:"MONOSPACED_TEXT",U:"UNDERLINED_TEXT",UL:"UNORDERED_LIST"},PlaceholderRegistry=function(){function PlaceholderRegistry(){this._placeHolderNameCounts={},this._signatureToName={}}return PlaceholderRegistry.prototype.getStartTagPlaceholderName=function(tag,attrs,isVoid){var signature=this._hashTag(tag,attrs,isVoid);if(this._signatureToName[signature])return this._signatureToName[signature];var upperTag=tag.toUpperCase(),baseName=TAG_TO_PLACEHOLDER_NAMES[upperTag]||"TAG_"+upperTag,name=this._generateUniqueName(isVoid?baseName:"START_"+baseName);return this._signatureToName[signature]=name,name},PlaceholderRegistry.prototype.getCloseTagPlaceholderName=function(tag){var signature=this._hashClosingTag(tag);if(this._signatureToName[signature])return this._signatureToName[signature];var upperTag=tag.toUpperCase(),baseName=TAG_TO_PLACEHOLDER_NAMES[upperTag]||"TAG_"+upperTag,name=this._generateUniqueName("CLOSE_"+baseName);return this._signatureToName[signature]=name,name},PlaceholderRegistry.prototype.getPlaceholderName=function(name,content){var upperName=name.toUpperCase(),signature="PH: "+upperName+"="+content;if(this._signatureToName[signature])return this._signatureToName[signature];var uniqueName=this._generateUniqueName(upperName);return this._signatureToName[signature]=uniqueName,uniqueName},PlaceholderRegistry.prototype.getUniquePlaceholder=function(name){return this._generateUniqueName(name.toUpperCase())},PlaceholderRegistry.prototype._hashTag=function(tag,attrs,isVoid){return"<"+tag+Object.keys(attrs).sort().map(function(name){return" "+name+"="+attrs[name]}).join("")+(isVoid?"/>":"></"+tag+">")},PlaceholderRegistry.prototype._hashClosingTag=function(tag){return this._hashTag("/"+tag,{},!1)},PlaceholderRegistry.prototype._generateUniqueName=function(base){if(!this._placeHolderNameCounts.hasOwnProperty(base))return this._placeHolderNameCounts[base]=1,base;var id=this._placeHolderNameCounts[base];return this._placeHolderNameCounts[base]=id+1,base+"_"+id},PlaceholderRegistry}(),_expParser=new Parser(new Lexer),_I18nVisitor=function(){function _I18nVisitor(_expressionParser,_interpolationConfig){this._expressionParser=_expressionParser,this._interpolationConfig=_interpolationConfig}return _I18nVisitor.prototype.toI18nMessage=function(nodes,meaning,description,id){this._isIcu=1==nodes.length&&nodes[0]instanceof Expansion,this._icuDepth=0,this._placeholderRegistry=new PlaceholderRegistry,this._placeholderToContent={},this._placeholderToMessage={};var i18nodes=visitAll(this,nodes,{});return new Message(i18nodes,this._placeholderToContent,this._placeholderToMessage,meaning,description,id)},_I18nVisitor.prototype.visitElement=function(el,context){var children=visitAll(this,el.children),attrs={};el.attrs.forEach(function(attr){attrs[attr.name]=attr.value});var isVoid=getHtmlTagDefinition(el.name).isVoid,startPhName=this._placeholderRegistry.getStartTagPlaceholderName(el.name,attrs,isVoid);this._placeholderToContent[startPhName]=el.sourceSpan.toString();var closePhName="";return isVoid||(closePhName=this._placeholderRegistry.getCloseTagPlaceholderName(el.name),this._placeholderToContent[closePhName]="</"+el.name+">"),new TagPlaceholder(el.name,attrs,startPhName,closePhName,children,isVoid,el.sourceSpan)},_I18nVisitor.prototype.visitAttribute=function(attribute,context){return this._visitTextWithInterpolation(attribute.value,attribute.sourceSpan)},_I18nVisitor.prototype.visitText=function(text,context){return this._visitTextWithInterpolation(text.value,text.sourceSpan)},_I18nVisitor.prototype.visitComment=function(comment,context){return null},_I18nVisitor.prototype.visitExpansion=function(icu,context){var _this=this;this._icuDepth++;var i18nIcuCases={},i18nIcu=new Icu(icu.switchValue,icu.type,i18nIcuCases,icu.sourceSpan);if(icu.cases.forEach(function(caze){i18nIcuCases[caze.value]=new Container(caze.expression.map(function(node){return node.visit(_this,{})}),caze.expSourceSpan)}),this._icuDepth--,this._isIcu||this._icuDepth>0){var expPh=this._placeholderRegistry.getUniquePlaceholder("VAR_"+icu.type);return i18nIcu.expressionPlaceholder=expPh,this._placeholderToContent[expPh]=icu.switchValue,i18nIcu}var phName=this._placeholderRegistry.getPlaceholderName("ICU",icu.sourceSpan.toString()),visitor=new _I18nVisitor(this._expressionParser,this._interpolationConfig);return this._placeholderToMessage[phName]=visitor.toI18nMessage([icu],"","",""),new IcuPlaceholder(i18nIcu,phName,icu.sourceSpan)},_I18nVisitor.prototype.visitExpansionCase=function(icuCase,context){throw new Error("Unreachable code")},_I18nVisitor.prototype._visitTextWithInterpolation=function(text,sourceSpan){var splitInterpolation=this._expressionParser.splitInterpolation(text,sourceSpan.start.toString(),this._interpolationConfig);if(!splitInterpolation)return new Text$1(text,sourceSpan);for(var nodes=[],container=new Container(nodes,sourceSpan),_a=this._interpolationConfig,sDelimiter=_a.start,eDelimiter=_a.end,i=0;i<splitInterpolation.strings.length-1;i++){var expression=splitInterpolation.expressions[i],baseName=_extractPlaceholderName(expression)||"INTERPOLATION",phName=this._placeholderRegistry.getPlaceholderName(baseName,expression);splitInterpolation.strings[i].length&&nodes.push(new Text$1(splitInterpolation.strings[i],sourceSpan)),nodes.push(new Placeholder(expression,phName,sourceSpan)),this._placeholderToContent[phName]=sDelimiter+expression+eDelimiter}var lastStringIdx=splitInterpolation.strings.length-1;return splitInterpolation.strings[lastStringIdx].length&&nodes.push(new Text$1(splitInterpolation.strings[lastStringIdx],sourceSpan)),container},_I18nVisitor}(),_CUSTOM_PH_EXP=/\/\/[\s\S]*i18n[\s\S]*\([\s\S]*ph[\s\S]*=[\s\S]*("|')([\s\S]*?)\1[\s\S]*\)/g,I18nError=function(_super){function I18nError(span,msg){return _super.call(this,span,msg)||this}return __extends(I18nError,_super),I18nError}(ParseError),_I18N_ATTR="i18n",_I18N_COMMENT_PREFIX_REGEXP=/^i18n:?/,MEANING_SEPARATOR="|",ID_SEPARATOR="@@",i18nCommentsWarned=!1,ExtractionResult=function(){function ExtractionResult(messages,errors){this.messages=messages,this.errors=errors}return ExtractionResult}(),_VisitorMode={Extract:0,Merge:1};_VisitorMode[_VisitorMode.Extract]="Extract",_VisitorMode[_VisitorMode.Merge]="Merge";var _Visitor=function(){function _Visitor(_implicitTags,_implicitAttrs){this._implicitTags=_implicitTags,this._implicitAttrs=_implicitAttrs}return _Visitor.prototype.extract=function(nodes,interpolationConfig){var _this=this;return this._init(_VisitorMode.Extract,interpolationConfig),nodes.forEach(function(node){return node.visit(_this,null)}),this._inI18nBlock&&this._reportError(nodes[nodes.length-1],"Unclosed block"),new ExtractionResult(this._messages,this._errors)},_Visitor.prototype.merge=function(nodes,translations,interpolationConfig){this._init(_VisitorMode.Merge,interpolationConfig),this._translations=translations;var wrapper=new Element("wrapper",[],nodes,void 0,void 0,void 0),translatedNode=wrapper.visit(this,null);return this._inI18nBlock&&this._reportError(nodes[nodes.length-1],"Unclosed block"),new ParseTreeResult(translatedNode.children,this._errors)},_Visitor.prototype.visitExpansionCase=function(icuCase,context){var expression=visitAll(this,icuCase.expression,context);if(this._mode===_VisitorMode.Merge)return new ExpansionCase(icuCase.value,expression,icuCase.sourceSpan,icuCase.valueSourceSpan,icuCase.expSourceSpan)},_Visitor.prototype.visitExpansion=function(icu,context){this._mayBeAddBlockChildren(icu);var wasInIcu=this._inIcu;this._inIcu||(this._isInTranslatableSection&&this._addMessage([icu]),this._inIcu=!0);var cases=visitAll(this,icu.cases,context);return this._mode===_VisitorMode.Merge&&(icu=new Expansion(icu.switchValue,icu.type,cases,icu.sourceSpan,icu.switchValueSourceSpan)),this._inIcu=wasInIcu,icu},_Visitor.prototype.visitComment=function(comment,context){var isOpening=_isOpeningComment(comment);if(isOpening&&this._isInTranslatableSection)return void this._reportError(comment,"Could not start a block inside a translatable section");var isClosing=_isClosingComment(comment);if(isClosing&&!this._inI18nBlock)return void this._reportError(comment,"Trying to close an unopened block");if(!this._inI18nNode&&!this._inIcu)if(this._inI18nBlock){if(isClosing){if(this._depth==this._blockStartDepth){this._closeTranslatableSection(comment,this._blockChildren),this._inI18nBlock=!1;var message=this._addMessage(this._blockChildren,this._blockMeaningAndDesc),nodes=this._translateMessage(comment,message);return visitAll(this,nodes)}return void this._reportError(comment,"I18N blocks should not cross element boundaries")}}else if(isOpening){if(!i18nCommentsWarned&&console&&console.warn){i18nCommentsWarned=!0;var details=comment.sourceSpan.details?", "+comment.sourceSpan.details:"";console.warn("I18n comments are deprecated, use an <ng-container> element instead ("+comment.sourceSpan.start+details+")")}this._inI18nBlock=!0,this._blockStartDepth=this._depth,this._blockChildren=[],this._blockMeaningAndDesc=comment.value.replace(_I18N_COMMENT_PREFIX_REGEXP,"").trim(),this._openTranslatableSection(comment)}},_Visitor.prototype.visitText=function(text,context){return this._isInTranslatableSection&&this._mayBeAddBlockChildren(text),text},_Visitor.prototype.visitElement=function(el,context){var _this=this;this._mayBeAddBlockChildren(el),this._depth++;var wasInI18nNode=this._inI18nNode,wasInImplicitNode=this._inImplicitNode,childNodes=[],translatedChildNodes=void 0,i18nAttr=_getI18nAttr(el),i18nMeta=i18nAttr?i18nAttr.value:"",isImplicit=this._implicitTags.some(function(tag){return el.name===tag})&&!this._inIcu&&!this._isInTranslatableSection,isTopLevelImplicit=!wasInImplicitNode&&isImplicit;if(this._inImplicitNode=wasInImplicitNode||isImplicit,this._isInTranslatableSection||this._inIcu)(i18nAttr||isTopLevelImplicit)&&this._reportError(el,"Could not mark an element as translatable inside a translatable section"),this._mode==_VisitorMode.Extract&&visitAll(this,el.children);else{if(i18nAttr||isTopLevelImplicit){this._inI18nNode=!0;var message=this._addMessage(el.children,i18nMeta);translatedChildNodes=this._translateMessage(el,message)}if(this._mode==_VisitorMode.Extract){var isTranslatable=i18nAttr||isTopLevelImplicit;isTranslatable&&this._openTranslatableSection(el),visitAll(this,el.children),isTranslatable&&this._closeTranslatableSection(el,el.children)}}if(this._mode===_VisitorMode.Merge){(translatedChildNodes||el.children).forEach(function(child){var visited=child.visit(_this,context);visited&&!_this._isInTranslatableSection&&(childNodes=childNodes.concat(visited))})}if(this._visitAttributesOf(el),this._depth--,this._inI18nNode=wasInI18nNode,this._inImplicitNode=wasInImplicitNode,this._mode===_VisitorMode.Merge){var translatedAttrs=this._translateAttributes(el);return new Element(el.name,translatedAttrs,childNodes,el.sourceSpan,el.startSourceSpan,el.endSourceSpan)}return null},_Visitor.prototype.visitAttribute=function(attribute,context){throw new Error("unreachable code")},_Visitor.prototype._init=function(mode,interpolationConfig){this._mode=mode,this._inI18nBlock=!1,this._inI18nNode=!1,this._depth=0,this._inIcu=!1,this._msgCountAtSectionStart=void 0,this._errors=[],this._messages=[],this._inImplicitNode=!1,this._createI18nMessage=createI18nMessageFactory(interpolationConfig)},_Visitor.prototype._visitAttributesOf=function(el){var _this=this,explicitAttrNameToValue={},implicitAttrNames=this._implicitAttrs[el.name]||[];el.attrs.filter(function(attr){return attr.name.startsWith("i18n-")}).forEach(function(attr){return explicitAttrNameToValue[attr.name.slice("i18n-".length)]=attr.value}),el.attrs.forEach(function(attr){attr.name in explicitAttrNameToValue?_this._addMessage([attr],explicitAttrNameToValue[attr.name]):implicitAttrNames.some(function(name){return attr.name===name})&&_this._addMessage([attr])})},_Visitor.prototype._addMessage=function(ast,msgMeta){if(0==ast.length||1==ast.length&&ast[0]instanceof Attribute$1&&!ast[0].value)return null;var _a=_parseMessageMeta(msgMeta),meaning=_a.meaning,description=_a.description,id=_a.id,message=this._createI18nMessage(ast,meaning,description,id);return this._messages.push(message),message},_Visitor.prototype._translateMessage=function(el,message){if(message&&this._mode===_VisitorMode.Merge){var nodes=this._translations.get(message);if(nodes)return nodes;this._reportError(el,'Translation unavailable for message id="'+this._translations.digest(message)+'"')}return[]},_Visitor.prototype._translateAttributes=function(el){var _this=this,attributes=el.attrs,i18nParsedMessageMeta={};attributes.forEach(function(attr){attr.name.startsWith("i18n-")&&(i18nParsedMessageMeta[attr.name.slice("i18n-".length)]=_parseMessageMeta(attr.value))});var translatedAttributes=[];return attributes.forEach(function(attr){if(attr.name!==_I18N_ATTR&&!attr.name.startsWith("i18n-"))if(attr.value&&""!=attr.value&&i18nParsedMessageMeta.hasOwnProperty(attr.name)){var _a=i18nParsedMessageMeta[attr.name],meaning=_a.meaning,description=_a.description,id=_a.id,message=_this._createI18nMessage([attr],meaning,description,id),nodes=_this._translations.get(message);if(nodes)if(0==nodes.length)translatedAttributes.push(new Attribute$1(attr.name,"",attr.sourceSpan));else if(nodes[0]instanceof Text){var value=nodes[0].value;translatedAttributes.push(new Attribute$1(attr.name,value,attr.sourceSpan))}else _this._reportError(el,'Unexpected translation for attribute "'+attr.name+'" (id="'+(id||_this._translations.digest(message))+'")');else _this._reportError(el,'Translation unavailable for attribute "'+attr.name+'" (id="'+(id||_this._translations.digest(message))+'")')}else translatedAttributes.push(attr)}),translatedAttributes},_Visitor.prototype._mayBeAddBlockChildren=function(node){this._inI18nBlock&&!this._inIcu&&this._depth==this._blockStartDepth&&this._blockChildren.push(node)},_Visitor.prototype._openTranslatableSection=function(node){this._isInTranslatableSection?this._reportError(node,"Unexpected section start"):this._msgCountAtSectionStart=this._messages.length},Object.defineProperty(_Visitor.prototype,"_isInTranslatableSection",{get:function(){return void 0!==this._msgCountAtSectionStart},enumerable:!0,configurable:!0}),_Visitor.prototype._closeTranslatableSection=function(node,directChildren){if(!this._isInTranslatableSection)return void this._reportError(node,"Unexpected section end");var startIndex=this._msgCountAtSectionStart;if(1==directChildren.reduce(function(count,node){return count+(node instanceof Comment?0:1)},0))for(var i=this._messages.length-1;i>=startIndex;i--){var ast=this._messages[i].nodes;if(!(1==ast.length&&ast[0]instanceof Text$1)){this._messages.splice(i,1);break}}this._msgCountAtSectionStart=void 0},_Visitor.prototype._reportError=function(node,msg){this._errors.push(new I18nError(node.sourceSpan,msg))},_Visitor}(),XmlTagDefinition=function(){function XmlTagDefinition(){this.closedByParent=!1,this.contentType=TagContentType.PARSABLE_DATA,this.isVoid=!1,this.ignoreFirstLf=!1,this.canSelfClose=!0}return XmlTagDefinition.prototype.requireExtraParent=function(currentParent){return!1},XmlTagDefinition.prototype.isClosedByChild=function(name){return!1},XmlTagDefinition}(),_TAG_DEFINITION=new XmlTagDefinition,XmlParser=function(_super){function XmlParser(){return _super.call(this,getXmlTagDefinition)||this}return __extends(XmlParser,_super),XmlParser.prototype.parse=function(source,url,parseExpansionForms){return void 0===parseExpansionForms&&(parseExpansionForms=!1),_super.prototype.parse.call(this,source,url,parseExpansionForms)},XmlParser}(Parser$1),Serializer=function(){function Serializer(){}return Serializer.prototype.createNameMapper=function(message){return null},Serializer}(),SimplePlaceholderMapper=function(_super){function SimplePlaceholderMapper(message,mapName){var _this=_super.call(this)||this;return _this.mapName=mapName,_this.internalToPublic={},_this.publicToNextId={},_this.publicToInternal={},message.nodes.forEach(function(node){return node.visit(_this)}),_this}return __extends(SimplePlaceholderMapper,_super),SimplePlaceholderMapper.prototype.toPublicName=function(internalName){return this.internalToPublic.hasOwnProperty(internalName)?this.internalToPublic[internalName]:null},SimplePlaceholderMapper.prototype.toInternalName=function(publicName){return this.publicToInternal.hasOwnProperty(publicName)?this.publicToInternal[publicName]:null},SimplePlaceholderMapper.prototype.visitText=function(text,context){return null},SimplePlaceholderMapper.prototype.visitTagPlaceholder=function(ph,context){this.visitPlaceholderName(ph.startName),_super.prototype.visitTagPlaceholder.call(this,ph,context),this.visitPlaceholderName(ph.closeName)},SimplePlaceholderMapper.prototype.visitPlaceholder=function(ph,context){this.visitPlaceholderName(ph.name)},SimplePlaceholderMapper.prototype.visitIcuPlaceholder=function(ph,context){this.visitPlaceholderName(ph.name)},SimplePlaceholderMapper.prototype.visitPlaceholderName=function(internalName){if(internalName&&!this.internalToPublic.hasOwnProperty(internalName)){var publicName=this.mapName(internalName);if(this.publicToInternal.hasOwnProperty(publicName)){var nextId=this.publicToNextId[publicName];this.publicToNextId[publicName]=nextId+1,publicName=publicName+"_"+nextId}else this.publicToNextId[publicName]=1;this.internalToPublic[internalName]=publicName,this.publicToInternal[publicName]=internalName}},SimplePlaceholderMapper}(RecurseVisitor),_Visitor$1=function(){function _Visitor(){}return _Visitor.prototype.visitTag=function(tag){var _this=this,strAttrs=this._serializeAttributes(tag.attrs);if(0==tag.children.length)return"<"+tag.name+strAttrs+"/>";var strChildren=tag.children.map(function(node){return node.visit(_this)});return"<"+tag.name+strAttrs+">"+strChildren.join("")+"</"+tag.name+">"},_Visitor.prototype.visitText=function(text){return text.value},_Visitor.prototype.visitDeclaration=function(decl){return"<?xml"+this._serializeAttributes(decl.attrs)+" ?>"},_Visitor.prototype._serializeAttributes=function(attrs){var strAttrs=Object.keys(attrs).map(function(name){return name+'="'+attrs[name]+'"'}).join(" ");return strAttrs.length>0?" "+strAttrs:""},_Visitor.prototype.visitDoctype=function(doctype){return"<!DOCTYPE "+doctype.rootTag+" [\n"+doctype.dtd+"\n]>"},_Visitor}(),_visitor=new _Visitor$1,Declaration=function(){function Declaration(unescapedAttrs){var _this=this;this.attrs={},Object.keys(unescapedAttrs).forEach(function(k){_this.attrs[k]=escapeXml(unescapedAttrs[k])})}return Declaration.prototype.visit=function(visitor){return visitor.visitDeclaration(this)},Declaration}(),Doctype=function(){function Doctype(rootTag,dtd){this.rootTag=rootTag,this.dtd=dtd}return Doctype.prototype.visit=function(visitor){return visitor.visitDoctype(this)},Doctype}(),Tag=function(){function Tag(name,unescapedAttrs,children){void 0===unescapedAttrs&&(unescapedAttrs={}),void 0===children&&(children=[]);var _this=this;this.name=name,this.children=children,this.attrs={},Object.keys(unescapedAttrs).forEach(function(k){_this.attrs[k]=escapeXml(unescapedAttrs[k])})}return Tag.prototype.visit=function(visitor){return visitor.visitTag(this)},Tag}(),Text$2=function(){function Text(unescapedValue){this.value=escapeXml(unescapedValue)}return Text.prototype.visit=function(visitor){return visitor.visitText(this)},Text}(),CR=function(_super){function CR(ws){return void 0===ws&&(ws=0),_super.call(this,"\n"+new Array(ws+1).join(" "))||this}return __extends(CR,_super),CR}(Text$2),_ESCAPED_CHARS=[[/&/g,"&amp;"],[/"/g,"&quot;"],[/'/g,"&apos;"],[/</g,"&lt;"],[/>/g,"&gt;"]],Xliff=function(_super){function Xliff(){return null!==_super&&_super.apply(this,arguments)||this}return __extends(Xliff,_super),Xliff.prototype.write=function(messages,locale){var visitor=new _WriteVisitor,transUnits=[];messages.forEach(function(message){var contextTags=[];message.sources.forEach(function(source){var contextGroupTag=new Tag("context-group",{purpose:"location"});contextGroupTag.children.push(new CR(10),new Tag("context",{"context-type":"sourcefile"},[new Text$2(source.filePath)]),new CR(10),new Tag("context",{"context-type":"linenumber"},[new Text$2(""+source.startLine)]),new CR(8)),contextTags.push(new CR(8),contextGroupTag)});var transUnit=new Tag("trans-unit",{id:message.id,datatype:"html"});(_a=transUnit.children).push.apply(_a,[new CR(8),new Tag("source",{},visitor.serialize(message.nodes))].concat(contextTags)),message.description&&transUnit.children.push(new CR(8),new Tag("note",{priority:"1",from:"description"},[new Text$2(message.description)])),message.meaning&&transUnit.children.push(new CR(8),new Tag("note",{priority:"1",from:"meaning"},[new Text$2(message.meaning)])),transUnit.children.push(new CR(6)),transUnits.push(new CR(6),transUnit);var _a});var body=new Tag("body",{},transUnits.concat([new CR(4)])),file=new Tag("file",{"source-language":locale||"en",datatype:"plaintext",original:"ng2.template"},[new CR(4),body,new CR(2)]),xliff=new Tag("xliff",{version:"1.2",xmlns:"urn:oasis:names:tc:xliff:document:1.2"},[new CR(2),file,new CR]);return serialize([new Declaration({version:"1.0",encoding:"UTF-8"}),new CR,xliff,new CR])},Xliff.prototype.load=function(content,url){var xliffParser=new XliffParser,_a=xliffParser.parse(content,url),locale=_a.locale,msgIdToHtml=_a.msgIdToHtml,errors=_a.errors,i18nNodesByMsgId={},converter=new XmlToI18n;if(Object.keys(msgIdToHtml).forEach(function(msgId){var _a=converter.convert(msgIdToHtml[msgId],url),i18nNodes=_a.i18nNodes,e=_a.errors;errors.push.apply(errors,e),i18nNodesByMsgId[msgId]=i18nNodes}),errors.length)throw new Error("xliff parse errors:\n"+errors.join("\n"));return{locale:locale,i18nNodesByMsgId:i18nNodesByMsgId}},Xliff.prototype.digest=function(message){return digest(message)},Xliff}(Serializer),_WriteVisitor=function(){function _WriteVisitor(){}return _WriteVisitor.prototype.visitText=function(text,context){return[new Text$2(text.value)]},_WriteVisitor.prototype.visitContainer=function(container,context){var _this=this,nodes=[];return container.children.forEach(function(node){return nodes.push.apply(nodes,node.visit(_this))}),nodes},_WriteVisitor.prototype.visitIcu=function(icu,context){var _this=this,nodes=[new Text$2("{"+icu.expressionPlaceholder+", "+icu.type+", ")];return Object.keys(icu.cases).forEach(function(c){nodes.push.apply(nodes,[new Text$2(c+" {")].concat(icu.cases[c].visit(_this),[new Text$2("} ")]))}),nodes.push(new Text$2("}")),nodes},_WriteVisitor.prototype.visitTagPlaceholder=function(ph,context){var ctype=getCtypeForTag(ph.tag);if(ph.isVoid)return[new Tag("x",{id:ph.startName,ctype:ctype,"equiv-text":"<"+ph.tag+"/>"})];var startTagPh=new Tag("x",{id:ph.startName,ctype:ctype,"equiv-text":"<"+ph.tag+">"}),closeTagPh=new Tag("x",{id:ph.closeName,ctype:ctype,"equiv-text":"</"+ph.tag+">"});return[startTagPh].concat(this.serialize(ph.children),[closeTagPh])},_WriteVisitor.prototype.visitPlaceholder=function(ph,context){return[new Tag("x",{id:ph.name,"equiv-text":"{{"+ph.value+"}}"})]},_WriteVisitor.prototype.visitIcuPlaceholder=function(ph,context){var equivText="{"+ph.value.expression+", "+ph.value.type+", "+Object.keys(ph.value.cases).map(function(value){return value+" {...}"}).join(" ")+"}";return[new Tag("x",{id:ph.name,"equiv-text":equivText})]},_WriteVisitor.prototype.serialize=function(nodes){var _this=this
;return[].concat.apply([],nodes.map(function(node){return node.visit(_this)}))},_WriteVisitor}(),XliffParser=function(){function XliffParser(){this._locale=null}return XliffParser.prototype.parse=function(xliff,url){this._unitMlString=null,this._msgIdToHtml={};var xml=(new XmlParser).parse(xliff,url,!1);return this._errors=xml.errors,visitAll(this,xml.rootNodes,null),{msgIdToHtml:this._msgIdToHtml,errors:this._errors,locale:this._locale}},XliffParser.prototype.visitElement=function(element,context){switch(element.name){case"trans-unit":this._unitMlString=null;var idAttr=element.attrs.find(function(attr){return"id"===attr.name});if(idAttr){var id=idAttr.value;this._msgIdToHtml.hasOwnProperty(id)?this._addError(element,"Duplicated translations for msg "+id):(visitAll(this,element.children,null),"string"==typeof this._unitMlString?this._msgIdToHtml[id]=this._unitMlString:this._addError(element,"Message "+id+" misses a translation"))}else this._addError(element,'<trans-unit> misses the "id" attribute');break;case"source":case"seg-source":break;case"target":var innerTextStart=element.startSourceSpan.end.offset,innerTextEnd=element.endSourceSpan.start.offset,content=element.startSourceSpan.start.file.content,innerText=content.slice(innerTextStart,innerTextEnd);this._unitMlString=innerText;break;case"file":var localeAttr=element.attrs.find(function(attr){return"target-language"===attr.name});localeAttr&&(this._locale=localeAttr.value),visitAll(this,element.children,null);break;default:visitAll(this,element.children,null)}},XliffParser.prototype.visitAttribute=function(attribute,context){},XliffParser.prototype.visitText=function(text,context){},XliffParser.prototype.visitComment=function(comment,context){},XliffParser.prototype.visitExpansion=function(expansion,context){},XliffParser.prototype.visitExpansionCase=function(expansionCase,context){},XliffParser.prototype._addError=function(node,message){this._errors.push(new I18nError(node.sourceSpan,message))},XliffParser}(),XmlToI18n=function(){function XmlToI18n(){}return XmlToI18n.prototype.convert=function(message,url){var xmlIcu=(new XmlParser).parse(message,url,!0);return this._errors=xmlIcu.errors,{i18nNodes:this._errors.length>0||0==xmlIcu.rootNodes.length?[]:[].concat.apply([],visitAll(this,xmlIcu.rootNodes)),errors:this._errors}},XmlToI18n.prototype.visitText=function(text,context){return new Text$1(text.value,text.sourceSpan)},XmlToI18n.prototype.visitElement=function(el,context){if("x"===el.name){var nameAttr=el.attrs.find(function(attr){return"id"===attr.name});return nameAttr?new Placeholder("",nameAttr.value,el.sourceSpan):(this._addError(el,'<x> misses the "id" attribute'),null)}return"mrk"===el.name?[].concat.apply([],visitAll(this,el.children)):(this._addError(el,"Unexpected tag"),null)},XmlToI18n.prototype.visitExpansion=function(icu,context){var caseMap={};return visitAll(this,icu.cases).forEach(function(c){caseMap[c.value]=new Container(c.nodes,icu.sourceSpan)}),new Icu(icu.switchValue,icu.type,caseMap,icu.sourceSpan)},XmlToI18n.prototype.visitExpansionCase=function(icuCase,context){return{value:icuCase.value,nodes:visitAll(this,icuCase.expression)}},XmlToI18n.prototype.visitComment=function(comment,context){},XmlToI18n.prototype.visitAttribute=function(attribute,context){},XmlToI18n.prototype._addError=function(node,message){this._errors.push(new I18nError(node.sourceSpan,message))},XmlToI18n}(),Xliff2=function(_super){function Xliff2(){return null!==_super&&_super.apply(this,arguments)||this}return __extends(Xliff2,_super),Xliff2.prototype.write=function(messages,locale){var visitor=new _WriteVisitor$1,units=[];messages.forEach(function(message){var unit=new Tag("unit",{id:message.id}),notes=new Tag("notes");(message.description||message.meaning)&&(message.description&&notes.children.push(new CR(8),new Tag("note",{category:"description"},[new Text$2(message.description)])),message.meaning&&notes.children.push(new CR(8),new Tag("note",{category:"meaning"},[new Text$2(message.meaning)]))),message.sources.forEach(function(source){notes.children.push(new CR(8),new Tag("note",{category:"location"},[new Text$2(source.filePath+":"+source.startLine+(source.endLine!==source.startLine?","+source.endLine:""))]))}),notes.children.push(new CR(6)),unit.children.push(new CR(6),notes);var segment=new Tag("segment");segment.children.push(new CR(8),new Tag("source",{},visitor.serialize(message.nodes)),new CR(6)),unit.children.push(new CR(6),segment,new CR(4)),units.push(new CR(4),unit)});var file=new Tag("file",{original:"ng.template",id:"ngi18n"},units.concat([new CR(2)])),xliff=new Tag("xliff",{version:"2.0",xmlns:"urn:oasis:names:tc:xliff:document:2.0",srcLang:locale||"en"},[new CR(2),file,new CR]);return serialize([new Declaration({version:"1.0",encoding:"UTF-8"}),new CR,xliff,new CR])},Xliff2.prototype.load=function(content,url){var xliff2Parser=new Xliff2Parser,_a=xliff2Parser.parse(content,url),locale=_a.locale,msgIdToHtml=_a.msgIdToHtml,errors=_a.errors,i18nNodesByMsgId={},converter=new XmlToI18n$1;if(Object.keys(msgIdToHtml).forEach(function(msgId){var _a=converter.convert(msgIdToHtml[msgId],url),i18nNodes=_a.i18nNodes,e=_a.errors;errors.push.apply(errors,e),i18nNodesByMsgId[msgId]=i18nNodes}),errors.length)throw new Error("xliff2 parse errors:\n"+errors.join("\n"));return{locale:locale,i18nNodesByMsgId:i18nNodesByMsgId}},Xliff2.prototype.digest=function(message){return decimalDigest(message)},Xliff2}(Serializer),_WriteVisitor$1=function(){function _WriteVisitor(){}return _WriteVisitor.prototype.visitText=function(text,context){return[new Text$2(text.value)]},_WriteVisitor.prototype.visitContainer=function(container,context){var _this=this,nodes=[];return container.children.forEach(function(node){return nodes.push.apply(nodes,node.visit(_this))}),nodes},_WriteVisitor.prototype.visitIcu=function(icu,context){var _this=this,nodes=[new Text$2("{"+icu.expressionPlaceholder+", "+icu.type+", ")];return Object.keys(icu.cases).forEach(function(c){nodes.push.apply(nodes,[new Text$2(c+" {")].concat(icu.cases[c].visit(_this),[new Text$2("} ")]))}),nodes.push(new Text$2("}")),nodes},_WriteVisitor.prototype.visitTagPlaceholder=function(ph,context){var _this=this,type=getTypeForTag(ph.tag);if(ph.isVoid){return[new Tag("ph",{id:(this._nextPlaceholderId++).toString(),equiv:ph.startName,type:type,disp:"<"+ph.tag+"/>"})]}var tagPc=new Tag("pc",{id:(this._nextPlaceholderId++).toString(),equivStart:ph.startName,equivEnd:ph.closeName,type:type,dispStart:"<"+ph.tag+">",dispEnd:"</"+ph.tag+">"}),nodes=[].concat.apply([],ph.children.map(function(node){return node.visit(_this)}));return nodes.length?nodes.forEach(function(node){return tagPc.children.push(node)}):tagPc.children.push(new Text$2("")),[tagPc]},_WriteVisitor.prototype.visitPlaceholder=function(ph,context){var idStr=(this._nextPlaceholderId++).toString();return[new Tag("ph",{id:idStr,equiv:ph.name,disp:"{{"+ph.value+"}}"})]},_WriteVisitor.prototype.visitIcuPlaceholder=function(ph,context){var cases=Object.keys(ph.value.cases).map(function(value){return value+" {...}"}).join(" "),idStr=(this._nextPlaceholderId++).toString();return[new Tag("ph",{id:idStr,equiv:ph.name,disp:"{"+ph.value.expression+", "+ph.value.type+", "+cases+"}"})]},_WriteVisitor.prototype.serialize=function(nodes){var _this=this;return this._nextPlaceholderId=0,[].concat.apply([],nodes.map(function(node){return node.visit(_this)}))},_WriteVisitor}(),Xliff2Parser=function(){function Xliff2Parser(){this._locale=null}return Xliff2Parser.prototype.parse=function(xliff,url){this._unitMlString=null,this._msgIdToHtml={};var xml=(new XmlParser).parse(xliff,url,!1);return this._errors=xml.errors,visitAll(this,xml.rootNodes,null),{msgIdToHtml:this._msgIdToHtml,errors:this._errors,locale:this._locale}},Xliff2Parser.prototype.visitElement=function(element,context){switch(element.name){case"unit":this._unitMlString=null;var idAttr=element.attrs.find(function(attr){return"id"===attr.name});if(idAttr){var id=idAttr.value;this._msgIdToHtml.hasOwnProperty(id)?this._addError(element,"Duplicated translations for msg "+id):(visitAll(this,element.children,null),"string"==typeof this._unitMlString?this._msgIdToHtml[id]=this._unitMlString:this._addError(element,"Message "+id+" misses a translation"))}else this._addError(element,'<unit> misses the "id" attribute');break;case"source":break;case"target":var innerTextStart=element.startSourceSpan.end.offset,innerTextEnd=element.endSourceSpan.start.offset,content=element.startSourceSpan.start.file.content,innerText=content.slice(innerTextStart,innerTextEnd);this._unitMlString=innerText;break;case"xliff":var localeAttr=element.attrs.find(function(attr){return"trgLang"===attr.name});localeAttr&&(this._locale=localeAttr.value);var versionAttr=element.attrs.find(function(attr){return"version"===attr.name});if(versionAttr){var version=versionAttr.value;"2.0"!==version?this._addError(element,"The XLIFF file version "+version+" is not compatible with XLIFF 2.0 serializer"):visitAll(this,element.children,null)}break;default:visitAll(this,element.children,null)}},Xliff2Parser.prototype.visitAttribute=function(attribute,context){},Xliff2Parser.prototype.visitText=function(text,context){},Xliff2Parser.prototype.visitComment=function(comment,context){},Xliff2Parser.prototype.visitExpansion=function(expansion,context){},Xliff2Parser.prototype.visitExpansionCase=function(expansionCase,context){},Xliff2Parser.prototype._addError=function(node,message){this._errors.push(new I18nError(node.sourceSpan,message))},Xliff2Parser}(),XmlToI18n$1=function(){function XmlToI18n(){}return XmlToI18n.prototype.convert=function(message,url){var xmlIcu=(new XmlParser).parse(message,url,!0);return this._errors=xmlIcu.errors,{i18nNodes:this._errors.length>0||0==xmlIcu.rootNodes.length?[]:[].concat.apply([],visitAll(this,xmlIcu.rootNodes)),errors:this._errors}},XmlToI18n.prototype.visitText=function(text,context){return new Text$1(text.value,text.sourceSpan)},XmlToI18n.prototype.visitElement=function(el,context){var _this=this;switch(el.name){case"ph":var nameAttr=el.attrs.find(function(attr){return"equiv"===attr.name});if(nameAttr)return[new Placeholder("",nameAttr.value,el.sourceSpan)];this._addError(el,'<ph> misses the "equiv" attribute');break;case"pc":var startAttr=el.attrs.find(function(attr){return"equivStart"===attr.name}),endAttr=el.attrs.find(function(attr){return"equivEnd"===attr.name});if(startAttr){if(endAttr){var startId=startAttr.value,endId=endAttr.value,nodes=[];return nodes.concat.apply(nodes,[new Placeholder("",startId,el.sourceSpan)].concat(el.children.map(function(node){return node.visit(_this,null)}),[new Placeholder("",endId,el.sourceSpan)]))}this._addError(el,'<ph> misses the "equivEnd" attribute')}else this._addError(el,'<ph> misses the "equivStart" attribute');break;case"mrk":return[].concat.apply([],visitAll(this,el.children));default:this._addError(el,"Unexpected tag")}return null},XmlToI18n.prototype.visitExpansion=function(icu,context){var caseMap={};return visitAll(this,icu.cases).forEach(function(c){caseMap[c.value]=new Container(c.nodes,icu.sourceSpan)}),new Icu(icu.switchValue,icu.type,caseMap,icu.sourceSpan)},XmlToI18n.prototype.visitExpansionCase=function(icuCase,context){return{value:icuCase.value,nodes:[].concat.apply([],visitAll(this,icuCase.expression))}},XmlToI18n.prototype.visitComment=function(comment,context){},XmlToI18n.prototype.visitAttribute=function(attribute,context){},XmlToI18n.prototype._addError=function(node,message){this._errors.push(new I18nError(node.sourceSpan,message))},XmlToI18n}(),Xmb=function(_super){function Xmb(){return null!==_super&&_super.apply(this,arguments)||this}return __extends(Xmb,_super),Xmb.prototype.write=function(messages,locale){var exampleVisitor=new ExampleVisitor,visitor=new _Visitor$2,rootNode=new Tag("messagebundle");return messages.forEach(function(message){var attrs={id:message.id};message.description&&(attrs.desc=message.description),message.meaning&&(attrs.meaning=message.meaning);var sourceTags=[];message.sources.forEach(function(source){sourceTags.push(new Tag("source",{},[new Text$2(source.filePath+":"+source.startLine+(source.endLine!==source.startLine?","+source.endLine:""))]))}),rootNode.children.push(new CR(2),new Tag("msg",attrs,sourceTags.concat(visitor.serialize(message.nodes))))}),rootNode.children.push(new CR),serialize([new Declaration({version:"1.0",encoding:"UTF-8"}),new CR,new Doctype("messagebundle",'<!ELEMENT messagebundle (msg)*>\n<!ATTLIST messagebundle class CDATA #IMPLIED>\n\n<!ELEMENT msg (#PCDATA|ph|source)*>\n<!ATTLIST msg id CDATA #IMPLIED>\n<!ATTLIST msg seq CDATA #IMPLIED>\n<!ATTLIST msg name CDATA #IMPLIED>\n<!ATTLIST msg desc CDATA #IMPLIED>\n<!ATTLIST msg meaning CDATA #IMPLIED>\n<!ATTLIST msg obsolete (obsolete) #IMPLIED>\n<!ATTLIST msg xml:space (default|preserve) "default">\n<!ATTLIST msg is_hidden CDATA #IMPLIED>\n\n<!ELEMENT source (#PCDATA)>\n\n<!ELEMENT ph (#PCDATA|ex)*>\n<!ATTLIST ph name CDATA #REQUIRED>\n\n<!ELEMENT ex (#PCDATA)>'),new CR,exampleVisitor.addDefaultExamples(rootNode),new CR])},Xmb.prototype.load=function(content,url){throw new Error("Unsupported")},Xmb.prototype.digest=function(message){return digest$1(message)},Xmb.prototype.createNameMapper=function(message){return new SimplePlaceholderMapper(message,toPublicName)},Xmb}(Serializer),_Visitor$2=function(){function _Visitor(){}return _Visitor.prototype.visitText=function(text,context){return[new Text$2(text.value)]},_Visitor.prototype.visitContainer=function(container,context){var _this=this,nodes=[];return container.children.forEach(function(node){return nodes.push.apply(nodes,node.visit(_this))}),nodes},_Visitor.prototype.visitIcu=function(icu,context){var _this=this,nodes=[new Text$2("{"+icu.expressionPlaceholder+", "+icu.type+", ")];return Object.keys(icu.cases).forEach(function(c){nodes.push.apply(nodes,[new Text$2(c+" {")].concat(icu.cases[c].visit(_this),[new Text$2("} ")]))}),nodes.push(new Text$2("}")),nodes},_Visitor.prototype.visitTagPlaceholder=function(ph,context){var startEx=new Tag("ex",{},[new Text$2("<"+ph.tag+">")]),startTagPh=new Tag("ph",{name:ph.startName},[startEx]);if(ph.isVoid)return[startTagPh];var closeEx=new Tag("ex",{},[new Text$2("</"+ph.tag+">")]),closeTagPh=new Tag("ph",{name:ph.closeName},[closeEx]);return[startTagPh].concat(this.serialize(ph.children),[closeTagPh])},_Visitor.prototype.visitPlaceholder=function(ph,context){var exTag=new Tag("ex",{},[new Text$2("{{"+ph.value+"}}")]);return[new Tag("ph",{name:ph.name},[exTag])]},_Visitor.prototype.visitIcuPlaceholder=function(ph,context){var exTag=new Tag("ex",{},[new Text$2("{"+ph.value.expression+", "+ph.value.type+", "+Object.keys(ph.value.cases).map(function(value){return value+" {...}"}).join(" ")+"}")]);return[new Tag("ph",{name:ph.name},[exTag])]},_Visitor.prototype.serialize=function(nodes){var _this=this;return[].concat.apply([],nodes.map(function(node){return node.visit(_this)}))},_Visitor}(),ExampleVisitor=function(){function ExampleVisitor(){}return ExampleVisitor.prototype.addDefaultExamples=function(node){return node.visit(this),node},ExampleVisitor.prototype.visitTag=function(tag){var _this=this;if("ph"===tag.name){if(!tag.children||0==tag.children.length){var exText=new Text$2(tag.attrs.name||"...");tag.children=[new Tag("ex",{},[exText])]}}else tag.children&&tag.children.forEach(function(node){return node.visit(_this)})},ExampleVisitor.prototype.visitText=function(text){},ExampleVisitor.prototype.visitDeclaration=function(decl){},ExampleVisitor.prototype.visitDoctype=function(doctype){},ExampleVisitor}(),Xtb=function(_super){function Xtb(){return null!==_super&&_super.apply(this,arguments)||this}return __extends(Xtb,_super),Xtb.prototype.write=function(messages,locale){throw new Error("Unsupported")},Xtb.prototype.load=function(content,url){var xtbParser=new XtbParser,_a=xtbParser.parse(content,url),locale=_a.locale,msgIdToHtml=_a.msgIdToHtml,errors=_a.errors,i18nNodesByMsgId={},converter=new XmlToI18n$2;if(Object.keys(msgIdToHtml).forEach(function(msgId){createLazyProperty(i18nNodesByMsgId,msgId,function(){var _a=converter.convert(msgIdToHtml[msgId],url),i18nNodes=_a.i18nNodes,errors=_a.errors;if(errors.length)throw new Error("xtb parse errors:\n"+errors.join("\n"));return i18nNodes})}),errors.length)throw new Error("xtb parse errors:\n"+errors.join("\n"));return{locale:locale,i18nNodesByMsgId:i18nNodesByMsgId}},Xtb.prototype.digest=function(message){return digest$1(message)},Xtb.prototype.createNameMapper=function(message){return new SimplePlaceholderMapper(message,toPublicName)},Xtb}(Serializer),XtbParser=function(){function XtbParser(){this._locale=null}return XtbParser.prototype.parse=function(xtb,url){this._bundleDepth=0,this._msgIdToHtml={};var xml=(new XmlParser).parse(xtb,url,!1);return this._errors=xml.errors,visitAll(this,xml.rootNodes),{msgIdToHtml:this._msgIdToHtml,errors:this._errors,locale:this._locale}},XtbParser.prototype.visitElement=function(element,context){switch(element.name){case"translationbundle":this._bundleDepth++,this._bundleDepth>1&&this._addError(element,"<translationbundle> elements can not be nested");var langAttr=element.attrs.find(function(attr){return"lang"===attr.name});langAttr&&(this._locale=langAttr.value),visitAll(this,element.children,null),this._bundleDepth--;break;case"translation":var idAttr=element.attrs.find(function(attr){return"id"===attr.name});if(idAttr){var id=idAttr.value;if(this._msgIdToHtml.hasOwnProperty(id))this._addError(element,"Duplicated translations for msg "+id);else{var innerTextStart=element.startSourceSpan.end.offset,innerTextEnd=element.endSourceSpan.start.offset,content=element.startSourceSpan.start.file.content,innerText=content.slice(innerTextStart,innerTextEnd);this._msgIdToHtml[id]=innerText}}else this._addError(element,'<translation> misses the "id" attribute');break;default:this._addError(element,"Unexpected tag")}},XtbParser.prototype.visitAttribute=function(attribute,context){},XtbParser.prototype.visitText=function(text,context){},XtbParser.prototype.visitComment=function(comment,context){},XtbParser.prototype.visitExpansion=function(expansion,context){},XtbParser.prototype.visitExpansionCase=function(expansionCase,context){},XtbParser.prototype._addError=function(node,message){this._errors.push(new I18nError(node.sourceSpan,message))},XtbParser}(),XmlToI18n$2=function(){function XmlToI18n(){}return XmlToI18n.prototype.convert=function(message,url){var xmlIcu=(new XmlParser).parse(message,url,!0);return this._errors=xmlIcu.errors,{i18nNodes:this._errors.length>0||0==xmlIcu.rootNodes.length?[]:visitAll(this,xmlIcu.rootNodes),errors:this._errors}},XmlToI18n.prototype.visitText=function(text,context){return new Text$1(text.value,text.sourceSpan)},XmlToI18n.prototype.visitExpansion=function(icu,context){var caseMap={};return visitAll(this,icu.cases).forEach(function(c){caseMap[c.value]=new Container(c.nodes,icu.sourceSpan)}),new Icu(icu.switchValue,icu.type,caseMap,icu.sourceSpan)},XmlToI18n.prototype.visitExpansionCase=function(icuCase,context){return{value:icuCase.value,nodes:visitAll(this,icuCase.expression)}},XmlToI18n.prototype.visitElement=function(el,context){if("ph"===el.name){var nameAttr=el.attrs.find(function(attr){return"name"===attr.name});if(nameAttr)return new Placeholder("",nameAttr.value,el.sourceSpan);this._addError(el,'<ph> misses the "name" attribute')}else this._addError(el,"Unexpected tag");return null},XmlToI18n.prototype.visitComment=function(comment,context){},XmlToI18n.prototype.visitAttribute=function(attribute,context){},XmlToI18n.prototype._addError=function(node,message){this._errors.push(new I18nError(node.sourceSpan,message))},XmlToI18n}(),HtmlParser=function(_super){function HtmlParser(){return _super.call(this,getHtmlTagDefinition)||this}return __extends(HtmlParser,_super),HtmlParser.prototype.parse=function(source,url,parseExpansionForms,interpolationConfig){return void 0===parseExpansionForms&&(parseExpansionForms=!1),void 0===interpolationConfig&&(interpolationConfig=DEFAULT_INTERPOLATION_CONFIG),_super.prototype.parse.call(this,source,url,parseExpansionForms,interpolationConfig)},HtmlParser}(Parser$1),TranslationBundle=function(){function TranslationBundle(_i18nNodesByMsgId,locale,digest,mapperFactory,missingTranslationStrategy,console){void 0===_i18nNodesByMsgId&&(_i18nNodesByMsgId={}),void 0===missingTranslationStrategy&&(missingTranslationStrategy=MissingTranslationStrategy.Warning),this._i18nNodesByMsgId=_i18nNodesByMsgId,this.digest=digest,this.mapperFactory=mapperFactory,this._i18nToHtml=new I18nToHtmlVisitor(_i18nNodesByMsgId,locale,digest,mapperFactory,missingTranslationStrategy,console)}return TranslationBundle.load=function(content,url,serializer,missingTranslationStrategy,console){var _a=serializer.load(content,url),locale=_a.locale;return new TranslationBundle(_a.i18nNodesByMsgId,locale,function(m){return serializer.digest(m)},function(m){return serializer.createNameMapper(m)},missingTranslationStrategy,console)},TranslationBundle.prototype.get=function(srcMsg){var html=this._i18nToHtml.convert(srcMsg);if(html.errors.length)throw new Error(html.errors.join("\n"));return html.nodes},TranslationBundle.prototype.has=function(srcMsg){return this.digest(srcMsg)in this._i18nNodesByMsgId},TranslationBundle}(),I18nToHtmlVisitor=function(){function I18nToHtmlVisitor(_i18nNodesByMsgId,_locale,_digest,_mapperFactory,_missingTranslationStrategy,_console){void 0===_i18nNodesByMsgId&&(_i18nNodesByMsgId={}),this._i18nNodesByMsgId=_i18nNodesByMsgId,this._locale=_locale,this._digest=_digest,this._mapperFactory=_mapperFactory,this._missingTranslationStrategy=_missingTranslationStrategy,this._console=_console,this._contextStack=[],this._errors=[]}return I18nToHtmlVisitor.prototype.convert=function(srcMsg){this._contextStack.length=0,this._errors.length=0;var text=this._convertToText(srcMsg),url=srcMsg.nodes[0].sourceSpan.start.file.url,html=(new HtmlParser).parse(text,url,!0);return{nodes:html.rootNodes,errors:this._errors.concat(html.errors)}},I18nToHtmlVisitor.prototype.visitText=function(text,context){return escapeXml(text.value)},I18nToHtmlVisitor.prototype.visitContainer=function(container,context){var _this=this;return container.children.map(function(n){return n.visit(_this)}).join("")},I18nToHtmlVisitor.prototype.visitIcu=function(icu,context){var _this=this,cases=Object.keys(icu.cases).map(function(k){return k+" {"+icu.cases[k].visit(_this)+"}"});return"{"+(this._srcMsg.placeholders.hasOwnProperty(icu.expression)?this._srcMsg.placeholders[icu.expression]:icu.expression)+", "+icu.type+", "+cases.join(" ")+"}"},I18nToHtmlVisitor.prototype.visitPlaceholder=function(ph,context){var phName=this._mapper(ph.name);return this._srcMsg.placeholders.hasOwnProperty(phName)?this._srcMsg.placeholders[phName]:this._srcMsg.placeholderToMessage.hasOwnProperty(phName)?this._convertToText(this._srcMsg.placeholderToMessage[phName]):(this._addError(ph,'Unknown placeholder "'+ph.name+'"'),"")},I18nToHtmlVisitor.prototype.visitTagPlaceholder=function(ph,context){var _this=this,tag=""+ph.tag,attrs=Object.keys(ph.attrs).map(function(name){return name+'="'+ph.attrs[name]+'"'}).join(" ");return ph.isVoid?"<"+tag+" "+attrs+"/>":"<"+tag+" "+attrs+">"+ph.children.map(function(c){return c.visit(_this)}).join("")+"</"+tag+">"},I18nToHtmlVisitor.prototype.visitIcuPlaceholder=function(ph,context){return this._convertToText(this._srcMsg.placeholderToMessage[ph.name])},I18nToHtmlVisitor.prototype._convertToText=function(srcMsg){var nodes,_this=this,id=this._digest(srcMsg),mapper=this._mapperFactory?this._mapperFactory(srcMsg):null;if(this._contextStack.push({msg:this._srcMsg,mapper:this._mapper}),this._srcMsg=srcMsg,this._i18nNodesByMsgId.hasOwnProperty(id))nodes=this._i18nNodesByMsgId[id],this._mapper=function(name){return mapper?mapper.toInternalName(name):name};else{if(this._missingTranslationStrategy===MissingTranslationStrategy.Error){var ctx=this._locale?' for locale "'+this._locale+'"':"";this._addError(srcMsg.nodes[0],'Missing translation for message "'+id+'"'+ctx)}else if(this._console&&this._missingTranslationStrategy===MissingTranslationStrategy.Warning){var ctx=this._locale?' for locale "'+this._locale+'"':"";this._console.warn('Missing translation for message "'+id+'"'+ctx)}nodes=srcMsg.nodes,this._mapper=function(name){return name}}var text=nodes.map(function(node){return node.visit(_this)}).join(""),context=this._contextStack.pop();return this._srcMsg=context.msg,this._mapper=context.mapper,text},I18nToHtmlVisitor.prototype._addError=function(el,msg){this._errors.push(new I18nError(el.sourceSpan,msg))},I18nToHtmlVisitor}(),I18NHtmlParser=function(){function I18NHtmlParser(_htmlParser,translations,translationsFormat,missingTranslation,console){if(void 0===missingTranslation&&(missingTranslation=MissingTranslationStrategy.Warning),this._htmlParser=_htmlParser,translations){var serializer=createSerializer(translationsFormat);this._translationBundle=TranslationBundle.load(translations,"i18n",serializer,missingTranslation,console)}else this._translationBundle=new TranslationBundle({},null,digest,void 0,missingTranslation,console)}return I18NHtmlParser.prototype.parse=function(source,url,parseExpansionForms,interpolationConfig){void 0===parseExpansionForms&&(parseExpansionForms=!1),void 0===interpolationConfig&&(interpolationConfig=DEFAULT_INTERPOLATION_CONFIG);var parseResult=this._htmlParser.parse(source,url,parseExpansionForms,interpolationConfig);return parseResult.errors.length?new ParseTreeResult(parseResult.rootNodes,parseResult.errors):mergeTranslations(parseResult.rootNodes,this._translationBundle,interpolationConfig,[],{})},I18NHtmlParser}(),STRIP_SRC_FILE_SUFFIXES=/(\.ts|\.d\.ts|\.js|\.jsx|\.tsx)$/,GENERATED_FILE=/\.ngfactory\.|\.ngsummary\./,JIT_SUMMARY_FILE=/\.ngsummary\./,JIT_SUMMARY_NAME=/NgSummary$/,LOWERED_SYMBOL=/\u0275\d+/,CORE="@angular/core",Identifiers=function(){function Identifiers(){}return Identifiers.ANALYZE_FOR_ENTRY_COMPONENTS={name:"ANALYZE_FOR_ENTRY_COMPONENTS",moduleName:CORE},Identifiers.ElementRef={name:"ElementRef",moduleName:CORE},Identifiers.NgModuleRef={name:"NgModuleRef",moduleName:CORE},Identifiers.ViewContainerRef={name:"ViewContainerRef",moduleName:CORE},Identifiers.ChangeDetectorRef={name:"ChangeDetectorRef",moduleName:CORE},Identifiers.QueryList={name:"QueryList",moduleName:CORE},Identifiers.TemplateRef={name:"TemplateRef",moduleName:CORE},Identifiers.CodegenComponentFactoryResolver={name:"ɵCodegenComponentFactoryResolver",moduleName:CORE},Identifiers.ComponentFactoryResolver={name:"ComponentFactoryResolver",moduleName:CORE},Identifiers.ComponentFactory={name:"ComponentFactory",moduleName:CORE},Identifiers.ComponentRef={name:"ComponentRef",moduleName:CORE},Identifiers.NgModuleFactory={name:"NgModuleFactory",moduleName:CORE},Identifiers.createModuleFactory={name:"ɵcmf",moduleName:CORE},Identifiers.moduleDef={name:"ɵmod",moduleName:CORE},Identifiers.moduleProviderDef={name:"ɵmpd",moduleName:CORE},Identifiers.RegisterModuleFactoryFn={name:"ɵregisterModuleFactory",moduleName:CORE},Identifiers.Injector={name:"Injector",moduleName:CORE},Identifiers.ViewEncapsulation={name:"ViewEncapsulation",moduleName:CORE},Identifiers.ChangeDetectionStrategy={name:"ChangeDetectionStrategy",moduleName:CORE},Identifiers.SecurityContext={name:"SecurityContext",moduleName:CORE},Identifiers.LOCALE_ID={name:"LOCALE_ID",moduleName:CORE},Identifiers.TRANSLATIONS_FORMAT={name:"TRANSLATIONS_FORMAT",moduleName:CORE},Identifiers.inlineInterpolate={name:"ɵinlineInterpolate",moduleName:CORE},Identifiers.interpolate={name:"ɵinterpolate",moduleName:CORE},Identifiers.EMPTY_ARRAY={name:"ɵEMPTY_ARRAY",moduleName:CORE},Identifiers.EMPTY_MAP={name:"ɵEMPTY_MAP",moduleName:CORE},Identifiers.Renderer={name:"Renderer",moduleName:CORE},Identifiers.viewDef={name:"ɵvid",moduleName:CORE},Identifiers.elementDef={name:"ɵeld",moduleName:CORE},Identifiers.anchorDef={name:"ɵand",moduleName:CORE},Identifiers.textDef={name:"ɵted",moduleName:CORE},Identifiers.directiveDef={name:"ɵdid",moduleName:CORE},Identifiers.providerDef={name:"ɵprd",moduleName:CORE},Identifiers.queryDef={name:"ɵqud",moduleName:CORE},Identifiers.pureArrayDef={name:"ɵpad",moduleName:CORE},Identifiers.pureObjectDef={name:"ɵpod",moduleName:CORE},Identifiers.purePipeDef={name:"ɵppd",moduleName:CORE},Identifiers.pipeDef={name:"ɵpid",moduleName:CORE},Identifiers.nodeValue={name:"ɵnov",moduleName:CORE},Identifiers.ngContentDef={name:"ɵncd",moduleName:CORE},Identifiers.unwrapValue={name:"ɵunv",moduleName:CORE},Identifiers.createRendererType2={name:"ɵcrt",moduleName:CORE},Identifiers.RendererType2={name:"RendererType2",moduleName:CORE},Identifiers.ViewDefinition={name:"ɵViewDefinition",moduleName:CORE},Identifiers.createComponentFactory={name:"ɵccf",moduleName:CORE},Identifiers}(),LifecycleHooks={OnInit:0,OnDestroy:1,DoCheck:2,OnChanges:3,AfterContentInit:4,AfterContentChecked:5,AfterViewInit:6,AfterViewChecked:7};LifecycleHooks[LifecycleHooks.OnInit]="OnInit",LifecycleHooks[LifecycleHooks.OnDestroy]="OnDestroy",LifecycleHooks[LifecycleHooks.DoCheck]="DoCheck",LifecycleHooks[LifecycleHooks.OnChanges]="OnChanges",LifecycleHooks[LifecycleHooks.AfterContentInit]="AfterContentInit",LifecycleHooks[LifecycleHooks.AfterContentChecked]="AfterContentChecked",LifecycleHooks[LifecycleHooks.AfterViewInit]="AfterViewInit",LifecycleHooks[LifecycleHooks.AfterViewChecked]="AfterViewChecked";var LIFECYCLE_HOOKS_VALUES=[LifecycleHooks.OnInit,LifecycleHooks.OnDestroy,LifecycleHooks.DoCheck,LifecycleHooks.OnChanges,LifecycleHooks.AfterContentInit,LifecycleHooks.AfterContentChecked,LifecycleHooks.AfterViewInit,LifecycleHooks.AfterViewChecked],_SELECTOR_REGEXP=new RegExp("(\\:not\\()|([-\\w]+)|(?:\\.([-\\w]+))|(?:\\[([-.\\w*]+)(?:=([\"']?)([^\\]\"']*)\\5)?\\])|(\\))|(\\s*,\\s*)","g"),CssSelector=function(){function CssSelector(){this.element=null,this.classNames=[],this.attrs=[],this.notSelectors=[]}return CssSelector.parse=function(selector){var match,results=[],_addResult=function(res,cssSel){cssSel.notSelectors.length>0&&!cssSel.element&&0==cssSel.classNames.length&&0==cssSel.attrs.length&&(cssSel.element="*"),res.push(cssSel)},cssSelector=new CssSelector,current=cssSelector,inNot=!1;for(_SELECTOR_REGEXP.lastIndex=0;match=_SELECTOR_REGEXP.exec(selector);){if(match[1]){if(inNot)throw new Error("Nesting :not is not allowed in a selector");inNot=!0,current=new CssSelector,cssSelector.notSelectors.push(current)}if(match[2]&&current.setElement(match[2]),match[3]&&current.addClassName(match[3]),match[4]&&current.addAttribute(match[4],match[6]),match[7]&&(inNot=!1,current=cssSelector),match[8]){if(inNot)throw new Error("Multiple selectors in :not are not supported");_addResult(results,cssSelector),cssSelector=current=new CssSelector}}return _addResult(results,cssSelector),results},CssSelector.prototype.isElementSelector=function(){return this.hasElementSelector()&&0==this.classNames.length&&0==this.attrs.length&&0===this.notSelectors.length},CssSelector.prototype.hasElementSelector=function(){return!!this.element},CssSelector.prototype.setElement=function(element){void 0===element&&(element=null),this.element=element},CssSelector.prototype.getMatchingElementTemplate=function(){for(var tagName=this.element||"div",classAttr=this.classNames.length>0?' class="'+this.classNames.join(" ")+'"':"",attrs="",i=0;i<this.attrs.length;i+=2){attrs+=" "+this.attrs[i]+(""!==this.attrs[i+1]?'="'+this.attrs[i+1]+'"':"")}return getHtmlTagDefinition(tagName).isVoid?"<"+tagName+classAttr+attrs+"/>":"<"+tagName+classAttr+attrs+"></"+tagName+">"},CssSelector.prototype.addAttribute=function(name,value){void 0===value&&(value=""),this.attrs.push(name,value&&value.toLowerCase()||"")},CssSelector.prototype.addClassName=function(name){this.classNames.push(name.toLowerCase())},CssSelector.prototype.toString=function(){var res=this.element||""
;if(this.classNames&&this.classNames.forEach(function(klass){return res+="."+klass}),this.attrs)for(var i=0;i<this.attrs.length;i+=2){var name_1=this.attrs[i],value=this.attrs[i+1];res+="["+name_1+(value?"="+value:"")+"]"}return this.notSelectors.forEach(function(notSelector){return res+=":not("+notSelector+")"}),res},CssSelector}(),SelectorMatcher=function(){function SelectorMatcher(){this._elementMap=new Map,this._elementPartialMap=new Map,this._classMap=new Map,this._classPartialMap=new Map,this._attrValueMap=new Map,this._attrValuePartialMap=new Map,this._listContexts=[]}return SelectorMatcher.createNotMatcher=function(notSelectors){var notMatcher=new SelectorMatcher;return notMatcher.addSelectables(notSelectors,null),notMatcher},SelectorMatcher.prototype.addSelectables=function(cssSelectors,callbackCtxt){var listContext=null;cssSelectors.length>1&&(listContext=new SelectorListContext(cssSelectors),this._listContexts.push(listContext));for(var i=0;i<cssSelectors.length;i++)this._addSelectable(cssSelectors[i],callbackCtxt,listContext)},SelectorMatcher.prototype._addSelectable=function(cssSelector,callbackCtxt,listContext){var matcher=this,element=cssSelector.element,classNames=cssSelector.classNames,attrs=cssSelector.attrs,selectable=new SelectorContext(cssSelector,callbackCtxt,listContext);if(element){var isTerminal=0===attrs.length&&0===classNames.length;isTerminal?this._addTerminal(matcher._elementMap,element,selectable):matcher=this._addPartial(matcher._elementPartialMap,element)}if(classNames)for(var i=0;i<classNames.length;i++){var isTerminal=0===attrs.length&&i===classNames.length-1,className=classNames[i];isTerminal?this._addTerminal(matcher._classMap,className,selectable):matcher=this._addPartial(matcher._classPartialMap,className)}if(attrs)for(var i=0;i<attrs.length;i+=2){var isTerminal=i===attrs.length-2,name_2=attrs[i],value=attrs[i+1];if(isTerminal){var terminalMap=matcher._attrValueMap,terminalValuesMap=terminalMap.get(name_2);terminalValuesMap||(terminalValuesMap=new Map,terminalMap.set(name_2,terminalValuesMap)),this._addTerminal(terminalValuesMap,value,selectable)}else{var partialMap=matcher._attrValuePartialMap,partialValuesMap=partialMap.get(name_2);partialValuesMap||(partialValuesMap=new Map,partialMap.set(name_2,partialValuesMap)),matcher=this._addPartial(partialValuesMap,value)}}},SelectorMatcher.prototype._addTerminal=function(map,name,selectable){var terminalList=map.get(name);terminalList||(terminalList=[],map.set(name,terminalList)),terminalList.push(selectable)},SelectorMatcher.prototype._addPartial=function(map,name){var matcher=map.get(name);return matcher||(matcher=new SelectorMatcher,map.set(name,matcher)),matcher},SelectorMatcher.prototype.match=function(cssSelector,matchedCallback){for(var result=!1,element=cssSelector.element,classNames=cssSelector.classNames,attrs=cssSelector.attrs,i=0;i<this._listContexts.length;i++)this._listContexts[i].alreadyMatched=!1;if(result=this._matchTerminal(this._elementMap,element,cssSelector,matchedCallback)||result,result=this._matchPartial(this._elementPartialMap,element,cssSelector,matchedCallback)||result,classNames)for(var i=0;i<classNames.length;i++){var className=classNames[i];result=this._matchTerminal(this._classMap,className,cssSelector,matchedCallback)||result,result=this._matchPartial(this._classPartialMap,className,cssSelector,matchedCallback)||result}if(attrs)for(var i=0;i<attrs.length;i+=2){var name_3=attrs[i],value=attrs[i+1],terminalValuesMap=this._attrValueMap.get(name_3);value&&(result=this._matchTerminal(terminalValuesMap,"",cssSelector,matchedCallback)||result),result=this._matchTerminal(terminalValuesMap,value,cssSelector,matchedCallback)||result;var partialValuesMap=this._attrValuePartialMap.get(name_3);value&&(result=this._matchPartial(partialValuesMap,"",cssSelector,matchedCallback)||result),result=this._matchPartial(partialValuesMap,value,cssSelector,matchedCallback)||result}return result},SelectorMatcher.prototype._matchTerminal=function(map,name,cssSelector,matchedCallback){if(!map||"string"!=typeof name)return!1;var selectables=map.get(name)||[],starSelectables=map.get("*");if(starSelectables&&(selectables=selectables.concat(starSelectables)),0===selectables.length)return!1;for(var selectable,result=!1,i=0;i<selectables.length;i++)selectable=selectables[i],result=selectable.finalize(cssSelector,matchedCallback)||result;return result},SelectorMatcher.prototype._matchPartial=function(map,name,cssSelector,matchedCallback){if(!map||"string"!=typeof name)return!1;var nestedSelector=map.get(name);return!!nestedSelector&&nestedSelector.match(cssSelector,matchedCallback)},SelectorMatcher}(),SelectorListContext=function(){function SelectorListContext(selectors){this.selectors=selectors,this.alreadyMatched=!1}return SelectorListContext}(),SelectorContext=function(){function SelectorContext(selector,cbContext,listContext){this.selector=selector,this.cbContext=cbContext,this.listContext=listContext,this.notSelectors=selector.notSelectors}return SelectorContext.prototype.finalize=function(cssSelector,callback){var result=!0;if(this.notSelectors.length>0&&(!this.listContext||!this.listContext.alreadyMatched)){result=!SelectorMatcher.createNotMatcher(this.notSelectors).match(cssSelector,null)}return!result||!callback||this.listContext&&this.listContext.alreadyMatched||(this.listContext&&(this.listContext.alreadyMatched=!0),callback(this.selector,this.cbContext)),result},SelectorContext}(),ERROR_COMPONENT_TYPE="ngComponentType",CompileMetadataResolver=function(){function CompileMetadataResolver(_config,_htmlParser,_ngModuleResolver,_directiveResolver,_pipeResolver,_summaryResolver,_schemaRegistry,_directiveNormalizer,_console,_staticSymbolCache,_reflector,_errorCollector){this._config=_config,this._htmlParser=_htmlParser,this._ngModuleResolver=_ngModuleResolver,this._directiveResolver=_directiveResolver,this._pipeResolver=_pipeResolver,this._summaryResolver=_summaryResolver,this._schemaRegistry=_schemaRegistry,this._directiveNormalizer=_directiveNormalizer,this._console=_console,this._staticSymbolCache=_staticSymbolCache,this._reflector=_reflector,this._errorCollector=_errorCollector,this._nonNormalizedDirectiveCache=new Map,this._directiveCache=new Map,this._summaryCache=new Map,this._pipeCache=new Map,this._ngModuleCache=new Map,this._ngModuleOfTypes=new Map}return CompileMetadataResolver.prototype.getReflector=function(){return this._reflector},CompileMetadataResolver.prototype.clearCacheFor=function(type){var dirMeta=this._directiveCache.get(type);this._directiveCache.delete(type),this._nonNormalizedDirectiveCache.delete(type),this._summaryCache.delete(type),this._pipeCache.delete(type),this._ngModuleOfTypes.delete(type),this._ngModuleCache.clear(),dirMeta&&this._directiveNormalizer.clearCacheFor(dirMeta)},CompileMetadataResolver.prototype.clearCache=function(){this._directiveCache.clear(),this._nonNormalizedDirectiveCache.clear(),this._summaryCache.clear(),this._pipeCache.clear(),this._ngModuleCache.clear(),this._ngModuleOfTypes.clear(),this._directiveNormalizer.clearCache()},CompileMetadataResolver.prototype._createProxyClass=function(baseType,name){var delegate=null,proxyClass=function(){if(!delegate)throw new Error("Illegal state: Class "+name+" for type "+stringify(baseType)+" is not compiled yet!");return delegate.apply(this,arguments)};return proxyClass.setDelegate=function(d){delegate=d,proxyClass.prototype=d.prototype},proxyClass.overriddenName=name,proxyClass},CompileMetadataResolver.prototype.getGeneratedClass=function(dirType,name){return dirType instanceof StaticSymbol?this._staticSymbolCache.get(ngfactoryFilePath(dirType.filePath),name):this._createProxyClass(dirType,name)},CompileMetadataResolver.prototype.getComponentViewClass=function(dirType){return this.getGeneratedClass(dirType,viewClassName(dirType,0))},CompileMetadataResolver.prototype.getHostComponentViewClass=function(dirType){return this.getGeneratedClass(dirType,hostViewClassName(dirType))},CompileMetadataResolver.prototype.getHostComponentType=function(dirType){var name=identifierName({reference:dirType})+"_Host";if(dirType instanceof StaticSymbol)return this._staticSymbolCache.get(dirType.filePath,name);var HostClass=function(){};return HostClass.overriddenName=name,HostClass},CompileMetadataResolver.prototype.getRendererType=function(dirType){return dirType instanceof StaticSymbol?this._staticSymbolCache.get(ngfactoryFilePath(dirType.filePath),rendererTypeName(dirType)):{}},CompileMetadataResolver.prototype.getComponentFactory=function(selector,dirType,inputs,outputs){if(dirType instanceof StaticSymbol)return this._staticSymbolCache.get(ngfactoryFilePath(dirType.filePath),componentFactoryName(dirType));var hostView=this.getHostComponentViewClass(dirType);return this._reflector.resolveExternalReference(Identifiers.createComponentFactory)(selector,dirType,hostView,inputs,outputs,[])},CompileMetadataResolver.prototype.initComponentFactory=function(factory,ngContentSelectors){factory instanceof StaticSymbol||(_a=factory.ngContentSelectors).push.apply(_a,ngContentSelectors);var _a},CompileMetadataResolver.prototype._loadSummary=function(type,kind){var typeSummary=this._summaryCache.get(type);if(!typeSummary){var summary=this._summaryResolver.resolveSummary(type);typeSummary=summary?summary.type:null,this._summaryCache.set(type,typeSummary||null)}return typeSummary&&typeSummary.summaryKind===kind?typeSummary:null},CompileMetadataResolver.prototype.getHostComponentMetadata=function(compMeta,hostViewType){var hostType=this.getHostComponentType(compMeta.type.reference);hostViewType||(hostViewType=this.getHostComponentViewClass(hostType));var template=CssSelector.parse(compMeta.selector)[0].getMatchingElementTemplate(),htmlAst=this._htmlParser.parse(template,"");return CompileDirectiveMetadata.create({isHost:!0,type:{reference:hostType,diDeps:[],lifecycleHooks:[]},template:new CompileTemplateMetadata({encapsulation:ViewEncapsulation.None,template:template,templateUrl:"",htmlAst:htmlAst,styles:[],styleUrls:[],ngContentSelectors:[],animations:[],isInline:!0,externalStylesheets:[],interpolation:null,preserveWhitespaces:!1}),exportAs:null,changeDetection:ChangeDetectionStrategy.Default,inputs:[],outputs:[],host:{},isComponent:!0,selector:"*",providers:[],viewProviders:[],queries:[],guards:{},viewQueries:[],componentViewType:hostViewType,rendererType:{id:"__Host__",encapsulation:ViewEncapsulation.None,styles:[],data:{}},entryComponents:[],componentFactory:null})},CompileMetadataResolver.prototype.loadDirectiveMetadata=function(ngModuleType,directiveType,isSync){var _this=this;if(this._directiveCache.has(directiveType))return null;directiveType=resolveForwardRef(directiveType);var _a=this.getNonNormalizedDirectiveMetadata(directiveType),annotation=_a.annotation,metadata=_a.metadata,createDirectiveMetadata=function(templateMetadata){var normalizedDirMeta=new CompileDirectiveMetadata({isHost:!1,type:metadata.type,isComponent:metadata.isComponent,selector:metadata.selector,exportAs:metadata.exportAs,changeDetection:metadata.changeDetection,inputs:metadata.inputs,outputs:metadata.outputs,hostListeners:metadata.hostListeners,hostProperties:metadata.hostProperties,hostAttributes:metadata.hostAttributes,providers:metadata.providers,viewProviders:metadata.viewProviders,queries:metadata.queries,guards:metadata.guards,viewQueries:metadata.viewQueries,entryComponents:metadata.entryComponents,componentViewType:metadata.componentViewType,rendererType:metadata.rendererType,componentFactory:metadata.componentFactory,template:templateMetadata});return templateMetadata&&_this.initComponentFactory(metadata.componentFactory,templateMetadata.ngContentSelectors),_this._directiveCache.set(directiveType,normalizedDirMeta),_this._summaryCache.set(directiveType,normalizedDirMeta.toSummary()),null};if(metadata.isComponent){var template=metadata.template,templateMeta=this._directiveNormalizer.normalizeTemplate({ngModuleType:ngModuleType,componentType:directiveType,moduleUrl:this._reflector.componentModuleUrl(directiveType,annotation),encapsulation:template.encapsulation,template:template.template,templateUrl:template.templateUrl,styles:template.styles,styleUrls:template.styleUrls,animations:template.animations,interpolation:template.interpolation,preserveWhitespaces:template.preserveWhitespaces});return isPromise(templateMeta)&&isSync?(this._reportError(componentStillLoadingError(directiveType),directiveType),null):SyncAsync.then(templateMeta,createDirectiveMetadata)}return createDirectiveMetadata(null),null},CompileMetadataResolver.prototype.getNonNormalizedDirectiveMetadata=function(directiveType){var _this=this;if(!(directiveType=resolveForwardRef(directiveType)))return null;var cacheEntry=this._nonNormalizedDirectiveCache.get(directiveType);if(cacheEntry)return cacheEntry;var dirMeta=this._directiveResolver.resolve(directiveType,!1);if(!dirMeta)return null;var nonNormalizedTemplateMetadata=void 0;if(createComponent.isTypeOf(dirMeta)){var compMeta=dirMeta;assertArrayOfStrings("styles",compMeta.styles),assertArrayOfStrings("styleUrls",compMeta.styleUrls),assertInterpolationSymbols("interpolation",compMeta.interpolation);var animations=compMeta.animations;nonNormalizedTemplateMetadata=new CompileTemplateMetadata({encapsulation:noUndefined(compMeta.encapsulation),template:noUndefined(compMeta.template),templateUrl:noUndefined(compMeta.templateUrl),htmlAst:null,styles:compMeta.styles||[],styleUrls:compMeta.styleUrls||[],animations:animations||[],interpolation:noUndefined(compMeta.interpolation),isInline:!!compMeta.template,externalStylesheets:[],ngContentSelectors:[],preserveWhitespaces:noUndefined(dirMeta.preserveWhitespaces)})}var changeDetectionStrategy=null,viewProviders=[],entryComponentMetadata=[],selector=dirMeta.selector;if(createComponent.isTypeOf(dirMeta)){var compMeta=dirMeta;changeDetectionStrategy=compMeta.changeDetection,compMeta.viewProviders&&(viewProviders=this._getProvidersMetadata(compMeta.viewProviders,entryComponentMetadata,'viewProviders for "'+stringifyType(directiveType)+'"',[],directiveType)),compMeta.entryComponents&&(entryComponentMetadata=flattenAndDedupeArray(compMeta.entryComponents).map(function(type){return _this._getEntryComponentMetadata(type)}).concat(entryComponentMetadata)),selector||(selector=this._schemaRegistry.getDefaultComponentElementName())}else selector||(this._reportError(syntaxError("Directive "+stringifyType(directiveType)+" has no selector, please add it!"),directiveType),selector="error");var providers=[];null!=dirMeta.providers&&(providers=this._getProvidersMetadata(dirMeta.providers,entryComponentMetadata,'providers for "'+stringifyType(directiveType)+'"',[],directiveType));var queries=[],viewQueries=[];null!=dirMeta.queries&&(queries=this._getQueriesMetadata(dirMeta.queries,!1,directiveType),viewQueries=this._getQueriesMetadata(dirMeta.queries,!0,directiveType));var metadata=CompileDirectiveMetadata.create({isHost:!1,selector:selector,exportAs:noUndefined(dirMeta.exportAs),isComponent:!!nonNormalizedTemplateMetadata,type:this._getTypeMetadata(directiveType),template:nonNormalizedTemplateMetadata,changeDetection:changeDetectionStrategy,inputs:dirMeta.inputs||[],outputs:dirMeta.outputs||[],host:dirMeta.host||{},providers:providers||[],viewProviders:viewProviders||[],queries:queries||[],guards:dirMeta.guards||{},viewQueries:viewQueries||[],entryComponents:entryComponentMetadata,componentViewType:nonNormalizedTemplateMetadata?this.getComponentViewClass(directiveType):null,rendererType:nonNormalizedTemplateMetadata?this.getRendererType(directiveType):null,componentFactory:null});return nonNormalizedTemplateMetadata&&(metadata.componentFactory=this.getComponentFactory(selector,directiveType,metadata.inputs,metadata.outputs)),cacheEntry={metadata:metadata,annotation:dirMeta},this._nonNormalizedDirectiveCache.set(directiveType,cacheEntry),cacheEntry},CompileMetadataResolver.prototype.getDirectiveMetadata=function(directiveType){var dirMeta=this._directiveCache.get(directiveType);return dirMeta||this._reportError(syntaxError("Illegal state: getDirectiveMetadata can only be called after loadNgModuleDirectiveAndPipeMetadata for a module that declares it. Directive "+stringifyType(directiveType)+"."),directiveType),dirMeta},CompileMetadataResolver.prototype.getDirectiveSummary=function(dirType){var dirSummary=this._loadSummary(dirType,CompileSummaryKind.Directive);return dirSummary||this._reportError(syntaxError("Illegal state: Could not load the summary for directive "+stringifyType(dirType)+"."),dirType),dirSummary},CompileMetadataResolver.prototype.isDirective=function(type){return!!this._loadSummary(type,CompileSummaryKind.Directive)||this._directiveResolver.isDirective(type)},CompileMetadataResolver.prototype.isPipe=function(type){return!!this._loadSummary(type,CompileSummaryKind.Pipe)||this._pipeResolver.isPipe(type)},CompileMetadataResolver.prototype.isNgModule=function(type){return!!this._loadSummary(type,CompileSummaryKind.NgModule)||this._ngModuleResolver.isNgModule(type)},CompileMetadataResolver.prototype.getNgModuleSummary=function(moduleType,alreadyCollecting){void 0===alreadyCollecting&&(alreadyCollecting=null);var moduleSummary=this._loadSummary(moduleType,CompileSummaryKind.NgModule);if(!moduleSummary){var moduleMeta=this.getNgModuleMetadata(moduleType,!1,alreadyCollecting);moduleSummary=moduleMeta?moduleMeta.toSummary():null,moduleSummary&&this._summaryCache.set(moduleType,moduleSummary)}return moduleSummary},CompileMetadataResolver.prototype.loadNgModuleDirectiveAndPipeMetadata=function(moduleType,isSync,throwIfNotFound){var _this=this;void 0===throwIfNotFound&&(throwIfNotFound=!0);var ngModule=this.getNgModuleMetadata(moduleType,throwIfNotFound),loading=[];return ngModule&&(ngModule.declaredDirectives.forEach(function(id){var promise=_this.loadDirectiveMetadata(moduleType,id.reference,isSync);promise&&loading.push(promise)}),ngModule.declaredPipes.forEach(function(id){return _this._loadPipeMetadata(id.reference)})),Promise.all(loading)},CompileMetadataResolver.prototype.getNgModuleMetadata=function(moduleType,throwIfNotFound,alreadyCollecting){var _this=this;void 0===throwIfNotFound&&(throwIfNotFound=!0),void 0===alreadyCollecting&&(alreadyCollecting=null),moduleType=resolveForwardRef(moduleType);var compileMeta=this._ngModuleCache.get(moduleType);if(compileMeta)return compileMeta;var meta=this._ngModuleResolver.resolve(moduleType,throwIfNotFound);if(!meta)return null;var declaredDirectives=[],exportedNonModuleIdentifiers=[],declaredPipes=[],importedModules=[],exportedModules=[],providers=[],entryComponents=[],bootstrapComponents=[],schemas=[];meta.imports&&flattenAndDedupeArray(meta.imports).forEach(function(importedType){var importedModuleType=void 0;if(isValidType(importedType))importedModuleType=importedType;else if(importedType&&importedType.ngModule){var moduleWithProviders=importedType;importedModuleType=moduleWithProviders.ngModule,moduleWithProviders.providers&&providers.push.apply(providers,_this._getProvidersMetadata(moduleWithProviders.providers,entryComponents,"provider for the NgModule '"+stringifyType(importedModuleType)+"'",[],importedType))}if(!importedModuleType)return void _this._reportError(syntaxError("Unexpected value '"+stringifyType(importedType)+"' imported by the module '"+stringifyType(moduleType)+"'"),moduleType);if(!_this._checkSelfImport(moduleType,importedModuleType)){if(alreadyCollecting||(alreadyCollecting=new Set),alreadyCollecting.has(importedModuleType))return void _this._reportError(syntaxError(_this._getTypeDescriptor(importedModuleType)+" '"+stringifyType(importedType)+"' is imported recursively by the module '"+stringifyType(moduleType)+"'."),moduleType);alreadyCollecting.add(importedModuleType);var importedModuleSummary=_this.getNgModuleSummary(importedModuleType,alreadyCollecting);if(alreadyCollecting.delete(importedModuleType),!importedModuleSummary)return void _this._reportError(syntaxError("Unexpected "+_this._getTypeDescriptor(importedType)+" '"+stringifyType(importedType)+"' imported by the module '"+stringifyType(moduleType)+"'. Please add a @NgModule annotation."),moduleType);importedModules.push(importedModuleSummary)}}),meta.exports&&flattenAndDedupeArray(meta.exports).forEach(function(exportedType){if(!isValidType(exportedType))return void _this._reportError(syntaxError("Unexpected value '"+stringifyType(exportedType)+"' exported by the module '"+stringifyType(moduleType)+"'"),moduleType);if(alreadyCollecting||(alreadyCollecting=new Set),alreadyCollecting.has(exportedType))return void _this._reportError(syntaxError(_this._getTypeDescriptor(exportedType)+" '"+stringify(exportedType)+"' is exported recursively by the module '"+stringifyType(moduleType)+"'"),moduleType);alreadyCollecting.add(exportedType);var exportedModuleSummary=_this.getNgModuleSummary(exportedType,alreadyCollecting);alreadyCollecting.delete(exportedType),exportedModuleSummary?exportedModules.push(exportedModuleSummary):exportedNonModuleIdentifiers.push(_this._getIdentifierMetadata(exportedType))});var transitiveModule=this._getTransitiveNgModuleMetadata(importedModules,exportedModules);meta.declarations&&flattenAndDedupeArray(meta.declarations).forEach(function(declaredType){if(!isValidType(declaredType))return void _this._reportError(syntaxError("Unexpected value '"+stringifyType(declaredType)+"' declared by the module '"+stringifyType(moduleType)+"'"),moduleType);var declaredIdentifier=_this._getIdentifierMetadata(declaredType);if(_this.isDirective(declaredType))transitiveModule.addDirective(declaredIdentifier),declaredDirectives.push(declaredIdentifier),_this._addTypeToModule(declaredType,moduleType);else{if(!_this.isPipe(declaredType))return void _this._reportError(syntaxError("Unexpected "+_this._getTypeDescriptor(declaredType)+" '"+stringifyType(declaredType)+"' declared by the module '"+stringifyType(moduleType)+"'. Please add a @Pipe/@Directive/@Component annotation."),moduleType);transitiveModule.addPipe(declaredIdentifier),transitiveModule.pipes.push(declaredIdentifier),declaredPipes.push(declaredIdentifier),_this._addTypeToModule(declaredType,moduleType)}});var exportedDirectives=[],exportedPipes=[];return exportedNonModuleIdentifiers.forEach(function(exportedId){if(transitiveModule.directivesSet.has(exportedId.reference))exportedDirectives.push(exportedId),transitiveModule.addExportedDirective(exportedId);else{if(!transitiveModule.pipesSet.has(exportedId.reference))return void _this._reportError(syntaxError("Can't export "+_this._getTypeDescriptor(exportedId.reference)+" "+stringifyType(exportedId.reference)+" from "+stringifyType(moduleType)+" as it was neither declared nor imported!"),moduleType);exportedPipes.push(exportedId),transitiveModule.addExportedPipe(exportedId)}}),meta.providers&&providers.push.apply(providers,this._getProvidersMetadata(meta.providers,entryComponents,"provider for the NgModule '"+stringifyType(moduleType)+"'",[],moduleType)),meta.entryComponents&&entryComponents.push.apply(entryComponents,flattenAndDedupeArray(meta.entryComponents).map(function(type){return _this._getEntryComponentMetadata(type)})),meta.bootstrap&&flattenAndDedupeArray(meta.bootstrap).forEach(function(type){if(!isValidType(type))return void _this._reportError(syntaxError("Unexpected value '"+stringifyType(type)+"' used in the bootstrap property of module '"+stringifyType(moduleType)+"'"),moduleType);bootstrapComponents.push(_this._getIdentifierMetadata(type))}),entryComponents.push.apply(entryComponents,bootstrapComponents.map(function(type){return _this._getEntryComponentMetadata(type.reference)})),meta.schemas&&schemas.push.apply(schemas,flattenAndDedupeArray(meta.schemas)),compileMeta=new CompileNgModuleMetadata({type:this._getTypeMetadata(moduleType),providers:providers,entryComponents:entryComponents,bootstrapComponents:bootstrapComponents,schemas:schemas,declaredDirectives:declaredDirectives,exportedDirectives:exportedDirectives,declaredPipes:declaredPipes,exportedPipes:exportedPipes,importedModules:importedModules,exportedModules:exportedModules,transitiveModule:transitiveModule,id:meta.id||null}),entryComponents.forEach(function(id){return transitiveModule.addEntryComponent(id)}),providers.forEach(function(provider){return transitiveModule.addProvider(provider,compileMeta.type)}),transitiveModule.addModule(compileMeta.type),this._ngModuleCache.set(moduleType,compileMeta),compileMeta},CompileMetadataResolver.prototype._checkSelfImport=function(moduleType,importedModuleType){return moduleType===importedModuleType&&(this._reportError(syntaxError("'"+stringifyType(moduleType)+"' module can't import itself"),moduleType),!0)},CompileMetadataResolver.prototype._getTypeDescriptor=function(type){if(isValidType(type)){if(this.isDirective(type))return"directive";if(this.isPipe(type))return"pipe";if(this.isNgModule(type))return"module"}return type.provide?"provider":"value"},CompileMetadataResolver.prototype._addTypeToModule=function(type,moduleType){var oldModule=this._ngModuleOfTypes.get(type);if(oldModule&&oldModule!==moduleType)return void this._reportError(syntaxError("Type "+stringifyType(type)+" is part of the declarations of 2 modules: "+stringifyType(oldModule)+" and "+stringifyType(moduleType)+"! Please consider moving "+stringifyType(type)+" to a higher module that imports "+stringifyType(oldModule)+" and "+stringifyType(moduleType)+". You can also create a new NgModule that exports and includes "+stringifyType(type)+" then import that NgModule in "+stringifyType(oldModule)+" and "+stringifyType(moduleType)+"."),moduleType);this._ngModuleOfTypes.set(type,moduleType)},CompileMetadataResolver.prototype._getTransitiveNgModuleMetadata=function(importedModules,exportedModules){var result=new TransitiveCompileNgModuleMetadata,modulesByToken=new Map;return importedModules.concat(exportedModules).forEach(function(modSummary){modSummary.modules.forEach(function(mod){return result.addModule(mod)}),modSummary.entryComponents.forEach(function(comp){return result.addEntryComponent(comp)});var addedTokens=new Set;modSummary.providers.forEach(function(entry){var tokenRef=tokenReference(entry.provider.token),prevModules=modulesByToken.get(tokenRef);prevModules||(prevModules=new Set,modulesByToken.set(tokenRef,prevModules));var moduleRef=entry.module.reference;!addedTokens.has(tokenRef)&&prevModules.has(moduleRef)||(prevModules.add(moduleRef),addedTokens.add(tokenRef),result.addProvider(entry.provider,entry.module))})}),exportedModules.forEach(function(modSummary){modSummary.exportedDirectives.forEach(function(id){return result.addExportedDirective(id)}),modSummary.exportedPipes.forEach(function(id){return result.addExportedPipe(id)})}),importedModules.forEach(function(modSummary){modSummary.exportedDirectives.forEach(function(id){return result.addDirective(id)}),modSummary.exportedPipes.forEach(function(id){return result.addPipe(id)})}),result},CompileMetadataResolver.prototype._getIdentifierMetadata=function(type){return type=resolveForwardRef(type),{reference:type}},CompileMetadataResolver.prototype.isInjectable=function(type){return this._reflector.annotations(type).some(function(ann){return createInjectable.isTypeOf(ann)})},CompileMetadataResolver.prototype.getInjectableSummary=function(type){return{summaryKind:CompileSummaryKind.Injectable,type:this._getTypeMetadata(type,null,!1)}},CompileMetadataResolver.prototype._getInjectableMetadata=function(type,dependencies){void 0===dependencies&&(dependencies=null);var typeSummary=this._loadSummary(type,CompileSummaryKind.Injectable);return typeSummary?typeSummary.type:this._getTypeMetadata(type,dependencies)},CompileMetadataResolver.prototype._getTypeMetadata=function(type,dependencies,throwOnUnknownDeps){void 0===dependencies&&(dependencies=null),void 0===throwOnUnknownDeps&&(throwOnUnknownDeps=!0);var identifier=this._getIdentifierMetadata(type);return{reference:identifier.reference,diDeps:this._getDependenciesMetadata(identifier.reference,dependencies,throwOnUnknownDeps),lifecycleHooks:getAllLifecycleHooks(this._reflector,identifier.reference)}},CompileMetadataResolver.prototype._getFactoryMetadata=function(factory,dependencies){return void 0===dependencies&&(dependencies=null),factory=resolveForwardRef(factory),{reference:factory,diDeps:this._getDependenciesMetadata(factory,dependencies)}},CompileMetadataResolver.prototype.getPipeMetadata=function(pipeType){var pipeMeta=this._pipeCache.get(pipeType);return pipeMeta||this._reportError(syntaxError("Illegal state: getPipeMetadata can only be called after loadNgModuleDirectiveAndPipeMetadata for a module that declares it. Pipe "+stringifyType(pipeType)+"."),pipeType),pipeMeta||null},CompileMetadataResolver.prototype.getPipeSummary=function(pipeType){var pipeSummary=this._loadSummary(pipeType,CompileSummaryKind.Pipe);return pipeSummary||this._reportError(syntaxError("Illegal state: Could not load the summary for pipe "+stringifyType(pipeType)+"."),pipeType),pipeSummary},CompileMetadataResolver.prototype.getOrLoadPipeMetadata=function(pipeType){var pipeMeta=this._pipeCache.get(pipeType);return pipeMeta||(pipeMeta=this._loadPipeMetadata(pipeType)),pipeMeta},CompileMetadataResolver.prototype._loadPipeMetadata=function(pipeType){pipeType=resolveForwardRef(pipeType);var pipeAnnotation=this._pipeResolver.resolve(pipeType),pipeMeta=new CompilePipeMetadata({type:this._getTypeMetadata(pipeType),name:pipeAnnotation.name,pure:!!pipeAnnotation.pure});return this._pipeCache.set(pipeType,pipeMeta),this._summaryCache.set(pipeType,pipeMeta.toSummary()),pipeMeta},CompileMetadataResolver.prototype._getDependenciesMetadata=function(typeOrFunc,dependencies,throwOnUnknownDeps){var _this=this;void 0===throwOnUnknownDeps&&(throwOnUnknownDeps=!0);var hasUnknownDeps=!1,params=dependencies||this._reflector.parameters(typeOrFunc)||[],dependenciesMetadata=params.map(function(param){var isAttribute=!1,isHost=!1,isSelf=!1,isSkipSelf=!1,isOptional=!1,token=null;return Array.isArray(param)?param.forEach(function(paramEntry){createHost.isTypeOf(paramEntry)?isHost=!0:createSelf.isTypeOf(paramEntry)?isSelf=!0:createSkipSelf.isTypeOf(paramEntry)?isSkipSelf=!0:createOptional.isTypeOf(paramEntry)?isOptional=!0:createAttribute.isTypeOf(paramEntry)?(isAttribute=!0,token=paramEntry.attributeName):createInject.isTypeOf(paramEntry)?token=paramEntry.token:createInjectionToken.isTypeOf(paramEntry)||paramEntry instanceof StaticSymbol?token=paramEntry:isValidType(paramEntry)&&null==token&&(token=paramEntry)}):token=param,null==token?(hasUnknownDeps=!0,null):{isAttribute:isAttribute,isHost:isHost,isSelf:isSelf,isSkipSelf:isSkipSelf,isOptional:isOptional,token:_this._getTokenMetadata(token)}});if(hasUnknownDeps){var depsTokens=dependenciesMetadata.map(function(dep){return dep?stringifyType(dep.token):"?"}).join(", "),message="Can't resolve all parameters for "+stringifyType(typeOrFunc)+": ("+depsTokens+").";throwOnUnknownDeps||this._config.strictInjectionParameters?this._reportError(syntaxError(message),typeOrFunc):this._console.warn("Warning: "+message+" This will become an error in Angular v6.x")}return dependenciesMetadata},CompileMetadataResolver.prototype._getTokenMetadata=function(token){token=resolveForwardRef(token);return"string"==typeof token?{value:token}:{identifier:{reference:token}}},CompileMetadataResolver.prototype._getProvidersMetadata=function(providers,targetEntryComponents,debugInfo,compileProviders,type){var _this=this;return void 0===compileProviders&&(compileProviders=[]),providers.forEach(function(provider,providerIdx){if(Array.isArray(provider))_this._getProvidersMetadata(provider,targetEntryComponents,debugInfo,compileProviders);else{provider=resolveForwardRef(provider);var providerMeta=void 0;if(provider&&"object"==typeof provider&&provider.hasOwnProperty("provide"))_this._validateProvider(provider),providerMeta=new ProviderMeta(provider.provide,provider);else{if(!isValidType(provider)){
if(void 0===provider)return void _this._reportError(syntaxError("Encountered undefined provider! Usually this means you have a circular dependencies (might be caused by using 'barrel' index.ts files."));var providersInfo=providers.reduce(function(soFar,seenProvider,seenProviderIdx){return seenProviderIdx<providerIdx?soFar.push(""+stringifyType(seenProvider)):seenProviderIdx==providerIdx?soFar.push("?"+stringifyType(seenProvider)+"?"):seenProviderIdx==providerIdx+1&&soFar.push("..."),soFar},[]).join(", ");return void _this._reportError(syntaxError("Invalid "+(debugInfo||"provider")+" - only instances of Provider and Type are allowed, got: ["+providersInfo+"]"),type)}providerMeta=new ProviderMeta(provider,{useClass:provider})}providerMeta.token===_this._reflector.resolveExternalReference(Identifiers.ANALYZE_FOR_ENTRY_COMPONENTS)?targetEntryComponents.push.apply(targetEntryComponents,_this._getEntryComponentsFromProvider(providerMeta,type)):compileProviders.push(_this.getProviderMetadata(providerMeta))}}),compileProviders},CompileMetadataResolver.prototype._validateProvider=function(provider){provider.hasOwnProperty("useClass")&&null==provider.useClass&&this._reportError(syntaxError("Invalid provider for "+stringifyType(provider.provide)+". useClass cannot be "+provider.useClass+".\n           Usually it happens when:\n           1. There's a circular dependency (might be caused by using index.ts (barrel) files).\n           2. Class was used before it was declared. Use forwardRef in this case."))},CompileMetadataResolver.prototype._getEntryComponentsFromProvider=function(provider,type){var _this=this,components=[],collectedIdentifiers=[];return provider.useFactory||provider.useExisting||provider.useClass?(this._reportError(syntaxError("The ANALYZE_FOR_ENTRY_COMPONENTS token only supports useValue!"),type),[]):provider.multi?(extractIdentifiers(provider.useValue,collectedIdentifiers),collectedIdentifiers.forEach(function(identifier){var entry=_this._getEntryComponentMetadata(identifier.reference,!1);entry&&components.push(entry)}),components):(this._reportError(syntaxError("The ANALYZE_FOR_ENTRY_COMPONENTS token only supports 'multi = true'!"),type),[])},CompileMetadataResolver.prototype._getEntryComponentMetadata=function(dirType,throwIfNotFound){void 0===throwIfNotFound&&(throwIfNotFound=!0);var dirMeta=this.getNonNormalizedDirectiveMetadata(dirType);if(dirMeta&&dirMeta.metadata.isComponent)return{componentType:dirType,componentFactory:dirMeta.metadata.componentFactory};var dirSummary=this._loadSummary(dirType,CompileSummaryKind.Directive);if(dirSummary&&dirSummary.isComponent)return{componentType:dirType,componentFactory:dirSummary.componentFactory};if(throwIfNotFound)throw syntaxError(dirType.name+" cannot be used as an entry component.");return null},CompileMetadataResolver.prototype.getProviderMetadata=function(provider){var compileDeps=void 0,compileTypeMetadata=null,compileFactoryMetadata=null,token=this._getTokenMetadata(provider.token);return provider.useClass?(compileTypeMetadata=this._getInjectableMetadata(provider.useClass,provider.dependencies),compileDeps=compileTypeMetadata.diDeps,provider.token===provider.useClass&&(token={identifier:compileTypeMetadata})):provider.useFactory&&(compileFactoryMetadata=this._getFactoryMetadata(provider.useFactory,provider.dependencies),compileDeps=compileFactoryMetadata.diDeps),{token:token,useClass:compileTypeMetadata,useValue:provider.useValue,useFactory:compileFactoryMetadata,useExisting:provider.useExisting?this._getTokenMetadata(provider.useExisting):void 0,deps:compileDeps,multi:provider.multi}},CompileMetadataResolver.prototype._getQueriesMetadata=function(queries,isViewQuery,directiveType){var _this=this,res=[];return Object.keys(queries).forEach(function(propertyName){var query=queries[propertyName];query.isViewQuery===isViewQuery&&res.push(_this._getQueryMetadata(query,propertyName,directiveType))}),res},CompileMetadataResolver.prototype._queryVarBindings=function(selector){return selector.split(/\s*,\s*/)},CompileMetadataResolver.prototype._getQueryMetadata=function(q,propertyName,typeOrFunc){var selectors,_this=this;return"string"==typeof q.selector?selectors=this._queryVarBindings(q.selector).map(function(varName){return _this._getTokenMetadata(varName)}):q.selector?selectors=[this._getTokenMetadata(q.selector)]:(this._reportError(syntaxError("Can't construct a query for the property \""+propertyName+'" of "'+stringifyType(typeOrFunc)+"\" since the query selector wasn't defined."),typeOrFunc),selectors=[]),{selectors:selectors,first:q.first,descendants:q.descendants,propertyName:propertyName,read:q.read?this._getTokenMetadata(q.read):null}},CompileMetadataResolver.prototype._reportError=function(error,type,otherType){if(!this._errorCollector)throw error;this._errorCollector(error,type),otherType&&this._errorCollector(error,otherType)},CompileMetadataResolver}(),_CompileValueConverter=function(_super){function _CompileValueConverter(){return null!==_super&&_super.apply(this,arguments)||this}return __extends(_CompileValueConverter,_super),_CompileValueConverter.prototype.visitOther=function(value,targetIdentifiers){targetIdentifiers.push({reference:value})},_CompileValueConverter}(ValueTransformer),TypeModifier={Const:0};TypeModifier[TypeModifier.Const]="Const";var Type$1=function(){function Type(modifiers){void 0===modifiers&&(modifiers=null),this.modifiers=modifiers,modifiers||(this.modifiers=[])}return Type.prototype.hasModifier=function(modifier){return-1!==this.modifiers.indexOf(modifier)},Type}(),BuiltinTypeName={Dynamic:0,Bool:1,String:2,Int:3,Number:4,Function:5,Inferred:6};BuiltinTypeName[BuiltinTypeName.Dynamic]="Dynamic",BuiltinTypeName[BuiltinTypeName.Bool]="Bool",BuiltinTypeName[BuiltinTypeName.String]="String",BuiltinTypeName[BuiltinTypeName.Int]="Int",BuiltinTypeName[BuiltinTypeName.Number]="Number",BuiltinTypeName[BuiltinTypeName.Function]="Function",BuiltinTypeName[BuiltinTypeName.Inferred]="Inferred";var BuiltinType=function(_super){function BuiltinType(name,modifiers){void 0===modifiers&&(modifiers=null);var _this=_super.call(this,modifiers)||this;return _this.name=name,_this}return __extends(BuiltinType,_super),BuiltinType.prototype.visitType=function(visitor,context){return visitor.visitBuiltintType(this,context)},BuiltinType}(Type$1),ExpressionType=function(_super){function ExpressionType(value,modifiers){void 0===modifiers&&(modifiers=null);var _this=_super.call(this,modifiers)||this;return _this.value=value,_this}return __extends(ExpressionType,_super),ExpressionType.prototype.visitType=function(visitor,context){return visitor.visitExpressionType(this,context)},ExpressionType}(Type$1),ArrayType=function(_super){function ArrayType(of,modifiers){void 0===modifiers&&(modifiers=null);var _this=_super.call(this,modifiers)||this;return _this.of=of,_this}return __extends(ArrayType,_super),ArrayType.prototype.visitType=function(visitor,context){return visitor.visitArrayType(this,context)},ArrayType}(Type$1),MapType=function(_super){function MapType(valueType,modifiers){void 0===modifiers&&(modifiers=null);var _this=_super.call(this,modifiers)||this;return _this.valueType=valueType||null,_this}return __extends(MapType,_super),MapType.prototype.visitType=function(visitor,context){return visitor.visitMapType(this,context)},MapType}(Type$1),DYNAMIC_TYPE=new BuiltinType(BuiltinTypeName.Dynamic),INFERRED_TYPE=new BuiltinType(BuiltinTypeName.Inferred),BOOL_TYPE=new BuiltinType(BuiltinTypeName.Bool),BinaryOperator=(new BuiltinType(BuiltinTypeName.Int),new BuiltinType(BuiltinTypeName.Number),new BuiltinType(BuiltinTypeName.String),new BuiltinType(BuiltinTypeName.Function),{Equals:0,NotEquals:1,Identical:2,NotIdentical:3,Minus:4,Plus:5,Divide:6,Multiply:7,Modulo:8,And:9,Or:10,Lower:11,LowerEquals:12,Bigger:13,BiggerEquals:14});BinaryOperator[BinaryOperator.Equals]="Equals",BinaryOperator[BinaryOperator.NotEquals]="NotEquals",BinaryOperator[BinaryOperator.Identical]="Identical",BinaryOperator[BinaryOperator.NotIdentical]="NotIdentical",BinaryOperator[BinaryOperator.Minus]="Minus",BinaryOperator[BinaryOperator.Plus]="Plus",BinaryOperator[BinaryOperator.Divide]="Divide",BinaryOperator[BinaryOperator.Multiply]="Multiply",BinaryOperator[BinaryOperator.Modulo]="Modulo",BinaryOperator[BinaryOperator.And]="And",BinaryOperator[BinaryOperator.Or]="Or",BinaryOperator[BinaryOperator.Lower]="Lower",BinaryOperator[BinaryOperator.LowerEquals]="LowerEquals",BinaryOperator[BinaryOperator.Bigger]="Bigger",BinaryOperator[BinaryOperator.BiggerEquals]="BiggerEquals";var Expression=function(){function Expression(type,sourceSpan){this.type=type||null,this.sourceSpan=sourceSpan||null}return Expression.prototype.prop=function(name,sourceSpan){return new ReadPropExpr(this,name,null,sourceSpan)},Expression.prototype.key=function(index,type,sourceSpan){return new ReadKeyExpr(this,index,type,sourceSpan)},Expression.prototype.callMethod=function(name,params,sourceSpan){return new InvokeMethodExpr(this,name,params,null,sourceSpan)},Expression.prototype.callFn=function(params,sourceSpan){return new InvokeFunctionExpr(this,params,null,sourceSpan)},Expression.prototype.instantiate=function(params,type,sourceSpan){return new InstantiateExpr(this,params,type,sourceSpan)},Expression.prototype.conditional=function(trueCase,falseCase,sourceSpan){return void 0===falseCase&&(falseCase=null),new ConditionalExpr(this,trueCase,falseCase,null,sourceSpan)},Expression.prototype.equals=function(rhs,sourceSpan){return new BinaryOperatorExpr(BinaryOperator.Equals,this,rhs,null,sourceSpan)},Expression.prototype.notEquals=function(rhs,sourceSpan){return new BinaryOperatorExpr(BinaryOperator.NotEquals,this,rhs,null,sourceSpan)},Expression.prototype.identical=function(rhs,sourceSpan){return new BinaryOperatorExpr(BinaryOperator.Identical,this,rhs,null,sourceSpan)},Expression.prototype.notIdentical=function(rhs,sourceSpan){return new BinaryOperatorExpr(BinaryOperator.NotIdentical,this,rhs,null,sourceSpan)},Expression.prototype.minus=function(rhs,sourceSpan){return new BinaryOperatorExpr(BinaryOperator.Minus,this,rhs,null,sourceSpan)},Expression.prototype.plus=function(rhs,sourceSpan){return new BinaryOperatorExpr(BinaryOperator.Plus,this,rhs,null,sourceSpan)},Expression.prototype.divide=function(rhs,sourceSpan){return new BinaryOperatorExpr(BinaryOperator.Divide,this,rhs,null,sourceSpan)},Expression.prototype.multiply=function(rhs,sourceSpan){return new BinaryOperatorExpr(BinaryOperator.Multiply,this,rhs,null,sourceSpan)},Expression.prototype.modulo=function(rhs,sourceSpan){return new BinaryOperatorExpr(BinaryOperator.Modulo,this,rhs,null,sourceSpan)},Expression.prototype.and=function(rhs,sourceSpan){return new BinaryOperatorExpr(BinaryOperator.And,this,rhs,null,sourceSpan)},Expression.prototype.or=function(rhs,sourceSpan){return new BinaryOperatorExpr(BinaryOperator.Or,this,rhs,null,sourceSpan)},Expression.prototype.lower=function(rhs,sourceSpan){return new BinaryOperatorExpr(BinaryOperator.Lower,this,rhs,null,sourceSpan)},Expression.prototype.lowerEquals=function(rhs,sourceSpan){return new BinaryOperatorExpr(BinaryOperator.LowerEquals,this,rhs,null,sourceSpan)},Expression.prototype.bigger=function(rhs,sourceSpan){return new BinaryOperatorExpr(BinaryOperator.Bigger,this,rhs,null,sourceSpan)},Expression.prototype.biggerEquals=function(rhs,sourceSpan){return new BinaryOperatorExpr(BinaryOperator.BiggerEquals,this,rhs,null,sourceSpan)},Expression.prototype.isBlank=function(sourceSpan){return this.equals(TYPED_NULL_EXPR,sourceSpan)},Expression.prototype.cast=function(type,sourceSpan){return new CastExpr(this,type,sourceSpan)},Expression.prototype.toStmt=function(){return new ExpressionStatement(this,null)},Expression}(),BuiltinVar={This:0,Super:1,CatchError:2,CatchStack:3};BuiltinVar[BuiltinVar.This]="This",BuiltinVar[BuiltinVar.Super]="Super",BuiltinVar[BuiltinVar.CatchError]="CatchError",BuiltinVar[BuiltinVar.CatchStack]="CatchStack";var ReadVarExpr=function(_super){function ReadVarExpr(name,type,sourceSpan){var _this=_super.call(this,type,sourceSpan)||this;return"string"==typeof name?(_this.name=name,_this.builtin=null):(_this.name=null,_this.builtin=name),_this}return __extends(ReadVarExpr,_super),ReadVarExpr.prototype.isEquivalent=function(e){return e instanceof ReadVarExpr&&this.name===e.name&&this.builtin===e.builtin},ReadVarExpr.prototype.visitExpression=function(visitor,context){return visitor.visitReadVarExpr(this,context)},ReadVarExpr.prototype.set=function(value){if(!this.name)throw new Error("Built in variable "+this.builtin+" can not be assigned to.");return new WriteVarExpr(this.name,value,null,this.sourceSpan)},ReadVarExpr}(Expression),WriteVarExpr=function(_super){function WriteVarExpr(name,value,type,sourceSpan){var _this=_super.call(this,type||value.type,sourceSpan)||this;return _this.name=name,_this.value=value,_this}return __extends(WriteVarExpr,_super),WriteVarExpr.prototype.isEquivalent=function(e){return e instanceof WriteVarExpr&&this.name===e.name&&this.value.isEquivalent(e.value)},WriteVarExpr.prototype.visitExpression=function(visitor,context){return visitor.visitWriteVarExpr(this,context)},WriteVarExpr.prototype.toDeclStmt=function(type,modifiers){return new DeclareVarStmt(this.name,this.value,type,modifiers,this.sourceSpan)},WriteVarExpr}(Expression),WriteKeyExpr=function(_super){function WriteKeyExpr(receiver,index,value,type,sourceSpan){var _this=_super.call(this,type||value.type,sourceSpan)||this;return _this.receiver=receiver,_this.index=index,_this.value=value,_this}return __extends(WriteKeyExpr,_super),WriteKeyExpr.prototype.isEquivalent=function(e){return e instanceof WriteKeyExpr&&this.receiver.isEquivalent(e.receiver)&&this.index.isEquivalent(e.index)&&this.value.isEquivalent(e.value)},WriteKeyExpr.prototype.visitExpression=function(visitor,context){return visitor.visitWriteKeyExpr(this,context)},WriteKeyExpr}(Expression),WritePropExpr=function(_super){function WritePropExpr(receiver,name,value,type,sourceSpan){var _this=_super.call(this,type||value.type,sourceSpan)||this;return _this.receiver=receiver,_this.name=name,_this.value=value,_this}return __extends(WritePropExpr,_super),WritePropExpr.prototype.isEquivalent=function(e){return e instanceof WritePropExpr&&this.receiver.isEquivalent(e.receiver)&&this.name===e.name&&this.value.isEquivalent(e.value)},WritePropExpr.prototype.visitExpression=function(visitor,context){return visitor.visitWritePropExpr(this,context)},WritePropExpr}(Expression),BuiltinMethod={ConcatArray:0,SubscribeObservable:1,Bind:2};BuiltinMethod[BuiltinMethod.ConcatArray]="ConcatArray",BuiltinMethod[BuiltinMethod.SubscribeObservable]="SubscribeObservable",BuiltinMethod[BuiltinMethod.Bind]="Bind";var InvokeMethodExpr=function(_super){function InvokeMethodExpr(receiver,method,args,type,sourceSpan){var _this=_super.call(this,type,sourceSpan)||this;return _this.receiver=receiver,_this.args=args,"string"==typeof method?(_this.name=method,_this.builtin=null):(_this.name=null,_this.builtin=method),_this}return __extends(InvokeMethodExpr,_super),InvokeMethodExpr.prototype.isEquivalent=function(e){return e instanceof InvokeMethodExpr&&this.receiver.isEquivalent(e.receiver)&&this.name===e.name&&this.builtin===e.builtin&&areAllEquivalent(this.args,e.args)},InvokeMethodExpr.prototype.visitExpression=function(visitor,context){return visitor.visitInvokeMethodExpr(this,context)},InvokeMethodExpr}(Expression),InvokeFunctionExpr=function(_super){function InvokeFunctionExpr(fn,args,type,sourceSpan){var _this=_super.call(this,type,sourceSpan)||this;return _this.fn=fn,_this.args=args,_this}return __extends(InvokeFunctionExpr,_super),InvokeFunctionExpr.prototype.isEquivalent=function(e){return e instanceof InvokeFunctionExpr&&this.fn.isEquivalent(e.fn)&&areAllEquivalent(this.args,e.args)},InvokeFunctionExpr.prototype.visitExpression=function(visitor,context){return visitor.visitInvokeFunctionExpr(this,context)},InvokeFunctionExpr}(Expression),InstantiateExpr=function(_super){function InstantiateExpr(classExpr,args,type,sourceSpan){var _this=_super.call(this,type,sourceSpan)||this;return _this.classExpr=classExpr,_this.args=args,_this}return __extends(InstantiateExpr,_super),InstantiateExpr.prototype.isEquivalent=function(e){return e instanceof InstantiateExpr&&this.classExpr.isEquivalent(e.classExpr)&&areAllEquivalent(this.args,e.args)},InstantiateExpr.prototype.visitExpression=function(visitor,context){return visitor.visitInstantiateExpr(this,context)},InstantiateExpr}(Expression),LiteralExpr=function(_super){function LiteralExpr(value,type,sourceSpan){var _this=_super.call(this,type,sourceSpan)||this;return _this.value=value,_this}return __extends(LiteralExpr,_super),LiteralExpr.prototype.isEquivalent=function(e){return e instanceof LiteralExpr&&this.value===e.value},LiteralExpr.prototype.visitExpression=function(visitor,context){return visitor.visitLiteralExpr(this,context)},LiteralExpr}(Expression),ExternalExpr=function(_super){function ExternalExpr(value,type,typeParams,sourceSpan){void 0===typeParams&&(typeParams=null);var _this=_super.call(this,type,sourceSpan)||this;return _this.value=value,_this.typeParams=typeParams,_this}return __extends(ExternalExpr,_super),ExternalExpr.prototype.isEquivalent=function(e){return e instanceof ExternalExpr&&this.value.name===e.value.name&&this.value.moduleName===e.value.moduleName&&this.value.runtime===e.value.runtime},ExternalExpr.prototype.visitExpression=function(visitor,context){return visitor.visitExternalExpr(this,context)},ExternalExpr}(Expression),ExternalReference=function(){function ExternalReference(moduleName,name,runtime){this.moduleName=moduleName,this.name=name,this.runtime=runtime}return ExternalReference}(),ConditionalExpr=function(_super){function ConditionalExpr(condition,trueCase,falseCase,type,sourceSpan){void 0===falseCase&&(falseCase=null);var _this=_super.call(this,type||trueCase.type,sourceSpan)||this;return _this.condition=condition,_this.falseCase=falseCase,_this.trueCase=trueCase,_this}return __extends(ConditionalExpr,_super),ConditionalExpr.prototype.isEquivalent=function(e){return e instanceof ConditionalExpr&&this.condition.isEquivalent(e.condition)&&this.trueCase.isEquivalent(e.trueCase)&&nullSafeIsEquivalent(this.falseCase,e.falseCase)},ConditionalExpr.prototype.visitExpression=function(visitor,context){return visitor.visitConditionalExpr(this,context)},ConditionalExpr}(Expression),NotExpr=function(_super){function NotExpr(condition,sourceSpan){var _this=_super.call(this,BOOL_TYPE,sourceSpan)||this;return _this.condition=condition,_this}return __extends(NotExpr,_super),NotExpr.prototype.isEquivalent=function(e){return e instanceof NotExpr&&this.condition.isEquivalent(e.condition)},NotExpr.prototype.visitExpression=function(visitor,context){return visitor.visitNotExpr(this,context)},NotExpr}(Expression),AssertNotNull=function(_super){function AssertNotNull(condition,sourceSpan){var _this=_super.call(this,condition.type,sourceSpan)||this;return _this.condition=condition,_this}return __extends(AssertNotNull,_super),AssertNotNull.prototype.isEquivalent=function(e){return e instanceof AssertNotNull&&this.condition.isEquivalent(e.condition)},AssertNotNull.prototype.visitExpression=function(visitor,context){return visitor.visitAssertNotNullExpr(this,context)},AssertNotNull}(Expression),CastExpr=function(_super){function CastExpr(value,type,sourceSpan){var _this=_super.call(this,type,sourceSpan)||this;return _this.value=value,_this}return __extends(CastExpr,_super),CastExpr.prototype.isEquivalent=function(e){return e instanceof CastExpr&&this.value.isEquivalent(e.value)},CastExpr.prototype.visitExpression=function(visitor,context){return visitor.visitCastExpr(this,context)},CastExpr}(Expression),FnParam=function(){function FnParam(name,type){void 0===type&&(type=null),this.name=name,this.type=type}return FnParam.prototype.isEquivalent=function(param){return this.name===param.name},FnParam}(),FunctionExpr=function(_super){function FunctionExpr(params,statements,type,sourceSpan){var _this=_super.call(this,type,sourceSpan)||this;return _this.params=params,_this.statements=statements,_this}return __extends(FunctionExpr,_super),FunctionExpr.prototype.isEquivalent=function(e){return e instanceof FunctionExpr&&areAllEquivalent(this.params,e.params)&&areAllEquivalent(this.statements,e.statements)},FunctionExpr.prototype.visitExpression=function(visitor,context){return visitor.visitFunctionExpr(this,context)},FunctionExpr.prototype.toDeclStmt=function(name,modifiers){return void 0===modifiers&&(modifiers=null),new DeclareFunctionStmt(name,this.params,this.statements,this.type,modifiers,this.sourceSpan)},FunctionExpr}(Expression),BinaryOperatorExpr=function(_super){function BinaryOperatorExpr(operator,lhs,rhs,type,sourceSpan){var _this=_super.call(this,type||lhs.type,sourceSpan)||this;return _this.operator=operator,_this.rhs=rhs,_this.lhs=lhs,_this}return __extends(BinaryOperatorExpr,_super),BinaryOperatorExpr.prototype.isEquivalent=function(e){return e instanceof BinaryOperatorExpr&&this.operator===e.operator&&this.lhs.isEquivalent(e.lhs)&&this.rhs.isEquivalent(e.rhs)},BinaryOperatorExpr.prototype.visitExpression=function(visitor,context){return visitor.visitBinaryOperatorExpr(this,context)},BinaryOperatorExpr}(Expression),ReadPropExpr=function(_super){function ReadPropExpr(receiver,name,type,sourceSpan){var _this=_super.call(this,type,sourceSpan)||this;return _this.receiver=receiver,_this.name=name,_this}return __extends(ReadPropExpr,_super),ReadPropExpr.prototype.isEquivalent=function(e){return e instanceof ReadPropExpr&&this.receiver.isEquivalent(e.receiver)&&this.name===e.name},ReadPropExpr.prototype.visitExpression=function(visitor,context){return visitor.visitReadPropExpr(this,context)},ReadPropExpr.prototype.set=function(value){return new WritePropExpr(this.receiver,this.name,value,null,this.sourceSpan)},ReadPropExpr}(Expression),ReadKeyExpr=function(_super){function ReadKeyExpr(receiver,index,type,sourceSpan){var _this=_super.call(this,type,sourceSpan)||this;return _this.receiver=receiver,_this.index=index,_this}return __extends(ReadKeyExpr,_super),ReadKeyExpr.prototype.isEquivalent=function(e){return e instanceof ReadKeyExpr&&this.receiver.isEquivalent(e.receiver)&&this.index.isEquivalent(e.index)},ReadKeyExpr.prototype.visitExpression=function(visitor,context){return visitor.visitReadKeyExpr(this,context)},ReadKeyExpr.prototype.set=function(value){return new WriteKeyExpr(this.receiver,this.index,value,null,this.sourceSpan)},ReadKeyExpr}(Expression),LiteralArrayExpr=function(_super){function LiteralArrayExpr(entries,type,sourceSpan){var _this=_super.call(this,type,sourceSpan)||this;return _this.entries=entries,_this}return __extends(LiteralArrayExpr,_super),LiteralArrayExpr.prototype.isEquivalent=function(e){return e instanceof LiteralArrayExpr&&areAllEquivalent(this.entries,e.entries)},LiteralArrayExpr.prototype.visitExpression=function(visitor,context){return visitor.visitLiteralArrayExpr(this,context)},LiteralArrayExpr}(Expression),LiteralMapEntry=function(){function LiteralMapEntry(key,value,quoted){this.key=key,this.value=value,this.quoted=quoted}return LiteralMapEntry.prototype.isEquivalent=function(e){return this.key===e.key&&this.value.isEquivalent(e.value)},LiteralMapEntry}(),LiteralMapExpr=function(_super){function LiteralMapExpr(entries,type,sourceSpan){var _this=_super.call(this,type,sourceSpan)||this;return _this.entries=entries,_this.valueType=null,type&&(_this.valueType=type.valueType),_this}return __extends(LiteralMapExpr,_super),LiteralMapExpr.prototype.isEquivalent=function(e){return e instanceof LiteralMapExpr&&areAllEquivalent(this.entries,e.entries)},LiteralMapExpr.prototype.visitExpression=function(visitor,context){return visitor.visitLiteralMapExpr(this,context)},LiteralMapExpr}(Expression),CommaExpr=function(_super){function CommaExpr(parts,sourceSpan){var _this=_super.call(this,parts[parts.length-1].type,sourceSpan)||this;return _this.parts=parts,_this}return __extends(CommaExpr,_super),CommaExpr.prototype.isEquivalent=function(e){return e instanceof CommaExpr&&areAllEquivalent(this.parts,e.parts)},CommaExpr.prototype.visitExpression=function(visitor,context){return visitor.visitCommaExpr(this,context)},CommaExpr}(Expression),NULL_EXPR=(new ReadVarExpr(BuiltinVar.This,null,null),new ReadVarExpr(BuiltinVar.Super,null,null),new ReadVarExpr(BuiltinVar.CatchError,null,null),new ReadVarExpr(BuiltinVar.CatchStack,null,null),new LiteralExpr(null,null,null)),TYPED_NULL_EXPR=new LiteralExpr(null,INFERRED_TYPE,null),StmtModifier={Final:0,Private:1,Exported:2};StmtModifier[StmtModifier.Final]="Final",StmtModifier[StmtModifier.Private]="Private",StmtModifier[StmtModifier.Exported]="Exported";var Statement=function(){function Statement(modifiers,sourceSpan){this.modifiers=modifiers||[],this.sourceSpan=sourceSpan||null}return Statement.prototype.hasModifier=function(modifier){return-1!==this.modifiers.indexOf(modifier)},Statement}(),DeclareVarStmt=function(_super){function DeclareVarStmt(name,value,type,modifiers,sourceSpan){void 0===modifiers&&(modifiers=null);var _this=_super.call(this,modifiers,sourceSpan)||this;return _this.name=name,_this.value=value,_this.type=type||value.type,_this}return __extends(DeclareVarStmt,_super),DeclareVarStmt.prototype.isEquivalent=function(stmt){return stmt instanceof DeclareVarStmt&&this.name===stmt.name&&this.value.isEquivalent(stmt.value)},DeclareVarStmt.prototype.visitStatement=function(visitor,context){return visitor.visitDeclareVarStmt(this,context)},DeclareVarStmt}(Statement),DeclareFunctionStmt=function(_super){function DeclareFunctionStmt(name,params,statements,type,modifiers,sourceSpan){void 0===modifiers&&(modifiers=null);var _this=_super.call(this,modifiers,sourceSpan)||this;return _this.name=name,_this.params=params,_this.statements=statements,_this.type=type||null,_this}return __extends(DeclareFunctionStmt,_super),DeclareFunctionStmt.prototype.isEquivalent=function(stmt){return stmt instanceof DeclareFunctionStmt&&areAllEquivalent(this.params,stmt.params)&&areAllEquivalent(this.statements,stmt.statements)},DeclareFunctionStmt.prototype.visitStatement=function(visitor,context){return visitor.visitDeclareFunctionStmt(this,context)},DeclareFunctionStmt}(Statement),ExpressionStatement=function(_super){function ExpressionStatement(expr,sourceSpan){var _this=_super.call(this,null,sourceSpan)||this;return _this.expr=expr,_this}return __extends(ExpressionStatement,_super),ExpressionStatement.prototype.isEquivalent=function(stmt){return stmt instanceof ExpressionStatement&&this.expr.isEquivalent(stmt.expr)},ExpressionStatement.prototype.visitStatement=function(visitor,context){return visitor.visitExpressionStmt(this,context)},ExpressionStatement}(Statement),ReturnStatement=function(_super){function ReturnStatement(value,sourceSpan){var _this=_super.call(this,null,sourceSpan)||this;return _this.value=value,_this}return __extends(ReturnStatement,_super),ReturnStatement.prototype.isEquivalent=function(stmt){return stmt instanceof ReturnStatement&&this.value.isEquivalent(stmt.value)},ReturnStatement.prototype.visitStatement=function(visitor,context){return visitor.visitReturnStmt(this,context)},ReturnStatement}(Statement),AbstractClassPart=function(){function AbstractClassPart(type,modifiers){this.modifiers=modifiers,modifiers||(this.modifiers=[]),this.type=type||null}return AbstractClassPart.prototype.hasModifier=function(modifier){return-1!==this.modifiers.indexOf(modifier)},AbstractClassPart}(),ClassMethod=(function(_super){function ClassField(name,type,modifiers){void 0===modifiers&&(modifiers=null);var _this=_super.call(this,type,modifiers)||this;return _this.name=name,_this}__extends(ClassField,_super),ClassField.prototype.isEquivalent=function(f){return this.name===f.name}}(AbstractClassPart),function(_super){function ClassMethod(name,params,body,type,modifiers){void 0===modifiers&&(modifiers=null);var _this=_super.call(this,type,modifiers)||this;return _this.name=name,_this.params=params,_this.body=body,_this}return __extends(ClassMethod,_super),ClassMethod.prototype.isEquivalent=function(m){return this.name===m.name&&areAllEquivalent(this.body,m.body)},ClassMethod}(AbstractClassPart)),ClassGetter=function(_super){function ClassGetter(name,body,type,modifiers){void 0===modifiers&&(modifiers=null);var _this=_super.call(this,type,modifiers)||this;return _this.name=name,_this.body=body,_this}return __extends(ClassGetter,_super),ClassGetter.prototype.isEquivalent=function(m){return this.name===m.name&&areAllEquivalent(this.body,m.body)},ClassGetter}(AbstractClassPart),ClassStmt=function(_super){function ClassStmt(name,parent,fields,getters,constructorMethod,methods,modifiers,sourceSpan){void 0===modifiers&&(modifiers=null);var _this=_super.call(this,modifiers,sourceSpan)||this;return _this.name=name,_this.parent=parent,_this.fields=fields,_this.getters=getters,_this.constructorMethod=constructorMethod,_this.methods=methods,_this}return __extends(ClassStmt,_super),ClassStmt.prototype.isEquivalent=function(stmt){return stmt instanceof ClassStmt&&this.name===stmt.name&&nullSafeIsEquivalent(this.parent,stmt.parent)&&areAllEquivalent(this.fields,stmt.fields)&&areAllEquivalent(this.getters,stmt.getters)&&this.constructorMethod.isEquivalent(stmt.constructorMethod)&&areAllEquivalent(this.methods,stmt.methods)},ClassStmt.prototype.visitStatement=function(visitor,context){return visitor.visitDeclareClassStmt(this,context)},ClassStmt}(Statement),IfStmt=function(_super){function IfStmt(condition,trueCase,falseCase,sourceSpan){void 0===falseCase&&(falseCase=[]);var _this=_super.call(this,null,sourceSpan)||this;return _this.condition=condition,_this.trueCase=trueCase,_this.falseCase=falseCase,_this}return __extends(IfStmt,_super),IfStmt.prototype.isEquivalent=function(stmt){return stmt instanceof IfStmt&&this.condition.isEquivalent(stmt.condition)&&areAllEquivalent(this.trueCase,stmt.trueCase)&&areAllEquivalent(this.falseCase,stmt.falseCase)},IfStmt.prototype.visitStatement=function(visitor,context){return visitor.visitIfStmt(this,context)},IfStmt}(Statement),CommentStmt=function(_super){function CommentStmt(comment,sourceSpan){var _this=_super.call(this,null,sourceSpan)||this;return _this.comment=comment,_this}return __extends(CommentStmt,_super),CommentStmt.prototype.isEquivalent=function(stmt){return stmt instanceof CommentStmt},CommentStmt.prototype.visitStatement=function(visitor,context){return visitor.visitCommentStmt(this,context)},CommentStmt}(Statement),TryCatchStmt=function(_super){function TryCatchStmt(bodyStmts,catchStmts,sourceSpan){var _this=_super.call(this,null,sourceSpan)||this;return _this.bodyStmts=bodyStmts,_this.catchStmts=catchStmts,_this}return __extends(TryCatchStmt,_super),TryCatchStmt.prototype.isEquivalent=function(stmt){return stmt instanceof TryCatchStmt&&areAllEquivalent(this.bodyStmts,stmt.bodyStmts)&&areAllEquivalent(this.catchStmts,stmt.catchStmts)},TryCatchStmt.prototype.visitStatement=function(visitor,context){return visitor.visitTryCatchStmt(this,context)},TryCatchStmt}(Statement),ThrowStmt=function(_super){function ThrowStmt(error,sourceSpan){var _this=_super.call(this,null,sourceSpan)||this;return _this.error=error,_this}return __extends(ThrowStmt,_super),ThrowStmt.prototype.isEquivalent=function(stmt){return stmt instanceof TryCatchStmt&&this.error.isEquivalent(stmt.error)},ThrowStmt.prototype.visitStatement=function(visitor,context){return visitor.visitThrowStmt(this,context)},ThrowStmt}(Statement),AstTransformer$1=function(){function AstTransformer(){}return AstTransformer.prototype.transformExpr=function(expr,context){return expr},AstTransformer.prototype.transformStmt=function(stmt,context){return stmt},AstTransformer.prototype.visitReadVarExpr=function(ast,context){return this.transformExpr(ast,context)},AstTransformer.prototype.visitWriteVarExpr=function(expr,context){
return this.transformExpr(new WriteVarExpr(expr.name,expr.value.visitExpression(this,context),expr.type,expr.sourceSpan),context)},AstTransformer.prototype.visitWriteKeyExpr=function(expr,context){return this.transformExpr(new WriteKeyExpr(expr.receiver.visitExpression(this,context),expr.index.visitExpression(this,context),expr.value.visitExpression(this,context),expr.type,expr.sourceSpan),context)},AstTransformer.prototype.visitWritePropExpr=function(expr,context){return this.transformExpr(new WritePropExpr(expr.receiver.visitExpression(this,context),expr.name,expr.value.visitExpression(this,context),expr.type,expr.sourceSpan),context)},AstTransformer.prototype.visitInvokeMethodExpr=function(ast,context){var method=ast.builtin||ast.name;return this.transformExpr(new InvokeMethodExpr(ast.receiver.visitExpression(this,context),method,this.visitAllExpressions(ast.args,context),ast.type,ast.sourceSpan),context)},AstTransformer.prototype.visitInvokeFunctionExpr=function(ast,context){return this.transformExpr(new InvokeFunctionExpr(ast.fn.visitExpression(this,context),this.visitAllExpressions(ast.args,context),ast.type,ast.sourceSpan),context)},AstTransformer.prototype.visitInstantiateExpr=function(ast,context){return this.transformExpr(new InstantiateExpr(ast.classExpr.visitExpression(this,context),this.visitAllExpressions(ast.args,context),ast.type,ast.sourceSpan),context)},AstTransformer.prototype.visitLiteralExpr=function(ast,context){return this.transformExpr(ast,context)},AstTransformer.prototype.visitExternalExpr=function(ast,context){return this.transformExpr(ast,context)},AstTransformer.prototype.visitConditionalExpr=function(ast,context){return this.transformExpr(new ConditionalExpr(ast.condition.visitExpression(this,context),ast.trueCase.visitExpression(this,context),ast.falseCase.visitExpression(this,context),ast.type,ast.sourceSpan),context)},AstTransformer.prototype.visitNotExpr=function(ast,context){return this.transformExpr(new NotExpr(ast.condition.visitExpression(this,context),ast.sourceSpan),context)},AstTransformer.prototype.visitAssertNotNullExpr=function(ast,context){return this.transformExpr(new AssertNotNull(ast.condition.visitExpression(this,context),ast.sourceSpan),context)},AstTransformer.prototype.visitCastExpr=function(ast,context){return this.transformExpr(new CastExpr(ast.value.visitExpression(this,context),ast.type,ast.sourceSpan),context)},AstTransformer.prototype.visitFunctionExpr=function(ast,context){return this.transformExpr(new FunctionExpr(ast.params,this.visitAllStatements(ast.statements,context),ast.type,ast.sourceSpan),context)},AstTransformer.prototype.visitBinaryOperatorExpr=function(ast,context){return this.transformExpr(new BinaryOperatorExpr(ast.operator,ast.lhs.visitExpression(this,context),ast.rhs.visitExpression(this,context),ast.type,ast.sourceSpan),context)},AstTransformer.prototype.visitReadPropExpr=function(ast,context){return this.transformExpr(new ReadPropExpr(ast.receiver.visitExpression(this,context),ast.name,ast.type,ast.sourceSpan),context)},AstTransformer.prototype.visitReadKeyExpr=function(ast,context){return this.transformExpr(new ReadKeyExpr(ast.receiver.visitExpression(this,context),ast.index.visitExpression(this,context),ast.type,ast.sourceSpan),context)},AstTransformer.prototype.visitLiteralArrayExpr=function(ast,context){return this.transformExpr(new LiteralArrayExpr(this.visitAllExpressions(ast.entries,context),ast.type,ast.sourceSpan),context)},AstTransformer.prototype.visitLiteralMapExpr=function(ast,context){var _this=this,entries=ast.entries.map(function(entry){return new LiteralMapEntry(entry.key,entry.value.visitExpression(_this,context),entry.quoted)}),mapType=new MapType(ast.valueType,null);return this.transformExpr(new LiteralMapExpr(entries,mapType,ast.sourceSpan),context)},AstTransformer.prototype.visitCommaExpr=function(ast,context){return this.transformExpr(new CommaExpr(this.visitAllExpressions(ast.parts,context),ast.sourceSpan),context)},AstTransformer.prototype.visitAllExpressions=function(exprs,context){var _this=this;return exprs.map(function(expr){return expr.visitExpression(_this,context)})},AstTransformer.prototype.visitDeclareVarStmt=function(stmt,context){return this.transformStmt(new DeclareVarStmt(stmt.name,stmt.value.visitExpression(this,context),stmt.type,stmt.modifiers,stmt.sourceSpan),context)},AstTransformer.prototype.visitDeclareFunctionStmt=function(stmt,context){return this.transformStmt(new DeclareFunctionStmt(stmt.name,stmt.params,this.visitAllStatements(stmt.statements,context),stmt.type,stmt.modifiers,stmt.sourceSpan),context)},AstTransformer.prototype.visitExpressionStmt=function(stmt,context){return this.transformStmt(new ExpressionStatement(stmt.expr.visitExpression(this,context),stmt.sourceSpan),context)},AstTransformer.prototype.visitReturnStmt=function(stmt,context){return this.transformStmt(new ReturnStatement(stmt.value.visitExpression(this,context),stmt.sourceSpan),context)},AstTransformer.prototype.visitDeclareClassStmt=function(stmt,context){var _this=this,parent=stmt.parent.visitExpression(this,context),getters=stmt.getters.map(function(getter){return new ClassGetter(getter.name,_this.visitAllStatements(getter.body,context),getter.type,getter.modifiers)}),ctorMethod=stmt.constructorMethod&&new ClassMethod(stmt.constructorMethod.name,stmt.constructorMethod.params,this.visitAllStatements(stmt.constructorMethod.body,context),stmt.constructorMethod.type,stmt.constructorMethod.modifiers),methods=stmt.methods.map(function(method){return new ClassMethod(method.name,method.params,_this.visitAllStatements(method.body,context),method.type,method.modifiers)});return this.transformStmt(new ClassStmt(stmt.name,parent,stmt.fields,getters,ctorMethod,methods,stmt.modifiers,stmt.sourceSpan),context)},AstTransformer.prototype.visitIfStmt=function(stmt,context){return this.transformStmt(new IfStmt(stmt.condition.visitExpression(this,context),this.visitAllStatements(stmt.trueCase,context),this.visitAllStatements(stmt.falseCase,context),stmt.sourceSpan),context)},AstTransformer.prototype.visitTryCatchStmt=function(stmt,context){return this.transformStmt(new TryCatchStmt(this.visitAllStatements(stmt.bodyStmts,context),this.visitAllStatements(stmt.catchStmts,context),stmt.sourceSpan),context)},AstTransformer.prototype.visitThrowStmt=function(stmt,context){return this.transformStmt(new ThrowStmt(stmt.error.visitExpression(this,context),stmt.sourceSpan),context)},AstTransformer.prototype.visitCommentStmt=function(stmt,context){return this.transformStmt(stmt,context)},AstTransformer.prototype.visitAllStatements=function(stmts,context){var _this=this;return stmts.map(function(stmt){return stmt.visitStatement(_this,context)})},AstTransformer}(),RecursiveAstVisitor$1=function(){function RecursiveAstVisitor(){}return RecursiveAstVisitor.prototype.visitType=function(ast,context){return ast},RecursiveAstVisitor.prototype.visitExpression=function(ast,context){return ast.type&&ast.type.visitType(this,context),ast},RecursiveAstVisitor.prototype.visitBuiltintType=function(type,context){return this.visitType(type,context)},RecursiveAstVisitor.prototype.visitExpressionType=function(type,context){return type.value.visitExpression(this,context),this.visitType(type,context)},RecursiveAstVisitor.prototype.visitArrayType=function(type,context){return this.visitType(type,context)},RecursiveAstVisitor.prototype.visitMapType=function(type,context){return this.visitType(type,context)},RecursiveAstVisitor.prototype.visitReadVarExpr=function(ast,context){return this.visitExpression(ast,context)},RecursiveAstVisitor.prototype.visitWriteVarExpr=function(ast,context){return ast.value.visitExpression(this,context),this.visitExpression(ast,context)},RecursiveAstVisitor.prototype.visitWriteKeyExpr=function(ast,context){return ast.receiver.visitExpression(this,context),ast.index.visitExpression(this,context),ast.value.visitExpression(this,context),this.visitExpression(ast,context)},RecursiveAstVisitor.prototype.visitWritePropExpr=function(ast,context){return ast.receiver.visitExpression(this,context),ast.value.visitExpression(this,context),this.visitExpression(ast,context)},RecursiveAstVisitor.prototype.visitInvokeMethodExpr=function(ast,context){return ast.receiver.visitExpression(this,context),this.visitAllExpressions(ast.args,context),this.visitExpression(ast,context)},RecursiveAstVisitor.prototype.visitInvokeFunctionExpr=function(ast,context){return ast.fn.visitExpression(this,context),this.visitAllExpressions(ast.args,context),this.visitExpression(ast,context)},RecursiveAstVisitor.prototype.visitInstantiateExpr=function(ast,context){return ast.classExpr.visitExpression(this,context),this.visitAllExpressions(ast.args,context),this.visitExpression(ast,context)},RecursiveAstVisitor.prototype.visitLiteralExpr=function(ast,context){return this.visitExpression(ast,context)},RecursiveAstVisitor.prototype.visitExternalExpr=function(ast,context){var _this=this;return ast.typeParams&&ast.typeParams.forEach(function(type){return type.visitType(_this,context)}),this.visitExpression(ast,context)},RecursiveAstVisitor.prototype.visitConditionalExpr=function(ast,context){return ast.condition.visitExpression(this,context),ast.trueCase.visitExpression(this,context),ast.falseCase.visitExpression(this,context),this.visitExpression(ast,context)},RecursiveAstVisitor.prototype.visitNotExpr=function(ast,context){return ast.condition.visitExpression(this,context),this.visitExpression(ast,context)},RecursiveAstVisitor.prototype.visitAssertNotNullExpr=function(ast,context){return ast.condition.visitExpression(this,context),this.visitExpression(ast,context)},RecursiveAstVisitor.prototype.visitCastExpr=function(ast,context){return ast.value.visitExpression(this,context),this.visitExpression(ast,context)},RecursiveAstVisitor.prototype.visitFunctionExpr=function(ast,context){return this.visitAllStatements(ast.statements,context),this.visitExpression(ast,context)},RecursiveAstVisitor.prototype.visitBinaryOperatorExpr=function(ast,context){return ast.lhs.visitExpression(this,context),ast.rhs.visitExpression(this,context),this.visitExpression(ast,context)},RecursiveAstVisitor.prototype.visitReadPropExpr=function(ast,context){return ast.receiver.visitExpression(this,context),this.visitExpression(ast,context)},RecursiveAstVisitor.prototype.visitReadKeyExpr=function(ast,context){return ast.receiver.visitExpression(this,context),ast.index.visitExpression(this,context),this.visitExpression(ast,context)},RecursiveAstVisitor.prototype.visitLiteralArrayExpr=function(ast,context){return this.visitAllExpressions(ast.entries,context),this.visitExpression(ast,context)},RecursiveAstVisitor.prototype.visitLiteralMapExpr=function(ast,context){var _this=this;return ast.entries.forEach(function(entry){return entry.value.visitExpression(_this,context)}),this.visitExpression(ast,context)},RecursiveAstVisitor.prototype.visitCommaExpr=function(ast,context){return this.visitAllExpressions(ast.parts,context),this.visitExpression(ast,context)},RecursiveAstVisitor.prototype.visitAllExpressions=function(exprs,context){var _this=this;exprs.forEach(function(expr){return expr.visitExpression(_this,context)})},RecursiveAstVisitor.prototype.visitDeclareVarStmt=function(stmt,context){return stmt.value.visitExpression(this,context),stmt.type&&stmt.type.visitType(this,context),stmt},RecursiveAstVisitor.prototype.visitDeclareFunctionStmt=function(stmt,context){return this.visitAllStatements(stmt.statements,context),stmt.type&&stmt.type.visitType(this,context),stmt},RecursiveAstVisitor.prototype.visitExpressionStmt=function(stmt,context){return stmt.expr.visitExpression(this,context),stmt},RecursiveAstVisitor.prototype.visitReturnStmt=function(stmt,context){return stmt.value.visitExpression(this,context),stmt},RecursiveAstVisitor.prototype.visitDeclareClassStmt=function(stmt,context){var _this=this;return stmt.parent.visitExpression(this,context),stmt.getters.forEach(function(getter){return _this.visitAllStatements(getter.body,context)}),stmt.constructorMethod&&this.visitAllStatements(stmt.constructorMethod.body,context),stmt.methods.forEach(function(method){return _this.visitAllStatements(method.body,context)}),stmt},RecursiveAstVisitor.prototype.visitIfStmt=function(stmt,context){return stmt.condition.visitExpression(this,context),this.visitAllStatements(stmt.trueCase,context),this.visitAllStatements(stmt.falseCase,context),stmt},RecursiveAstVisitor.prototype.visitTryCatchStmt=function(stmt,context){return this.visitAllStatements(stmt.bodyStmts,context),this.visitAllStatements(stmt.catchStmts,context),stmt},RecursiveAstVisitor.prototype.visitThrowStmt=function(stmt,context){return stmt.error.visitExpression(this,context),stmt},RecursiveAstVisitor.prototype.visitCommentStmt=function(stmt,context){return stmt},RecursiveAstVisitor.prototype.visitAllStatements=function(stmts,context){var _this=this;stmts.forEach(function(stmt){return stmt.visitStatement(_this,context)})},RecursiveAstVisitor}(),_ReadVarVisitor=function(_super){function _ReadVarVisitor(){var _this=null!==_super&&_super.apply(this,arguments)||this;return _this.varNames=new Set,_this}return __extends(_ReadVarVisitor,_super),_ReadVarVisitor.prototype.visitDeclareFunctionStmt=function(stmt,context){return stmt},_ReadVarVisitor.prototype.visitDeclareClassStmt=function(stmt,context){return stmt},_ReadVarVisitor.prototype.visitReadVarExpr=function(ast,context){return ast.name&&this.varNames.add(ast.name),null},_ReadVarVisitor}(RecursiveAstVisitor$1),_FindExternalReferencesVisitor=function(_super){function _FindExternalReferencesVisitor(){var _this=null!==_super&&_super.apply(this,arguments)||this;return _this.externalReferences=[],_this}return __extends(_FindExternalReferencesVisitor,_super),_FindExternalReferencesVisitor.prototype.visitExternalExpr=function(e,context){return this.externalReferences.push(e.value),_super.prototype.visitExternalExpr.call(this,e,context)},_FindExternalReferencesVisitor}(RecursiveAstVisitor$1),_ApplySourceSpanTransformer=function(_super){function _ApplySourceSpanTransformer(sourceSpan){var _this=_super.call(this)||this;return _this.sourceSpan=sourceSpan,_this}return __extends(_ApplySourceSpanTransformer,_super),_ApplySourceSpanTransformer.prototype._clone=function(obj){var clone=Object.create(obj.constructor.prototype);for(var prop in obj)clone[prop]=obj[prop];return clone},_ApplySourceSpanTransformer.prototype.transformExpr=function(expr,context){return expr.sourceSpan||(expr=this._clone(expr),expr.sourceSpan=this.sourceSpan),expr},_ApplySourceSpanTransformer.prototype.transformStmt=function(stmt,context){return stmt.sourceSpan||(stmt=this._clone(stmt),stmt.sourceSpan=this.sourceSpan),stmt},_ApplySourceSpanTransformer}(AstTransformer$1),ProviderError=function(_super){function ProviderError(message,span){return _super.call(this,span,message)||this}return __extends(ProviderError,_super),ProviderError}(ParseError),ProviderViewContext=function(){function ProviderViewContext(reflector,component){var _this=this;this.reflector=reflector,this.component=component,this.errors=[],this.viewQueries=_getViewQueries(component),this.viewProviders=new Map,component.viewProviders.forEach(function(provider){null==_this.viewProviders.get(tokenReference(provider.token))&&_this.viewProviders.set(tokenReference(provider.token),!0)})}return ProviderViewContext}(),ProviderElementContext=function(){function ProviderElementContext(viewContext,_parent,_isViewRoot,_directiveAsts,attrs,refs,isTemplate,contentQueryStartId,_sourceSpan){var _this=this;this.viewContext=viewContext,this._parent=_parent,this._isViewRoot=_isViewRoot,this._directiveAsts=_directiveAsts,this._sourceSpan=_sourceSpan,this._transformedProviders=new Map,this._seenProviders=new Map,this._queriedTokens=new Map,this.transformedHasViewContainer=!1,this._attrs={},attrs.forEach(function(attrAst){return _this._attrs[attrAst.name]=attrAst.value});var directivesMeta=_directiveAsts.map(function(directiveAst){return directiveAst.directive});if(this._allProviders=_resolveProvidersFromDirectives(directivesMeta,_sourceSpan,viewContext.errors),this._contentQueries=_getContentQueries(contentQueryStartId,directivesMeta),Array.from(this._allProviders.values()).forEach(function(provider){_this._addQueryReadsTo(provider.token,provider.token,_this._queriedTokens)}),isTemplate){var templateRefId=createTokenForExternalReference(this.viewContext.reflector,Identifiers.TemplateRef);this._addQueryReadsTo(templateRefId,templateRefId,this._queriedTokens)}refs.forEach(function(refAst){var defaultQueryValue=refAst.value||createTokenForExternalReference(_this.viewContext.reflector,Identifiers.ElementRef);_this._addQueryReadsTo({value:refAst.name},defaultQueryValue,_this._queriedTokens)}),this._queriedTokens.get(this.viewContext.reflector.resolveExternalReference(Identifiers.ViewContainerRef))&&(this.transformedHasViewContainer=!0),Array.from(this._allProviders.values()).forEach(function(provider){(provider.eager||_this._queriedTokens.get(tokenReference(provider.token)))&&_this._getOrCreateLocalProvider(provider.providerType,provider.token,!0)})}return ProviderElementContext.prototype.afterElement=function(){var _this=this;Array.from(this._allProviders.values()).forEach(function(provider){_this._getOrCreateLocalProvider(provider.providerType,provider.token,!1)})},Object.defineProperty(ProviderElementContext.prototype,"transformProviders",{get:function(){var lazyProviders=[],eagerProviders=[];return this._transformedProviders.forEach(function(provider){provider.eager?eagerProviders.push(provider):lazyProviders.push(provider)}),lazyProviders.concat(eagerProviders)},enumerable:!0,configurable:!0}),Object.defineProperty(ProviderElementContext.prototype,"transformedDirectiveAsts",{get:function(){var sortedProviderTypes=this.transformProviders.map(function(provider){return provider.token.identifier}),sortedDirectives=this._directiveAsts.slice();return sortedDirectives.sort(function(dir1,dir2){return sortedProviderTypes.indexOf(dir1.directive.type)-sortedProviderTypes.indexOf(dir2.directive.type)}),sortedDirectives},enumerable:!0,configurable:!0}),Object.defineProperty(ProviderElementContext.prototype,"queryMatches",{get:function(){var allMatches=[];return this._queriedTokens.forEach(function(matches){allMatches.push.apply(allMatches,matches)}),allMatches},enumerable:!0,configurable:!0}),ProviderElementContext.prototype._addQueryReadsTo=function(token,defaultValue,queryReadTokens){this._getQueriesFor(token).forEach(function(query){var queryValue=query.meta.read||defaultValue,tokenRef=tokenReference(queryValue),queryMatches=queryReadTokens.get(tokenRef);queryMatches||(queryMatches=[],queryReadTokens.set(tokenRef,queryMatches)),queryMatches.push({queryId:query.queryId,value:queryValue})})},ProviderElementContext.prototype._getQueriesFor=function(token){for(var queries,result=[],currentEl=this,distance=0;null!==currentEl;)queries=currentEl._contentQueries.get(tokenReference(token)),queries&&result.push.apply(result,queries.filter(function(query){return query.meta.descendants||distance<=1})),currentEl._directiveAsts.length>0&&distance++,currentEl=currentEl._parent;return queries=this.viewContext.viewQueries.get(tokenReference(token)),queries&&result.push.apply(result,queries),result},ProviderElementContext.prototype._getOrCreateLocalProvider=function(requestingProviderType,token,eager){var _this=this,resolvedProvider=this._allProviders.get(tokenReference(token));if(!resolvedProvider||(requestingProviderType===ProviderAstType.Directive||requestingProviderType===ProviderAstType.PublicService)&&resolvedProvider.providerType===ProviderAstType.PrivateService||(requestingProviderType===ProviderAstType.PrivateService||requestingProviderType===ProviderAstType.PublicService)&&resolvedProvider.providerType===ProviderAstType.Builtin)return null;var transformedProviderAst=this._transformedProviders.get(tokenReference(token));if(transformedProviderAst)return transformedProviderAst;if(null!=this._seenProviders.get(tokenReference(token)))return this.viewContext.errors.push(new ProviderError("Cannot instantiate cyclic dependency! "+tokenName(token),this._sourceSpan)),null;this._seenProviders.set(tokenReference(token),!0);var transformedProviders=resolvedProvider.providers.map(function(provider){var transformedUseValue=provider.useValue,transformedUseExisting=provider.useExisting,transformedDeps=void 0;if(null!=provider.useExisting){var existingDiDep=_this._getDependency(resolvedProvider.providerType,{token:provider.useExisting},eager);null!=existingDiDep.token?transformedUseExisting=existingDiDep.token:(transformedUseExisting=null,transformedUseValue=existingDiDep.value)}else if(provider.useFactory){var deps=provider.deps||provider.useFactory.diDeps;transformedDeps=deps.map(function(dep){return _this._getDependency(resolvedProvider.providerType,dep,eager)})}else if(provider.useClass){var deps=provider.deps||provider.useClass.diDeps;transformedDeps=deps.map(function(dep){return _this._getDependency(resolvedProvider.providerType,dep,eager)})}return _transformProvider(provider,{useExisting:transformedUseExisting,useValue:transformedUseValue,deps:transformedDeps})});return transformedProviderAst=_transformProviderAst(resolvedProvider,{eager:eager,providers:transformedProviders}),this._transformedProviders.set(tokenReference(token),transformedProviderAst),transformedProviderAst},ProviderElementContext.prototype._getLocalDependency=function(requestingProviderType,dep,eager){if(void 0===eager&&(eager=!1),dep.isAttribute){var attrValue=this._attrs[dep.token.value];return{isValue:!0,value:null==attrValue?null:attrValue}}if(null!=dep.token){if(requestingProviderType===ProviderAstType.Directive||requestingProviderType===ProviderAstType.Component){if(tokenReference(dep.token)===this.viewContext.reflector.resolveExternalReference(Identifiers.Renderer)||tokenReference(dep.token)===this.viewContext.reflector.resolveExternalReference(Identifiers.ElementRef)||tokenReference(dep.token)===this.viewContext.reflector.resolveExternalReference(Identifiers.ChangeDetectorRef)||tokenReference(dep.token)===this.viewContext.reflector.resolveExternalReference(Identifiers.TemplateRef))return dep;tokenReference(dep.token)===this.viewContext.reflector.resolveExternalReference(Identifiers.ViewContainerRef)&&(this.transformedHasViewContainer=!0)}if(tokenReference(dep.token)===this.viewContext.reflector.resolveExternalReference(Identifiers.Injector))return dep;if(null!=this._getOrCreateLocalProvider(requestingProviderType,dep.token,eager))return dep}return null},ProviderElementContext.prototype._getDependency=function(requestingProviderType,dep,eager){void 0===eager&&(eager=!1);var currElement=this,currEager=eager,result=null;if(dep.isSkipSelf||(result=this._getLocalDependency(requestingProviderType,dep,eager)),dep.isSelf)!result&&dep.isOptional&&(result={isValue:!0,value:null});else{for(;!result&&currElement._parent;){var prevElement=currElement;currElement=currElement._parent,prevElement._isViewRoot&&(currEager=!1),result=currElement._getLocalDependency(ProviderAstType.PublicService,dep,currEager)}result||(result=!dep.isHost||this.viewContext.component.isHost||this.viewContext.component.type.reference===tokenReference(dep.token)||null!=this.viewContext.viewProviders.get(tokenReference(dep.token))?dep:dep.isOptional?result={isValue:!0,value:null}:null)}return result||this.viewContext.errors.push(new ProviderError("No provider for "+tokenName(dep.token),this._sourceSpan)),result},ProviderElementContext}(),NgModuleProviderAnalyzer=function(){function NgModuleProviderAnalyzer(reflector,ngModule,extraProviders,sourceSpan){var _this=this;this.reflector=reflector,this._transformedProviders=new Map,this._seenProviders=new Map,this._errors=[],this._allProviders=new Map,ngModule.transitiveModule.modules.forEach(function(ngModuleType){_resolveProviders([{token:{identifier:ngModuleType},useClass:ngModuleType}],ProviderAstType.PublicService,!0,sourceSpan,_this._errors,_this._allProviders)}),_resolveProviders(ngModule.transitiveModule.providers.map(function(entry){return entry.provider}).concat(extraProviders),ProviderAstType.PublicService,!1,sourceSpan,this._errors,this._allProviders)}return NgModuleProviderAnalyzer.prototype.parse=function(){var _this=this;if(Array.from(this._allProviders.values()).forEach(function(provider){_this._getOrCreateLocalProvider(provider.token,provider.eager)}),this._errors.length>0){var errorString=this._errors.join("\n");throw new Error("Provider parse errors:\n"+errorString)}var lazyProviders=[],eagerProviders=[];return this._transformedProviders.forEach(function(provider){provider.eager?eagerProviders.push(provider):lazyProviders.push(provider)}),lazyProviders.concat(eagerProviders)},NgModuleProviderAnalyzer.prototype._getOrCreateLocalProvider=function(token,eager){var _this=this,resolvedProvider=this._allProviders.get(tokenReference(token));if(!resolvedProvider)return null;var transformedProviderAst=this._transformedProviders.get(tokenReference(token));if(transformedProviderAst)return transformedProviderAst;if(null!=this._seenProviders.get(tokenReference(token)))return this._errors.push(new ProviderError("Cannot instantiate cyclic dependency! "+tokenName(token),resolvedProvider.sourceSpan)),null;this._seenProviders.set(tokenReference(token),!0);var transformedProviders=resolvedProvider.providers.map(function(provider){var transformedUseValue=provider.useValue,transformedUseExisting=provider.useExisting,transformedDeps=void 0;if(null!=provider.useExisting){var existingDiDep=_this._getDependency({token:provider.useExisting},eager,resolvedProvider.sourceSpan);null!=existingDiDep.token?transformedUseExisting=existingDiDep.token:(transformedUseExisting=null,transformedUseValue=existingDiDep.value)}else if(provider.useFactory){var deps=provider.deps||provider.useFactory.diDeps;transformedDeps=deps.map(function(dep){return _this._getDependency(dep,eager,resolvedProvider.sourceSpan)})}else if(provider.useClass){var deps=provider.deps||provider.useClass.diDeps;transformedDeps=deps.map(function(dep){return _this._getDependency(dep,eager,resolvedProvider.sourceSpan)})}return _transformProvider(provider,{useExisting:transformedUseExisting,useValue:transformedUseValue,deps:transformedDeps})});return transformedProviderAst=_transformProviderAst(resolvedProvider,{eager:eager,providers:transformedProviders}),this._transformedProviders.set(tokenReference(token),transformedProviderAst),transformedProviderAst},NgModuleProviderAnalyzer.prototype._getDependency=function(dep,eager,requestorSourceSpan){void 0===eager&&(eager=!1);var foundLocal=!1;dep.isSkipSelf||null==dep.token||(tokenReference(dep.token)===this.reflector.resolveExternalReference(Identifiers.Injector)||tokenReference(dep.token)===this.reflector.resolveExternalReference(Identifiers.ComponentFactoryResolver)?foundLocal=!0:null!=this._getOrCreateLocalProvider(dep.token,eager)&&(foundLocal=!0));var result=dep;return dep.isSelf&&!foundLocal&&(dep.isOptional?result={isValue:!0,value:null}:this._errors.push(new ProviderError("No provider for "+tokenName(dep.token),requestorSourceSpan))),result},NgModuleProviderAnalyzer}(),_ValueOutputAstTransformer=function(){function _ValueOutputAstTransformer(ctx){this.ctx=ctx}return _ValueOutputAstTransformer.prototype.visitArray=function(arr,type){var _this=this;return literalArr(arr.map(function(value){return visitValue(value,_this,null)}),type)},_ValueOutputAstTransformer.prototype.visitStringMap=function(map,type){var _this=this,entries=[],quotedSet=new Set(map&&map.$quoted$);return Object.keys(map).forEach(function(key){entries.push(new LiteralMapEntry(key,visitValue(map[key],_this,null),quotedSet.has(key)))}),new LiteralMapExpr(entries,type)},_ValueOutputAstTransformer.prototype.visitPrimitive=function(value,type){return literal(value,type)},_ValueOutputAstTransformer.prototype.visitOther=function(value,type){return value instanceof Expression?value:this.ctx.importExpr(value)},_ValueOutputAstTransformer}(),NgModuleCompileResult=function(){function NgModuleCompileResult(ngModuleFactoryVar){this.ngModuleFactoryVar=ngModuleFactoryVar}return NgModuleCompileResult}(),LOG_VAR=variable("_l"),NgModuleCompiler=function(){function NgModuleCompiler(reflector){this.reflector=reflector}return NgModuleCompiler.prototype.compile=function(ctx,ngModuleMeta,extraProviders){var sourceSpan=typeSourceSpan("NgModule",ngModuleMeta.type),entryComponentFactories=ngModuleMeta.transitiveModule.entryComponents,bootstrapComponents=ngModuleMeta.bootstrapComponents,providerParser=new NgModuleProviderAnalyzer(this.reflector,ngModuleMeta,extraProviders,sourceSpan),providerDefs=[componentFactoryResolverProviderDef(this.reflector,ctx,0,entryComponentFactories)].concat(providerParser.parse().map(function(provider){return providerDef(ctx,provider)})).map(function(_a){var providerExpr=_a.providerExpr,depsExpr=_a.depsExpr,flags=_a.flags,tokenExpr=_a.tokenExpr;return importExpr(Identifiers.moduleProviderDef).callFn([literal(flags),tokenExpr,providerExpr,depsExpr])}),ngModuleDef=importExpr(Identifiers.moduleDef).callFn([literalArr(providerDefs)]),ngModuleDefFactory=fn([new FnParam(LOG_VAR.name)],[new ReturnStatement(ngModuleDef)],INFERRED_TYPE),ngModuleFactoryVar=identifierName(ngModuleMeta.type)+"NgFactory";if(this._createNgModuleFactory(ctx,ngModuleMeta.type.reference,importExpr(Identifiers.createModuleFactory).callFn([ctx.importExpr(ngModuleMeta.type.reference),literalArr(bootstrapComponents.map(function(id){return ctx.importExpr(id.reference)})),ngModuleDefFactory])),ngModuleMeta.id){var registerFactoryStmt=importExpr(Identifiers.RegisterModuleFactoryFn).callFn([literal(ngModuleMeta.id),variable(ngModuleFactoryVar)]).toStmt();ctx.statements.push(registerFactoryStmt)}return new NgModuleCompileResult(ngModuleFactoryVar)},NgModuleCompiler.prototype.createStub=function(ctx,ngModuleReference){this._createNgModuleFactory(ctx,ngModuleReference,NULL_EXPR)},NgModuleCompiler.prototype._createNgModuleFactory=function(ctx,reference,value){var ngModuleFactoryVar=identifierName({reference:reference})+"NgFactory",ngModuleFactoryStmt=variable(ngModuleFactoryVar).set(value).toDeclStmt(importType(Identifiers.NgModuleFactory,[expressionType(ctx.importExpr(reference))],[TypeModifier.Const]),[StmtModifier.Final,StmtModifier.Exported]);ctx.statements.push(ngModuleFactoryStmt)},NgModuleCompiler}(),NgModuleResolver=function(){function NgModuleResolver(_reflector){this._reflector=_reflector}return NgModuleResolver.prototype.isNgModule=function(type){return this._reflector.annotations(type).some(createNgModule.isTypeOf)},NgModuleResolver.prototype.resolve=function(type,throwIfNotFound){void 0===throwIfNotFound&&(throwIfNotFound=!0);var ngModuleMeta=findLast(this._reflector.annotations(type),createNgModule.isTypeOf);if(ngModuleMeta)return ngModuleMeta;if(throwIfNotFound)throw new Error("No NgModule metadata found for '"+stringify(type)+"'.");return null},NgModuleResolver}(),SourceMapGenerator=function(){function SourceMapGenerator(file){void 0===file&&(file=null),this.file=file,this.sourcesContent=new Map,this.lines=[],this.lastCol0=0,this.hasMappings=!1}return SourceMapGenerator.prototype.addSource=function(url,content){return void 0===content&&(content=null),this.sourcesContent.has(url)||this.sourcesContent.set(url,content),this},SourceMapGenerator.prototype.addLine=function(){return this.lines.push([]),this.lastCol0=0,this},SourceMapGenerator.prototype.addMapping=function(col0,sourceUrl,sourceLine0,sourceCol0){if(!this.currentLine)throw new Error("A line must be added before mappings can be added");if(null!=sourceUrl&&!this.sourcesContent.has(sourceUrl))throw new Error('Unknown source file "'+sourceUrl+'"');if(null==col0)throw new Error("The column in the generated code must be provided");if(col0<this.lastCol0)throw new Error("Mapping should be added in output order")
;if(sourceUrl&&(null==sourceLine0||null==sourceCol0))throw new Error("The source location must be provided when a source url is provided");return this.hasMappings=!0,this.lastCol0=col0,this.currentLine.push({col0:col0,sourceUrl:sourceUrl,sourceLine0:sourceLine0,sourceCol0:sourceCol0}),this},Object.defineProperty(SourceMapGenerator.prototype,"currentLine",{get:function(){return this.lines.slice(-1)[0]},enumerable:!0,configurable:!0}),SourceMapGenerator.prototype.toJSON=function(){var _this=this;if(!this.hasMappings)return null;var sourcesIndex=new Map,sources=[],sourcesContent=[];Array.from(this.sourcesContent.keys()).forEach(function(url,i){sourcesIndex.set(url,i),sources.push(url),sourcesContent.push(_this.sourcesContent.get(url)||null)});var mappings="",lastCol0=0,lastSourceIndex=0,lastSourceLine0=0,lastSourceCol0=0;return this.lines.forEach(function(segments){lastCol0=0,mappings+=segments.map(function(segment){var segAsStr=toBase64VLQ(segment.col0-lastCol0);return lastCol0=segment.col0,null!=segment.sourceUrl&&(segAsStr+=toBase64VLQ(sourcesIndex.get(segment.sourceUrl)-lastSourceIndex),lastSourceIndex=sourcesIndex.get(segment.sourceUrl),segAsStr+=toBase64VLQ(segment.sourceLine0-lastSourceLine0),lastSourceLine0=segment.sourceLine0,segAsStr+=toBase64VLQ(segment.sourceCol0-lastSourceCol0),lastSourceCol0=segment.sourceCol0),segAsStr}).join(","),mappings+=";"}),mappings=mappings.slice(0,-1),{file:this.file||"",version:3,sourceRoot:"",sources:sources,sourcesContent:sourcesContent,mappings:mappings}},SourceMapGenerator.prototype.toJsComment=function(){return this.hasMappings?"//# sourceMappingURL=data:application/json;base64,"+toBase64String(JSON.stringify(this,null,0)):""},SourceMapGenerator}(),B64_DIGITS="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/",_SINGLE_QUOTE_ESCAPE_STRING_RE=/'|\\|\n|\r|\$/g,_LEGAL_IDENTIFIER_RE=/^[$A-Z_][0-9A-Z_$]*$/i,_INDENT_WITH="  ",CATCH_ERROR_VAR$1=variable("error",null,null),CATCH_STACK_VAR$1=variable("stack",null,null),_EmittedLine=function(){function _EmittedLine(indent){this.indent=indent,this.partsLength=0,this.parts=[],this.srcSpans=[]}return _EmittedLine}(),EmitterVisitorContext=function(){function EmitterVisitorContext(_indent){this._indent=_indent,this._classes=[],this._preambleLineCount=0,this._lines=[new _EmittedLine(_indent)]}return EmitterVisitorContext.createRoot=function(){return new EmitterVisitorContext(0)},Object.defineProperty(EmitterVisitorContext.prototype,"_currentLine",{get:function(){return this._lines[this._lines.length-1]},enumerable:!0,configurable:!0}),EmitterVisitorContext.prototype.println=function(from,lastPart){void 0===lastPart&&(lastPart=""),this.print(from||null,lastPart,!0)},EmitterVisitorContext.prototype.lineIsEmpty=function(){return 0===this._currentLine.parts.length},EmitterVisitorContext.prototype.lineLength=function(){return this._currentLine.indent*_INDENT_WITH.length+this._currentLine.partsLength},EmitterVisitorContext.prototype.print=function(from,part,newLine){void 0===newLine&&(newLine=!1),part.length>0&&(this._currentLine.parts.push(part),this._currentLine.partsLength+=part.length,this._currentLine.srcSpans.push(from&&from.sourceSpan||null)),newLine&&this._lines.push(new _EmittedLine(this._indent))},EmitterVisitorContext.prototype.removeEmptyLastLine=function(){this.lineIsEmpty()&&this._lines.pop()},EmitterVisitorContext.prototype.incIndent=function(){this._indent++,this.lineIsEmpty()&&(this._currentLine.indent=this._indent)},EmitterVisitorContext.prototype.decIndent=function(){this._indent--,this.lineIsEmpty()&&(this._currentLine.indent=this._indent)},EmitterVisitorContext.prototype.pushClass=function(clazz){this._classes.push(clazz)},EmitterVisitorContext.prototype.popClass=function(){return this._classes.pop()},Object.defineProperty(EmitterVisitorContext.prototype,"currentClass",{get:function(){return this._classes.length>0?this._classes[this._classes.length-1]:null},enumerable:!0,configurable:!0}),EmitterVisitorContext.prototype.toSource=function(){return this.sourceLines.map(function(l){return l.parts.length>0?_createIndent(l.indent)+l.parts.join(""):""}).join("\n")},EmitterVisitorContext.prototype.toSourceMapGenerator=function(genFilePath,startsAtLine){void 0===startsAtLine&&(startsAtLine=0);for(var map=new SourceMapGenerator(genFilePath),firstOffsetMapped=!1,mapFirstOffsetIfNeeded=function(){firstOffsetMapped||(map.addSource(genFilePath," ").addMapping(0,genFilePath,0,0),firstOffsetMapped=!0)},i=0;i<startsAtLine;i++)map.addLine(),mapFirstOffsetIfNeeded();return this.sourceLines.forEach(function(line,lineIdx){map.addLine();for(var spans=line.srcSpans,parts=line.parts,col0=line.indent*_INDENT_WITH.length,spanIdx=0;spanIdx<spans.length&&!spans[spanIdx];)col0+=parts[spanIdx].length,spanIdx++;for(spanIdx<spans.length&&0===lineIdx&&0===col0?firstOffsetMapped=!0:mapFirstOffsetIfNeeded();spanIdx<spans.length;){var span=spans[spanIdx],source=span.start.file,sourceLine=span.start.line,sourceCol=span.start.col;for(map.addSource(source.url,source.content).addMapping(col0,source.url,sourceLine,sourceCol),col0+=parts[spanIdx].length,spanIdx++;spanIdx<spans.length&&(span===spans[spanIdx]||!spans[spanIdx]);)col0+=parts[spanIdx].length,spanIdx++}}),map},EmitterVisitorContext.prototype.setPreambleLineCount=function(count){return this._preambleLineCount=count},EmitterVisitorContext.prototype.spanOf=function(line,column){var emittedLine=this._lines[line-this._preambleLineCount];if(emittedLine)for(var columnsLeft=column-_createIndent(emittedLine.indent).length,partIndex=0;partIndex<emittedLine.parts.length;partIndex++){var part=emittedLine.parts[partIndex];if(part.length>columnsLeft)return emittedLine.srcSpans[partIndex];columnsLeft-=part.length}return null},Object.defineProperty(EmitterVisitorContext.prototype,"sourceLines",{get:function(){return this._lines.length&&0===this._lines[this._lines.length-1].parts.length?this._lines.slice(0,-1):this._lines},enumerable:!0,configurable:!0}),EmitterVisitorContext}(),AbstractEmitterVisitor=function(){function AbstractEmitterVisitor(_escapeDollarInStrings){this._escapeDollarInStrings=_escapeDollarInStrings}return AbstractEmitterVisitor.prototype.visitExpressionStmt=function(stmt,ctx){return stmt.expr.visitExpression(this,ctx),ctx.println(stmt,";"),null},AbstractEmitterVisitor.prototype.visitReturnStmt=function(stmt,ctx){return ctx.print(stmt,"return "),stmt.value.visitExpression(this,ctx),ctx.println(stmt,";"),null},AbstractEmitterVisitor.prototype.visitIfStmt=function(stmt,ctx){ctx.print(stmt,"if ("),stmt.condition.visitExpression(this,ctx),ctx.print(stmt,") {");var hasElseCase=null!=stmt.falseCase&&stmt.falseCase.length>0;return stmt.trueCase.length<=1&&!hasElseCase?(ctx.print(stmt," "),this.visitAllStatements(stmt.trueCase,ctx),ctx.removeEmptyLastLine(),ctx.print(stmt," ")):(ctx.println(),ctx.incIndent(),this.visitAllStatements(stmt.trueCase,ctx),ctx.decIndent(),hasElseCase&&(ctx.println(stmt,"} else {"),ctx.incIndent(),this.visitAllStatements(stmt.falseCase,ctx),ctx.decIndent())),ctx.println(stmt,"}"),null},AbstractEmitterVisitor.prototype.visitThrowStmt=function(stmt,ctx){return ctx.print(stmt,"throw "),stmt.error.visitExpression(this,ctx),ctx.println(stmt,";"),null},AbstractEmitterVisitor.prototype.visitCommentStmt=function(stmt,ctx){return stmt.comment.split("\n").forEach(function(line){ctx.println(stmt,"// "+line)}),null},AbstractEmitterVisitor.prototype.visitWriteVarExpr=function(expr,ctx){var lineWasEmpty=ctx.lineIsEmpty();return lineWasEmpty||ctx.print(expr,"("),ctx.print(expr,expr.name+" = "),expr.value.visitExpression(this,ctx),lineWasEmpty||ctx.print(expr,")"),null},AbstractEmitterVisitor.prototype.visitWriteKeyExpr=function(expr,ctx){var lineWasEmpty=ctx.lineIsEmpty();return lineWasEmpty||ctx.print(expr,"("),expr.receiver.visitExpression(this,ctx),ctx.print(expr,"["),expr.index.visitExpression(this,ctx),ctx.print(expr,"] = "),expr.value.visitExpression(this,ctx),lineWasEmpty||ctx.print(expr,")"),null},AbstractEmitterVisitor.prototype.visitWritePropExpr=function(expr,ctx){var lineWasEmpty=ctx.lineIsEmpty();return lineWasEmpty||ctx.print(expr,"("),expr.receiver.visitExpression(this,ctx),ctx.print(expr,"."+expr.name+" = "),expr.value.visitExpression(this,ctx),lineWasEmpty||ctx.print(expr,")"),null},AbstractEmitterVisitor.prototype.visitInvokeMethodExpr=function(expr,ctx){expr.receiver.visitExpression(this,ctx);var name=expr.name;return null!=expr.builtin&&null==(name=this.getBuiltinMethodName(expr.builtin))?null:(ctx.print(expr,"."+name+"("),this.visitAllExpressions(expr.args,ctx,","),ctx.print(expr,")"),null)},AbstractEmitterVisitor.prototype.visitInvokeFunctionExpr=function(expr,ctx){return expr.fn.visitExpression(this,ctx),ctx.print(expr,"("),this.visitAllExpressions(expr.args,ctx,","),ctx.print(expr,")"),null},AbstractEmitterVisitor.prototype.visitReadVarExpr=function(ast,ctx){var varName=ast.name;if(null!=ast.builtin)switch(ast.builtin){case BuiltinVar.Super:varName="super";break;case BuiltinVar.This:varName="this";break;case BuiltinVar.CatchError:varName=CATCH_ERROR_VAR$1.name;break;case BuiltinVar.CatchStack:varName=CATCH_STACK_VAR$1.name;break;default:throw new Error("Unknown builtin variable "+ast.builtin)}return ctx.print(ast,varName),null},AbstractEmitterVisitor.prototype.visitInstantiateExpr=function(ast,ctx){return ctx.print(ast,"new "),ast.classExpr.visitExpression(this,ctx),ctx.print(ast,"("),this.visitAllExpressions(ast.args,ctx,","),ctx.print(ast,")"),null},AbstractEmitterVisitor.prototype.visitLiteralExpr=function(ast,ctx){var value=ast.value;return"string"==typeof value?ctx.print(ast,escapeIdentifier(value,this._escapeDollarInStrings)):ctx.print(ast,""+value),null},AbstractEmitterVisitor.prototype.visitConditionalExpr=function(ast,ctx){return ctx.print(ast,"("),ast.condition.visitExpression(this,ctx),ctx.print(ast,"? "),ast.trueCase.visitExpression(this,ctx),ctx.print(ast,": "),ast.falseCase.visitExpression(this,ctx),ctx.print(ast,")"),null},AbstractEmitterVisitor.prototype.visitNotExpr=function(ast,ctx){return ctx.print(ast,"!"),ast.condition.visitExpression(this,ctx),null},AbstractEmitterVisitor.prototype.visitAssertNotNullExpr=function(ast,ctx){return ast.condition.visitExpression(this,ctx),null},AbstractEmitterVisitor.prototype.visitBinaryOperatorExpr=function(ast,ctx){var opStr;switch(ast.operator){case BinaryOperator.Equals:opStr="==";break;case BinaryOperator.Identical:opStr="===";break;case BinaryOperator.NotEquals:opStr="!=";break;case BinaryOperator.NotIdentical:opStr="!==";break;case BinaryOperator.And:opStr="&&";break;case BinaryOperator.Or:opStr="||";break;case BinaryOperator.Plus:opStr="+";break;case BinaryOperator.Minus:opStr="-";break;case BinaryOperator.Divide:opStr="/";break;case BinaryOperator.Multiply:opStr="*";break;case BinaryOperator.Modulo:opStr="%";break;case BinaryOperator.Lower:opStr="<";break;case BinaryOperator.LowerEquals:opStr="<=";break;case BinaryOperator.Bigger:opStr=">";break;case BinaryOperator.BiggerEquals:opStr=">=";break;default:throw new Error("Unknown operator "+ast.operator)}return ctx.print(ast,"("),ast.lhs.visitExpression(this,ctx),ctx.print(ast," "+opStr+" "),ast.rhs.visitExpression(this,ctx),ctx.print(ast,")"),null},AbstractEmitterVisitor.prototype.visitReadPropExpr=function(ast,ctx){return ast.receiver.visitExpression(this,ctx),ctx.print(ast,"."),ctx.print(ast,ast.name),null},AbstractEmitterVisitor.prototype.visitReadKeyExpr=function(ast,ctx){return ast.receiver.visitExpression(this,ctx),ctx.print(ast,"["),ast.index.visitExpression(this,ctx),ctx.print(ast,"]"),null},AbstractEmitterVisitor.prototype.visitLiteralArrayExpr=function(ast,ctx){return ctx.print(ast,"["),this.visitAllExpressions(ast.entries,ctx,","),ctx.print(ast,"]"),null},AbstractEmitterVisitor.prototype.visitLiteralMapExpr=function(ast,ctx){var _this=this;return ctx.print(ast,"{"),this.visitAllObjects(function(entry){ctx.print(ast,escapeIdentifier(entry.key,_this._escapeDollarInStrings,entry.quoted)+":"),entry.value.visitExpression(_this,ctx)},ast.entries,ctx,","),ctx.print(ast,"}"),null},AbstractEmitterVisitor.prototype.visitCommaExpr=function(ast,ctx){return ctx.print(ast,"("),this.visitAllExpressions(ast.parts,ctx,","),ctx.print(ast,")"),null},AbstractEmitterVisitor.prototype.visitAllExpressions=function(expressions,ctx,separator){var _this=this;this.visitAllObjects(function(expr){return expr.visitExpression(_this,ctx)},expressions,ctx,separator)},AbstractEmitterVisitor.prototype.visitAllObjects=function(handler,expressions,ctx,separator){for(var incrementedIndent=!1,i=0;i<expressions.length;i++)i>0&&(ctx.lineLength()>80?(ctx.print(null,separator,!0),incrementedIndent||(ctx.incIndent(),ctx.incIndent(),incrementedIndent=!0)):ctx.print(null,separator,!1)),handler(expressions[i]);incrementedIndent&&(ctx.decIndent(),ctx.decIndent())},AbstractEmitterVisitor.prototype.visitAllStatements=function(statements,ctx){var _this=this;statements.forEach(function(stmt){return stmt.visitStatement(_this,ctx)})},AbstractEmitterVisitor}(),TypeScriptEmitter=function(){function TypeScriptEmitter(){}return TypeScriptEmitter.prototype.emitStatementsAndContext=function(genFilePath,stmts,preamble,emitSourceMaps,referenceFilter){void 0===preamble&&(preamble=""),void 0===emitSourceMaps&&(emitSourceMaps=!0);var converter=new _TsEmitterVisitor(referenceFilter),ctx=EmitterVisitorContext.createRoot();converter.visitAllStatements(stmts,ctx);var preambleLines=preamble?preamble.split("\n"):[];converter.reexports.forEach(function(reexports,exportedModuleName){var reexportsCode=reexports.map(function(reexport){return reexport.name+" as "+reexport.as}).join(",");preambleLines.push("export {"+reexportsCode+"} from '"+exportedModuleName+"';")}),converter.importsWithPrefixes.forEach(function(prefix,importedModuleName){preambleLines.push("import * as "+prefix+" from '"+importedModuleName+"';")});var sm=emitSourceMaps?ctx.toSourceMapGenerator(genFilePath,preambleLines.length).toJsComment():"",lines=preambleLines.concat([ctx.toSource(),sm]);return sm&&lines.push(""),ctx.setPreambleLineCount(preambleLines.length),{sourceText:lines.join("\n"),context:ctx}},TypeScriptEmitter.prototype.emitStatements=function(genFilePath,stmts,preamble){return void 0===preamble&&(preamble=""),this.emitStatementsAndContext(genFilePath,stmts,preamble).sourceText},TypeScriptEmitter}(),_TsEmitterVisitor=function(_super){function _TsEmitterVisitor(referenceFilter){var _this=_super.call(this,!1)||this;return _this.referenceFilter=referenceFilter,_this.typeExpression=0,_this.importsWithPrefixes=new Map,_this.reexports=new Map,_this}return __extends(_TsEmitterVisitor,_super),_TsEmitterVisitor.prototype.visitType=function(t,ctx,defaultType){void 0===defaultType&&(defaultType="any"),t?(this.typeExpression++,t.visitType(this,ctx),this.typeExpression--):ctx.print(null,defaultType)},_TsEmitterVisitor.prototype.visitLiteralExpr=function(ast,ctx){var value=ast.value;return null==value&&ast.type!=INFERRED_TYPE?(ctx.print(ast,"("+value+" as any)"),null):_super.prototype.visitLiteralExpr.call(this,ast,ctx)},_TsEmitterVisitor.prototype.visitLiteralArrayExpr=function(ast,ctx){0===ast.entries.length&&ctx.print(ast,"(");var result=_super.prototype.visitLiteralArrayExpr.call(this,ast,ctx);return 0===ast.entries.length&&ctx.print(ast," as any[])"),result},_TsEmitterVisitor.prototype.visitExternalExpr=function(ast,ctx){return this._visitIdentifier(ast.value,ast.typeParams,ctx),null},_TsEmitterVisitor.prototype.visitAssertNotNullExpr=function(ast,ctx){var result=_super.prototype.visitAssertNotNullExpr.call(this,ast,ctx);return ctx.print(ast,"!"),result},_TsEmitterVisitor.prototype.visitDeclareVarStmt=function(stmt,ctx){if(stmt.hasModifier(StmtModifier.Exported)&&stmt.value instanceof ExternalExpr&&!stmt.type){var _a=stmt.value.value,name_1=_a.name,moduleName=_a.moduleName;if(moduleName){var reexports=this.reexports.get(moduleName);return reexports||(reexports=[],this.reexports.set(moduleName,reexports)),reexports.push({name:name_1,as:stmt.name}),null}}return stmt.hasModifier(StmtModifier.Exported)&&ctx.print(stmt,"export "),stmt.hasModifier(StmtModifier.Final)?ctx.print(stmt,"const"):ctx.print(stmt,"var"),ctx.print(stmt," "+stmt.name),this._printColonType(stmt.type,ctx),ctx.print(stmt," = "),stmt.value.visitExpression(this,ctx),ctx.println(stmt,";"),null},_TsEmitterVisitor.prototype.visitCastExpr=function(ast,ctx){return ctx.print(ast,"(<"),ast.type.visitType(this,ctx),ctx.print(ast,">"),ast.value.visitExpression(this,ctx),ctx.print(ast,")"),null},_TsEmitterVisitor.prototype.visitInstantiateExpr=function(ast,ctx){return ctx.print(ast,"new "),this.typeExpression++,ast.classExpr.visitExpression(this,ctx),this.typeExpression--,ctx.print(ast,"("),this.visitAllExpressions(ast.args,ctx,","),ctx.print(ast,")"),null},_TsEmitterVisitor.prototype.visitDeclareClassStmt=function(stmt,ctx){var _this=this;return ctx.pushClass(stmt),stmt.hasModifier(StmtModifier.Exported)&&ctx.print(stmt,"export "),ctx.print(stmt,"class "+stmt.name),null!=stmt.parent&&(ctx.print(stmt," extends "),this.typeExpression++,stmt.parent.visitExpression(this,ctx),this.typeExpression--),ctx.println(stmt," {"),ctx.incIndent(),stmt.fields.forEach(function(field){return _this._visitClassField(field,ctx)}),null!=stmt.constructorMethod&&this._visitClassConstructor(stmt,ctx),stmt.getters.forEach(function(getter){return _this._visitClassGetter(getter,ctx)}),stmt.methods.forEach(function(method){return _this._visitClassMethod(method,ctx)}),ctx.decIndent(),ctx.println(stmt,"}"),ctx.popClass(),null},_TsEmitterVisitor.prototype._visitClassField=function(field,ctx){field.hasModifier(StmtModifier.Private)&&ctx.print(null,"/*private*/ "),ctx.print(null,field.name),this._printColonType(field.type,ctx),ctx.println(null,";")},_TsEmitterVisitor.prototype._visitClassGetter=function(getter,ctx){getter.hasModifier(StmtModifier.Private)&&ctx.print(null,"private "),ctx.print(null,"get "+getter.name+"()"),this._printColonType(getter.type,ctx),ctx.println(null," {"),ctx.incIndent(),this.visitAllStatements(getter.body,ctx),ctx.decIndent(),ctx.println(null,"}")},_TsEmitterVisitor.prototype._visitClassConstructor=function(stmt,ctx){ctx.print(stmt,"constructor("),this._visitParams(stmt.constructorMethod.params,ctx),ctx.println(stmt,") {"),ctx.incIndent(),this.visitAllStatements(stmt.constructorMethod.body,ctx),ctx.decIndent(),ctx.println(stmt,"}")},_TsEmitterVisitor.prototype._visitClassMethod=function(method,ctx){method.hasModifier(StmtModifier.Private)&&ctx.print(null,"private "),ctx.print(null,method.name+"("),this._visitParams(method.params,ctx),ctx.print(null,")"),this._printColonType(method.type,ctx,"void"),ctx.println(null," {"),ctx.incIndent(),this.visitAllStatements(method.body,ctx),ctx.decIndent(),ctx.println(null,"}")},_TsEmitterVisitor.prototype.visitFunctionExpr=function(ast,ctx){return ctx.print(ast,"("),this._visitParams(ast.params,ctx),ctx.print(ast,")"),this._printColonType(ast.type,ctx,"void"),ctx.println(ast," => {"),ctx.incIndent(),this.visitAllStatements(ast.statements,ctx),ctx.decIndent(),ctx.print(ast,"}"),null},_TsEmitterVisitor.prototype.visitDeclareFunctionStmt=function(stmt,ctx){return stmt.hasModifier(StmtModifier.Exported)&&ctx.print(stmt,"export "),ctx.print(stmt,"function "+stmt.name+"("),this._visitParams(stmt.params,ctx),ctx.print(stmt,")"),this._printColonType(stmt.type,ctx,"void"),ctx.println(stmt," {"),ctx.incIndent(),this.visitAllStatements(stmt.statements,ctx),ctx.decIndent(),ctx.println(stmt,"}"),null},_TsEmitterVisitor.prototype.visitTryCatchStmt=function(stmt,ctx){ctx.println(stmt,"try {"),ctx.incIndent(),this.visitAllStatements(stmt.bodyStmts,ctx),ctx.decIndent(),ctx.println(stmt,"} catch ("+CATCH_ERROR_VAR$1.name+") {"),ctx.incIndent();var catchStmts=[CATCH_STACK_VAR$1.set(CATCH_ERROR_VAR$1.prop("stack",null)).toDeclStmt(null,[StmtModifier.Final])].concat(stmt.catchStmts);return this.visitAllStatements(catchStmts,ctx),ctx.decIndent(),ctx.println(stmt,"}"),null},_TsEmitterVisitor.prototype.visitBuiltintType=function(type,ctx){var typeStr;switch(type.name){case BuiltinTypeName.Bool:typeStr="boolean";break;case BuiltinTypeName.Dynamic:typeStr="any";break;case BuiltinTypeName.Function:typeStr="Function";break;case BuiltinTypeName.Number:case BuiltinTypeName.Int:typeStr="number";break;case BuiltinTypeName.String:typeStr="string";break;default:throw new Error("Unsupported builtin type "+type.name)}return ctx.print(null,typeStr),null},_TsEmitterVisitor.prototype.visitExpressionType=function(ast,ctx){return ast.value.visitExpression(this,ctx),null},_TsEmitterVisitor.prototype.visitArrayType=function(type,ctx){return this.visitType(type.of,ctx),ctx.print(null,"[]"),null},_TsEmitterVisitor.prototype.visitMapType=function(type,ctx){return ctx.print(null,"{[key: string]:"),this.visitType(type.valueType,ctx),ctx.print(null,"}"),null},_TsEmitterVisitor.prototype.getBuiltinMethodName=function(method){var name;switch(method){case BuiltinMethod.ConcatArray:name="concat";break;case BuiltinMethod.SubscribeObservable:name="subscribe";break;case BuiltinMethod.Bind:name="bind";break;default:throw new Error("Unknown builtin method: "+method)}return name},_TsEmitterVisitor.prototype._visitParams=function(params,ctx){var _this=this;this.visitAllObjects(function(param){ctx.print(null,param.name),_this._printColonType(param.type,ctx)},params,ctx,",")},_TsEmitterVisitor.prototype._visitIdentifier=function(value,typeParams,ctx){var _this=this,name=value.name,moduleName=value.moduleName;if(this.referenceFilter&&this.referenceFilter(value))return void ctx.print(null,"(null as any)");if(moduleName){var prefix=this.importsWithPrefixes.get(moduleName);null==prefix&&(prefix="i"+this.importsWithPrefixes.size,this.importsWithPrefixes.set(moduleName,prefix)),ctx.print(null,prefix+".")}if(ctx.print(null,name),this.typeExpression>0){(typeParams||[]).length>0&&(ctx.print(null,"<"),this.visitAllObjects(function(type){return type.visitType(_this,ctx)},typeParams,ctx,","),ctx.print(null,">"))}},_TsEmitterVisitor.prototype._printColonType=function(type,ctx,defaultType){type!==INFERRED_TYPE&&(ctx.print(null,":"),this.visitType(type,ctx,defaultType))},_TsEmitterVisitor}(AbstractEmitterVisitor),PipeResolver=function(){function PipeResolver(_reflector){this._reflector=_reflector}return PipeResolver.prototype.isPipe=function(type){var typeMetadata=this._reflector.annotations(resolveForwardRef(type));return typeMetadata&&typeMetadata.some(createPipe.isTypeOf)},PipeResolver.prototype.resolve=function(type,throwIfNotFound){void 0===throwIfNotFound&&(throwIfNotFound=!0);var metas=this._reflector.annotations(resolveForwardRef(type));if(metas){var annotation=findLast(metas,createPipe.isTypeOf);if(annotation)return annotation}if(throwIfNotFound)throw new Error("No Pipe decorator found on "+stringify(type));return null},PipeResolver}(),SECURITY_SCHEMA={};registerContext(SecurityContext.HTML,["iframe|srcdoc","*|innerHTML","*|outerHTML"]),registerContext(SecurityContext.STYLE,["*|style"]),registerContext(SecurityContext.URL,["*|formAction","area|href","area|ping","audio|src","a|href","a|ping","blockquote|cite","body|background","del|cite","form|action","img|src","img|srcset","input|src","ins|cite","q|cite","source|src","source|srcset","track|src","video|poster","video|src"]),registerContext(SecurityContext.RESOURCE_URL,["applet|code","applet|codebase","base|href","embed|src","frame|src","head|profile","html|manifest","iframe|src","link|href","media|src","object|codebase","object|data","script|src"]);/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
var ElementSchemaRegistry=function(){function ElementSchemaRegistry(){}return ElementSchemaRegistry}(),BOOLEAN="boolean",NUMBER="number",STRING="string",OBJECT="object",SCHEMA=["[Element]|textContent,%classList,className,id,innerHTML,*beforecopy,*beforecut,*beforepaste,*copy,*cut,*paste,*search,*selectstart,*webkitfullscreenchange,*webkitfullscreenerror,*wheel,outerHTML,#scrollLeft,#scrollTop,slot,*message,*mozfullscreenchange,*mozfullscreenerror,*mozpointerlockchange,*mozpointerlockerror,*webglcontextcreationerror,*webglcontextlost,*webglcontextrestored","[HTMLElement]^[Element]|accessKey,contentEditable,dir,!draggable,!hidden,innerText,lang,*abort,*auxclick,*blur,*cancel,*canplay,*canplaythrough,*change,*click,*close,*contextmenu,*cuechange,*dblclick,*drag,*dragend,*dragenter,*dragleave,*dragover,*dragstart,*drop,*durationchange,*emptied,*ended,*error,*focus,*gotpointercapture,*input,*invalid,*keydown,*keypress,*keyup,*load,*loadeddata,*loadedmetadata,*loadstart,*lostpointercapture,*mousedown,*mouseenter,*mouseleave,*mousemove,*mouseout,*mouseover,*mouseup,*mousewheel,*pause,*play,*playing,*pointercancel,*pointerdown,*pointerenter,*pointerleave,*pointermove,*pointerout,*pointerover,*pointerup,*progress,*ratechange,*reset,*resize,*scroll,*seeked,*seeking,*select,*show,*stalled,*submit,*suspend,*timeupdate,*toggle,*volumechange,*waiting,outerText,!spellcheck,%style,#tabIndex,title,!translate","abbr,address,article,aside,b,bdi,bdo,cite,code,dd,dfn,dt,em,figcaption,figure,footer,header,i,kbd,main,mark,nav,noscript,rb,rp,rt,rtc,ruby,s,samp,section,small,strong,sub,sup,u,var,wbr^[HTMLElement]|accessKey,contentEditable,dir,!draggable,!hidden,innerText,lang,*abort,*auxclick,*blur,*cancel,*canplay,*canplaythrough,*change,*click,*close,*contextmenu,*cuechange,*dblclick,*drag,*dragend,*dragenter,*dragleave,*dragover,*dragstart,*drop,*durationchange,*emptied,*ended,*error,*focus,*gotpointercapture,*input,*invalid,*keydown,*keypress,*keyup,*load,*loadeddata,*loadedmetadata,*loadstart,*lostpointercapture,*mousedown,*mouseenter,*mouseleave,*mousemove,*mouseout,*mouseover,*mouseup,*mousewheel,*pause,*play,*playing,*pointercancel,*pointerdown,*pointerenter,*pointerleave,*pointermove,*pointerout,*pointerover,*pointerup,*progress,*ratechange,*reset,*resize,*scroll,*seeked,*seeking,*select,*show,*stalled,*submit,*suspend,*timeupdate,*toggle,*volumechange,*waiting,outerText,!spellcheck,%style,#tabIndex,title,!translate","media^[HTMLElement]|!autoplay,!controls,%controlsList,%crossOrigin,#currentTime,!defaultMuted,#defaultPlaybackRate,!disableRemotePlayback,!loop,!muted,*encrypted,*waitingforkey,#playbackRate,preload,src,%srcObject,#volume",":svg:^[HTMLElement]|*abort,*auxclick,*blur,*cancel,*canplay,*canplaythrough,*change,*click,*close,*contextmenu,*cuechange,*dblclick,*drag,*dragend,*dragenter,*dragleave,*dragover,*dragstart,*drop,*durationchange,*emptied,*ended,*error,*focus,*gotpointercapture,*input,*invalid,*keydown,*keypress,*keyup,*load,*loadeddata,*loadedmetadata,*loadstart,*lostpointercapture,*mousedown,*mouseenter,*mouseleave,*mousemove,*mouseout,*mouseover,*mouseup,*mousewheel,*pause,*play,*playing,*pointercancel,*pointerdown,*pointerenter,*pointerleave,*pointermove,*pointerout,*pointerover,*pointerup,*progress,*ratechange,*reset,*resize,*scroll,*seeked,*seeking,*select,*show,*stalled,*submit,*suspend,*timeupdate,*toggle,*volumechange,*waiting,%style,#tabIndex",":svg:graphics^:svg:|",":svg:animation^:svg:|*begin,*end,*repeat",":svg:geometry^:svg:|",":svg:componentTransferFunction^:svg:|",":svg:gradient^:svg:|",":svg:textContent^:svg:graphics|",":svg:textPositioning^:svg:textContent|","a^[HTMLElement]|charset,coords,download,hash,host,hostname,href,hreflang,name,password,pathname,ping,port,protocol,referrerPolicy,rel,rev,search,shape,target,text,type,username","area^[HTMLElement]|alt,coords,download,hash,host,hostname,href,!noHref,password,pathname,ping,port,protocol,referrerPolicy,rel,search,shape,target,username","audio^media|","br^[HTMLElement]|clear","base^[HTMLElement]|href,target","body^[HTMLElement]|aLink,background,bgColor,link,*beforeunload,*blur,*error,*focus,*hashchange,*languagechange,*load,*message,*offline,*online,*pagehide,*pageshow,*popstate,*rejectionhandled,*resize,*scroll,*storage,*unhandledrejection,*unload,text,vLink","button^[HTMLElement]|!autofocus,!disabled,formAction,formEnctype,formMethod,!formNoValidate,formTarget,name,type,value","canvas^[HTMLElement]|#height,#width","content^[HTMLElement]|select","dl^[HTMLElement]|!compact","datalist^[HTMLElement]|","details^[HTMLElement]|!open","dialog^[HTMLElement]|!open,returnValue","dir^[HTMLElement]|!compact","div^[HTMLElement]|align","embed^[HTMLElement]|align,height,name,src,type,width","fieldset^[HTMLElement]|!disabled,name","font^[HTMLElement]|color,face,size","form^[HTMLElement]|acceptCharset,action,autocomplete,encoding,enctype,method,name,!noValidate,target","frame^[HTMLElement]|frameBorder,longDesc,marginHeight,marginWidth,name,!noResize,scrolling,src","frameset^[HTMLElement]|cols,*beforeunload,*blur,*error,*focus,*hashchange,*languagechange,*load,*message,*offline,*online,*pagehide,*pageshow,*popstate,*rejectionhandled,*resize,*scroll,*storage,*unhandledrejection,*unload,rows","hr^[HTMLElement]|align,color,!noShade,size,width","head^[HTMLElement]|","h1,h2,h3,h4,h5,h6^[HTMLElement]|align","html^[HTMLElement]|version","iframe^[HTMLElement]|align,!allowFullscreen,frameBorder,height,longDesc,marginHeight,marginWidth,name,referrerPolicy,%sandbox,scrolling,src,srcdoc,width","img^[HTMLElement]|align,alt,border,%crossOrigin,#height,#hspace,!isMap,longDesc,lowsrc,name,referrerPolicy,sizes,src,srcset,useMap,#vspace,#width","input^[HTMLElement]|accept,align,alt,autocapitalize,autocomplete,!autofocus,!checked,!defaultChecked,defaultValue,dirName,!disabled,%files,formAction,formEnctype,formMethod,!formNoValidate,formTarget,#height,!incremental,!indeterminate,max,#maxLength,min,#minLength,!multiple,name,pattern,placeholder,!readOnly,!required,selectionDirection,#selectionEnd,#selectionStart,#size,src,step,type,useMap,value,%valueAsDate,#valueAsNumber,#width","li^[HTMLElement]|type,#value","label^[HTMLElement]|htmlFor","legend^[HTMLElement]|align","link^[HTMLElement]|as,charset,%crossOrigin,!disabled,href,hreflang,integrity,media,referrerPolicy,rel,%relList,rev,%sizes,target,type","map^[HTMLElement]|name","marquee^[HTMLElement]|behavior,bgColor,direction,height,#hspace,#loop,#scrollAmount,#scrollDelay,!trueSpeed,#vspace,width","menu^[HTMLElement]|!compact","meta^[HTMLElement]|content,httpEquiv,name,scheme","meter^[HTMLElement]|#high,#low,#max,#min,#optimum,#value","ins,del^[HTMLElement]|cite,dateTime","ol^[HTMLElement]|!compact,!reversed,#start,type","object^[HTMLElement]|align,archive,border,code,codeBase,codeType,data,!declare,height,#hspace,name,standby,type,useMap,#vspace,width","optgroup^[HTMLElement]|!disabled,label","option^[HTMLElement]|!defaultSelected,!disabled,label,!selected,text,value","output^[HTMLElement]|defaultValue,%htmlFor,name,value","p^[HTMLElement]|align","param^[HTMLElement]|name,type,value,valueType","picture^[HTMLElement]|","pre^[HTMLElement]|#width","progress^[HTMLElement]|#max,#value","q,blockquote,cite^[HTMLElement]|","script^[HTMLElement]|!async,charset,%crossOrigin,!defer,event,htmlFor,integrity,src,text,type","select^[HTMLElement]|!autofocus,!disabled,#length,!multiple,name,!required,#selectedIndex,#size,value","shadow^[HTMLElement]|","slot^[HTMLElement]|name","source^[HTMLElement]|media,sizes,src,srcset,type","span^[HTMLElement]|","style^[HTMLElement]|!disabled,media,type","caption^[HTMLElement]|align","th,td^[HTMLElement]|abbr,align,axis,bgColor,ch,chOff,#colSpan,headers,height,!noWrap,#rowSpan,scope,vAlign,width","col,colgroup^[HTMLElement]|align,ch,chOff,#span,vAlign,width","table^[HTMLElement]|align,bgColor,border,%caption,cellPadding,cellSpacing,frame,rules,summary,%tFoot,%tHead,width","tr^[HTMLElement]|align,bgColor,ch,chOff,vAlign","tfoot,thead,tbody^[HTMLElement]|align,ch,chOff,vAlign","template^[HTMLElement]|","textarea^[HTMLElement]|autocapitalize,!autofocus,#cols,defaultValue,dirName,!disabled,#maxLength,#minLength,name,placeholder,!readOnly,!required,#rows,selectionDirection,#selectionEnd,#selectionStart,value,wrap","title^[HTMLElement]|text","track^[HTMLElement]|!default,kind,label,src,srclang","ul^[HTMLElement]|!compact,type","unknown^[HTMLElement]|","video^media|#height,poster,#width",":svg:a^:svg:graphics|",":svg:animate^:svg:animation|",":svg:animateMotion^:svg:animation|",":svg:animateTransform^:svg:animation|",":svg:circle^:svg:geometry|",":svg:clipPath^:svg:graphics|",":svg:defs^:svg:graphics|",":svg:desc^:svg:|",":svg:discard^:svg:|",":svg:ellipse^:svg:geometry|",":svg:feBlend^:svg:|",":svg:feColorMatrix^:svg:|",":svg:feComponentTransfer^:svg:|",":svg:feComposite^:svg:|",":svg:feConvolveMatrix^:svg:|",":svg:feDiffuseLighting^:svg:|",":svg:feDisplacementMap^:svg:|",":svg:feDistantLight^:svg:|",":svg:feDropShadow^:svg:|",":svg:feFlood^:svg:|",":svg:feFuncA^:svg:componentTransferFunction|",":svg:feFuncB^:svg:componentTransferFunction|",":svg:feFuncG^:svg:componentTransferFunction|",":svg:feFuncR^:svg:componentTransferFunction|",":svg:feGaussianBlur^:svg:|",":svg:feImage^:svg:|",":svg:feMerge^:svg:|",":svg:feMergeNode^:svg:|",":svg:feMorphology^:svg:|",":svg:feOffset^:svg:|",":svg:fePointLight^:svg:|",":svg:feSpecularLighting^:svg:|",":svg:feSpotLight^:svg:|",":svg:feTile^:svg:|",":svg:feTurbulence^:svg:|",":svg:filter^:svg:|",":svg:foreignObject^:svg:graphics|",":svg:g^:svg:graphics|",":svg:image^:svg:graphics|",":svg:line^:svg:geometry|",":svg:linearGradient^:svg:gradient|",":svg:mpath^:svg:|",":svg:marker^:svg:|",":svg:mask^:svg:|",":svg:metadata^:svg:|",":svg:path^:svg:geometry|",":svg:pattern^:svg:|",":svg:polygon^:svg:geometry|",":svg:polyline^:svg:geometry|",":svg:radialGradient^:svg:gradient|",":svg:rect^:svg:geometry|",":svg:svg^:svg:graphics|#currentScale,#zoomAndPan",":svg:script^:svg:|type",":svg:set^:svg:animation|",":svg:stop^:svg:|",":svg:style^:svg:|!disabled,media,title,type",":svg:switch^:svg:graphics|",":svg:symbol^:svg:|",":svg:tspan^:svg:textPositioning|",":svg:text^:svg:textPositioning|",":svg:textPath^:svg:textContent|",":svg:title^:svg:|",":svg:use^:svg:graphics|",":svg:view^:svg:|#zoomAndPan","data^[HTMLElement]|value","keygen^[HTMLElement]|!autofocus,challenge,!disabled,form,keytype,name","menuitem^[HTMLElement]|type,label,icon,!disabled,!checked,radiogroup,!default","summary^[HTMLElement]|","time^[HTMLElement]|dateTime",":svg:cursor^:svg:|"],_ATTR_TO_PROP={class:"className",for:"htmlFor",formaction:"formAction",innerHtml:"innerHTML",readonly:"readOnly",tabindex:"tabIndex"},DomElementSchemaRegistry=function(_super){function DomElementSchemaRegistry(){var _this=_super.call(this)||this;return _this._schema={},SCHEMA.forEach(function(encodedType){var type={},_a=encodedType.split("|"),strType=_a[0],strProperties=_a[1],properties=strProperties.split(","),_b=strType.split("^"),typeNames=_b[0],superName=_b[1];typeNames.split(",").forEach(function(tag){return _this._schema[tag.toLowerCase()]=type});var superType=superName&&_this._schema[superName.toLowerCase()];superType&&Object.keys(superType).forEach(function(prop){type[prop]=superType[prop]}),properties.forEach(function(property){if(property.length>0)switch(property[0]){case"*":break;case"!":type[property.substring(1)]=BOOLEAN;break;case"#":type[property.substring(1)]=NUMBER;break;case"%":type[property.substring(1)]=OBJECT;break;default:type[property]=STRING}})}),_this}return __extends(DomElementSchemaRegistry,_super),DomElementSchemaRegistry.prototype.hasProperty=function(tagName,propName,schemaMetas){if(schemaMetas.some(function(schema){return schema.name===NO_ERRORS_SCHEMA.name}))return!0;if(tagName.indexOf("-")>-1){if(isNgContainer(tagName)||isNgContent(tagName))return!1;if(schemaMetas.some(function(schema){return schema.name===CUSTOM_ELEMENTS_SCHEMA.name}))return!0}return!!(this._schema[tagName.toLowerCase()]||this._schema.unknown)[propName]},DomElementSchemaRegistry.prototype.hasElement=function(tagName,schemaMetas){if(schemaMetas.some(function(schema){return schema.name===NO_ERRORS_SCHEMA.name}))return!0;if(tagName.indexOf("-")>-1){if(isNgContainer(tagName)||isNgContent(tagName))return!0;if(schemaMetas.some(function(schema){return schema.name===CUSTOM_ELEMENTS_SCHEMA.name}))return!0}return!!this._schema[tagName.toLowerCase()]},DomElementSchemaRegistry.prototype.securityContext=function(tagName,propName,isAttribute){isAttribute&&(propName=this.getMappedPropName(propName)),tagName=tagName.toLowerCase(),propName=propName.toLowerCase();var ctx=SECURITY_SCHEMA[tagName+"|"+propName];return ctx||((ctx=SECURITY_SCHEMA["*|"+propName])||SecurityContext.NONE)},DomElementSchemaRegistry.prototype.getMappedPropName=function(propName){return _ATTR_TO_PROP[propName]||propName},DomElementSchemaRegistry.prototype.getDefaultComponentElementName=function(){return"ng-component"},DomElementSchemaRegistry.prototype.validateProperty=function(name){if(name.toLowerCase().startsWith("on")){return{error:!0,msg:"Binding to event property '"+name+"' is disallowed for security reasons, please use ("+name.slice(2)+")=...\nIf '"+name+"' is a directive input, make sure the directive is imported by the current module."}}return{error:!1}},DomElementSchemaRegistry.prototype.validateAttribute=function(name){if(name.toLowerCase().startsWith("on")){return{error:!0,msg:"Binding to event attribute '"+name+"' is disallowed for security reasons, please use ("+name.slice(2)+")=..."}}return{error:!1}},DomElementSchemaRegistry.prototype.allKnownElementNames=function(){return Object.keys(this._schema)},DomElementSchemaRegistry.prototype.normalizeAnimationStyleProperty=function(propName){return dashCaseToCamelCase(propName)},DomElementSchemaRegistry.prototype.normalizeAnimationStyleValue=function(camelCaseProp,userProvidedProp,val){var unit="",strVal=val.toString().trim(),errorMsg=null;if(_isPixelDimensionStyle(camelCaseProp)&&0!==val&&"0"!==val)if("number"==typeof val)unit="px";else{var valAndSuffixMatch=val.match(/^[+-]?[\d\.]+([a-z]*)$/);valAndSuffixMatch&&0==valAndSuffixMatch[1].length&&(errorMsg="Please provide a CSS unit value for "+userProvidedProp+":"+val)}return{error:errorMsg,value:strVal+unit}},DomElementSchemaRegistry}(ElementSchemaRegistry),ShadowCss=function(){function ShadowCss(){this.strictStyling=!0}return ShadowCss.prototype.shimCssText=function(cssText,selector,hostSelector){void 0===hostSelector&&(hostSelector="");var commentsWithHash=extractCommentsWithHash(cssText);return cssText=stripComments(cssText),cssText=this._insertDirectives(cssText),[this._scopeCssText(cssText,selector,hostSelector)].concat(commentsWithHash).join("\n")},ShadowCss.prototype._insertDirectives=function(cssText){return cssText=this._insertPolyfillDirectivesInCssText(cssText),this._insertPolyfillRulesInCssText(cssText)},ShadowCss.prototype._insertPolyfillDirectivesInCssText=function(cssText){return cssText.replace(_cssContentNextSelectorRe,function(){for(var m=[],_i=0;_i<arguments.length;_i++)m[_i]=arguments[_i];return m[2]+"{"})},ShadowCss.prototype._insertPolyfillRulesInCssText=function(cssText){return cssText.replace(_cssContentRuleRe,function(){for(var m=[],_i=0;_i<arguments.length;_i++)m[_i]=arguments[_i];var rule=m[0].replace(m[1],"").replace(m[2],"");return m[4]+rule})},ShadowCss.prototype._scopeCssText=function(cssText,scopeSelector,hostSelector){var unscopedRules=this._extractUnscopedRulesFromCssText(cssText);return cssText=this._insertPolyfillHostInCssText(cssText),cssText=this._convertColonHost(cssText),cssText=this._convertColonHostContext(cssText),cssText=this._convertShadowDOMSelectors(cssText),scopeSelector&&(cssText=this._scopeSelectors(cssText,scopeSelector,hostSelector)),cssText=cssText+"\n"+unscopedRules,cssText.trim()},ShadowCss.prototype._extractUnscopedRulesFromCssText=function(cssText){var m,r="";for(_cssContentUnscopedRuleRe.lastIndex=0;null!==(m=_cssContentUnscopedRuleRe.exec(cssText));){r+=m[0].replace(m[2],"").replace(m[1],m[4])+"\n\n"}return r},ShadowCss.prototype._convertColonHost=function(cssText){return this._convertColonRule(cssText,_cssColonHostRe,this._colonHostPartReplacer)},ShadowCss.prototype._convertColonHostContext=function(cssText){return this._convertColonRule(cssText,_cssColonHostContextRe,this._colonHostContextPartReplacer)},ShadowCss.prototype._convertColonRule=function(cssText,regExp,partReplacer){return cssText.replace(regExp,function(){for(var m=[],_i=0;_i<arguments.length;_i++)m[_i]=arguments[_i];if(m[2]){for(var parts=m[2].split(","),r=[],i=0;i<parts.length;i++){var p=parts[i].trim();if(!p)break;r.push(partReplacer(_polyfillHostNoCombinator,p,m[3]))}return r.join(",")}return _polyfillHostNoCombinator+m[3]})},ShadowCss.prototype._colonHostContextPartReplacer=function(host,part,suffix){return part.indexOf(_polyfillHost)>-1?this._colonHostPartReplacer(host,part,suffix):host+part+suffix+", "+part+" "+host+suffix},ShadowCss.prototype._colonHostPartReplacer=function(host,part,suffix){return host+part.replace(_polyfillHost,"")+suffix},ShadowCss.prototype._convertShadowDOMSelectors=function(cssText){return _shadowDOMSelectorsRe.reduce(function(result,pattern){return result.replace(pattern," ")},cssText)},ShadowCss.prototype._scopeSelectors=function(cssText,scopeSelector,hostSelector){var _this=this;return processRules(cssText,function(rule){var selector=rule.selector,content=rule.content;return"@"!=rule.selector[0]?selector=_this._scopeSelector(rule.selector,scopeSelector,hostSelector,_this.strictStyling):(rule.selector.startsWith("@media")||rule.selector.startsWith("@supports")||rule.selector.startsWith("@page")||rule.selector.startsWith("@document"))&&(content=_this._scopeSelectors(rule.content,scopeSelector,hostSelector)),new CssRule(selector,content)})},ShadowCss.prototype._scopeSelector=function(selector,scopeSelector,hostSelector,strict){var _this=this;return selector.split(",").map(function(part){return part.trim().split(_shadowDeepSelectors)}).map(function(deepParts){var shallowPart=deepParts[0],otherParts=deepParts.slice(1);return[function(shallowPart){return _this._selectorNeedsScoping(shallowPart,scopeSelector)?strict?_this._applyStrictSelectorScope(shallowPart,scopeSelector,hostSelector):_this._applySelectorScope(shallowPart,scopeSelector,hostSelector):shallowPart}(shallowPart)].concat(otherParts).join(" ")}).join(", ")},ShadowCss.prototype._selectorNeedsScoping=function(selector,scopeSelector){return!this._makeScopeMatcher(scopeSelector).test(selector)},ShadowCss.prototype._makeScopeMatcher=function(scopeSelector){var lre=/\[/g,rre=/\]/g;return scopeSelector=scopeSelector.replace(lre,"\\[").replace(rre,"\\]"),new RegExp("^("+scopeSelector+")"+_selectorReSuffix,"m")},ShadowCss.prototype._applySelectorScope=function(selector,scopeSelector,hostSelector){return this._applySimpleSelectorScope(selector,scopeSelector,hostSelector)},ShadowCss.prototype._applySimpleSelectorScope=function(selector,scopeSelector,hostSelector){if(_polyfillHostRe.lastIndex=0,_polyfillHostRe.test(selector)){var replaceBy_1=this.strictStyling?"["+hostSelector+"]":scopeSelector;return selector.replace(_polyfillHostNoCombinatorRe,function(hnc,selector){return selector.replace(/([^:]*)(:*)(.*)/,function(_,before,colon,after){return before+replaceBy_1+colon+after})}).replace(_polyfillHostRe,replaceBy_1+" ")}return scopeSelector+" "+selector},ShadowCss.prototype._applyStrictSelectorScope=function(selector,scopeSelector,hostSelector){var _this=this,isRe=/\[is=([^\]]*)\]/g;scopeSelector=scopeSelector.replace(isRe,function(_){for(var parts=[],_i=1;_i<arguments.length;_i++)parts[_i-1]=arguments[_i];return parts[0]});var attrName="["+scopeSelector+"]",_scopeSelectorPart=function(p){var scopedP=p.trim();if(!scopedP)return"";if(p.indexOf(_polyfillHostNoCombinator)>-1)scopedP=_this._applySimpleSelectorScope(p,scopeSelector,hostSelector);else{var t=p.replace(_polyfillHostRe,"");if(t.length>0){var matches=t.match(/([^:]*)(:*)(.*)/);matches&&(scopedP=matches[1]+attrName+matches[2]+matches[3])}}return scopedP},safeContent=new SafeSelector(selector);selector=safeContent.content();for(var res,scopedSelector="",startIndex=0,sep=/( |>|\+|~(?!=))\s*/g,hasHost=selector.indexOf(_polyfillHostNoCombinator)>-1,shouldScope=!hasHost;null!==(res=sep.exec(selector));){var separator=res[1],part_1=selector.slice(startIndex,res.index).trim();shouldScope=shouldScope||part_1.indexOf(_polyfillHostNoCombinator)>-1;scopedSelector+=(shouldScope?_scopeSelectorPart(part_1):part_1)+" "+separator+" ",startIndex=sep.lastIndex}var part=selector.substring(startIndex);return shouldScope=shouldScope||part.indexOf(_polyfillHostNoCombinator)>-1,scopedSelector+=shouldScope?_scopeSelectorPart(part):part,safeContent.restore(scopedSelector)},ShadowCss.prototype._insertPolyfillHostInCssText=function(selector){return selector.replace(_colonHostContextRe,_polyfillHostContext).replace(_colonHostRe,_polyfillHost)},ShadowCss}(),SafeSelector=function(){function SafeSelector(selector){var _this=this;this.placeholders=[],this.index=0,selector=selector.replace(/(\[[^\]]*\])/g,function(_,keep){var replaceBy="__ph-"+_this.index+"__";return _this.placeholders.push(keep),_this.index++,replaceBy}),this._content=selector.replace(/(:nth-[-\w]+)(\([^)]+\))/g,function(_,pseudo,exp){var replaceBy="__ph-"+_this.index+"__";return _this.placeholders.push(exp),_this.index++,pseudo+replaceBy})}return SafeSelector.prototype.restore=function(content){var _this=this;return content.replace(/__ph-(\d+)__/g,function(ph,index){return _this.placeholders[+index]})},SafeSelector.prototype.content=function(){return this._content},SafeSelector}(),_cssContentNextSelectorRe=/polyfill-next-selector[^}]*content:[\s]*?(['"])(.*?)\1[;\s]*}([^{]*?){/gim,_cssContentRuleRe=/(polyfill-rule)[^}]*(content:[\s]*(['"])(.*?)\3)[;\s]*[^}]*}/gim,_cssContentUnscopedRuleRe=/(polyfill-unscoped-rule)[^}]*(content:[\s]*(['"])(.*?)\3)[;\s]*[^}]*}/gim,_polyfillHost="-shadowcsshost",_polyfillHostContext="-shadowcsscontext",_parenSuffix=")(?:\\(((?:\\([^)(]*\\)|[^)(]*)+?)\\))?([^,{]*)",_cssColonHostRe=new RegExp("("+_polyfillHost+_parenSuffix,"gim"),_cssColonHostContextRe=new RegExp("("+_polyfillHostContext+_parenSuffix,"gim"),_polyfillHostNoCombinator=_polyfillHost+"-no-combinator",_polyfillHostNoCombinatorRe=/-shadowcsshost-no-combinator([^\s]*)/,_shadowDOMSelectorsRe=[/::shadow/g,/::content/g,/\/shadow-deep\//g,/\/shadow\//g],_shadowDeepSelectors=/(?:>>>)|(?:\/deep\/)|(?:::ng-deep)/g,_selectorReSuffix="([>\\s~+[.,{:][\\s\\S]*)?$",_polyfillHostRe=/-shadowcsshost/gim,_colonHostRe=/:host/gim,_colonHostContextRe=/:host-context/gim,_commentRe=/\/\*\s*[\s\S]*?\*\//g,_commentWithHashRe=/\/\*\s*#\s*source(Mapping)?URL=[\s\S]+?\*\//g,_ruleRe=/(\s*)([^;\{\}]+?)(\s*)((?:{%BLOCK%}?\s*;?)|(?:\s*;))/g,_curlyRe=/([{}])/g,OPEN_CURLY="{",CLOSE_CURLY="}",BLOCK_PLACEHOLDER="%BLOCK%",CssRule=function(){function CssRule(selector,content){this.selector=selector,this.content=content}return CssRule}(),StringWithEscapedBlocks=function(){function StringWithEscapedBlocks(escapedString,blocks){this.escapedString=escapedString,this.blocks=blocks}return StringWithEscapedBlocks}(),StylesCompileDependency=function(){function StylesCompileDependency(name,moduleUrl,setValue){this.name=name,this.moduleUrl=moduleUrl,this.setValue=setValue}return StylesCompileDependency}(),CompiledStylesheet=function(){function CompiledStylesheet(outputCtx,stylesVar,dependencies,isShimmed,meta){this.outputCtx=outputCtx,this.stylesVar=stylesVar,this.dependencies=dependencies,this.isShimmed=isShimmed,this.meta=meta}return CompiledStylesheet}(),StyleCompiler=function(){function StyleCompiler(_urlResolver){this._urlResolver=_urlResolver,this._shadowCss=new ShadowCss}return StyleCompiler.prototype.compileComponent=function(outputCtx,comp){var template=comp.template;return this._compileStyles(outputCtx,comp,new CompileStylesheetMetadata({styles:template.styles,styleUrls:template.styleUrls,moduleUrl:identifierModuleUrl(comp.type)}),this.needsStyleShim(comp),!0)},StyleCompiler.prototype.compileStyles=function(outputCtx,comp,stylesheet,shim){return void 0===shim&&(shim=this.needsStyleShim(comp)),this._compileStyles(outputCtx,comp,stylesheet,shim,!1)},StyleCompiler.prototype.needsStyleShim=function(comp){return comp.template.encapsulation===ViewEncapsulation.Emulated},StyleCompiler.prototype._compileStyles=function(outputCtx,comp,stylesheet,shim,isComponentStylesheet){var _this=this,styleExpressions=stylesheet.styles.map(function(plainStyle){return literal(_this._shimIfNeeded(plainStyle,shim))}),dependencies=[];stylesheet.styleUrls.forEach(function(styleUrl){var exprIndex=styleExpressions.length;styleExpressions.push(null),dependencies.push(new StylesCompileDependency(getStylesVarName(null),styleUrl,function(value){return styleExpressions[exprIndex]=outputCtx.importExpr(value)}))});var stylesVar=getStylesVarName(isComponentStylesheet?comp:null),stmt=variable(stylesVar).set(literalArr(styleExpressions,new ArrayType(DYNAMIC_TYPE,[TypeModifier.Const]))).toDeclStmt(null,isComponentStylesheet?[StmtModifier.Final]:[StmtModifier.Final,StmtModifier.Exported]);return outputCtx.statements.push(stmt),new CompiledStylesheet(outputCtx,stylesVar,dependencies,shim,stylesheet)},StyleCompiler.prototype._shimIfNeeded=function(style,shim){return shim?this._shadowCss.shimCssText(style,"_ngcontent-%COMP%","_nghost-%COMP%"):style},StyleCompiler}(),PRESERVE_WS_ATTR_NAME="ngPreserveWhitespaces",SKIP_WS_TRIM_TAGS=new Set(["pre","template","textarea","script","style"]),WS_CHARS=" \f\n\r\t\v ᠎ - \u2028\u2029  　\ufeff",NO_WS_REGEXP=new RegExp("[^"+WS_CHARS+"]"),WS_REPLACE_REGEXP=new RegExp("["+WS_CHARS+"]{2,}","g"),WhitespaceVisitor=function(){function WhitespaceVisitor(){}return WhitespaceVisitor.prototype.visitElement=function(element,context){return SKIP_WS_TRIM_TAGS.has(element.name)||hasPreserveWhitespacesAttr(element.attrs)?new Element(element.name,visitAll(this,element.attrs),element.children,element.sourceSpan,element.startSourceSpan,element.endSourceSpan):new Element(element.name,element.attrs,visitAll(this,element.children),element.sourceSpan,element.startSourceSpan,element.endSourceSpan)},WhitespaceVisitor.prototype.visitAttribute=function(attribute,context){return attribute.name!==PRESERVE_WS_ATTR_NAME?attribute:null},WhitespaceVisitor.prototype.visitText=function(text,context){return text.value.match(NO_WS_REGEXP)?new Text(replaceNgsp(text.value).replace(WS_REPLACE_REGEXP," "),text.sourceSpan):null},WhitespaceVisitor.prototype.visitComment=function(comment,context){return comment},WhitespaceVisitor.prototype.visitExpansion=function(expansion,context){return expansion},WhitespaceVisitor.prototype.visitExpansionCase=function(expansionCase,context){return expansionCase},WhitespaceVisitor}(),PLURAL_CASES=["zero","one","two","few","many","other"],ExpansionResult=function(){function ExpansionResult(nodes,expanded,errors){this.nodes=nodes,this.expanded=expanded,this.errors=errors}return ExpansionResult}(),ExpansionError=function(_super){function ExpansionError(span,errorMsg){return _super.call(this,span,errorMsg)||this}return __extends(ExpansionError,_super),ExpansionError}(ParseError),_Expander=function(){function _Expander(){this.isExpanded=!1,this.errors=[]}return _Expander.prototype.visitElement=function(element,context){return new Element(element.name,element.attrs,visitAll(this,element.children),element.sourceSpan,element.startSourceSpan,element.endSourceSpan)},_Expander.prototype.visitAttribute=function(attribute,context){return attribute},_Expander.prototype.visitText=function(text,context){return text},_Expander.prototype.visitComment=function(comment,context){return comment},_Expander.prototype.visitExpansion=function(icu,context){return this.isExpanded=!0,"plural"==icu.type?_expandPluralForm(icu,this.errors):_expandDefaultForm(icu,this.errors)},_Expander.prototype.visitExpansionCase=function(icuCase,context){throw new Error("Should not be reached")},_Expander}(),BoundPropertyType={DEFAULT:0,LITERAL_ATTR:1,ANIMATION:2};BoundPropertyType[BoundPropertyType.DEFAULT]="DEFAULT",BoundPropertyType[BoundPropertyType.LITERAL_ATTR]="LITERAL_ATTR",BoundPropertyType[BoundPropertyType.ANIMATION]="ANIMATION";var BoundProperty=function(){function BoundProperty(name,expression,type,sourceSpan){this.name=name,this.expression=expression,this.type=type,this.sourceSpan=sourceSpan,this.isLiteral=this.type===BoundPropertyType.LITERAL_ATTR,this.isAnimation=this.type===BoundPropertyType.ANIMATION}return BoundProperty}(),BindingParser=function(){function BindingParser(_exprParser,_interpolationConfig,_schemaRegistry,pipes,_targetErrors){var _this=this;this._exprParser=_exprParser,this._interpolationConfig=_interpolationConfig,this._schemaRegistry=_schemaRegistry,this._targetErrors=_targetErrors,this.pipesByName=new Map,this._usedPipes=new Map,pipes.forEach(function(pipe){return _this.pipesByName.set(pipe.name,pipe)})}return BindingParser.prototype.getUsedPipes=function(){return Array.from(this._usedPipes.values())},BindingParser.prototype.createDirectiveHostPropertyAsts=function(dirMeta,elementSelector,sourceSpan){var _this=this;if(dirMeta.hostProperties){var boundProps_1=[];return Object.keys(dirMeta.hostProperties).forEach(function(propName){var expression=dirMeta.hostProperties[propName];"string"==typeof expression?_this.parsePropertyBinding(propName,expression,!0,sourceSpan,[],boundProps_1):_this._reportError('Value of the host property binding "'+propName+'" needs to be a string representing an expression but got "'+expression+'" ('+typeof expression+")",sourceSpan)}),boundProps_1.map(function(prop){return _this.createElementPropertyAst(elementSelector,prop)})}return null},BindingParser.prototype.createDirectiveHostEventAsts=function(dirMeta,sourceSpan){var _this=this;if(dirMeta.hostListeners){var targetEventAsts_1=[];return Object.keys(dirMeta.hostListeners).forEach(function(propName){var expression=dirMeta.hostListeners[propName];"string"==typeof expression?_this.parseEvent(propName,expression,sourceSpan,[],targetEventAsts_1):_this._reportError('Value of the host listener "'+propName+'" needs to be a string representing an expression but got "'+expression+'" ('+typeof expression+")",sourceSpan)}),targetEventAsts_1}return null},BindingParser.prototype.parseInterpolation=function(value,sourceSpan){var sourceInfo=sourceSpan.start.toString();try{var ast=this._exprParser.parseInterpolation(value,sourceInfo,this._interpolationConfig);return ast&&this._reportExpressionParserErrors(ast.errors,sourceSpan),this._checkPipes(ast,sourceSpan),ast}catch(e){return this._reportError(""+e,sourceSpan),this._exprParser.wrapLiteralPrimitive("ERROR",sourceInfo)}},BindingParser.prototype.parseInlineTemplateBinding=function(prefixToken,value,sourceSpan,targetMatchableAttrs,targetProps,targetVars){for(var bindings=this._parseTemplateBindings(prefixToken,value,sourceSpan),i=0;i<bindings.length;i++){var binding=bindings[i];binding.keyIsVar?targetVars.push(new VariableAst(binding.key,binding.name,sourceSpan)):binding.expression?this._parsePropertyAst(binding.key,binding.expression,sourceSpan,targetMatchableAttrs,targetProps):(targetMatchableAttrs.push([binding.key,""]),this.parseLiteralAttr(binding.key,null,sourceSpan,targetMatchableAttrs,targetProps))}},BindingParser.prototype._parseTemplateBindings=function(prefixToken,value,sourceSpan){var _this=this,sourceInfo=sourceSpan.start.toString();try{var bindingsResult=this._exprParser.parseTemplateBindings(prefixToken,value,sourceInfo);return this._reportExpressionParserErrors(bindingsResult.errors,sourceSpan),bindingsResult.templateBindings.forEach(function(binding){binding.expression&&_this._checkPipes(binding.expression,sourceSpan)}),bindingsResult.warnings.forEach(function(warning){_this._reportError(warning,sourceSpan,ParseErrorLevel.WARNING)}),bindingsResult.templateBindings}catch(e){
return this._reportError(""+e,sourceSpan),[]}},BindingParser.prototype.parseLiteralAttr=function(name,value,sourceSpan,targetMatchableAttrs,targetProps){_isAnimationLabel(name)?(name=name.substring(1),value&&this._reportError('Assigning animation triggers via @prop="exp" attributes with an expression is invalid. Use property bindings (e.g. [@prop]="exp") or use an attribute without a value (e.g. @prop) instead.',sourceSpan,ParseErrorLevel.ERROR),this._parseAnimation(name,value,sourceSpan,targetMatchableAttrs,targetProps)):targetProps.push(new BoundProperty(name,this._exprParser.wrapLiteralPrimitive(value,""),BoundPropertyType.LITERAL_ATTR,sourceSpan))},BindingParser.prototype.parsePropertyBinding=function(name,expression,isHost,sourceSpan,targetMatchableAttrs,targetProps){var isAnimationProp=!1;name.startsWith("animate-")?(isAnimationProp=!0,name=name.substring("animate-".length)):_isAnimationLabel(name)&&(isAnimationProp=!0,name=name.substring(1)),isAnimationProp?this._parseAnimation(name,expression,sourceSpan,targetMatchableAttrs,targetProps):this._parsePropertyAst(name,this._parseBinding(expression,isHost,sourceSpan),sourceSpan,targetMatchableAttrs,targetProps)},BindingParser.prototype.parsePropertyInterpolation=function(name,value,sourceSpan,targetMatchableAttrs,targetProps){var expr=this.parseInterpolation(value,sourceSpan);return!!expr&&(this._parsePropertyAst(name,expr,sourceSpan,targetMatchableAttrs,targetProps),!0)},BindingParser.prototype._parsePropertyAst=function(name,ast,sourceSpan,targetMatchableAttrs,targetProps){targetMatchableAttrs.push([name,ast.source]),targetProps.push(new BoundProperty(name,ast,BoundPropertyType.DEFAULT,sourceSpan))},BindingParser.prototype._parseAnimation=function(name,expression,sourceSpan,targetMatchableAttrs,targetProps){var ast=this._parseBinding(expression||"undefined",!1,sourceSpan);targetMatchableAttrs.push([name,ast.source]),targetProps.push(new BoundProperty(name,ast,BoundPropertyType.ANIMATION,sourceSpan))},BindingParser.prototype._parseBinding=function(value,isHostBinding,sourceSpan){var sourceInfo=sourceSpan.start.toString();try{var ast=isHostBinding?this._exprParser.parseSimpleBinding(value,sourceInfo,this._interpolationConfig):this._exprParser.parseBinding(value,sourceInfo,this._interpolationConfig);return ast&&this._reportExpressionParserErrors(ast.errors,sourceSpan),this._checkPipes(ast,sourceSpan),ast}catch(e){return this._reportError(""+e,sourceSpan),this._exprParser.wrapLiteralPrimitive("ERROR",sourceInfo)}},BindingParser.prototype.createElementPropertyAst=function(elementSelector,boundProp){if(boundProp.isAnimation)return new BoundElementPropertyAst(boundProp.name,PropertyBindingType.Animation,SecurityContext.NONE,boundProp.expression,null,boundProp.sourceSpan);var unit=null,bindingType=void 0,boundPropertyName=null,parts=boundProp.name.split("."),securityContexts=void 0;if(parts.length>1)if("attr"==parts[0]){boundPropertyName=parts[1],this._validatePropertyOrAttributeName(boundPropertyName,boundProp.sourceSpan,!0),securityContexts=calcPossibleSecurityContexts(this._schemaRegistry,elementSelector,boundPropertyName,!0);var nsSeparatorIdx=boundPropertyName.indexOf(":");if(nsSeparatorIdx>-1){var ns=boundPropertyName.substring(0,nsSeparatorIdx),name_1=boundPropertyName.substring(nsSeparatorIdx+1);boundPropertyName=mergeNsAndName(ns,name_1)}bindingType=PropertyBindingType.Attribute}else"class"==parts[0]?(boundPropertyName=parts[1],bindingType=PropertyBindingType.Class,securityContexts=[SecurityContext.NONE]):"style"==parts[0]&&(unit=parts.length>2?parts[2]:null,boundPropertyName=parts[1],bindingType=PropertyBindingType.Style,securityContexts=[SecurityContext.STYLE]);return null===boundPropertyName&&(boundPropertyName=this._schemaRegistry.getMappedPropName(boundProp.name),securityContexts=calcPossibleSecurityContexts(this._schemaRegistry,elementSelector,boundPropertyName,!1),bindingType=PropertyBindingType.Property,this._validatePropertyOrAttributeName(boundPropertyName,boundProp.sourceSpan,!1)),new BoundElementPropertyAst(boundPropertyName,bindingType,securityContexts[0],boundProp.expression,unit,boundProp.sourceSpan)},BindingParser.prototype.parseEvent=function(name,expression,sourceSpan,targetMatchableAttrs,targetEvents){_isAnimationLabel(name)?(name=name.substr(1),this._parseAnimationEvent(name,expression,sourceSpan,targetEvents)):this._parseEvent(name,expression,sourceSpan,targetMatchableAttrs,targetEvents)},BindingParser.prototype._parseAnimationEvent=function(name,expression,sourceSpan,targetEvents){var matches=splitAtPeriod(name,[name,""]),eventName=matches[0],phase=matches[1].toLowerCase();if(phase)switch(phase){case"start":case"done":var ast=this._parseAction(expression,sourceSpan);targetEvents.push(new BoundEventAst(eventName,null,phase,ast,sourceSpan));break;default:this._reportError('The provided animation output phase value "'+phase+'" for "@'+eventName+'" is not supported (use start or done)',sourceSpan)}else this._reportError("The animation trigger output event (@"+eventName+") is missing its phase value name (start or done are currently supported)",sourceSpan)},BindingParser.prototype._parseEvent=function(name,expression,sourceSpan,targetMatchableAttrs,targetEvents){var _a=splitAtColon(name,[null,name]),target=_a[0],eventName=_a[1],ast=this._parseAction(expression,sourceSpan);targetMatchableAttrs.push([name,ast.source]),targetEvents.push(new BoundEventAst(eventName,target,null,ast,sourceSpan))},BindingParser.prototype._parseAction=function(value,sourceSpan){var sourceInfo=sourceSpan.start.toString();try{var ast=this._exprParser.parseAction(value,sourceInfo,this._interpolationConfig);return ast&&this._reportExpressionParserErrors(ast.errors,sourceSpan),!ast||ast.ast instanceof EmptyExpr?(this._reportError("Empty expressions are not allowed",sourceSpan),this._exprParser.wrapLiteralPrimitive("ERROR",sourceInfo)):(this._checkPipes(ast,sourceSpan),ast)}catch(e){return this._reportError(""+e,sourceSpan),this._exprParser.wrapLiteralPrimitive("ERROR",sourceInfo)}},BindingParser.prototype._reportError=function(message,sourceSpan,level){void 0===level&&(level=ParseErrorLevel.ERROR),this._targetErrors.push(new ParseError(sourceSpan,message,level))},BindingParser.prototype._reportExpressionParserErrors=function(errors,sourceSpan){for(var _i=0,errors_1=errors;_i<errors_1.length;_i++){var error=errors_1[_i];this._reportError(error.message,sourceSpan)}},BindingParser.prototype._checkPipes=function(ast,sourceSpan){var _this=this;if(ast){var collector=new PipeCollector;ast.visit(collector),collector.pipes.forEach(function(ast,pipeName){var pipeMeta=_this.pipesByName.get(pipeName);pipeMeta?_this._usedPipes.set(pipeName,pipeMeta):_this._reportError("The pipe '"+pipeName+"' could not be found",new ParseSourceSpan(sourceSpan.start.moveBy(ast.span.start),sourceSpan.start.moveBy(ast.span.end)))})}},BindingParser.prototype._validatePropertyOrAttributeName=function(propName,sourceSpan,isAttr){var report=isAttr?this._schemaRegistry.validateAttribute(propName):this._schemaRegistry.validateProperty(propName);report.error&&this._reportError(report.msg,sourceSpan,ParseErrorLevel.ERROR)},BindingParser}(),PipeCollector=function(_super){function PipeCollector(){var _this=null!==_super&&_super.apply(this,arguments)||this;return _this.pipes=new Map,_this}return __extends(PipeCollector,_super),PipeCollector.prototype.visitPipe=function(ast,context){return this.pipes.set(ast.name,ast),ast.exp.visit(this),this.visitAll(ast.args,context),null},PipeCollector}(RecursiveAstVisitor),BIND_NAME_REGEXP=/^(?:(?:(?:(bind-)|(let-)|(ref-|#)|(on-)|(bindon-)|(@))(.+))|\[\(([^\)]+)\)\]|\[([^\]]+)\]|\(([^\)]+)\))$/,TEMPLATE_ELEMENT="template",CLASS_ATTR="class",TEXT_CSS_SELECTOR=CssSelector.parse("*")[0],TEMPLATE_ELEMENT_DEPRECATION_WARNING="The <template> element is deprecated. Use <ng-template> instead",warningCounts={},TemplateParseError=function(_super){function TemplateParseError(message,span,level){return _super.call(this,span,message,level)||this}return __extends(TemplateParseError,_super),TemplateParseError}(ParseError),TemplateParseResult=function(){function TemplateParseResult(templateAst,usedPipes,errors){this.templateAst=templateAst,this.usedPipes=usedPipes,this.errors=errors}return TemplateParseResult}(),TemplateParser=function(){function TemplateParser(_config,_reflector,_exprParser,_schemaRegistry,_htmlParser,_console,transforms){this._config=_config,this._reflector=_reflector,this._exprParser=_exprParser,this._schemaRegistry=_schemaRegistry,this._htmlParser=_htmlParser,this._console=_console,this.transforms=transforms}return TemplateParser.prototype.parse=function(component,template,directives,pipes,schemas,templateUrl,preserveWhitespaces){var result=this.tryParse(component,template,directives,pipes,schemas,templateUrl,preserveWhitespaces),warnings=result.errors.filter(function(error){return error.level===ParseErrorLevel.WARNING}).filter(warnOnlyOnce(["The template attribute is deprecated. Use an ng-template element instead.",TEMPLATE_ELEMENT_DEPRECATION_WARNING])),errors=result.errors.filter(function(error){return error.level===ParseErrorLevel.ERROR});if(warnings.length>0&&this._console.warn("Template parse warnings:\n"+warnings.join("\n")),errors.length>0){throw syntaxError("Template parse errors:\n"+errors.join("\n"),errors)}return{template:result.templateAst,pipes:result.usedPipes}},TemplateParser.prototype.tryParse=function(component,template,directives,pipes,schemas,templateUrl,preserveWhitespaces){var htmlParseResult="string"==typeof template?this._htmlParser.parse(template,templateUrl,!0,this.getInterpolationConfig(component)):template;return preserveWhitespaces||(htmlParseResult=removeWhitespaces(htmlParseResult)),this.tryParseHtml(this.expandHtml(htmlParseResult),component,directives,pipes,schemas)},TemplateParser.prototype.tryParseHtml=function(htmlAstWithErrors,component,directives,pipes,schemas){var result,errors=htmlAstWithErrors.errors,usedPipes=[];if(htmlAstWithErrors.rootNodes.length>0){var uniqDirectives=removeSummaryDuplicates(directives),uniqPipes=removeSummaryDuplicates(pipes),providerViewContext=new ProviderViewContext(this._reflector,component),interpolationConfig=void 0;component.template&&component.template.interpolation&&(interpolationConfig={start:component.template.interpolation[0],end:component.template.interpolation[1]});var bindingParser=new BindingParser(this._exprParser,interpolationConfig,this._schemaRegistry,uniqPipes,errors),parseVisitor=new TemplateParseVisitor(this._reflector,this._config,providerViewContext,uniqDirectives,bindingParser,this._schemaRegistry,schemas,errors);result=visitAll(parseVisitor,htmlAstWithErrors.rootNodes,EMPTY_ELEMENT_CONTEXT),errors.push.apply(errors,providerViewContext.errors),usedPipes.push.apply(usedPipes,bindingParser.getUsedPipes())}else result=[];return this._assertNoReferenceDuplicationOnTemplate(result,errors),errors.length>0?new TemplateParseResult(result,usedPipes,errors):(this.transforms&&this.transforms.forEach(function(transform){result=templateVisitAll(transform,result)}),new TemplateParseResult(result,usedPipes,errors))},TemplateParser.prototype.expandHtml=function(htmlAstWithErrors,forced){void 0===forced&&(forced=!1);var errors=htmlAstWithErrors.errors;if(0==errors.length||forced){var expandedHtmlAst=expandNodes(htmlAstWithErrors.rootNodes);errors.push.apply(errors,expandedHtmlAst.errors),htmlAstWithErrors=new ParseTreeResult(expandedHtmlAst.nodes,errors)}return htmlAstWithErrors},TemplateParser.prototype.getInterpolationConfig=function(component){if(component.template)return InterpolationConfig.fromArray(component.template.interpolation)},TemplateParser.prototype._assertNoReferenceDuplicationOnTemplate=function(result,errors){var existingReferences=[];result.filter(function(element){return!!element.references}).forEach(function(element){return element.references.forEach(function(reference){var name=reference.name;if(existingReferences.indexOf(name)<0)existingReferences.push(name);else{var error=new TemplateParseError('Reference "#'+name+'" is defined several times',reference.sourceSpan,ParseErrorLevel.ERROR);errors.push(error)}})})},TemplateParser}(),TemplateParseVisitor=function(){function TemplateParseVisitor(reflector,config,providerViewContext,directives,_bindingParser,_schemaRegistry,_schemas,_targetErrors){var _this=this;this.reflector=reflector,this.config=config,this.providerViewContext=providerViewContext,this._bindingParser=_bindingParser,this._schemaRegistry=_schemaRegistry,this._schemas=_schemas,this._targetErrors=_targetErrors,this.selectorMatcher=new SelectorMatcher,this.directivesIndex=new Map,this.ngContentCount=0,this.contentQueryStartId=providerViewContext.component.viewQueries.length+1,directives.forEach(function(directive,index){var selector=CssSelector.parse(directive.selector);_this.selectorMatcher.addSelectables(selector,directive),_this.directivesIndex.set(directive,index)})}return TemplateParseVisitor.prototype.visitExpansion=function(expansion,context){return null},TemplateParseVisitor.prototype.visitExpansionCase=function(expansionCase,context){return null},TemplateParseVisitor.prototype.visitText=function(text,parent){var ngContentIndex=parent.findNgContentIndex(TEXT_CSS_SELECTOR),valueNoNgsp=replaceNgsp(text.value),expr=this._bindingParser.parseInterpolation(valueNoNgsp,text.sourceSpan);return expr?new BoundTextAst(expr,ngContentIndex,text.sourceSpan):new TextAst(valueNoNgsp,ngContentIndex,text.sourceSpan)},TemplateParseVisitor.prototype.visitAttribute=function(attribute,context){return new AttrAst(attribute.name,attribute.value,attribute.sourceSpan)},TemplateParseVisitor.prototype.visitComment=function(comment,context){return null},TemplateParseVisitor.prototype.visitElement=function(element,parent){var _this=this,queryStartIndex=this.contentQueryStartId,nodeName=element.name,preparsedElement=preparseElement(element);if(preparsedElement.type===PreparsedElementType.SCRIPT||preparsedElement.type===PreparsedElementType.STYLE)return null;if(preparsedElement.type===PreparsedElementType.STYLESHEET&&isStyleUrlResolvable(preparsedElement.hrefAttr))return null;var matchableAttrs=[],elementOrDirectiveProps=[],elementOrDirectiveRefs=[],elementVars=[],events=[],templateElementOrDirectiveProps=[],templateMatchableAttrs=[],templateElementVars=[],hasInlineTemplates=!1,attrs=[],isTemplateElement=isTemplate(element,this.config.enableLegacyTemplate,function(m,span){return _this._reportError(m,span,ParseErrorLevel.WARNING)});element.attrs.forEach(function(attr){var templateBindingsSource,prefixToken,hasBinding=_this._parseAttr(isTemplateElement,attr,matchableAttrs,elementOrDirectiveProps,events,elementOrDirectiveRefs,elementVars),normalizedName=_this._normalizeAttributeName(attr.name);_this.config.enableLegacyTemplate&&"template"==normalizedName?(_this._reportError("The template attribute is deprecated. Use an ng-template element instead.",attr.sourceSpan,ParseErrorLevel.WARNING),templateBindingsSource=attr.value):normalizedName.startsWith("*")&&(templateBindingsSource=attr.value,prefixToken=normalizedName.substring("*".length)+":");var hasTemplateBinding=null!=templateBindingsSource;hasTemplateBinding&&(hasInlineTemplates&&_this._reportError("Can't have multiple template bindings on one element. Use only one attribute named 'template' or prefixed with *",attr.sourceSpan),hasInlineTemplates=!0,_this._bindingParser.parseInlineTemplateBinding(prefixToken,templateBindingsSource,attr.sourceSpan,templateMatchableAttrs,templateElementOrDirectiveProps,templateElementVars)),hasBinding||hasTemplateBinding||(attrs.push(_this.visitAttribute(attr,null)),matchableAttrs.push([attr.name,attr.value]))});var elementCssSelector=createElementCssSelector(nodeName,matchableAttrs),_a=this._parseDirectives(this.selectorMatcher,elementCssSelector),directiveMetas=_a.directives,matchElement=_a.matchElement,references=[],boundDirectivePropNames=new Set,directiveAsts=this._createDirectiveAsts(isTemplateElement,element.name,directiveMetas,elementOrDirectiveProps,elementOrDirectiveRefs,element.sourceSpan,references,boundDirectivePropNames),elementProps=this._createElementPropertyAsts(element.name,elementOrDirectiveProps,boundDirectivePropNames),isViewRoot=parent.isTemplateElement||hasInlineTemplates,providerContext=new ProviderElementContext(this.providerViewContext,parent.providerContext,isViewRoot,directiveAsts,attrs,references,isTemplateElement,queryStartIndex,element.sourceSpan),children=visitAll(preparsedElement.nonBindable?NON_BINDABLE_VISITOR:this,element.children,ElementContext.create(isTemplateElement,directiveAsts,isTemplateElement?parent.providerContext:providerContext));providerContext.afterElement();var parsedElement,projectionSelector=null!=preparsedElement.projectAs?CssSelector.parse(preparsedElement.projectAs)[0]:elementCssSelector,ngContentIndex=parent.findNgContentIndex(projectionSelector);if(preparsedElement.type===PreparsedElementType.NG_CONTENT)element.children&&!element.children.every(_isEmptyTextNode)&&this._reportError("<ng-content> element cannot have content.",element.sourceSpan),parsedElement=new NgContentAst(this.ngContentCount++,hasInlineTemplates?null:ngContentIndex,element.sourceSpan);else if(isTemplateElement)this._assertAllEventsPublishedByDirectives(directiveAsts,events),this._assertNoComponentsNorElementBindingsOnTemplate(directiveAsts,elementProps,element.sourceSpan),parsedElement=new EmbeddedTemplateAst(attrs,events,references,elementVars,providerContext.transformedDirectiveAsts,providerContext.transformProviders,providerContext.transformedHasViewContainer,providerContext.queryMatches,children,hasInlineTemplates?null:ngContentIndex,element.sourceSpan);else{this._assertElementExists(matchElement,element),this._assertOnlyOneComponent(directiveAsts,element.sourceSpan);var ngContentIndex_1=hasInlineTemplates?null:parent.findNgContentIndex(projectionSelector);parsedElement=new ElementAst(nodeName,attrs,elementProps,events,references,providerContext.transformedDirectiveAsts,providerContext.transformProviders,providerContext.transformedHasViewContainer,providerContext.queryMatches,children,hasInlineTemplates?null:ngContentIndex_1,element.sourceSpan,element.endSourceSpan||null)}if(hasInlineTemplates){var templateQueryStartIndex=this.contentQueryStartId,templateSelector=createElementCssSelector(TEMPLATE_ELEMENT,templateMatchableAttrs),templateDirectiveMetas=this._parseDirectives(this.selectorMatcher,templateSelector).directives,templateBoundDirectivePropNames=new Set,templateDirectiveAsts=this._createDirectiveAsts(!0,element.name,templateDirectiveMetas,templateElementOrDirectiveProps,[],element.sourceSpan,[],templateBoundDirectivePropNames),templateElementProps=this._createElementPropertyAsts(element.name,templateElementOrDirectiveProps,templateBoundDirectivePropNames);this._assertNoComponentsNorElementBindingsOnTemplate(templateDirectiveAsts,templateElementProps,element.sourceSpan);var templateProviderContext=new ProviderElementContext(this.providerViewContext,parent.providerContext,parent.isTemplateElement,templateDirectiveAsts,[],[],!0,templateQueryStartIndex,element.sourceSpan);templateProviderContext.afterElement(),parsedElement=new EmbeddedTemplateAst([],[],[],templateElementVars,templateProviderContext.transformedDirectiveAsts,templateProviderContext.transformProviders,templateProviderContext.transformedHasViewContainer,templateProviderContext.queryMatches,[parsedElement],ngContentIndex,element.sourceSpan)}return parsedElement},TemplateParseVisitor.prototype._parseAttr=function(isTemplateElement,attr,targetMatchableAttrs,targetProps,targetEvents,targetRefs,targetVars){var name=this._normalizeAttributeName(attr.name),value=attr.value,srcSpan=attr.sourceSpan,bindParts=name.match(BIND_NAME_REGEXP),hasBinding=!1;if(null!==bindParts)if(hasBinding=!0,null!=bindParts[1])this._bindingParser.parsePropertyBinding(bindParts[7],value,!1,srcSpan,targetMatchableAttrs,targetProps);else if(bindParts[2])if(isTemplateElement){var identifier=bindParts[7];this._parseVariable(identifier,value,srcSpan,targetVars)}else this._reportError('"let-" is only supported on ng-template elements.',srcSpan);else if(bindParts[3]){var identifier=bindParts[7];this._parseReference(identifier,value,srcSpan,targetRefs)}else bindParts[4]?this._bindingParser.parseEvent(bindParts[7],value,srcSpan,targetMatchableAttrs,targetEvents):bindParts[5]?(this._bindingParser.parsePropertyBinding(bindParts[7],value,!1,srcSpan,targetMatchableAttrs,targetProps),this._parseAssignmentEvent(bindParts[7],value,srcSpan,targetMatchableAttrs,targetEvents)):bindParts[6]?this._bindingParser.parseLiteralAttr(name,value,srcSpan,targetMatchableAttrs,targetProps):bindParts[8]?(this._bindingParser.parsePropertyBinding(bindParts[8],value,!1,srcSpan,targetMatchableAttrs,targetProps),this._parseAssignmentEvent(bindParts[8],value,srcSpan,targetMatchableAttrs,targetEvents)):bindParts[9]?this._bindingParser.parsePropertyBinding(bindParts[9],value,!1,srcSpan,targetMatchableAttrs,targetProps):bindParts[10]&&this._bindingParser.parseEvent(bindParts[10],value,srcSpan,targetMatchableAttrs,targetEvents);else hasBinding=this._bindingParser.parsePropertyInterpolation(name,value,srcSpan,targetMatchableAttrs,targetProps);return hasBinding||this._bindingParser.parseLiteralAttr(name,value,srcSpan,targetMatchableAttrs,targetProps),hasBinding},TemplateParseVisitor.prototype._normalizeAttributeName=function(attrName){return/^data-/i.test(attrName)?attrName.substring(5):attrName},TemplateParseVisitor.prototype._parseVariable=function(identifier,value,sourceSpan,targetVars){identifier.indexOf("-")>-1&&this._reportError('"-" is not allowed in variable names',sourceSpan),targetVars.push(new VariableAst(identifier,value,sourceSpan))},TemplateParseVisitor.prototype._parseReference=function(identifier,value,sourceSpan,targetRefs){identifier.indexOf("-")>-1&&this._reportError('"-" is not allowed in reference names',sourceSpan),targetRefs.push(new ElementOrDirectiveRef(identifier,value,sourceSpan))},TemplateParseVisitor.prototype._parseAssignmentEvent=function(name,expression,sourceSpan,targetMatchableAttrs,targetEvents){this._bindingParser.parseEvent(name+"Change",expression+"=$event",sourceSpan,targetMatchableAttrs,targetEvents)},TemplateParseVisitor.prototype._parseDirectives=function(selectorMatcher,elementCssSelector){var _this=this,directives=new Array(this.directivesIndex.size),matchElement=!1;return selectorMatcher.match(elementCssSelector,function(selector,directive){directives[_this.directivesIndex.get(directive)]=directive,matchElement=matchElement||selector.hasElementSelector()}),{directives:directives.filter(function(dir){return!!dir}),matchElement:matchElement}},TemplateParseVisitor.prototype._createDirectiveAsts=function(isTemplateElement,elementName,directives,props,elementOrDirectiveRefs,elementSourceSpan,targetReferences,targetBoundDirectivePropNames){var _this=this,matchedReferences=new Set,component=null,directiveAsts=directives.map(function(directive){var sourceSpan=new ParseSourceSpan(elementSourceSpan.start,elementSourceSpan.end,"Directive "+identifierName(directive.type));directive.isComponent&&(component=directive);var directiveProperties=[],hostProperties=_this._bindingParser.createDirectiveHostPropertyAsts(directive,elementName,sourceSpan);hostProperties=_this._checkPropertiesInSchema(elementName,hostProperties);var hostEvents=_this._bindingParser.createDirectiveHostEventAsts(directive,sourceSpan);_this._createDirectivePropertyAsts(directive.inputs,props,directiveProperties,targetBoundDirectivePropNames),elementOrDirectiveRefs.forEach(function(elOrDirRef){(0===elOrDirRef.value.length&&directive.isComponent||elOrDirRef.isReferenceToDirective(directive))&&(targetReferences.push(new ReferenceAst(elOrDirRef.name,createTokenForReference(directive.type.reference),elOrDirRef.sourceSpan)),matchedReferences.add(elOrDirRef.name))});var contentQueryStartId=_this.contentQueryStartId;return _this.contentQueryStartId+=directive.queries.length,new DirectiveAst(directive,directiveProperties,hostProperties,hostEvents,contentQueryStartId,sourceSpan)});return elementOrDirectiveRefs.forEach(function(elOrDirRef){if(elOrDirRef.value.length>0)matchedReferences.has(elOrDirRef.name)||_this._reportError('There is no directive with "exportAs" set to "'+elOrDirRef.value+'"',elOrDirRef.sourceSpan);else if(!component){var refToken=null;isTemplateElement&&(refToken=createTokenForExternalReference(_this.reflector,Identifiers.TemplateRef)),targetReferences.push(new ReferenceAst(elOrDirRef.name,refToken,elOrDirRef.sourceSpan))}}),directiveAsts},TemplateParseVisitor.prototype._createDirectivePropertyAsts=function(directiveProperties,boundProps,targetBoundDirectiveProps,targetBoundDirectivePropNames){if(directiveProperties){var boundPropsByName_1=new Map;boundProps.forEach(function(boundProp){var prevValue=boundPropsByName_1.get(boundProp.name);prevValue&&!prevValue.isLiteral||boundPropsByName_1.set(boundProp.name,boundProp)}),Object.keys(directiveProperties).forEach(function(dirProp){var elProp=directiveProperties[dirProp],boundProp=boundPropsByName_1.get(elProp);boundProp&&(targetBoundDirectivePropNames.add(boundProp.name),isEmptyExpression(boundProp.expression)||targetBoundDirectiveProps.push(new BoundDirectivePropertyAst(dirProp,boundProp.name,boundProp.expression,boundProp.sourceSpan)))})}},TemplateParseVisitor.prototype._createElementPropertyAsts=function(elementName,props,boundDirectivePropNames){var _this=this,boundElementProps=[];return props.forEach(function(prop){prop.isLiteral||boundDirectivePropNames.has(prop.name)||boundElementProps.push(_this._bindingParser.createElementPropertyAst(elementName,prop))}),this._checkPropertiesInSchema(elementName,boundElementProps)},TemplateParseVisitor.prototype._findComponentDirectives=function(directives){return directives.filter(function(directive){return directive.directive.isComponent})},TemplateParseVisitor.prototype._findComponentDirectiveNames=function(directives){return this._findComponentDirectives(directives).map(function(directive){return identifierName(directive.directive.type)})},TemplateParseVisitor.prototype._assertOnlyOneComponent=function(directives,sourceSpan){var componentTypeNames=this._findComponentDirectiveNames(directives);componentTypeNames.length>1&&this._reportError("More than one component matched on this element.\nMake sure that only one component's selector can match a given element.\nConflicting components: "+componentTypeNames.join(","),sourceSpan)},TemplateParseVisitor.prototype._assertElementExists=function(matchElement,element){var elName=element.name.replace(/^:xhtml:/,"");if(!matchElement&&!this._schemaRegistry.hasElement(elName,this._schemas)){var errorMsg="'"+elName+"' is not a known element:\n";errorMsg+="1. If '"+elName+"' is an Angular component, then verify that it is part of this module.\n",elName.indexOf("-")>-1?errorMsg+="2. If '"+elName+"' is a Web Component then add 'CUSTOM_ELEMENTS_SCHEMA' to the '@NgModule.schemas' of this component to suppress this message.":errorMsg+="2. To allow any element add 'NO_ERRORS_SCHEMA' to the '@NgModule.schemas' of this component.",this._reportError(errorMsg,element.sourceSpan)}},TemplateParseVisitor.prototype._assertNoComponentsNorElementBindingsOnTemplate=function(directives,elementProps,sourceSpan){var _this=this,componentTypeNames=this._findComponentDirectiveNames(directives);componentTypeNames.length>0&&this._reportError("Components on an embedded template: "+componentTypeNames.join(","),sourceSpan),elementProps.forEach(function(prop){_this._reportError("Property binding "+prop.name+' not used by any directive on an embedded template. Make sure that the property name is spelled correctly and all directives are listed in the "@NgModule.declarations".',sourceSpan)})},TemplateParseVisitor.prototype._assertAllEventsPublishedByDirectives=function(directives,events){var _this=this,allDirectiveEvents=new Set;directives.forEach(function(directive){Object.keys(directive.directive.outputs).forEach(function(k){var eventName=directive.directive.outputs[k];allDirectiveEvents.add(eventName)})}),events.forEach(function(event){null==event.target&&allDirectiveEvents.has(event.name)||_this._reportError("Event binding "+event.fullName+' not emitted by any directive on an embedded template. Make sure that the event name is spelled correctly and all directives are listed in the "@NgModule.declarations".',event.sourceSpan)})},TemplateParseVisitor.prototype._checkPropertiesInSchema=function(elementName,boundProps){var _this=this;return boundProps.filter(function(boundProp){if(boundProp.type===PropertyBindingType.Property&&!_this._schemaRegistry.hasProperty(elementName,boundProp.name,_this._schemas)){var errorMsg="Can't bind to '"+boundProp.name+"' since it isn't a known property of '"+elementName+"'.";elementName.startsWith("ng-")?errorMsg+="\n1. If '"+boundProp.name+"' is an Angular directive, then add 'CommonModule' to the '@NgModule.imports' of this component.\n2. To allow any property add 'NO_ERRORS_SCHEMA' to the '@NgModule.schemas' of this component.":elementName.indexOf("-")>-1&&(errorMsg+="\n1. If '"+elementName+"' is an Angular component and it has '"+boundProp.name+"' input, then verify that it is part of this module.\n2. If '"+elementName+"' is a Web Component then add 'CUSTOM_ELEMENTS_SCHEMA' to the '@NgModule.schemas' of this component to suppress this message.\n3. To allow any property add 'NO_ERRORS_SCHEMA' to the '@NgModule.schemas' of this component."),_this._reportError(errorMsg,boundProp.sourceSpan)}return!isEmptyExpression(boundProp.value)})},TemplateParseVisitor.prototype._reportError=function(message,sourceSpan,level){void 0===level&&(level=ParseErrorLevel.ERROR),this._targetErrors.push(new ParseError(sourceSpan,message,level))},TemplateParseVisitor}(),NonBindableVisitor=function(){function NonBindableVisitor(){}return NonBindableVisitor.prototype.visitElement=function(ast,parent){var preparsedElement=preparseElement(ast);if(preparsedElement.type===PreparsedElementType.SCRIPT||preparsedElement.type===PreparsedElementType.STYLE||preparsedElement.type===PreparsedElementType.STYLESHEET)return null;var attrNameAndValues=ast.attrs.map(function(attr){return[attr.name,attr.value]}),selector=createElementCssSelector(ast.name,attrNameAndValues),ngContentIndex=parent.findNgContentIndex(selector),children=visitAll(this,ast.children,EMPTY_ELEMENT_CONTEXT);return new ElementAst(ast.name,visitAll(this,ast.attrs),[],[],[],[],[],!1,[],children,ngContentIndex,ast.sourceSpan,ast.endSourceSpan)},NonBindableVisitor.prototype.visitComment=function(comment,context){return null},NonBindableVisitor.prototype.visitAttribute=function(attribute,context){return new AttrAst(attribute.name,attribute.value,attribute.sourceSpan)},NonBindableVisitor.prototype.visitText=function(text,parent){var ngContentIndex=parent.findNgContentIndex(TEXT_CSS_SELECTOR);return new TextAst(text.value,ngContentIndex,text.sourceSpan)},NonBindableVisitor.prototype.visitExpansion=function(expansion,context){return expansion},NonBindableVisitor.prototype.visitExpansionCase=function(expansionCase,context){return expansionCase},NonBindableVisitor}(),ElementOrDirectiveRef=function(){function ElementOrDirectiveRef(name,value,sourceSpan){this.name=name,this.value=value,this.sourceSpan=sourceSpan}return ElementOrDirectiveRef.prototype.isReferenceToDirective=function(directive){return-1!==splitExportAs(directive.exportAs).indexOf(this.value)},ElementOrDirectiveRef}(),ElementContext=function(){function ElementContext(isTemplateElement,_ngContentIndexMatcher,_wildcardNgContentIndex,providerContext){this.isTemplateElement=isTemplateElement,this._ngContentIndexMatcher=_ngContentIndexMatcher,this._wildcardNgContentIndex=_wildcardNgContentIndex,this.providerContext=providerContext}return ElementContext.create=function(isTemplateElement,directives,providerContext){
var matcher=new SelectorMatcher,wildcardNgContentIndex=null,component=directives.find(function(directive){return directive.directive.isComponent});if(component)for(var ngContentSelectors=component.directive.template.ngContentSelectors,i=0;i<ngContentSelectors.length;i++){var selector=ngContentSelectors[i];"*"===selector?wildcardNgContentIndex=i:matcher.addSelectables(CssSelector.parse(ngContentSelectors[i]),i)}return new ElementContext(isTemplateElement,matcher,wildcardNgContentIndex,providerContext)},ElementContext.prototype.findNgContentIndex=function(selector){var ngContentIndices=[];return this._ngContentIndexMatcher.match(selector,function(selector,ngContentIndex){ngContentIndices.push(ngContentIndex)}),ngContentIndices.sort(),null!=this._wildcardNgContentIndex&&ngContentIndices.push(this._wildcardNgContentIndex),ngContentIndices.length>0?ngContentIndices[0]:null},ElementContext}(),EMPTY_ELEMENT_CONTEXT=new ElementContext(!0,new SelectorMatcher,null,null),NON_BINDABLE_VISITOR=new NonBindableVisitor,EventHandlerVars=function(){function EventHandlerVars(){}return EventHandlerVars.event=variable("$event"),EventHandlerVars}(),ConvertActionBindingResult=function(){function ConvertActionBindingResult(stmts,allowDefault){this.stmts=stmts,this.allowDefault=allowDefault}return ConvertActionBindingResult}(),ConvertPropertyBindingResult=function(){function ConvertPropertyBindingResult(stmts,currValExpr){this.stmts=stmts,this.currValExpr=currValExpr}return ConvertPropertyBindingResult}(),BindingForm={General:0,TrySimple:1};BindingForm[BindingForm.General]="General",BindingForm[BindingForm.TrySimple]="TrySimple";var _Mode={Statement:0,Expression:1};_Mode[_Mode.Statement]="Statement",_Mode[_Mode.Expression]="Expression";var _BuiltinAstConverter=function(_super){function _BuiltinAstConverter(_converterFactory){var _this=_super.call(this)||this;return _this._converterFactory=_converterFactory,_this}return __extends(_BuiltinAstConverter,_super),_BuiltinAstConverter.prototype.visitPipe=function(ast,context){var _this=this,args=[ast.exp].concat(ast.args).map(function(ast){return ast.visit(_this,context)});return new BuiltinFunctionCall(ast.span,args,this._converterFactory.createPipeConverter(ast.name,args.length))},_BuiltinAstConverter.prototype.visitLiteralArray=function(ast,context){var _this=this,args=ast.expressions.map(function(ast){return ast.visit(_this,context)});return new BuiltinFunctionCall(ast.span,args,this._converterFactory.createLiteralArrayConverter(ast.expressions.length))},_BuiltinAstConverter.prototype.visitLiteralMap=function(ast,context){var _this=this,args=ast.values.map(function(ast){return ast.visit(_this,context)});return new BuiltinFunctionCall(ast.span,args,this._converterFactory.createLiteralMapConverter(ast.keys))},_BuiltinAstConverter}(AstTransformer),_AstToIrVisitor=function(){function _AstToIrVisitor(_localResolver,_implicitReceiver,bindingId){this._localResolver=_localResolver,this._implicitReceiver=_implicitReceiver,this.bindingId=bindingId,this._nodeMap=new Map,this._resultMap=new Map,this._currentTemporary=0,this.temporaryCount=0}return _AstToIrVisitor.prototype.visitBinary=function(ast,mode){var op;switch(ast.operation){case"+":op=BinaryOperator.Plus;break;case"-":op=BinaryOperator.Minus;break;case"*":op=BinaryOperator.Multiply;break;case"/":op=BinaryOperator.Divide;break;case"%":op=BinaryOperator.Modulo;break;case"&&":op=BinaryOperator.And;break;case"||":op=BinaryOperator.Or;break;case"==":op=BinaryOperator.Equals;break;case"!=":op=BinaryOperator.NotEquals;break;case"===":op=BinaryOperator.Identical;break;case"!==":op=BinaryOperator.NotIdentical;break;case"<":op=BinaryOperator.Lower;break;case">":op=BinaryOperator.Bigger;break;case"<=":op=BinaryOperator.LowerEquals;break;case">=":op=BinaryOperator.BiggerEquals;break;default:throw new Error("Unsupported operation "+ast.operation)}return convertToStatementIfNeeded(mode,new BinaryOperatorExpr(op,this._visit(ast.left,_Mode.Expression),this._visit(ast.right,_Mode.Expression)))},_AstToIrVisitor.prototype.visitChain=function(ast,mode){return ensureStatementMode(mode,ast),this.visitAll(ast.expressions,mode)},_AstToIrVisitor.prototype.visitConditional=function(ast,mode){return convertToStatementIfNeeded(mode,this._visit(ast.condition,_Mode.Expression).conditional(this._visit(ast.trueExp,_Mode.Expression),this._visit(ast.falseExp,_Mode.Expression)))},_AstToIrVisitor.prototype.visitPipe=function(ast,mode){throw new Error("Illegal state: Pipes should have been converted into functions. Pipe: "+ast.name)},_AstToIrVisitor.prototype.visitFunctionCall=function(ast,mode){var fnResult,convertedArgs=this.visitAll(ast.args,_Mode.Expression);return fnResult=ast instanceof BuiltinFunctionCall?ast.converter(convertedArgs):this._visit(ast.target,_Mode.Expression).callFn(convertedArgs),convertToStatementIfNeeded(mode,fnResult)},_AstToIrVisitor.prototype.visitImplicitReceiver=function(ast,mode){return ensureExpressionMode(mode,ast),this._implicitReceiver},_AstToIrVisitor.prototype.visitInterpolation=function(ast,mode){ensureExpressionMode(mode,ast);for(var args=[literal(ast.expressions.length)],i=0;i<ast.strings.length-1;i++)args.push(literal(ast.strings[i])),args.push(this._visit(ast.expressions[i],_Mode.Expression));return args.push(literal(ast.strings[ast.strings.length-1])),ast.expressions.length<=9?importExpr(Identifiers.inlineInterpolate).callFn(args):importExpr(Identifiers.interpolate).callFn([args[0],literalArr(args.slice(1))])},_AstToIrVisitor.prototype.visitKeyedRead=function(ast,mode){var leftMostSafe=this.leftMostSafeNode(ast);return leftMostSafe?this.convertSafeAccess(ast,leftMostSafe,mode):convertToStatementIfNeeded(mode,this._visit(ast.obj,_Mode.Expression).key(this._visit(ast.key,_Mode.Expression)))},_AstToIrVisitor.prototype.visitKeyedWrite=function(ast,mode){var obj=this._visit(ast.obj,_Mode.Expression),key=this._visit(ast.key,_Mode.Expression),value=this._visit(ast.value,_Mode.Expression);return convertToStatementIfNeeded(mode,obj.key(key).set(value))},_AstToIrVisitor.prototype.visitLiteralArray=function(ast,mode){throw new Error("Illegal State: literal arrays should have been converted into functions")},_AstToIrVisitor.prototype.visitLiteralMap=function(ast,mode){throw new Error("Illegal State: literal maps should have been converted into functions")},_AstToIrVisitor.prototype.visitLiteralPrimitive=function(ast,mode){var type=null===ast.value||void 0===ast.value||!0===ast.value||!0===ast.value?INFERRED_TYPE:void 0;return convertToStatementIfNeeded(mode,literal(ast.value,type))},_AstToIrVisitor.prototype._getLocal=function(name){return this._localResolver.getLocal(name)},_AstToIrVisitor.prototype.visitMethodCall=function(ast,mode){if(ast.receiver instanceof ImplicitReceiver&&"$any"==ast.name){var args=this.visitAll(ast.args,_Mode.Expression);if(1!=args.length)throw new Error("Invalid call to $any, expected 1 argument but received "+(args.length||"none"));return args[0].cast(DYNAMIC_TYPE)}var leftMostSafe=this.leftMostSafeNode(ast);if(leftMostSafe)return this.convertSafeAccess(ast,leftMostSafe,mode);var args=this.visitAll(ast.args,_Mode.Expression),result=null,receiver=this._visit(ast.receiver,_Mode.Expression);if(receiver===this._implicitReceiver){var varExpr=this._getLocal(ast.name);varExpr&&(result=varExpr.callFn(args))}return null==result&&(result=receiver.callMethod(ast.name,args)),convertToStatementIfNeeded(mode,result)},_AstToIrVisitor.prototype.visitPrefixNot=function(ast,mode){return convertToStatementIfNeeded(mode,not(this._visit(ast.expression,_Mode.Expression)))},_AstToIrVisitor.prototype.visitNonNullAssert=function(ast,mode){return convertToStatementIfNeeded(mode,assertNotNull(this._visit(ast.expression,_Mode.Expression)))},_AstToIrVisitor.prototype.visitPropertyRead=function(ast,mode){var leftMostSafe=this.leftMostSafeNode(ast);if(leftMostSafe)return this.convertSafeAccess(ast,leftMostSafe,mode);var result=null,receiver=this._visit(ast.receiver,_Mode.Expression);return receiver===this._implicitReceiver&&(result=this._getLocal(ast.name)),null==result&&(result=receiver.prop(ast.name)),convertToStatementIfNeeded(mode,result)},_AstToIrVisitor.prototype.visitPropertyWrite=function(ast,mode){var receiver=this._visit(ast.receiver,_Mode.Expression);if(receiver===this._implicitReceiver){if(this._getLocal(ast.name))throw new Error("Cannot assign to a reference or variable!")}return convertToStatementIfNeeded(mode,receiver.prop(ast.name).set(this._visit(ast.value,_Mode.Expression)))},_AstToIrVisitor.prototype.visitSafePropertyRead=function(ast,mode){return this.convertSafeAccess(ast,this.leftMostSafeNode(ast),mode)},_AstToIrVisitor.prototype.visitSafeMethodCall=function(ast,mode){return this.convertSafeAccess(ast,this.leftMostSafeNode(ast),mode)},_AstToIrVisitor.prototype.visitAll=function(asts,mode){var _this=this;return asts.map(function(ast){return _this._visit(ast,mode)})},_AstToIrVisitor.prototype.visitQuote=function(ast,mode){throw new Error("Quotes are not supported for evaluation!\n        Statement: "+ast.uninterpretedExpression+" located at "+ast.location)},_AstToIrVisitor.prototype._visit=function(ast,mode){var result=this._resultMap.get(ast);return result||(this._nodeMap.get(ast)||ast).visit(this,mode)},_AstToIrVisitor.prototype.convertSafeAccess=function(ast,leftMostSafe,mode){var guardedExpression=this._visit(leftMostSafe.receiver,_Mode.Expression),temporary=void 0;this.needsTemporary(leftMostSafe.receiver)&&(temporary=this.allocateTemporary(),guardedExpression=temporary.set(guardedExpression),this._resultMap.set(leftMostSafe.receiver,temporary));var condition=guardedExpression.isBlank();leftMostSafe instanceof SafeMethodCall?this._nodeMap.set(leftMostSafe,new MethodCall(leftMostSafe.span,leftMostSafe.receiver,leftMostSafe.name,leftMostSafe.args)):this._nodeMap.set(leftMostSafe,new PropertyRead(leftMostSafe.span,leftMostSafe.receiver,leftMostSafe.name));var access=this._visit(ast,_Mode.Expression);return this._nodeMap.delete(leftMostSafe),temporary&&this.releaseTemporary(temporary),convertToStatementIfNeeded(mode,condition.conditional(literal(null),access))},_AstToIrVisitor.prototype.leftMostSafeNode=function(ast){var _this=this,visit=function(visitor,ast){return(_this._nodeMap.get(ast)||ast).visit(visitor)};return ast.visit({visitBinary:function(ast){return null},visitChain:function(ast){return null},visitConditional:function(ast){return null},visitFunctionCall:function(ast){return null},visitImplicitReceiver:function(ast){return null},visitInterpolation:function(ast){return null},visitKeyedRead:function(ast){return visit(this,ast.obj)},visitKeyedWrite:function(ast){return null},visitLiteralArray:function(ast){return null},visitLiteralMap:function(ast){return null},visitLiteralPrimitive:function(ast){return null},visitMethodCall:function(ast){return visit(this,ast.receiver)},visitPipe:function(ast){return null},visitPrefixNot:function(ast){return null},visitNonNullAssert:function(ast){return null},visitPropertyRead:function(ast){return visit(this,ast.receiver)},visitPropertyWrite:function(ast){return null},visitQuote:function(ast){return null},visitSafeMethodCall:function(ast){return visit(this,ast.receiver)||ast},visitSafePropertyRead:function(ast){return visit(this,ast.receiver)||ast}})},_AstToIrVisitor.prototype.needsTemporary=function(ast){var _this=this,visit=function(visitor,ast){return ast&&(_this._nodeMap.get(ast)||ast).visit(visitor)},visitSome=function(visitor,ast){return ast.some(function(ast){return visit(visitor,ast)})};return ast.visit({visitBinary:function(ast){return visit(this,ast.left)||visit(this,ast.right)},visitChain:function(ast){return!1},visitConditional:function(ast){return visit(this,ast.condition)||visit(this,ast.trueExp)||visit(this,ast.falseExp)},visitFunctionCall:function(ast){return!0},visitImplicitReceiver:function(ast){return!1},visitInterpolation:function(ast){return visitSome(this,ast.expressions)},visitKeyedRead:function(ast){return!1},visitKeyedWrite:function(ast){return!1},visitLiteralArray:function(ast){return!0},visitLiteralMap:function(ast){return!0},visitLiteralPrimitive:function(ast){return!1},visitMethodCall:function(ast){return!0},visitPipe:function(ast){return!0},visitPrefixNot:function(ast){return visit(this,ast.expression)},visitNonNullAssert:function(ast){return visit(this,ast.expression)},visitPropertyRead:function(ast){return!1},visitPropertyWrite:function(ast){return!1},visitQuote:function(ast){return!1},visitSafeMethodCall:function(ast){return!0},visitSafePropertyRead:function(ast){return!1}})},_AstToIrVisitor.prototype.allocateTemporary=function(){var tempNumber=this._currentTemporary++;return this.temporaryCount=Math.max(this._currentTemporary,this.temporaryCount),new ReadVarExpr(temporaryName(this.bindingId,tempNumber))},_AstToIrVisitor.prototype.releaseTemporary=function(temporary){if(this._currentTemporary--,temporary.name!=temporaryName(this.bindingId,this._currentTemporary))throw new Error("Temporary "+temporary.name+" released out of order")},_AstToIrVisitor}(),DefaultLocalResolver=function(){function DefaultLocalResolver(){}return DefaultLocalResolver.prototype.getLocal=function(name){return name===EventHandlerVars.event.name?EventHandlerVars.event:null},DefaultLocalResolver}(),BuiltinFunctionCall=function(_super){function BuiltinFunctionCall(span,args,converter){var _this=_super.call(this,span,null,args)||this;return _this.args=args,_this.converter=converter,_this}return __extends(BuiltinFunctionCall,_super),BuiltinFunctionCall}(FunctionCall),TypeCheckCompiler=function(){function TypeCheckCompiler(options,reflector){this.options=options,this.reflector=reflector}return TypeCheckCompiler.prototype.compileComponent=function(componentId,component,template,usedPipes,externalReferenceVars,ctx){var _this=this,pipes=new Map;usedPipes.forEach(function(p){return pipes.set(p.name,p.type.reference)});var embeddedViewCount=0,viewBuilderFactory=function(parent,guards){var embeddedViewIndex=embeddedViewCount++;return new ViewBuilder(_this.options,_this.reflector,externalReferenceVars,parent,component.type.reference,component.isHost,embeddedViewIndex,pipes,guards,ctx,viewBuilderFactory)},visitor=viewBuilderFactory(null,[]);return visitor.visitAll([],template),visitor.build(componentId)},TypeCheckCompiler}(),TypeCheckLocalResolver=function(){function TypeCheckLocalResolver(){}return TypeCheckLocalResolver.prototype.getLocal=function(name){return name===EventHandlerVars.event.name?variable("_any"):null},TypeCheckLocalResolver}(),defaultResolver=new TypeCheckLocalResolver,ViewBuilder=function(){function ViewBuilder(options,reflector,externalReferenceVars,parent,component,isHostComponent,embeddedViewIndex,pipes,guards,ctx,viewBuilderFactory){this.options=options,this.reflector=reflector,this.externalReferenceVars=externalReferenceVars,this.parent=parent,this.component=component,this.isHostComponent=isHostComponent,this.embeddedViewIndex=embeddedViewIndex,this.pipes=pipes,this.guards=guards,this.ctx=ctx,this.viewBuilderFactory=viewBuilderFactory,this.refOutputVars=new Map,this.variables=[],this.children=[],this.updates=[],this.actions=[]}return ViewBuilder.prototype.getOutputVar=function(type){var varName;if(!(varName=type===this.component&&this.isHostComponent?"_any":type instanceof StaticSymbol?this.externalReferenceVars.get(type):"_any"))throw new Error("Illegal State: referring to a type without a variable "+JSON.stringify(type));return varName},ViewBuilder.prototype.getTypeGuardExpressions=function(ast){for(var result=this.guards.slice(),_i=0,_a=ast.directives;_i<_a.length;_i++)for(var directive=_a[_i],_b=0,_c=directive.inputs;_b<_c.length;_b++){var input=_c[_b],guard=directive.directive.guards[input.directiveName];if(guard){var useIf="UseIf"===guard;result.push({guard:guard,useIf:useIf,expression:{context:this.component,value:input.value}})}}return result},ViewBuilder.prototype.visitAll=function(variables,astNodes){this.variables=variables,templateVisitAll(this,astNodes)},ViewBuilder.prototype.build=function(componentId,targetStatements){var _this=this;void 0===targetStatements&&(targetStatements=[]),this.children.forEach(function(child){return child.build(componentId,targetStatements)});var viewStmts=[variable("_any").set(NULL_EXPR).toDeclStmt(DYNAMIC_TYPE)],bindingCount=0;if(this.updates.forEach(function(expression){var _a=_this.preprocessUpdateExpression(expression),sourceSpan=_a.sourceSpan,context=_a.context,value=_a.value,bindingId=""+bindingCount++,nameResolver=context===_this.component?_this:defaultResolver,_b=convertPropertyBinding(nameResolver,variable(_this.getOutputVar(context)),value,bindingId,BindingForm.General),stmts=_b.stmts,currValExpr=_b.currValExpr;stmts.push(new ExpressionStatement(currValExpr)),viewStmts.push.apply(viewStmts,stmts.map(function(stmt){return applySourceSpanToStatementIfNeeded(stmt,sourceSpan)}))}),this.actions.forEach(function(_a){var sourceSpan=_a.sourceSpan,context=_a.context,value=_a.value,bindingId=""+bindingCount++,nameResolver=context===_this.component?_this:defaultResolver,stmts=convertActionBinding(nameResolver,variable(_this.getOutputVar(context)),value,bindingId).stmts;viewStmts.push.apply(viewStmts,stmts.map(function(stmt){return applySourceSpanToStatementIfNeeded(stmt,sourceSpan)}))}),this.guards.length){for(var guardExpression=void 0,_i=0,_a=this.guards;_i<_a.length;_i++){var guard=_a[_i],_b=this.preprocessUpdateExpression(guard.expression),context=_b.context,value=_b.value,bindingId=""+bindingCount++,nameResolver=context===this.component?this:defaultResolver,_c=convertPropertyBinding(nameResolver,variable(this.getOutputVar(context)),value,bindingId,BindingForm.TrySimple),stmts=_c.stmts,currValExpr=_c.currValExpr;if(0==stmts.length){var guardClause=guard.useIf?currValExpr:this.ctx.importExpr(guard.guard).callFn([currValExpr]);guardExpression=guardExpression?guardExpression.and(guardClause):guardClause}}guardExpression&&(viewStmts=[new IfStmt(guardExpression,viewStmts)])}var viewName="_View_"+componentId+"_"+this.embeddedViewIndex,viewFactory=new DeclareFunctionStmt(viewName,[],viewStmts);return targetStatements.push(viewFactory),targetStatements},ViewBuilder.prototype.visitBoundText=function(ast,context){var _this=this;ast.value.ast.expressions.forEach(function(expr){return _this.updates.push({context:_this.component,value:expr,sourceSpan:ast.sourceSpan})})},ViewBuilder.prototype.visitEmbeddedTemplate=function(ast,context){if(this.visitElementOrTemplate(ast),this.options.fullTemplateTypeCheck){var guards=this.getTypeGuardExpressions(ast),childVisitor=this.viewBuilderFactory(this,guards);this.children.push(childVisitor),childVisitor.visitAll(ast.variables,ast.children)}},ViewBuilder.prototype.visitElement=function(ast,context){var _this=this;this.visitElementOrTemplate(ast);ast.inputs.forEach(function(inputAst){_this.updates.push({context:_this.component,value:inputAst.value,sourceSpan:inputAst.sourceSpan})}),templateVisitAll(this,ast.children)},ViewBuilder.prototype.visitElementOrTemplate=function(ast){var _this=this;ast.directives.forEach(function(dirAst){_this.visitDirective(dirAst)}),ast.references.forEach(function(ref){var outputVarType=null;outputVarType=ref.value&&ref.value.identifier&&_this.options.fullTemplateTypeCheck?ref.value.identifier.reference:BuiltinTypeName.Dynamic,_this.refOutputVars.set(ref.name,outputVarType)}),ast.outputs.forEach(function(outputAst){_this.actions.push({context:_this.component,value:outputAst.handler,sourceSpan:outputAst.sourceSpan})})},ViewBuilder.prototype.visitDirective=function(dirAst){var _this=this,dirType=dirAst.directive.type.reference;dirAst.inputs.forEach(function(input){return _this.updates.push({context:_this.component,value:input.value,sourceSpan:input.sourceSpan})}),this.options.fullTemplateTypeCheck&&(dirAst.hostProperties.forEach(function(inputAst){return _this.updates.push({context:dirType,value:inputAst.value,sourceSpan:inputAst.sourceSpan})}),dirAst.hostEvents.forEach(function(hostEventAst){return _this.actions.push({context:dirType,value:hostEventAst.handler,sourceSpan:hostEventAst.sourceSpan})}))},ViewBuilder.prototype.getLocal=function(name){if(name==EventHandlerVars.event.name)return variable(this.getOutputVar(BuiltinTypeName.Dynamic));for(var currBuilder=this;currBuilder;currBuilder=currBuilder.parent){var outputVarType=void 0;if(null==(outputVarType=currBuilder.refOutputVars.get(name))){currBuilder.variables.find(function(varAst){return varAst.name===name})&&(outputVarType=BuiltinTypeName.Dynamic)}if(null!=outputVarType)return variable(this.getOutputVar(outputVarType))}return null},ViewBuilder.prototype.pipeOutputVar=function(name){var pipe=this.pipes.get(name);if(!pipe)throw new Error("Illegal State: Could not find pipe "+name+" in template of "+this.component);return this.getOutputVar(pipe)},ViewBuilder.prototype.preprocessUpdateExpression=function(expression){var _this=this;return{sourceSpan:expression.sourceSpan,context:expression.context,value:convertPropertyBindingBuiltins({createLiteralArrayConverter:function(argCount){return function(args){var arr=literalArr(args);return _this.options.fullTemplateTypeCheck?arr:arr.cast(DYNAMIC_TYPE)}},createLiteralMapConverter:function(keys){return function(values){var entries=keys.map(function(k,i){return{key:k.key,value:values[i],quoted:k.quoted}}),map=literalMap(entries);return _this.options.fullTemplateTypeCheck?map:map.cast(DYNAMIC_TYPE)}},createPipeConverter:function(name,argCount){return function(args){return variable(_this.options.fullTemplateTypeCheck?_this.pipeOutputVar(name):_this.getOutputVar(BuiltinTypeName.Dynamic)).callMethod("transform",args)}}},expression.value)}},ViewBuilder.prototype.visitNgContent=function(ast,context){},ViewBuilder.prototype.visitText=function(ast,context){},ViewBuilder.prototype.visitDirectiveProperty=function(ast,context){},ViewBuilder.prototype.visitReference=function(ast,context){},ViewBuilder.prototype.visitVariable=function(ast,context){},ViewBuilder.prototype.visitEvent=function(ast,context){},ViewBuilder.prototype.visitElementProperty=function(ast,context){},ViewBuilder.prototype.visitAttr=function(ast,context){},ViewBuilder}(),CLASS_ATTR$1="class",STYLE_ATTR="style",ViewCompileResult=function(){function ViewCompileResult(viewClassVar,rendererTypeVar){this.viewClassVar=viewClassVar,this.rendererTypeVar=rendererTypeVar}return ViewCompileResult}(),ViewCompiler=function(){function ViewCompiler(_reflector){this._reflector=_reflector}return ViewCompiler.prototype.compileComponent=function(outputCtx,component,template,styles,usedPipes){var _this=this,embeddedViewCount=0,staticQueryIds=findStaticQueryIds(template),renderComponentVarName=void 0;if(!component.isHost){var template_1=component.template,customRenderData=[];template_1.animations&&template_1.animations.length&&customRenderData.push(new LiteralMapEntry("animation",convertValueToOutputAst(outputCtx,template_1.animations),!0));var renderComponentVar=variable(rendererTypeName(component.type.reference));renderComponentVarName=renderComponentVar.name,outputCtx.statements.push(renderComponentVar.set(importExpr(Identifiers.createRendererType2).callFn([new LiteralMapExpr([new LiteralMapEntry("encapsulation",literal(template_1.encapsulation),!1),new LiteralMapEntry("styles",styles,!1),new LiteralMapEntry("data",new LiteralMapExpr(customRenderData),!1)])])).toDeclStmt(importType(Identifiers.RendererType2),[StmtModifier.Final,StmtModifier.Exported]))}var viewBuilderFactory=function(parent){var embeddedViewIndex=embeddedViewCount++;return new ViewBuilder$1(_this._reflector,outputCtx,parent,component,embeddedViewIndex,usedPipes,staticQueryIds,viewBuilderFactory)},visitor=viewBuilderFactory(null);return visitor.visitAll([],template),(_a=outputCtx.statements).push.apply(_a,visitor.build()),new ViewCompileResult(visitor.viewName,renderComponentVarName);var _a},ViewCompiler}(),LOG_VAR$1=variable("_l"),VIEW_VAR=variable("_v"),CHECK_VAR=variable("_ck"),COMP_VAR=variable("_co"),EVENT_NAME_VAR=variable("en"),ALLOW_DEFAULT_VAR=variable("ad"),ViewBuilder$1=function(){function ViewBuilder(reflector,outputCtx,parent,component,embeddedViewIndex,usedPipes,staticQueryIds,viewBuilderFactory){this.reflector=reflector,this.outputCtx=outputCtx,this.parent=parent,this.component=component,this.embeddedViewIndex=embeddedViewIndex,this.usedPipes=usedPipes,this.staticQueryIds=staticQueryIds,this.viewBuilderFactory=viewBuilderFactory,this.nodes=[],this.purePipeNodeIndices=Object.create(null),this.refNodeIndices=Object.create(null),this.variables=[],this.children=[],this.compType=this.embeddedViewIndex>0?DYNAMIC_TYPE:expressionType(outputCtx.importExpr(this.component.type.reference)),this.viewName=viewClassName(this.component.type.reference,this.embeddedViewIndex)}return ViewBuilder.prototype.visitAll=function(variables,astNodes){var _this=this;if(this.variables=variables,this.parent||this.usedPipes.forEach(function(pipe){pipe.pure&&(_this.purePipeNodeIndices[pipe.name]=_this._createPipe(null,pipe))}),!this.parent){var queryIds_1=staticViewQueryIds(this.staticQueryIds);this.component.viewQueries.forEach(function(query,queryIndex){var queryId=queryIndex+1,bindingType=query.first?0:1,flags=134217728|calcStaticDynamicQueryFlags(queryIds_1,queryId,query.first);_this.nodes.push(function(){return{sourceSpan:null,nodeFlags:flags,nodeDef:importExpr(Identifiers.queryDef).callFn([literal(flags),literal(queryId),new LiteralMapExpr([new LiteralMapEntry(query.propertyName,literal(bindingType),!1)])])}})})}templateVisitAll(this,astNodes),this.parent&&(0===astNodes.length||needsAdditionalRootNode(astNodes))&&this.nodes.push(function(){return{sourceSpan:null,nodeFlags:1,nodeDef:importExpr(Identifiers.anchorDef).callFn([literal(0),NULL_EXPR,NULL_EXPR,literal(0)])}})},ViewBuilder.prototype.build=function(targetStatements){void 0===targetStatements&&(targetStatements=[]),this.children.forEach(function(child){return child.build(targetStatements)});var _a=this._createNodeExpressions(),updateRendererStmts=_a.updateRendererStmts,updateDirectivesStmts=_a.updateDirectivesStmts,nodeDefExprs=_a.nodeDefExprs,updateRendererFn=this._createUpdateFn(updateRendererStmts),updateDirectivesFn=this._createUpdateFn(updateDirectivesStmts),viewFlags=0;this.parent||this.component.changeDetection!==ChangeDetectionStrategy.OnPush||(viewFlags|=2);var viewFactory=new DeclareFunctionStmt(this.viewName,[new FnParam(LOG_VAR$1.name)],[new ReturnStatement(importExpr(Identifiers.viewDef).callFn([literal(viewFlags),literalArr(nodeDefExprs),updateDirectivesFn,updateRendererFn]))],importType(Identifiers.ViewDefinition),0===this.embeddedViewIndex?[StmtModifier.Exported]:[]);return targetStatements.push(viewFactory),targetStatements},ViewBuilder.prototype._createUpdateFn=function(updateStmts){var updateFn;if(updateStmts.length>0){var preStmts=[];!this.component.isHost&&findReadVarNames(updateStmts).has(COMP_VAR.name)&&preStmts.push(COMP_VAR.set(VIEW_VAR.prop("component")).toDeclStmt(this.compType)),updateFn=fn([new FnParam(CHECK_VAR.name,INFERRED_TYPE),new FnParam(VIEW_VAR.name,INFERRED_TYPE)],preStmts.concat(updateStmts),INFERRED_TYPE)}else updateFn=NULL_EXPR;return updateFn},ViewBuilder.prototype.visitNgContent=function(ast,context){this.nodes.push(function(){return{sourceSpan:ast.sourceSpan,nodeFlags:8,nodeDef:importExpr(Identifiers.ngContentDef).callFn([literal(ast.ngContentIndex),literal(ast.index)])}})},ViewBuilder.prototype.visitText=function(ast,context){this.nodes.push(function(){return{sourceSpan:ast.sourceSpan,nodeFlags:2,nodeDef:importExpr(Identifiers.textDef).callFn([literal(-1),literal(ast.ngContentIndex),literalArr([literal(ast.value)])])}})},ViewBuilder.prototype.visitBoundText=function(ast,context){var _this=this,nodeIndex=this.nodes.length;this.nodes.push(null);var astWithSource=ast.value,inter=astWithSource.ast,updateRendererExpressions=inter.expressions.map(function(expr,bindingIndex){return _this._preprocessUpdateExpression({nodeIndex:nodeIndex,bindingIndex:bindingIndex,sourceSpan:ast.sourceSpan,context:COMP_VAR,value:expr})}),checkIndex=nodeIndex;this.nodes[nodeIndex]=function(){return{sourceSpan:ast.sourceSpan,nodeFlags:2,nodeDef:importExpr(Identifiers.textDef).callFn([literal(checkIndex),literal(ast.ngContentIndex),literalArr(inter.strings.map(function(s){return literal(s)}))]),updateRenderer:updateRendererExpressions}}},ViewBuilder.prototype.visitEmbeddedTemplate=function(ast,context){var _this=this,nodeIndex=this.nodes.length;this.nodes.push(null);var _a=this._visitElementOrTemplate(nodeIndex,ast),flags=_a.flags,queryMatchesExpr=_a.queryMatchesExpr,hostEvents=_a.hostEvents,childVisitor=this.viewBuilderFactory(this);this.children.push(childVisitor),childVisitor.visitAll(ast.variables,ast.children);var childCount=this.nodes.length-nodeIndex-1;this.nodes[nodeIndex]=function(){return{sourceSpan:ast.sourceSpan,nodeFlags:1|flags,nodeDef:importExpr(Identifiers.anchorDef).callFn([literal(flags),queryMatchesExpr,literal(ast.ngContentIndex),literal(childCount),_this._createElementHandleEventFn(nodeIndex,hostEvents),variable(childVisitor.viewName)])}}},ViewBuilder.prototype.visitElement=function(ast,context){var _this=this,nodeIndex=this.nodes.length;this.nodes.push(null);var elName=isNgContainer(ast.name)?null:ast.name,_a=this._visitElementOrTemplate(nodeIndex,ast),flags=_a.flags,usedEvents=_a.usedEvents,queryMatchesExpr=_a.queryMatchesExpr,dirHostBindings=_a.hostBindings,hostEvents=_a.hostEvents,inputDefs=[],updateRendererExpressions=[],outputDefs=[];if(elName){var hostBindings=ast.inputs.map(function(inputAst){return{context:COMP_VAR,inputAst:inputAst,dirAst:null}}).concat(dirHostBindings);hostBindings.length&&(updateRendererExpressions=hostBindings.map(function(hostBinding,bindingIndex){return _this._preprocessUpdateExpression({context:hostBinding.context,nodeIndex:nodeIndex,bindingIndex:bindingIndex,sourceSpan:hostBinding.inputAst.sourceSpan,value:hostBinding.inputAst.value})}),inputDefs=hostBindings.map(function(hostBinding){return elementBindingDef(hostBinding.inputAst,hostBinding.dirAst)})),outputDefs=usedEvents.map(function(_a){var target=_a[0],eventName=_a[1];return literalArr([literal(target),literal(eventName)])})}templateVisitAll(this,ast.children);var childCount=this.nodes.length-nodeIndex-1,compAst=ast.directives.find(function(dirAst){return dirAst.directive.isComponent}),compRendererType=NULL_EXPR,compView=NULL_EXPR;compAst&&(compView=this.outputCtx.importExpr(compAst.directive.componentViewType),compRendererType=this.outputCtx.importExpr(compAst.directive.rendererType));var checkIndex=nodeIndex;this.nodes[nodeIndex]=function(){return{sourceSpan:ast.sourceSpan,nodeFlags:1|flags,nodeDef:importExpr(Identifiers.elementDef).callFn([literal(checkIndex),literal(flags),queryMatchesExpr,literal(ast.ngContentIndex),literal(childCount),literal(elName),elName?fixedAttrsDef(ast):NULL_EXPR,inputDefs.length?literalArr(inputDefs):NULL_EXPR,outputDefs.length?literalArr(outputDefs):NULL_EXPR,_this._createElementHandleEventFn(nodeIndex,hostEvents),compView,compRendererType]),updateRenderer:updateRendererExpressions}}},ViewBuilder.prototype._visitElementOrTemplate=function(nodeIndex,ast){var _this=this,flags=0;ast.hasViewContainer&&(flags|=16777216);var usedEvents=new Map;ast.outputs.forEach(function(event){var _a=elementEventNameAndTarget(event,null),name=_a.name,target=_a.target;usedEvents.set(elementEventFullName(target,name),[target,name])}),ast.directives.forEach(function(dirAst){dirAst.hostEvents.forEach(function(event){var _a=elementEventNameAndTarget(event,dirAst),name=_a.name,target=_a.target;usedEvents.set(elementEventFullName(target,name),[target,name])})});var hostBindings=[],hostEvents=[];this._visitComponentFactoryResolverProvider(ast.directives),ast.providers.forEach(function(providerAst,providerIndex){var dirAst=void 0,dirIndex=void 0;if(ast.directives.forEach(function(localDirAst,i){
localDirAst.directive.type.reference===tokenReference(providerAst.token)&&(dirAst=localDirAst,dirIndex=i)}),dirAst){var _a=_this._visitDirective(providerAst,dirAst,dirIndex,nodeIndex,ast.references,ast.queryMatches,usedEvents,_this.staticQueryIds.get(ast)),dirHostBindings=_a.hostBindings,dirHostEvents=_a.hostEvents;hostBindings.push.apply(hostBindings,dirHostBindings),hostEvents.push.apply(hostEvents,dirHostEvents)}else _this._visitProvider(providerAst,ast.queryMatches)});var queryMatchExprs=[];return ast.queryMatches.forEach(function(match){var valueType=void 0;tokenReference(match.value)===_this.reflector.resolveExternalReference(Identifiers.ElementRef)?valueType=0:tokenReference(match.value)===_this.reflector.resolveExternalReference(Identifiers.ViewContainerRef)?valueType=3:tokenReference(match.value)===_this.reflector.resolveExternalReference(Identifiers.TemplateRef)&&(valueType=2),null!=valueType&&queryMatchExprs.push(literalArr([literal(match.queryId),literal(valueType)]))}),ast.references.forEach(function(ref){var valueType=void 0;ref.value?tokenReference(ref.value)===_this.reflector.resolveExternalReference(Identifiers.TemplateRef)&&(valueType=2):valueType=1,null!=valueType&&(_this.refNodeIndices[ref.name]=nodeIndex,queryMatchExprs.push(literalArr([literal(ref.name),literal(valueType)])))}),ast.outputs.forEach(function(outputAst){hostEvents.push({context:COMP_VAR,eventAst:outputAst,dirAst:null})}),{flags:flags,usedEvents:Array.from(usedEvents.values()),queryMatchesExpr:queryMatchExprs.length?literalArr(queryMatchExprs):NULL_EXPR,hostBindings:hostBindings,hostEvents:hostEvents}},ViewBuilder.prototype._visitDirective=function(providerAst,dirAst,directiveIndex,elementNodeIndex,refs,queryMatches,usedEvents,queryIds){var _this=this,nodeIndex=this.nodes.length;this.nodes.push(null),dirAst.directive.queries.forEach(function(query,queryIndex){var queryId=dirAst.contentQueryStartId+queryIndex,flags=67108864|calcStaticDynamicQueryFlags(queryIds,queryId,query.first),bindingType=query.first?0:1;_this.nodes.push(function(){return{sourceSpan:dirAst.sourceSpan,nodeFlags:flags,nodeDef:importExpr(Identifiers.queryDef).callFn([literal(flags),literal(queryId),new LiteralMapExpr([new LiteralMapEntry(query.propertyName,literal(bindingType),!1)])])}})});var childCount=this.nodes.length-nodeIndex-1,_a=this._visitProviderOrDirective(providerAst,queryMatches),flags=_a.flags,queryMatchExprs=_a.queryMatchExprs,providerExpr=_a.providerExpr,depsExpr=_a.depsExpr;refs.forEach(function(ref){ref.value&&tokenReference(ref.value)===tokenReference(providerAst.token)&&(_this.refNodeIndices[ref.name]=nodeIndex,queryMatchExprs.push(literalArr([literal(ref.name),literal(4)])))}),dirAst.directive.isComponent&&(flags|=32768);var inputDefs=dirAst.inputs.map(function(inputAst,inputIndex){var mapValue=literalArr([literal(inputIndex),literal(inputAst.directiveName)]);return new LiteralMapEntry(inputAst.directiveName,mapValue,!1)}),outputDefs=[],dirMeta=dirAst.directive;Object.keys(dirMeta.outputs).forEach(function(propName){var eventName=dirMeta.outputs[propName];usedEvents.has(eventName)&&outputDefs.push(new LiteralMapEntry(propName,literal(eventName),!1))});var updateDirectiveExpressions=[];(dirAst.inputs.length||(327680&flags)>0)&&(updateDirectiveExpressions=dirAst.inputs.map(function(input,bindingIndex){return _this._preprocessUpdateExpression({nodeIndex:nodeIndex,bindingIndex:bindingIndex,sourceSpan:input.sourceSpan,context:COMP_VAR,value:input.value})}));var dirContextExpr=importExpr(Identifiers.nodeValue).callFn([VIEW_VAR,literal(nodeIndex)]),hostBindings=dirAst.hostProperties.map(function(inputAst){return{context:dirContextExpr,dirAst:dirAst,inputAst:inputAst}}),hostEvents=dirAst.hostEvents.map(function(hostEventAst){return{context:dirContextExpr,eventAst:hostEventAst,dirAst:dirAst}}),checkIndex=nodeIndex;return this.nodes[nodeIndex]=function(){return{sourceSpan:dirAst.sourceSpan,nodeFlags:16384|flags,nodeDef:importExpr(Identifiers.directiveDef).callFn([literal(checkIndex),literal(flags),queryMatchExprs.length?literalArr(queryMatchExprs):NULL_EXPR,literal(childCount),providerExpr,depsExpr,inputDefs.length?new LiteralMapExpr(inputDefs):NULL_EXPR,outputDefs.length?new LiteralMapExpr(outputDefs):NULL_EXPR]),updateDirectives:updateDirectiveExpressions,directive:dirAst.directive.type}},{hostBindings:hostBindings,hostEvents:hostEvents}},ViewBuilder.prototype._visitProvider=function(providerAst,queryMatches){this._addProviderNode(this._visitProviderOrDirective(providerAst,queryMatches))},ViewBuilder.prototype._visitComponentFactoryResolverProvider=function(directives){var componentDirMeta=directives.find(function(dirAst){return dirAst.directive.isComponent});if(componentDirMeta&&componentDirMeta.directive.entryComponents.length){var _a=componentFactoryResolverProviderDef(this.reflector,this.outputCtx,8192,componentDirMeta.directive.entryComponents),providerExpr=_a.providerExpr,depsExpr=_a.depsExpr,flags=_a.flags,tokenExpr=_a.tokenExpr;this._addProviderNode({providerExpr:providerExpr,depsExpr:depsExpr,flags:flags,tokenExpr:tokenExpr,queryMatchExprs:[],sourceSpan:componentDirMeta.sourceSpan})}},ViewBuilder.prototype._addProviderNode=function(data){this.nodes.length;this.nodes.push(function(){return{sourceSpan:data.sourceSpan,nodeFlags:data.flags,nodeDef:importExpr(Identifiers.providerDef).callFn([literal(data.flags),data.queryMatchExprs.length?literalArr(data.queryMatchExprs):NULL_EXPR,data.tokenExpr,data.providerExpr,data.depsExpr])}})},ViewBuilder.prototype._visitProviderOrDirective=function(providerAst,queryMatches){var queryMatchExprs=[];queryMatches.forEach(function(match){tokenReference(match.value)===tokenReference(providerAst.token)&&queryMatchExprs.push(literalArr([literal(match.queryId),literal(4)]))});var _a=providerDef(this.outputCtx,providerAst),providerExpr=_a.providerExpr,depsExpr=_a.depsExpr,providerFlags=_a.flags,tokenExpr=_a.tokenExpr;return{flags:0|providerFlags,queryMatchExprs:queryMatchExprs,providerExpr:providerExpr,depsExpr:depsExpr,tokenExpr:tokenExpr,sourceSpan:providerAst.sourceSpan}},ViewBuilder.prototype.getLocal=function(name){if(name==EventHandlerVars.event.name)return EventHandlerVars.event;for(var currViewExpr=VIEW_VAR,currBuilder=this;currBuilder;currBuilder=currBuilder.parent,currViewExpr=currViewExpr.prop("parent").cast(DYNAMIC_TYPE)){var refNodeIndex=currBuilder.refNodeIndices[name];if(null!=refNodeIndex)return importExpr(Identifiers.nodeValue).callFn([currViewExpr,literal(refNodeIndex)]);var varAst=currBuilder.variables.find(function(varAst){return varAst.name===name});if(varAst){var varValue=varAst.value||"$implicit";return currViewExpr.prop("context").prop(varValue)}}return null},ViewBuilder.prototype._createLiteralArrayConverter=function(sourceSpan,argCount){if(0===argCount){var valueExpr_1=importExpr(Identifiers.EMPTY_ARRAY);return function(){return valueExpr_1}}var checkIndex=this.nodes.length;return this.nodes.push(function(){return{sourceSpan:sourceSpan,nodeFlags:32,nodeDef:importExpr(Identifiers.pureArrayDef).callFn([literal(checkIndex),literal(argCount)])}}),function(args){return callCheckStmt(checkIndex,args)}},ViewBuilder.prototype._createLiteralMapConverter=function(sourceSpan,keys){if(0===keys.length){var valueExpr_2=importExpr(Identifiers.EMPTY_MAP);return function(){return valueExpr_2}}var map=literalMap(keys.map(function(e,i){return __assign({},e,{value:literal(i)})})),checkIndex=this.nodes.length;return this.nodes.push(function(){return{sourceSpan:sourceSpan,nodeFlags:64,nodeDef:importExpr(Identifiers.pureObjectDef).callFn([literal(checkIndex),map])}}),function(args){return callCheckStmt(checkIndex,args)}},ViewBuilder.prototype._createPipeConverter=function(expression,name,argCount){var pipe=this.usedPipes.find(function(pipeSummary){return pipeSummary.name===name});if(pipe.pure){var checkIndex_1=this.nodes.length;this.nodes.push(function(){return{sourceSpan:expression.sourceSpan,nodeFlags:128,nodeDef:importExpr(Identifiers.purePipeDef).callFn([literal(checkIndex_1),literal(argCount)])}});for(var compViewExpr=VIEW_VAR,compBuilder=this;compBuilder.parent;)compBuilder=compBuilder.parent,compViewExpr=compViewExpr.prop("parent").cast(DYNAMIC_TYPE);var pipeNodeIndex=compBuilder.purePipeNodeIndices[name],pipeValueExpr_1=importExpr(Identifiers.nodeValue).callFn([compViewExpr,literal(pipeNodeIndex)]);return function(args){return callUnwrapValue(expression.nodeIndex,expression.bindingIndex,callCheckStmt(checkIndex_1,[pipeValueExpr_1].concat(args)))}}var nodeIndex=this._createPipe(expression.sourceSpan,pipe),nodeValueExpr_1=importExpr(Identifiers.nodeValue).callFn([VIEW_VAR,literal(nodeIndex)]);return function(args){return callUnwrapValue(expression.nodeIndex,expression.bindingIndex,nodeValueExpr_1.callMethod("transform",args))}},ViewBuilder.prototype._createPipe=function(sourceSpan,pipe){var _this=this,nodeIndex=this.nodes.length,flags=0;pipe.type.lifecycleHooks.forEach(function(lifecycleHook){lifecycleHook===LifecycleHooks.OnDestroy&&(flags|=lifecycleHookToNodeFlag(lifecycleHook))});var depExprs=pipe.type.diDeps.map(function(diDep){return depDef(_this.outputCtx,diDep)});return this.nodes.push(function(){return{sourceSpan:sourceSpan,nodeFlags:16,nodeDef:importExpr(Identifiers.pipeDef).callFn([literal(flags),_this.outputCtx.importExpr(pipe.type.reference),literalArr(depExprs)])}}),nodeIndex},ViewBuilder.prototype._preprocessUpdateExpression=function(expression){var _this=this;return{nodeIndex:expression.nodeIndex,bindingIndex:expression.bindingIndex,sourceSpan:expression.sourceSpan,context:expression.context,value:convertPropertyBindingBuiltins({createLiteralArrayConverter:function(argCount){return _this._createLiteralArrayConverter(expression.sourceSpan,argCount)},createLiteralMapConverter:function(keys){return _this._createLiteralMapConverter(expression.sourceSpan,keys)},createPipeConverter:function(name,argCount){return _this._createPipeConverter(expression,name,argCount)}},expression.value)}},ViewBuilder.prototype._createNodeExpressions=function(){function createUpdateStatements(nodeIndex,sourceSpan,expressions,allowEmptyExprs){var updateStmts=[],exprs=expressions.map(function(_a){var sourceSpan=_a.sourceSpan,context=_a.context,value=_a.value,bindingId=""+updateBindingCount++,nameResolver=context===COMP_VAR?self:null,_b=convertPropertyBinding(nameResolver,context,value,bindingId,BindingForm.General),stmts=_b.stmts,currValExpr=_b.currValExpr;return updateStmts.push.apply(updateStmts,stmts.map(function(stmt){return applySourceSpanToStatementIfNeeded(stmt,sourceSpan)})),applySourceSpanToExpressionIfNeeded(currValExpr,sourceSpan)});return(expressions.length||allowEmptyExprs)&&updateStmts.push(applySourceSpanToStatementIfNeeded(callCheckStmt(nodeIndex,exprs).toStmt(),sourceSpan)),updateStmts}var self=this,updateBindingCount=0,updateRendererStmts=[],updateDirectivesStmts=[],nodeDefExprs=this.nodes.map(function(factory,nodeIndex){var _a=factory(),nodeDef=_a.nodeDef,nodeFlags=_a.nodeFlags,updateDirectives=_a.updateDirectives,updateRenderer=_a.updateRenderer,sourceSpan=_a.sourceSpan;return updateRenderer&&updateRendererStmts.push.apply(updateRendererStmts,createUpdateStatements(nodeIndex,sourceSpan,updateRenderer,!1)),updateDirectives&&updateDirectivesStmts.push.apply(updateDirectivesStmts,createUpdateStatements(nodeIndex,sourceSpan,updateDirectives,(327680&nodeFlags)>0)),applySourceSpanToExpressionIfNeeded(3&nodeFlags?new CommaExpr([LOG_VAR$1.callFn([]).callFn([]),nodeDef]):nodeDef,sourceSpan)});return{updateRendererStmts:updateRendererStmts,updateDirectivesStmts:updateDirectivesStmts,nodeDefExprs:nodeDefExprs}},ViewBuilder.prototype._createElementHandleEventFn=function(nodeIndex,handlers){var _this=this,handleEventStmts=[],handleEventBindingCount=0;handlers.forEach(function(_a){var context=_a.context,eventAst=_a.eventAst,dirAst=_a.dirAst,bindingId=""+handleEventBindingCount++,nameResolver=context===COMP_VAR?_this:null,_b=convertActionBinding(nameResolver,context,eventAst.handler,bindingId),stmts=_b.stmts,allowDefault=_b.allowDefault,trueStmts=stmts;allowDefault&&trueStmts.push(ALLOW_DEFAULT_VAR.set(allowDefault.and(ALLOW_DEFAULT_VAR)).toStmt());var _c=elementEventNameAndTarget(eventAst,dirAst),eventTarget=_c.target,eventName=_c.name,fullEventName=elementEventFullName(eventTarget,eventName);handleEventStmts.push(applySourceSpanToStatementIfNeeded(new IfStmt(literal(fullEventName).identical(EVENT_NAME_VAR),trueStmts),eventAst.sourceSpan))});var handleEventFn;if(handleEventStmts.length>0){var preStmts=[ALLOW_DEFAULT_VAR.set(literal(!0)).toDeclStmt(BOOL_TYPE)];!this.component.isHost&&findReadVarNames(handleEventStmts).has(COMP_VAR.name)&&preStmts.push(COMP_VAR.set(VIEW_VAR.prop("component")).toDeclStmt(this.compType)),handleEventFn=fn([new FnParam(VIEW_VAR.name,INFERRED_TYPE),new FnParam(EVENT_NAME_VAR.name,INFERRED_TYPE),new FnParam(EventHandlerVars.event.name,INFERRED_TYPE)],preStmts.concat(handleEventStmts,[new ReturnStatement(ALLOW_DEFAULT_VAR)]),INFERRED_TYPE)}else handleEventFn=NULL_EXPR;return handleEventFn},ViewBuilder.prototype.visitDirective=function(ast,context){},ViewBuilder.prototype.visitDirectiveProperty=function(ast,context){},ViewBuilder.prototype.visitReference=function(ast,context){},ViewBuilder.prototype.visitVariable=function(ast,context){},ViewBuilder.prototype.visitEvent=function(ast,context){},ViewBuilder.prototype.visitElementProperty=function(ast,context){},ViewBuilder.prototype.visitAttr=function(ast,context){},ViewBuilder}(),MessageBundle=function(){function MessageBundle(_htmlParser,_implicitTags,_implicitAttrs,_locale){void 0===_locale&&(_locale=null),this._htmlParser=_htmlParser,this._implicitTags=_implicitTags,this._implicitAttrs=_implicitAttrs,this._locale=_locale,this._messages=[]}return MessageBundle.prototype.updateFromTemplate=function(html,url,interpolationConfig){var htmlParserResult=this._htmlParser.parse(html,url,!0,interpolationConfig);if(htmlParserResult.errors.length)return htmlParserResult.errors;var i18nParserResult=extractMessages(htmlParserResult.rootNodes,interpolationConfig,this._implicitTags,this._implicitAttrs);return i18nParserResult.errors.length?i18nParserResult.errors:((_a=this._messages).push.apply(_a,i18nParserResult.messages),[]);var _a},MessageBundle.prototype.getMessages=function(){return this._messages},MessageBundle.prototype.write=function(serializer,filterSources){var messages={},mapperVisitor=new MapPlaceholderNames;this._messages.forEach(function(message){var id=serializer.digest(message);messages.hasOwnProperty(id)?(_a=messages[id].sources).push.apply(_a,message.sources):messages[id]=message;var _a});var msgList=Object.keys(messages).map(function(id){var mapper=serializer.createNameMapper(messages[id]),src=messages[id],nodes=mapper?mapperVisitor.convert(src.nodes,mapper):src.nodes,transformedMessage=new Message(nodes,{},{},src.meaning,src.description,id);return transformedMessage.sources=src.sources,filterSources&&transformedMessage.sources.forEach(function(source){return source.filePath=filterSources(source.filePath)}),transformedMessage});return serializer.write(msgList,this._locale)},MessageBundle}(),MapPlaceholderNames=function(_super){function MapPlaceholderNames(){return null!==_super&&_super.apply(this,arguments)||this}return __extends(MapPlaceholderNames,_super),MapPlaceholderNames.prototype.convert=function(nodes,mapper){var _this=this;return mapper?nodes.map(function(n){return n.visit(_this,mapper)}):nodes},MapPlaceholderNames.prototype.visitTagPlaceholder=function(ph,mapper){var _this=this,startName=mapper.toPublicName(ph.startName),closeName=ph.closeName?mapper.toPublicName(ph.closeName):ph.closeName,children=ph.children.map(function(n){return n.visit(_this,mapper)});return new TagPlaceholder(ph.tag,ph.attrs,startName,closeName,children,ph.isVoid,ph.sourceSpan)},MapPlaceholderNames.prototype.visitPlaceholder=function(ph,mapper){return new Placeholder(ph.value,mapper.toPublicName(ph.name),ph.sourceSpan)},MapPlaceholderNames.prototype.visitIcuPlaceholder=function(ph,mapper){return new IcuPlaceholder(ph.value,mapper.toPublicName(ph.name),ph.sourceSpan)},MapPlaceholderNames}(CloneVisitor),GeneratedFile=function(){function GeneratedFile(srcFileUrl,genFileUrl,sourceOrStmts){this.srcFileUrl=srcFileUrl,this.genFileUrl=genFileUrl,"string"==typeof sourceOrStmts?(this.source=sourceOrStmts,this.stmts=null):(this.source=null,this.stmts=sourceOrStmts)}return GeneratedFile.prototype.isEquivalent=function(other){return this.genFileUrl===other.genFileUrl&&(this.source?this.source===other.source:null!=other.stmts&&areAllEquivalent(this.stmts,other.stmts))},GeneratedFile}(),ResolvedStaticSymbol=function(){function ResolvedStaticSymbol(symbol,metadata){this.symbol=symbol,this.metadata=metadata}return ResolvedStaticSymbol}(),StaticSymbolResolver=function(){function StaticSymbolResolver(host,staticSymbolCache,summaryResolver,errorRecorder){this.host=host,this.staticSymbolCache=staticSymbolCache,this.summaryResolver=summaryResolver,this.errorRecorder=errorRecorder,this.metadataCache=new Map,this.resolvedSymbols=new Map,this.resolvedFilePaths=new Set,this.importAs=new Map,this.symbolResourcePaths=new Map,this.symbolFromFile=new Map,this.knownFileNameToModuleNames=new Map}return StaticSymbolResolver.prototype.resolveSymbol=function(staticSymbol){if(staticSymbol.members.length>0)return this._resolveSymbolMembers(staticSymbol);var resultFromSummary=this._resolveSymbolFromSummary(staticSymbol);if(resultFromSummary)return resultFromSummary;var resultFromCache=this.resolvedSymbols.get(staticSymbol);return resultFromCache||(this._createSymbolsOf(staticSymbol.filePath),this.resolvedSymbols.get(staticSymbol))},StaticSymbolResolver.prototype.getImportAs=function(staticSymbol,useSummaries){if(void 0===useSummaries&&(useSummaries=!0),staticSymbol.members.length){var baseSymbol=this.getStaticSymbol(staticSymbol.filePath,staticSymbol.name),baseImportAs=this.getImportAs(baseSymbol,useSummaries);return baseImportAs?this.getStaticSymbol(baseImportAs.filePath,baseImportAs.name,staticSymbol.members):null}var summarizedFileName=stripSummaryForJitFileSuffix(staticSymbol.filePath);if(summarizedFileName!==staticSymbol.filePath){var summarizedName=stripSummaryForJitNameSuffix(staticSymbol.name),baseSymbol=this.getStaticSymbol(summarizedFileName,summarizedName,staticSymbol.members),baseImportAs=this.getImportAs(baseSymbol,useSummaries);return baseImportAs?this.getStaticSymbol(summaryForJitFileName(baseImportAs.filePath),summaryForJitName(baseImportAs.name),baseSymbol.members):null}var result=useSummaries&&this.summaryResolver.getImportAs(staticSymbol)||null;return result||(result=this.importAs.get(staticSymbol)),result},StaticSymbolResolver.prototype.getResourcePath=function(staticSymbol){return this.symbolResourcePaths.get(staticSymbol)||staticSymbol.filePath},StaticSymbolResolver.prototype.getTypeArity=function(staticSymbol){if(isGeneratedFile(staticSymbol.filePath))return null;for(var resolvedSymbol=unwrapResolvedMetadata(this.resolveSymbol(staticSymbol));resolvedSymbol&&resolvedSymbol.metadata instanceof StaticSymbol;)resolvedSymbol=unwrapResolvedMetadata(this.resolveSymbol(resolvedSymbol.metadata));return resolvedSymbol&&resolvedSymbol.metadata&&resolvedSymbol.metadata.arity||null},StaticSymbolResolver.prototype.getKnownModuleName=function(filePath){return this.knownFileNameToModuleNames.get(filePath)||null},StaticSymbolResolver.prototype.recordImportAs=function(sourceSymbol,targetSymbol){sourceSymbol.assertNoMembers(),targetSymbol.assertNoMembers(),this.importAs.set(sourceSymbol,targetSymbol)},StaticSymbolResolver.prototype.recordModuleNameForFileName=function(fileName,moduleName){this.knownFileNameToModuleNames.set(fileName,moduleName)},StaticSymbolResolver.prototype.invalidateFile=function(fileName){this.metadataCache.delete(fileName),this.resolvedFilePaths.delete(fileName);var symbols=this.symbolFromFile.get(fileName);if(symbols){this.symbolFromFile.delete(fileName);for(var _i=0,symbols_1=symbols;_i<symbols_1.length;_i++){var symbol=symbols_1[_i];this.resolvedSymbols.delete(symbol),this.importAs.delete(symbol),this.symbolResourcePaths.delete(symbol)}}},StaticSymbolResolver.prototype.ignoreErrorsFor=function(cb){var recorder=this.errorRecorder;this.errorRecorder=function(){};try{return cb()}finally{this.errorRecorder=recorder}},StaticSymbolResolver.prototype._resolveSymbolMembers=function(staticSymbol){var members=staticSymbol.members,baseResolvedSymbol=this.resolveSymbol(this.getStaticSymbol(staticSymbol.filePath,staticSymbol.name));if(!baseResolvedSymbol)return null;var baseMetadata=unwrapResolvedMetadata(baseResolvedSymbol.metadata);if(baseMetadata instanceof StaticSymbol)return new ResolvedStaticSymbol(staticSymbol,this.getStaticSymbol(baseMetadata.filePath,baseMetadata.name,members));if(!baseMetadata||"class"!==baseMetadata.__symbolic){for(var value=baseMetadata,i=0;i<members.length&&value;i++)value=value[members[i]];return new ResolvedStaticSymbol(staticSymbol,value)}return baseMetadata.statics&&1===members.length?new ResolvedStaticSymbol(staticSymbol,baseMetadata.statics[members[0]]):null},StaticSymbolResolver.prototype._resolveSymbolFromSummary=function(staticSymbol){var summary=this.summaryResolver.resolveSummary(staticSymbol);return summary?new ResolvedStaticSymbol(staticSymbol,summary.metadata):null},StaticSymbolResolver.prototype.getStaticSymbol=function(declarationFile,name,members){return this.staticSymbolCache.get(declarationFile,name,members)},StaticSymbolResolver.prototype.hasDecorators=function(filePath){var metadata=this.getModuleMetadata(filePath);return!!metadata.metadata&&Object.keys(metadata.metadata).some(function(metadataKey){var entry=metadata.metadata[metadataKey];return entry&&"class"===entry.__symbolic&&entry.decorators})},StaticSymbolResolver.prototype.getSymbolsOf=function(filePath){var summarySymbols=this.summaryResolver.getSymbolsOf(filePath);if(summarySymbols)return summarySymbols;this._createSymbolsOf(filePath);var metadataSymbols=[];return this.resolvedSymbols.forEach(function(resolvedSymbol){resolvedSymbol.symbol.filePath===filePath&&metadataSymbols.push(resolvedSymbol.symbol)}),metadataSymbols},StaticSymbolResolver.prototype._createSymbolsOf=function(filePath){var _this=this;if(!this.resolvedFilePaths.has(filePath)){this.resolvedFilePaths.add(filePath);var resolvedSymbols=[],metadata=this.getModuleMetadata(filePath);if(metadata.importAs&&this.knownFileNameToModuleNames.set(filePath,metadata.importAs),metadata.exports)for(var this_1=this,_i=0,_a=metadata.exports;_i<_a.length;_i++){var moduleExport=_a[_i];!function(moduleExport){if(moduleExport.export)moduleExport.export.forEach(function(exportSymbol){var symbolName;symbolName="string"==typeof exportSymbol?exportSymbol:exportSymbol.as,symbolName=unescapeIdentifier(symbolName);var symName=symbolName;"string"!=typeof exportSymbol&&(symName=unescapeIdentifier(exportSymbol.name));var resolvedModule=_this.resolveModule(moduleExport.from,filePath);if(resolvedModule){var targetSymbol=_this.getStaticSymbol(resolvedModule,symName),sourceSymbol=_this.getStaticSymbol(filePath,symbolName);resolvedSymbols.push(_this.createExport(sourceSymbol,targetSymbol))}});else{var resolvedModule=this_1.resolveModule(moduleExport.from,filePath);if(resolvedModule){this_1.getSymbolsOf(resolvedModule).forEach(function(targetSymbol){var sourceSymbol=_this.getStaticSymbol(filePath,targetSymbol.name);resolvedSymbols.push(_this.createExport(sourceSymbol,targetSymbol))})}}}(moduleExport)}if(metadata.metadata){var topLevelSymbolNames_1=new Set(Object.keys(metadata.metadata).map(unescapeIdentifier)),origins_1=metadata.origins||{};Object.keys(metadata.metadata).forEach(function(metadataKey){var symbolMeta=metadata.metadata[metadataKey],name=unescapeIdentifier(metadataKey),symbol=_this.getStaticSymbol(filePath,name),origin=origins_1.hasOwnProperty(metadataKey)&&origins_1[metadataKey];if(origin){var originFilePath=_this.resolveModule(origin,filePath);originFilePath?_this.symbolResourcePaths.set(symbol,originFilePath):_this.reportError(new Error("Couldn't resolve original symbol for "+origin+" from "+filePath))}resolvedSymbols.push(_this.createResolvedSymbol(symbol,filePath,topLevelSymbolNames_1,symbolMeta))})}resolvedSymbols.forEach(function(resolvedSymbol){return _this.resolvedSymbols.set(resolvedSymbol.symbol,resolvedSymbol)}),this.symbolFromFile.set(filePath,resolvedSymbols.map(function(resolvedSymbol){return resolvedSymbol.symbol}))}},StaticSymbolResolver.prototype.createResolvedSymbol=function(sourceSymbol,topLevelPath,topLevelSymbolNames,metadata){var _this=this;if(this.summaryResolver.isLibraryFile(sourceSymbol.filePath)&&metadata&&"class"===metadata.__symbolic){var transformedMeta_1={__symbolic:"class",arity:metadata.arity};return new ResolvedStaticSymbol(sourceSymbol,transformedMeta_1)}var _originalFileMemo,getOriginalName=function(){return _originalFileMemo||(_originalFileMemo=_this.host.getOutputName(topLevelPath.replace(/((\.ts)|(\.d\.ts)|)$/,".ts").replace(/^.*node_modules[\/\\]/,""))),_originalFileMemo},self=this,ReferenceTransformer=function(_super){function ReferenceTransformer(){return null!==_super&&_super.apply(this,arguments)||this}return __extends(ReferenceTransformer,_super),ReferenceTransformer.prototype.visitStringMap=function(map,functionParams){var symbolic=map.__symbolic;if("function"===symbolic){var oldLen=functionParams.length;functionParams.push.apply(functionParams,map.parameters||[]);var result=_super.prototype.visitStringMap.call(this,map,functionParams);return functionParams.length=oldLen,result}if("reference"!==symbolic)return"error"===symbolic?__assign({},map,{fileName:getOriginalName()}):_super.prototype.visitStringMap.call(this,map,functionParams);var module=map.module,name_1=map.name?unescapeIdentifier(map.name):map.name;if(!name_1)return null;var filePath=void 0;return module?(filePath=self.resolveModule(module,sourceSymbol.filePath),filePath?{__symbolic:"resolved",symbol:self.getStaticSymbol(filePath,name_1),line:map.line,character:map.character,fileName:getOriginalName()}:{__symbolic:"error",message:"Could not resolve "+module+" relative to "+sourceSymbol.filePath+".",line:map.line,character:map.character,fileName:getOriginalName()}):functionParams.indexOf(name_1)>=0?{__symbolic:"reference",name:name_1}:topLevelSymbolNames.has(name_1)?self.getStaticSymbol(topLevelPath,name_1):void 0},ReferenceTransformer}(ValueTransformer),transformedMeta=visitValue(metadata,new ReferenceTransformer,[]),unwrappedTransformedMeta=unwrapResolvedMetadata(transformedMeta);return unwrappedTransformedMeta instanceof StaticSymbol?this.createExport(sourceSymbol,unwrappedTransformedMeta):new ResolvedStaticSymbol(sourceSymbol,transformedMeta)},StaticSymbolResolver.prototype.createExport=function(sourceSymbol,targetSymbol){return sourceSymbol.assertNoMembers(),targetSymbol.assertNoMembers(),this.summaryResolver.isLibraryFile(sourceSymbol.filePath)&&this.summaryResolver.isLibraryFile(targetSymbol.filePath)&&this.importAs.set(targetSymbol,this.getImportAs(sourceSymbol)||sourceSymbol),new ResolvedStaticSymbol(sourceSymbol,targetSymbol)},StaticSymbolResolver.prototype.reportError=function(error,context,path){if(!this.errorRecorder)throw error;this.errorRecorder(error,context&&context.filePath||path)},StaticSymbolResolver.prototype.getModuleMetadata=function(module){var moduleMetadata=this.metadataCache.get(module);if(!moduleMetadata){var moduleMetadatas=this.host.getMetadataFor(module);if(moduleMetadatas){var maxVersion_1=-1;moduleMetadatas.forEach(function(md){md&&md.version>maxVersion_1&&(maxVersion_1=md.version,moduleMetadata=md)})}if(moduleMetadata||(moduleMetadata={__symbolic:"module",version:4,module:module,metadata:{}}),4!=moduleMetadata.version){var errorMessage=2==moduleMetadata.version?"Unsupported metadata version "+moduleMetadata.version+" for module "+module+". This module should be compiled with a newer version of ngc":"Metadata version mismatch for module "+module+", found version "+moduleMetadata.version+", expected 4";this.reportError(new Error(errorMessage))}this.metadataCache.set(module,moduleMetadata)}return moduleMetadata},StaticSymbolResolver.prototype.getSymbolByModule=function(module,symbolName,containingFile){var filePath=this.resolveModule(module,containingFile);return filePath?this.getStaticSymbol(filePath,symbolName):(this.reportError(new Error("Could not resolve module "+module+(containingFile?" relative to "+containingFile:""))),this.getStaticSymbol("ERROR:"+module,symbolName))},StaticSymbolResolver.prototype.resolveModule=function(module,containingFile){try{return this.host.moduleNameToFileName(module,containingFile)}catch(e){console.error("Could not resolve module '"+module+"' relative to file "+containingFile),this.reportError(e,void 0,containingFile)}return null},StaticSymbolResolver}(),ToJsonSerializer=function(_super){function ToJsonSerializer(symbolResolver,summaryResolver,srcFileName){var _this=_super.call(this)||this;return _this.symbolResolver=symbolResolver,_this.summaryResolver=summaryResolver,_this.srcFileName=srcFileName,_this.symbols=[],_this.indexBySymbol=new Map,_this.reexportedBy=new Map,_this.processedSummaryBySymbol=new Map,_this.processedSummaries=[],_this.unprocessedSymbolSummariesBySymbol=new Map,_this.moduleName=symbolResolver.getKnownModuleName(srcFileName),_this}return __extends(ToJsonSerializer,_super),ToJsonSerializer.prototype.addSummary=function(summary){var _this=this,unprocessedSummary=this.unprocessedSymbolSummariesBySymbol.get(summary.symbol),processedSummary=this.processedSummaryBySymbol.get(summary.symbol);if(unprocessedSummary||(unprocessedSummary={symbol:summary.symbol,metadata:void 0},this.unprocessedSymbolSummariesBySymbol.set(summary.symbol,unprocessedSummary),processedSummary={symbol:this.processValue(summary.symbol,0)},this.processedSummaries.push(processedSummary),this.processedSummaryBySymbol.set(summary.symbol,processedSummary)),!unprocessedSummary.metadata&&summary.metadata){var metadata_1=summary.metadata||{};if("class"===metadata_1.__symbolic){var clone_1={};Object.keys(metadata_1).forEach(function(propName){"decorators"!==propName&&(clone_1[propName]=metadata_1[propName])}),metadata_1=clone_1}else isCall(metadata_1)&&(isFunctionCall(metadata_1)||isMethodCallOnVariable(metadata_1)||(metadata_1={__symbolic:"error",message:"Complex function calls are not supported."}));if(unprocessedSummary.metadata=metadata_1,processedSummary.metadata=this.processValue(metadata_1,1),metadata_1 instanceof StaticSymbol&&this.summaryResolver.isLibraryFile(metadata_1.filePath)){var declarationSymbol=this.symbols[this.indexBySymbol.get(metadata_1)];isLoweredSymbol(declarationSymbol.name)||this.reexportedBy.set(declarationSymbol,summary.symbol)}}if(!unprocessedSummary.type&&summary.type&&(unprocessedSummary.type=summary.type,processedSummary.type=this.processValue(summary.type,0),summary.type.summaryKind===CompileSummaryKind.NgModule)){var ngModuleSummary=summary.type;ngModuleSummary.exportedDirectives.concat(ngModuleSummary.exportedPipes).forEach(function(id){var symbol=id.reference;if(_this.summaryResolver.isLibraryFile(symbol.filePath)&&!_this.unprocessedSymbolSummariesBySymbol.has(symbol)){var summary_1=_this.summaryResolver.resolveSummary(symbol);summary_1&&_this.addSummary(summary_1)}})}},ToJsonSerializer.prototype.serialize=function(){var _this=this,exportAs=[];return{json:JSON.stringify({moduleName:this.moduleName,summaries:this.processedSummaries,symbols:this.symbols.map(function(symbol,index){symbol.assertNoMembers();var importAs=void 0;if(_this.summaryResolver.isLibraryFile(symbol.filePath)){var reexportSymbol=_this.reexportedBy.get(symbol);if(reexportSymbol)importAs=_this.indexBySymbol.get(reexportSymbol);else{var summary=_this.unprocessedSymbolSummariesBySymbol.get(symbol);summary&&summary.metadata&&"interface"===summary.metadata.__symbolic||(importAs=symbol.name+"_"+index,exportAs.push({symbol:symbol,exportAs:importAs
}))}}return{__symbol:index,name:symbol.name,filePath:_this.summaryResolver.toSummaryFileName(symbol.filePath,_this.srcFileName),importAs:importAs}})}),exportAs:exportAs}},ToJsonSerializer.prototype.processValue=function(value,flags){return visitValue(value,this,flags)},ToJsonSerializer.prototype.visitOther=function(value,context){if(value instanceof StaticSymbol){var baseSymbol=this.symbolResolver.getStaticSymbol(value.filePath,value.name);return{__symbol:this.visitStaticSymbol(baseSymbol,context),members:value.members}}},ToJsonSerializer.prototype.visitStaticSymbol=function(baseSymbol,flags){var index=this.indexBySymbol.get(baseSymbol),summary=null;if(1&flags&&this.summaryResolver.isLibraryFile(baseSymbol.filePath)){if(this.unprocessedSymbolSummariesBySymbol.has(baseSymbol))return index;summary=this.loadSummary(baseSymbol),summary&&summary.metadata instanceof StaticSymbol&&(index=this.visitStaticSymbol(summary.metadata,flags),summary=null)}else if(null!=index)return index;return null==index&&(index=this.symbols.length,this.symbols.push(baseSymbol)),this.indexBySymbol.set(baseSymbol,index),summary&&this.addSummary(summary),index},ToJsonSerializer.prototype.loadSummary=function(symbol){var summary=this.summaryResolver.resolveSummary(symbol);if(!summary){var resolvedSymbol=this.symbolResolver.resolveSymbol(symbol);resolvedSymbol&&(summary={symbol:resolvedSymbol.symbol,metadata:resolvedSymbol.metadata})}return summary},ToJsonSerializer}(ValueTransformer),ForJitSerializer=function(){function ForJitSerializer(outputCtx,symbolResolver,summaryResolver){this.outputCtx=outputCtx,this.symbolResolver=symbolResolver,this.summaryResolver=summaryResolver,this.data=[]}return ForJitSerializer.prototype.addSourceType=function(summary,metadata){this.data.push({summary:summary,metadata:metadata,isLibrary:!1})},ForJitSerializer.prototype.addLibType=function(summary){this.data.push({summary:summary,metadata:null,isLibrary:!0})},ForJitSerializer.prototype.serialize=function(exportAsArr){for(var _this=this,exportAsBySymbol=new Map,_i=0,exportAsArr_1=exportAsArr;_i<exportAsArr_1.length;_i++){var _a=exportAsArr_1[_i],symbol=_a.symbol,exportAs=_a.exportAs;exportAsBySymbol.set(symbol,exportAs)}for(var ngModuleSymbols=new Set,_b=0,_c=this.data;_b<_c.length;_b++){var _d=_c[_b],summary=_d.summary,metadata=_d.metadata,isLibrary=_d.isLibrary;if(summary.summaryKind===CompileSummaryKind.NgModule){ngModuleSymbols.add(summary.type.reference);for(var modSummary=summary,_e=0,_f=modSummary.modules;_e<_f.length;_e++){var mod=_f[_e];ngModuleSymbols.add(mod.reference)}}if(!isLibrary){summaryForJitName(summary.type.reference.name);createSummaryForJitFunction(this.outputCtx,summary.type.reference,this.serializeSummaryWithDeps(summary,metadata))}}ngModuleSymbols.forEach(function(ngModuleSymbol){if(_this.summaryResolver.isLibraryFile(ngModuleSymbol.filePath)){var exportAs=exportAsBySymbol.get(ngModuleSymbol)||ngModuleSymbol.name,jitExportAsName=summaryForJitName(exportAs);_this.outputCtx.statements.push(variable(jitExportAsName).set(_this.serializeSummaryRef(ngModuleSymbol)).toDeclStmt(null,[StmtModifier.Exported]))}})},ForJitSerializer.prototype.serializeSummaryWithDeps=function(summary,metadata){var _this=this,expressions=[this.serializeSummary(summary)],providers=[];if(metadata instanceof CompileNgModuleMetadata)expressions.push.apply(expressions,metadata.declaredDirectives.concat(metadata.declaredPipes).map(function(type){return type.reference}).concat(metadata.transitiveModule.modules.map(function(type){return type.reference}).filter(function(ref){return ref!==metadata.type.reference})).map(function(ref){return _this.serializeSummaryRef(ref)})),providers=metadata.providers;else if(summary.summaryKind===CompileSummaryKind.Directive){var dirSummary=summary;providers=dirSummary.providers.concat(dirSummary.viewProviders)}return expressions.push.apply(expressions,providers.filter(function(provider){return!!provider.useClass}).map(function(provider){return _this.serializeSummary({summaryKind:CompileSummaryKind.Injectable,type:provider.useClass})})),literalArr(expressions)},ForJitSerializer.prototype.serializeSummaryRef=function(typeSymbol){var jitImportedSymbol=this.symbolResolver.getStaticSymbol(summaryForJitFileName(typeSymbol.filePath),summaryForJitName(typeSymbol.name));return this.outputCtx.importExpr(jitImportedSymbol)},ForJitSerializer.prototype.serializeSummary=function(data){var outputCtx=this.outputCtx;return visitValue(data,new(function(){function Transformer(){}return Transformer.prototype.visitArray=function(arr,context){var _this=this;return literalArr(arr.map(function(entry){return visitValue(entry,_this,context)}))},Transformer.prototype.visitStringMap=function(map,context){var _this=this;return new LiteralMapExpr(Object.keys(map).map(function(key){return new LiteralMapEntry(key,visitValue(map[key],_this,context),!1)}))},Transformer.prototype.visitPrimitive=function(value,context){return literal(value)},Transformer.prototype.visitOther=function(value,context){if(value instanceof StaticSymbol)return outputCtx.importExpr(value);throw new Error("Illegal State: Encountered value "+value)},Transformer}()),null)},ForJitSerializer}(),FromJsonDeserializer=function(_super){function FromJsonDeserializer(symbolCache,summaryResolver){var _this=_super.call(this)||this;return _this.symbolCache=symbolCache,_this.summaryResolver=summaryResolver,_this}return __extends(FromJsonDeserializer,_super),FromJsonDeserializer.prototype.deserialize=function(libraryFileName,json){var _this=this,data=JSON.parse(json),allImportAs=[];this.symbols=data.symbols.map(function(serializedSymbol){return _this.symbolCache.get(_this.summaryResolver.fromSummaryFileName(serializedSymbol.filePath,libraryFileName),serializedSymbol.name)}),data.symbols.forEach(function(serializedSymbol,index){var symbol=_this.symbols[index],importAs=serializedSymbol.importAs;"number"==typeof importAs?allImportAs.push({symbol:symbol,importAs:_this.symbols[importAs]}):"string"==typeof importAs&&allImportAs.push({symbol:symbol,importAs:_this.symbolCache.get(ngfactoryFilePath(libraryFileName),importAs)})});var summaries=visitValue(data.summaries,this,null);return{moduleName:data.moduleName,summaries:summaries,importAs:allImportAs}},FromJsonDeserializer.prototype.visitStringMap=function(map,context){if("__symbol"in map){var baseSymbol=this.symbols[map.__symbol],members=map.members;return members.length?this.symbolCache.get(baseSymbol.filePath,baseSymbol.name,members):baseSymbol}return _super.prototype.visitStringMap.call(this,map,context)},FromJsonDeserializer}(ValueTransformer),StubEmitFlags={Basic:1,TypeCheck:2,All:3};StubEmitFlags[StubEmitFlags.Basic]="Basic",StubEmitFlags[StubEmitFlags.TypeCheck]="TypeCheck",StubEmitFlags[StubEmitFlags.All]="All";var AotCompiler=function(){function AotCompiler(_config,_options,_host,_reflector,_metadataResolver,_templateParser,_styleCompiler,_viewCompiler,_typeCheckCompiler,_ngModuleCompiler,_outputEmitter,_summaryResolver,_symbolResolver){this._config=_config,this._options=_options,this._host=_host,this._reflector=_reflector,this._metadataResolver=_metadataResolver,this._templateParser=_templateParser,this._styleCompiler=_styleCompiler,this._viewCompiler=_viewCompiler,this._typeCheckCompiler=_typeCheckCompiler,this._ngModuleCompiler=_ngModuleCompiler,this._outputEmitter=_outputEmitter,this._summaryResolver=_summaryResolver,this._symbolResolver=_symbolResolver,this._templateAstCache=new Map,this._analyzedFiles=new Map}return AotCompiler.prototype.clearCache=function(){this._metadataResolver.clearCache()},AotCompiler.prototype.analyzeModulesSync=function(rootFiles){var _this=this,analyzeResult=analyzeAndValidateNgModules(rootFiles,this._host,this._symbolResolver,this._metadataResolver);return analyzeResult.ngModules.forEach(function(ngModule){return _this._metadataResolver.loadNgModuleDirectiveAndPipeMetadata(ngModule.type.reference,!0)}),analyzeResult},AotCompiler.prototype.analyzeModulesAsync=function(rootFiles){var _this=this,analyzeResult=analyzeAndValidateNgModules(rootFiles,this._host,this._symbolResolver,this._metadataResolver);return Promise.all(analyzeResult.ngModules.map(function(ngModule){return _this._metadataResolver.loadNgModuleDirectiveAndPipeMetadata(ngModule.type.reference,!1)})).then(function(){return analyzeResult})},AotCompiler.prototype._analyzeFile=function(fileName){var analyzedFile=this._analyzedFiles.get(fileName);return analyzedFile||(analyzedFile=analyzeFile(this._host,this._symbolResolver,this._metadataResolver,fileName),this._analyzedFiles.set(fileName,analyzedFile)),analyzedFile},AotCompiler.prototype.findGeneratedFileNames=function(fileName){var _this=this,genFileNames=[],file=this._analyzeFile(fileName);(this._options.allowEmptyCodegenFiles||file.directives.length||file.pipes.length||file.injectables.length||file.ngModules.length||file.exportsNonSourceFiles)&&(genFileNames.push(ngfactoryFilePath(file.fileName,!0)),this._options.enableSummariesForJit&&genFileNames.push(summaryForJitFileName(file.fileName,!0)));var fileSuffix=normalizeGenFileSuffix(splitTypescriptSuffix(file.fileName,!0)[1]);return file.directives.forEach(function(dirSymbol){var compMeta=_this._metadataResolver.getNonNormalizedDirectiveMetadata(dirSymbol).metadata;compMeta.isComponent&&compMeta.template.styleUrls.forEach(function(styleUrl){var normalizedUrl=_this._host.resourceNameToFileName(styleUrl,file.fileName);if(!normalizedUrl)throw syntaxError("Couldn't resolve resource "+styleUrl+" relative to "+file.fileName);var needsShim=(compMeta.template.encapsulation||_this._config.defaultEncapsulation)===ViewEncapsulation.Emulated;genFileNames.push(_stylesModuleUrl(normalizedUrl,needsShim,fileSuffix)),_this._options.allowEmptyCodegenFiles&&genFileNames.push(_stylesModuleUrl(normalizedUrl,!needsShim,fileSuffix))})}),genFileNames},AotCompiler.prototype.emitBasicStub=function(genFileName,originalFileName){var outputCtx=this._createOutputContext(genFileName);if(genFileName.endsWith(".ngfactory.ts")){if(!originalFileName)throw new Error("Assertion error: require the original file for .ngfactory.ts stubs. File: "+genFileName);var originalFile=this._analyzeFile(originalFileName);this._createNgFactoryStub(outputCtx,originalFile,StubEmitFlags.Basic)}else if(genFileName.endsWith(".ngsummary.ts")){if(this._options.enableSummariesForJit){if(!originalFileName)throw new Error("Assertion error: require the original file for .ngsummary.ts stubs. File: "+genFileName);var originalFile=this._analyzeFile(originalFileName);_createEmptyStub(outputCtx),originalFile.ngModules.forEach(function(ngModule){createForJitStub(outputCtx,ngModule.type.reference)})}}else genFileName.endsWith(".ngstyle.ts")&&_createEmptyStub(outputCtx);return this._codegenSourceModule("unknown",outputCtx)},AotCompiler.prototype.emitTypeCheckStub=function(genFileName,originalFileName){var originalFile=this._analyzeFile(originalFileName),outputCtx=this._createOutputContext(genFileName);return genFileName.endsWith(".ngfactory.ts")&&this._createNgFactoryStub(outputCtx,originalFile,StubEmitFlags.TypeCheck),outputCtx.statements.length>0?this._codegenSourceModule(originalFile.fileName,outputCtx):null},AotCompiler.prototype.loadFilesAsync=function(fileNames){var _this=this,files=fileNames.map(function(fileName){return _this._analyzeFile(fileName)}),loadingPromises=[];return files.forEach(function(file){return file.ngModules.forEach(function(ngModule){return loadingPromises.push(_this._metadataResolver.loadNgModuleDirectiveAndPipeMetadata(ngModule.type.reference,!1))})}),Promise.all(loadingPromises).then(function(_){return mergeAndValidateNgFiles(files)})},AotCompiler.prototype.loadFilesSync=function(fileNames){var _this=this,files=fileNames.map(function(fileName){return _this._analyzeFile(fileName)});return files.forEach(function(file){return file.ngModules.forEach(function(ngModule){return _this._metadataResolver.loadNgModuleDirectiveAndPipeMetadata(ngModule.type.reference,!0)})}),mergeAndValidateNgFiles(files)},AotCompiler.prototype._createNgFactoryStub=function(outputCtx,file,emitFlags){var _this=this,componentId=0;file.ngModules.forEach(function(ngModuleMeta,ngModuleIndex){_this._ngModuleCompiler.createStub(outputCtx,ngModuleMeta.type.reference);var externalReferences=ngModuleMeta.transitiveModule.directives.map(function(d){return d.reference}).concat(ngModuleMeta.transitiveModule.pipes.map(function(d){return d.reference}),ngModuleMeta.importedModules.map(function(m){return m.type.reference}),ngModuleMeta.exportedModules.map(function(m){return m.type.reference}),_this._externalIdentifierReferences([Identifiers.TemplateRef,Identifiers.ElementRef])),externalReferenceVars=new Map;externalReferences.forEach(function(ref,typeIndex){externalReferenceVars.set(ref,"_decl"+ngModuleIndex+"_"+typeIndex)}),externalReferenceVars.forEach(function(varName,reference){outputCtx.statements.push(variable(varName).set(NULL_EXPR.cast(DYNAMIC_TYPE)).toDeclStmt(expressionType(outputCtx.importExpr(reference,null,!1))))}),emitFlags&StubEmitFlags.TypeCheck&&ngModuleMeta.declaredDirectives.forEach(function(dirId){var compMeta=_this._metadataResolver.getDirectiveMetadata(dirId.reference);compMeta.isComponent&&(componentId++,_this._createTypeCheckBlock(outputCtx,compMeta.type.reference.name+"_Host_"+componentId,ngModuleMeta,_this._metadataResolver.getHostComponentMetadata(compMeta),[compMeta.type],externalReferenceVars),_this._createTypeCheckBlock(outputCtx,compMeta.type.reference.name+"_"+componentId,ngModuleMeta,compMeta,ngModuleMeta.transitiveModule.directives,externalReferenceVars))})}),0===outputCtx.statements.length&&_createEmptyStub(outputCtx)},AotCompiler.prototype._externalIdentifierReferences=function(references){for(var result=[],_i=0,references_1=references;_i<references_1.length;_i++){var reference=references_1[_i],token=createTokenForExternalReference(this._reflector,reference);token.identifier&&result.push(token.identifier.reference)}return result},AotCompiler.prototype._createTypeCheckBlock=function(ctx,componentId,moduleMeta,compMeta,directives,externalReferenceVars){var _a=this._parseTemplate(compMeta,moduleMeta,directives),parsedTemplate=_a.template,usedPipes=_a.pipes;(_b=ctx.statements).push.apply(_b,this._typeCheckCompiler.compileComponent(componentId,compMeta,parsedTemplate,usedPipes,externalReferenceVars,ctx));var _b},AotCompiler.prototype.emitMessageBundle=function(analyzeResult,locale){var _this=this,errors=[],htmlParser=new HtmlParser,messageBundle=new MessageBundle(htmlParser,[],{},locale);if(analyzeResult.files.forEach(function(file){var compMetas=[];file.directives.forEach(function(directiveType){var dirMeta=_this._metadataResolver.getDirectiveMetadata(directiveType);dirMeta&&dirMeta.isComponent&&compMetas.push(dirMeta)}),compMetas.forEach(function(compMeta){var html=compMeta.template.template,interpolationConfig=InterpolationConfig.fromArray(compMeta.template.interpolation);errors.push.apply(errors,messageBundle.updateFromTemplate(html,file.fileName,interpolationConfig))})}),errors.length)throw new Error(errors.map(function(e){return e.toString()}).join("\n"));return messageBundle},AotCompiler.prototype.emitAllImpls=function(analyzeResult){var _this=this,ngModuleByPipeOrDirective=analyzeResult.ngModuleByPipeOrDirective;return flatten(analyzeResult.files.map(function(file){return _this._compileImplFile(file.fileName,ngModuleByPipeOrDirective,file.directives,file.pipes,file.ngModules,file.injectables)}))},AotCompiler.prototype._compileImplFile=function(srcFileUrl,ngModuleByPipeOrDirective,directives,pipes,ngModules,injectables){var _this=this,fileSuffix=normalizeGenFileSuffix(splitTypescriptSuffix(srcFileUrl,!0)[1]),generatedFiles=[],outputCtx=this._createOutputContext(ngfactoryFilePath(srcFileUrl,!0));if(generatedFiles.push.apply(generatedFiles,this._createSummary(srcFileUrl,directives,pipes,ngModules,injectables,outputCtx)),ngModules.forEach(function(ngModuleMeta){return _this._compileModule(outputCtx,ngModuleMeta)}),directives.forEach(function(dirType){var compMeta=_this._metadataResolver.getDirectiveMetadata(dirType);if(compMeta.isComponent){var ngModule=ngModuleByPipeOrDirective.get(dirType);if(!ngModule)throw new Error("Internal Error: cannot determine the module for component "+identifierName(compMeta.type)+"!");var componentStylesheet=_this._styleCompiler.compileComponent(outputCtx,compMeta);compMeta.template.externalStylesheets.forEach(function(stylesheetMeta){var shim=_this._styleCompiler.needsStyleShim(compMeta);generatedFiles.push(_this._codegenStyles(srcFileUrl,compMeta,stylesheetMeta,shim,fileSuffix)),_this._options.allowEmptyCodegenFiles&&generatedFiles.push(_this._codegenStyles(srcFileUrl,compMeta,stylesheetMeta,!shim,fileSuffix))});_this._compileComponent(outputCtx,compMeta,ngModule,ngModule.transitiveModule.directives,componentStylesheet,fileSuffix);_this._compileComponentFactory(outputCtx,compMeta,ngModule,fileSuffix)}}),outputCtx.statements.length>0||this._options.allowEmptyCodegenFiles){var srcModule=this._codegenSourceModule(srcFileUrl,outputCtx);generatedFiles.unshift(srcModule)}return generatedFiles},AotCompiler.prototype._createSummary=function(srcFileName,directives,pipes,ngModules,injectables,ngFactoryCtx){var _this=this,symbolSummaries=this._symbolResolver.getSymbolsOf(srcFileName).map(function(symbol){return _this._symbolResolver.resolveSymbol(symbol)}),typeData=ngModules.map(function(meta){return{summary:_this._metadataResolver.getNgModuleSummary(meta.type.reference),metadata:_this._metadataResolver.getNgModuleMetadata(meta.type.reference)}}).concat(directives.map(function(ref){return{summary:_this._metadataResolver.getDirectiveSummary(ref),metadata:_this._metadataResolver.getDirectiveMetadata(ref)}}),pipes.map(function(ref){return{summary:_this._metadataResolver.getPipeSummary(ref),metadata:_this._metadataResolver.getPipeMetadata(ref)}}),injectables.map(function(ref){return{summary:_this._metadataResolver.getInjectableSummary(ref),metadata:_this._metadataResolver.getInjectableSummary(ref).type}})),forJitOutputCtx=this._options.enableSummariesForJit?this._createOutputContext(summaryForJitFileName(srcFileName,!0)):null,_a=serializeSummaries(srcFileName,forJitOutputCtx,this._summaryResolver,this._symbolResolver,symbolSummaries,typeData),json=_a.json;_a.exportAs.forEach(function(entry){ngFactoryCtx.statements.push(variable(entry.exportAs).set(ngFactoryCtx.importExpr(entry.symbol)).toDeclStmt(null,[StmtModifier.Exported]))});var summaryJson=new GeneratedFile(srcFileName,summaryFileName(srcFileName),json),result=[summaryJson];return forJitOutputCtx&&result.push(this._codegenSourceModule(srcFileName,forJitOutputCtx)),result},AotCompiler.prototype._compileModule=function(outputCtx,ngModule){var providers=[];if(this._options.locale){var normalizedLocale=this._options.locale.replace(/_/g,"-");providers.push({token:createTokenForExternalReference(this._reflector,Identifiers.LOCALE_ID),useValue:normalizedLocale})}this._options.i18nFormat&&providers.push({token:createTokenForExternalReference(this._reflector,Identifiers.TRANSLATIONS_FORMAT),useValue:this._options.i18nFormat}),this._ngModuleCompiler.compile(outputCtx,ngModule,providers)},AotCompiler.prototype._compileComponentFactory=function(outputCtx,compMeta,ngModule,fileSuffix){var hostMeta=this._metadataResolver.getHostComponentMetadata(compMeta),hostViewFactoryVar=this._compileComponent(outputCtx,hostMeta,ngModule,[compMeta.type],null,fileSuffix).viewClassVar,compFactoryVar=componentFactoryName(compMeta.type.reference),inputsExprs=[];for(var propName in compMeta.inputs){var templateName=compMeta.inputs[propName];inputsExprs.push(new LiteralMapEntry(propName,literal(templateName),!1))}var outputsExprs=[];for(var propName in compMeta.outputs){var templateName=compMeta.outputs[propName];outputsExprs.push(new LiteralMapEntry(propName,literal(templateName),!1))}outputCtx.statements.push(variable(compFactoryVar).set(importExpr(Identifiers.createComponentFactory).callFn([literal(compMeta.selector),outputCtx.importExpr(compMeta.type.reference),variable(hostViewFactoryVar),new LiteralMapExpr(inputsExprs),new LiteralMapExpr(outputsExprs),literalArr(compMeta.template.ngContentSelectors.map(function(selector){return literal(selector)}))])).toDeclStmt(importType(Identifiers.ComponentFactory,[expressionType(outputCtx.importExpr(compMeta.type.reference))],[TypeModifier.Const]),[StmtModifier.Final,StmtModifier.Exported]))},AotCompiler.prototype._compileComponent=function(outputCtx,compMeta,ngModule,directiveIdentifiers,componentStyles,fileSuffix){var _a=this._parseTemplate(compMeta,ngModule,directiveIdentifiers),parsedTemplate=_a.template,usedPipes=_a.pipes,stylesExpr=componentStyles?variable(componentStyles.stylesVar):literalArr([]),viewResult=this._viewCompiler.compileComponent(outputCtx,compMeta,parsedTemplate,stylesExpr,usedPipes);return componentStyles&&_resolveStyleStatements(this._symbolResolver,componentStyles,this._styleCompiler.needsStyleShim(compMeta),fileSuffix),viewResult},AotCompiler.prototype._parseTemplate=function(compMeta,ngModule,directiveIdentifiers){var _this=this;if(this._templateAstCache.has(compMeta.type.reference))return this._templateAstCache.get(compMeta.type.reference);var preserveWhitespaces=compMeta.template.preserveWhitespaces,directives=directiveIdentifiers.map(function(dir){return _this._metadataResolver.getDirectiveSummary(dir.reference)}),pipes=ngModule.transitiveModule.pipes.map(function(pipe){return _this._metadataResolver.getPipeSummary(pipe.reference)}),result=this._templateParser.parse(compMeta,compMeta.template.htmlAst,directives,pipes,ngModule.schemas,templateSourceUrl(ngModule.type,compMeta,compMeta.template),preserveWhitespaces);return this._templateAstCache.set(compMeta.type.reference,result),result},AotCompiler.prototype._createOutputContext=function(genFilePath){var _this=this;return{statements:[],genFilePath:genFilePath,importExpr:function(symbol,typeParams,useSummaries){if(void 0===typeParams&&(typeParams=null),void 0===useSummaries&&(useSummaries=!0),!(symbol instanceof StaticSymbol))throw new Error("Internal error: unknown identifier "+JSON.stringify(symbol));var arity=_this._symbolResolver.getTypeArity(symbol)||0,_a=_this._symbolResolver.getImportAs(symbol,useSummaries)||symbol,filePath=_a.filePath,name=_a.name,members=_a.members,importModule=_this._fileNameToModuleName(filePath,genFilePath),selfReference=_this._fileNameToModuleName(genFilePath,genFilePath),moduleName=importModule===selfReference?null:importModule,suppliedTypeParams=typeParams||[],missingTypeParamsCount=arity-suppliedTypeParams.length,allTypeParams=suppliedTypeParams.concat(new Array(missingTypeParamsCount).fill(DYNAMIC_TYPE));return members.reduce(function(expr,memberName){return expr.prop(memberName)},importExpr(new ExternalReference(moduleName,name,null),allTypeParams))}}},AotCompiler.prototype._fileNameToModuleName=function(importedFilePath,containingFilePath){return this._summaryResolver.getKnownModuleName(importedFilePath)||this._symbolResolver.getKnownModuleName(importedFilePath)||this._host.fileNameToModuleName(importedFilePath,containingFilePath)},AotCompiler.prototype._codegenStyles=function(srcFileUrl,compMeta,stylesheetMetadata,isShimmed,fileSuffix){var outputCtx=this._createOutputContext(_stylesModuleUrl(stylesheetMetadata.moduleUrl,isShimmed,fileSuffix)),compiledStylesheet=this._styleCompiler.compileStyles(outputCtx,compMeta,stylesheetMetadata,isShimmed);return _resolveStyleStatements(this._symbolResolver,compiledStylesheet,isShimmed,fileSuffix),this._codegenSourceModule(srcFileUrl,outputCtx)},AotCompiler.prototype._codegenSourceModule=function(srcFileUrl,ctx){return new GeneratedFile(srcFileUrl,ctx.genFilePath,ctx.statements)},AotCompiler.prototype.listLazyRoutes=function(entryRoute,analyzedModules){function visitLazyRoute(symbol,seenRoutes,allLazyRoutes){if(void 0===seenRoutes&&(seenRoutes=new Set),void 0===allLazyRoutes&&(allLazyRoutes=[]),seenRoutes.has(symbol)||!symbol.name)return allLazyRoutes;seenRoutes.add(symbol);for(var lazyRoutes=listLazyRoutes(self._metadataResolver.getNgModuleMetadata(symbol,!0),self._reflector),_i=0,lazyRoutes_2=lazyRoutes;_i<lazyRoutes_2.length;_i++){var lazyRoute=lazyRoutes_2[_i];allLazyRoutes.push(lazyRoute),visitLazyRoute(lazyRoute.referencedModule,seenRoutes,allLazyRoutes)}return allLazyRoutes}var self=this;if(entryRoute){return visitLazyRoute(parseLazyRoute(entryRoute,this._reflector).referencedModule)}if(analyzedModules){for(var allLazyRoutes=[],_i=0,_a=analyzedModules.ngModules;_i<_a.length;_i++)for(var ngModule=_a[_i],lazyRoutes=listLazyRoutes(ngModule,this._reflector),_b=0,lazyRoutes_1=lazyRoutes;_b<lazyRoutes_1.length;_b++){var lazyRoute=lazyRoutes_1[_b];allLazyRoutes.push(lazyRoute)}return allLazyRoutes}throw new Error("Either route or analyzedModules has to be specified!")},AotCompiler}(),FORMATTED_MESSAGE="ngFormattedMessage",ANGULAR_CORE="@angular/core",HIDDEN_KEY=/^\$.*\$$/,IGNORE={__symbolic:"ignore"},USE_VALUE="useValue",PROVIDE="provide",REFERENCE_SET=new Set([USE_VALUE,"useFactory","data"]),StaticReflector=function(){function StaticReflector(summaryResolver,symbolResolver,knownMetadataClasses,knownMetadataFunctions,errorRecorder){void 0===knownMetadataClasses&&(knownMetadataClasses=[]),void 0===knownMetadataFunctions&&(knownMetadataFunctions=[]);var _this=this;this.summaryResolver=summaryResolver,this.symbolResolver=symbolResolver,this.errorRecorder=errorRecorder,this.annotationCache=new Map,this.propertyCache=new Map,this.parameterCache=new Map,this.methodCache=new Map,this.staticCache=new Map,this.conversionMap=new Map,this.resolvedExternalReferences=new Map,this.annotationForParentClassWithSummaryKind=new Map,this.initializeConversionMap(),knownMetadataClasses.forEach(function(kc){return _this._registerDecoratorOrConstructor(_this.getStaticSymbol(kc.filePath,kc.name),kc.ctor)}),knownMetadataFunctions.forEach(function(kf){return _this._registerFunction(_this.getStaticSymbol(kf.filePath,kf.name),kf.fn)}),this.annotationForParentClassWithSummaryKind.set(CompileSummaryKind.Directive,[createDirective,createComponent]),this.annotationForParentClassWithSummaryKind.set(CompileSummaryKind.Pipe,[createPipe]),this.annotationForParentClassWithSummaryKind.set(CompileSummaryKind.NgModule,[createNgModule]),this.annotationForParentClassWithSummaryKind.set(CompileSummaryKind.Injectable,[createInjectable,createPipe,createDirective,createComponent,createNgModule])}return StaticReflector.prototype.componentModuleUrl=function(typeOrFunc){var staticSymbol=this.findSymbolDeclaration(typeOrFunc);return this.symbolResolver.getResourcePath(staticSymbol)},StaticReflector.prototype.resolveExternalReference=function(ref,containingFile){var key=void 0;if(!containingFile){key=ref.moduleName+":"+ref.name;var declarationSymbol_1=this.resolvedExternalReferences.get(key);if(declarationSymbol_1)return declarationSymbol_1}var refSymbol=this.symbolResolver.getSymbolByModule(ref.moduleName,ref.name,containingFile),declarationSymbol=this.findSymbolDeclaration(refSymbol);return containingFile||(this.symbolResolver.recordModuleNameForFileName(refSymbol.filePath,ref.moduleName),this.symbolResolver.recordImportAs(declarationSymbol,refSymbol)),key&&this.resolvedExternalReferences.set(key,declarationSymbol),declarationSymbol},StaticReflector.prototype.findDeclaration=function(moduleUrl,name,containingFile){return this.findSymbolDeclaration(this.symbolResolver.getSymbolByModule(moduleUrl,name,containingFile))},StaticReflector.prototype.tryFindDeclaration=function(moduleUrl,name){var _this=this;return this.symbolResolver.ignoreErrorsFor(function(){return _this.findDeclaration(moduleUrl,name)})},StaticReflector.prototype.findSymbolDeclaration=function(symbol){var resolvedSymbol=this.symbolResolver.resolveSymbol(symbol);if(resolvedSymbol){var resolvedMetadata=resolvedSymbol.metadata;if(resolvedMetadata&&"resolved"===resolvedMetadata.__symbolic&&(resolvedMetadata=resolvedMetadata.symbol),resolvedMetadata instanceof StaticSymbol)return this.findSymbolDeclaration(resolvedSymbol.metadata)}return symbol},StaticReflector.prototype.annotations=function(type){var annotations=this.annotationCache.get(type);if(!annotations){annotations=[];var classMetadata=this.getTypeMetadata(type),parentType=this.findParentType(type,classMetadata);if(parentType){var parentAnnotations=this.annotations(parentType);annotations.push.apply(annotations,parentAnnotations)}var ownAnnotations_1=[];if(classMetadata.decorators&&(ownAnnotations_1=this.simplify(type,classMetadata.decorators),annotations.push.apply(annotations,ownAnnotations_1)),parentType&&!this.summaryResolver.isLibraryFile(type.filePath)&&this.summaryResolver.isLibraryFile(parentType.filePath)){var summary=this.summaryResolver.resolveSummary(parentType);if(summary&&summary.type){var requiredAnnotationTypes=this.annotationForParentClassWithSummaryKind.get(summary.type.summaryKind);requiredAnnotationTypes.some(function(requiredType){return ownAnnotations_1.some(function(ann){return requiredType.isTypeOf(ann)})})||this.reportError(formatMetadataError(metadataError("Class "+type.name+" in "+type.filePath+" extends from a "+CompileSummaryKind[summary.type.summaryKind]+" in another compilation unit without duplicating the decorator",void 0,"Please add a "+requiredAnnotationTypes.map(function(type){return type.ngMetadataName}).join(" or ")+" decorator to the class"),type),type)}}this.annotationCache.set(type,annotations.filter(function(ann){return!!ann}))}return annotations},StaticReflector.prototype.propMetadata=function(type){var _this=this,propMetadata=this.propertyCache.get(type);if(!propMetadata){var classMetadata=this.getTypeMetadata(type);propMetadata={};var parentType=this.findParentType(type,classMetadata);if(parentType){var parentPropMetadata_1=this.propMetadata(parentType);Object.keys(parentPropMetadata_1).forEach(function(parentProp){propMetadata[parentProp]=parentPropMetadata_1[parentProp]})}var members_1=classMetadata.members||{};Object.keys(members_1).forEach(function(propName){var propData=members_1[propName],prop=propData.find(function(a){return"property"==a.__symbolic||"method"==a.__symbolic}),decorators=[];propMetadata[propName]&&decorators.push.apply(decorators,propMetadata[propName]),propMetadata[propName]=decorators,prop&&prop.decorators&&decorators.push.apply(decorators,_this.simplify(type,prop.decorators))}),this.propertyCache.set(type,propMetadata)}return propMetadata},StaticReflector.prototype.parameters=function(type){var _this=this;if(!(type instanceof StaticSymbol))return this.reportError(new Error("parameters received "+JSON.stringify(type)+" which is not a StaticSymbol"),type),[];try{var parameters_1=this.parameterCache.get(type);if(!parameters_1){var classMetadata=this.getTypeMetadata(type),parentType=this.findParentType(type,classMetadata),members=classMetadata?classMetadata.members:null,ctorData=members?members.__ctor__:null;if(ctorData){var ctor=ctorData.find(function(a){return"constructor"==a.__symbolic}),rawParameterTypes=ctor.parameters||[],parameterDecorators_1=this.simplify(type,ctor.parameterDecorators||[]);parameters_1=[],rawParameterTypes.forEach(function(rawParamType,index){var nestedResult=[],paramType=_this.trySimplify(type,rawParamType);paramType&&nestedResult.push(paramType);var decorators=parameterDecorators_1?parameterDecorators_1[index]:null;decorators&&nestedResult.push.apply(nestedResult,decorators),parameters_1.push(nestedResult)})}else parentType&&(parameters_1=this.parameters(parentType));parameters_1||(parameters_1=[]),this.parameterCache.set(type,parameters_1)}return parameters_1}catch(e){throw console.error("Failed on type "+JSON.stringify(type)+" with error "+e),e}},StaticReflector.prototype._methodNames=function(type){var methodNames=this.methodCache.get(type);if(!methodNames){var classMetadata=this.getTypeMetadata(type);methodNames={};var parentType=this.findParentType(type,classMetadata);if(parentType){
var parentMethodNames_1=this._methodNames(parentType);Object.keys(parentMethodNames_1).forEach(function(parentProp){methodNames[parentProp]=parentMethodNames_1[parentProp]})}var members_2=classMetadata.members||{};Object.keys(members_2).forEach(function(propName){var propData=members_2[propName],isMethod=propData.some(function(a){return"method"==a.__symbolic});methodNames[propName]=methodNames[propName]||isMethod}),this.methodCache.set(type,methodNames)}return methodNames},StaticReflector.prototype._staticMembers=function(type){var staticMembers=this.staticCache.get(type);if(!staticMembers){var classMetadata=this.getTypeMetadata(type),staticMemberData=classMetadata.statics||{};staticMembers=Object.keys(staticMemberData),this.staticCache.set(type,staticMembers)}return staticMembers},StaticReflector.prototype.findParentType=function(type,classMetadata){var parentType=this.trySimplify(type,classMetadata.extends);if(parentType instanceof StaticSymbol)return parentType},StaticReflector.prototype.hasLifecycleHook=function(type,lcProperty){type instanceof StaticSymbol||this.reportError(new Error("hasLifecycleHook received "+JSON.stringify(type)+" which is not a StaticSymbol"),type);try{return!!this._methodNames(type)[lcProperty]}catch(e){throw console.error("Failed on type "+JSON.stringify(type)+" with error "+e),e}},StaticReflector.prototype.guards=function(type){if(!(type instanceof StaticSymbol))return this.reportError(new Error("guards received "+JSON.stringify(type)+" which is not a StaticSymbol"),type),{};for(var staticMembers=this._staticMembers(type),result={},_i=0,staticMembers_1=staticMembers;_i<staticMembers_1.length;_i++){var name_1=staticMembers_1[_i];if(name_1.endsWith("TypeGuard")){var property=name_1.substr(0,name_1.length-"TypeGuard".length),value=void 0;property.endsWith("UseIf")?(property=name_1.substr(0,property.length-"UseIf".length),value="UseIf"):value=this.getStaticSymbol(type.filePath,type.name,[name_1]),result[property]=value}}return result},StaticReflector.prototype._registerDecoratorOrConstructor=function(type,ctor){this.conversionMap.set(type,function(context,args){return new(ctor.bind.apply(ctor,[void 0].concat(args)))})},StaticReflector.prototype._registerFunction=function(type,fn){this.conversionMap.set(type,function(context,args){return fn.apply(void 0,args)})},StaticReflector.prototype.initializeConversionMap=function(){this.injectionToken=this.findDeclaration(ANGULAR_CORE,"InjectionToken"),this.opaqueToken=this.findDeclaration(ANGULAR_CORE,"OpaqueToken"),this.ROUTES=this.tryFindDeclaration("@angular/router","ROUTES"),this.ANALYZE_FOR_ENTRY_COMPONENTS=this.findDeclaration(ANGULAR_CORE,"ANALYZE_FOR_ENTRY_COMPONENTS"),this._registerDecoratorOrConstructor(this.findDeclaration(ANGULAR_CORE,"Host"),createHost),this._registerDecoratorOrConstructor(this.findDeclaration(ANGULAR_CORE,"Injectable"),createInjectable),this._registerDecoratorOrConstructor(this.findDeclaration(ANGULAR_CORE,"Self"),createSelf),this._registerDecoratorOrConstructor(this.findDeclaration(ANGULAR_CORE,"SkipSelf"),createSkipSelf),this._registerDecoratorOrConstructor(this.findDeclaration(ANGULAR_CORE,"Inject"),createInject),this._registerDecoratorOrConstructor(this.findDeclaration(ANGULAR_CORE,"Optional"),createOptional),this._registerDecoratorOrConstructor(this.findDeclaration(ANGULAR_CORE,"Attribute"),createAttribute),this._registerDecoratorOrConstructor(this.findDeclaration(ANGULAR_CORE,"ContentChild"),createContentChild),this._registerDecoratorOrConstructor(this.findDeclaration(ANGULAR_CORE,"ContentChildren"),createContentChildren),this._registerDecoratorOrConstructor(this.findDeclaration(ANGULAR_CORE,"ViewChild"),createViewChild),this._registerDecoratorOrConstructor(this.findDeclaration(ANGULAR_CORE,"ViewChildren"),createViewChildren),this._registerDecoratorOrConstructor(this.findDeclaration(ANGULAR_CORE,"Input"),createInput),this._registerDecoratorOrConstructor(this.findDeclaration(ANGULAR_CORE,"Output"),createOutput),this._registerDecoratorOrConstructor(this.findDeclaration(ANGULAR_CORE,"Pipe"),createPipe),this._registerDecoratorOrConstructor(this.findDeclaration(ANGULAR_CORE,"HostBinding"),createHostBinding),this._registerDecoratorOrConstructor(this.findDeclaration(ANGULAR_CORE,"HostListener"),createHostListener),this._registerDecoratorOrConstructor(this.findDeclaration(ANGULAR_CORE,"Directive"),createDirective),this._registerDecoratorOrConstructor(this.findDeclaration(ANGULAR_CORE,"Component"),createComponent),this._registerDecoratorOrConstructor(this.findDeclaration(ANGULAR_CORE,"NgModule"),createNgModule),this._registerDecoratorOrConstructor(this.findDeclaration(ANGULAR_CORE,"Host"),createHost),this._registerDecoratorOrConstructor(this.findDeclaration(ANGULAR_CORE,"Self"),createSelf),this._registerDecoratorOrConstructor(this.findDeclaration(ANGULAR_CORE,"SkipSelf"),createSkipSelf),this._registerDecoratorOrConstructor(this.findDeclaration(ANGULAR_CORE,"Optional"),createOptional)},StaticReflector.prototype.getStaticSymbol=function(declarationFile,name,members){return this.symbolResolver.getStaticSymbol(declarationFile,name,members)},StaticReflector.prototype.trySimplify=function(context,value){var originalRecorder=this.errorRecorder;this.errorRecorder=function(error,fileName){};var result=this.simplify(context,value);return this.errorRecorder=originalRecorder,result},StaticReflector.prototype.simplify=function(context,value){function simplifyInContext(context,value,depth,references){function resolveReferenceValue(staticSymbol){var resolvedSymbol=self.symbolResolver.resolveSymbol(staticSymbol);return resolvedSymbol?resolvedSymbol.metadata:null}function simplifyEagerly(value){return simplifyInContext(context,value,depth,0)}function simplifyLazily(value){return simplifyInContext(context,value,depth,references+1)}function simplifyNested(nestedContext,value){if(nestedContext===context)return simplifyInContext(nestedContext,value,depth+1,references);try{return simplifyInContext(nestedContext,value,depth+1,references)}catch(e){if(!isMetadataError(e))throw e;var summaryMsg=e.chain?"references '"+e.symbol.name+"'":errorSummary(e),summary="'"+nestedContext.name+"' "+summaryMsg,chain={message:summary,position:e.position,next:e.chain};self.error({message:e.message,advise:e.advise,context:e.context,chain:chain,symbol:nestedContext},context)}}function simplifyCall(functionSymbol,targetFunction,args,targetExpression){if(targetFunction&&"function"==targetFunction.__symbolic){calling.get(functionSymbol)&&self.error({message:"Recursion is not supported",summary:"called '"+functionSymbol.name+"' recursively",value:targetFunction},functionSymbol);try{var value_1=targetFunction.value;if(value_1&&(0!=depth||"error"!=value_1.__symbolic)){var parameters=targetFunction.parameters,defaults=targetFunction.defaults;args=args.map(function(arg){return simplifyNested(context,arg)}).map(function(arg){return shouldIgnore(arg)?void 0:arg}),defaults&&defaults.length>args.length&&args.push.apply(args,defaults.slice(args.length).map(function(value){return simplify(value)})),calling.set(functionSymbol,!0);for(var functionScope=BindingScope.build(),i=0;i<parameters.length;i++)functionScope.define(parameters[i],args[i]);var result_1,oldScope=scope;try{scope=functionScope.done(),result_1=simplifyNested(functionSymbol,value_1)}finally{scope=oldScope}return result_1}}finally{calling.delete(functionSymbol)}}if(0===depth)return IGNORE;var position=void 0;if(targetExpression&&"resolved"==targetExpression.__symbolic){var line=targetExpression.line,character=targetExpression.character,fileName=targetExpression.fileName;null!=fileName&&null!=line&&null!=character&&(position={fileName:fileName,line:line,column:character})}self.error({message:FUNCTION_CALL_NOT_SUPPORTED,context:functionSymbol,value:targetFunction,position:position},context)}function simplify(expression){if(isPrimitive(expression))return expression;if(expression instanceof Array){for(var result_2=[],_i=0,_a=expression;_i<_a.length;_i++){var item=_a[_i];if(item&&"spread"===item.__symbolic){var spreadArray=simplifyEagerly(item.expression);if(Array.isArray(spreadArray)){for(var _b=0,spreadArray_1=spreadArray;_b<spreadArray_1.length;_b++){var spreadItem=spreadArray_1[_b];result_2.push(spreadItem)}continue}}var value_2=simplify(item);shouldIgnore(value_2)||result_2.push(value_2)}return result_2}if(expression instanceof StaticSymbol){if(expression===self.injectionToken||self.conversionMap.has(expression)||references>0&&!expression.members.length)return expression;var staticSymbol=expression,declarationValue=resolveReferenceValue(staticSymbol);return null!=declarationValue?simplifyNested(staticSymbol,declarationValue):staticSymbol}if(expression){if(expression.__symbolic){var staticSymbol=void 0;switch(expression.__symbolic){case"binop":var left=simplify(expression.left);if(shouldIgnore(left))return left;var right=simplify(expression.right);if(shouldIgnore(right))return right;switch(expression.operator){case"&&":return left&&right;case"||":return left||right;case"|":return left|right;case"^":return left^right;case"&":return left&right;case"==":return left==right;case"!=":return left!=right;case"===":return left===right;case"!==":return left!==right;case"<":return left<right;case">":return left>right;case"<=":return left<=right;case">=":return left>=right;case"<<":return left<<right;case">>":return left>>right;case"+":return left+right;case"-":return left-right;case"*":return left*right;case"/":return left/right;case"%":return left%right}return null;case"if":return simplify(simplify(expression.condition)?expression.thenExpression:expression.elseExpression);case"pre":var operand=simplify(expression.operand);if(shouldIgnore(operand))return operand;switch(expression.operator){case"+":return operand;case"-":return-operand;case"!":return!operand;case"~":return~operand}return null;case"index":var indexTarget=simplifyEagerly(expression.expression),index=simplifyEagerly(expression.index);return indexTarget&&isPrimitive(index)?indexTarget[index]:null;case"select":var member=expression.member,selectContext=context,selectTarget=simplify(expression.expression);if(selectTarget instanceof StaticSymbol){var members=selectTarget.members.concat(member);selectContext=self.getStaticSymbol(selectTarget.filePath,selectTarget.name,members);var declarationValue=resolveReferenceValue(selectContext);return null!=declarationValue?simplifyNested(selectContext,declarationValue):selectContext}return selectTarget&&isPrimitive(member)?simplifyNested(selectContext,selectTarget[member]):null;case"reference":var name_2=expression.name,localValue=scope.resolve(name_2);if(localValue!=BindingScope.missing)return localValue;break;case"resolved":try{return simplify(expression.symbol)}catch(e){throw isMetadataError(e)&&null!=expression.fileName&&null!=expression.line&&null!=expression.character&&(e.position={fileName:expression.fileName,line:expression.line,column:expression.character}),e}case"class":case"function":return context;case"new":case"call":if((staticSymbol=simplifyInContext(context,expression.expression,depth+1,0))instanceof StaticSymbol){if(staticSymbol===self.injectionToken||staticSymbol===self.opaqueToken)return context;var argExpressions=expression.arguments||[],converter=self.conversionMap.get(staticSymbol);if(converter){var args=argExpressions.map(function(arg){return simplifyNested(context,arg)}).map(function(arg){return shouldIgnore(arg)?void 0:arg});return converter(context,args)}return simplifyCall(staticSymbol,resolveReferenceValue(staticSymbol),argExpressions,expression.expression)}return IGNORE;case"error":var message=expression.message;return null!=expression.line?self.error({message:message,context:expression.context,value:expression,position:{fileName:expression.fileName,line:expression.line,column:expression.character}},context):self.error({message:message,context:expression.context},context),IGNORE;case"ignore":return expression}return null}return mapStringMap(expression,function(value,name){if(REFERENCE_SET.has(name)){if(name===USE_VALUE&&PROVIDE in expression){var provide=simplify(expression.provide);if(provide===self.ROUTES||provide==self.ANALYZE_FOR_ENTRY_COMPONENTS)return simplify(value)}return simplifyLazily(value)}return simplify(value)})}return IGNORE}return simplify(value)}var result,self=this,scope=BindingScope.empty,calling=new Map;try{result=simplifyInContext(context,value,0,0)}catch(e){if(!this.errorRecorder)throw formatMetadataError(e,context);this.reportError(e,context)}if(!shouldIgnore(result))return result},StaticReflector.prototype.getTypeMetadata=function(type){var resolvedSymbol=this.symbolResolver.resolveSymbol(type);return resolvedSymbol&&resolvedSymbol.metadata?resolvedSymbol.metadata:{__symbolic:"class"}},StaticReflector.prototype.reportError=function(error,context,path){if(!this.errorRecorder)throw error;this.errorRecorder(formatMetadataError(error,context),context&&context.filePath||path)},StaticReflector.prototype.error=function(_a,reportingContext){var message=_a.message,summary=_a.summary,advise=_a.advise,position=_a.position,context=_a.context,symbol=(_a.value,_a.symbol),chain=_a.chain;this.reportError(metadataError(message,summary,advise,position,symbol,context,chain),reportingContext)},StaticReflector}(),METADATA_ERROR="ngMetadataError",REFERENCE_TO_NONEXPORTED_CLASS="Reference to non-exported class",VARIABLE_NOT_INITIALIZED="Variable not initialized",DESTRUCTURE_NOT_SUPPORTED="Destructuring not supported",COULD_NOT_RESOLVE_TYPE="Could not resolve type",FUNCTION_CALL_NOT_SUPPORTED="Function call not supported",REFERENCE_TO_LOCAL_SYMBOL="Reference to a local symbol",LAMBDA_NOT_SUPPORTED="Lambda not supported",BindingScope=function(){function BindingScope(){}return BindingScope.build=function(){var current=new Map;return{define:function(name,value){return current.set(name,value),this},done:function(){return current.size>0?new PopulatedScope(current):BindingScope.empty}}},BindingScope.missing={},BindingScope.empty={resolve:function(name){return BindingScope.missing}},BindingScope}(),PopulatedScope=function(_super){function PopulatedScope(bindings){var _this=_super.call(this)||this;return _this.bindings=bindings,_this}return __extends(PopulatedScope,_super),PopulatedScope.prototype.resolve=function(name){return this.bindings.has(name)?this.bindings.get(name):BindingScope.missing},PopulatedScope}(BindingScope),AotSummaryResolver=function(){function AotSummaryResolver(host,staticSymbolCache){this.host=host,this.staticSymbolCache=staticSymbolCache,this.summaryCache=new Map,this.loadedFilePaths=new Map,this.importAs=new Map,this.knownFileNameToModuleNames=new Map}return AotSummaryResolver.prototype.isLibraryFile=function(filePath){return!this.host.isSourceFile(stripGeneratedFileSuffix(filePath))},AotSummaryResolver.prototype.toSummaryFileName=function(filePath,referringSrcFileName){return this.host.toSummaryFileName(filePath,referringSrcFileName)},AotSummaryResolver.prototype.fromSummaryFileName=function(fileName,referringLibFileName){return this.host.fromSummaryFileName(fileName,referringLibFileName)},AotSummaryResolver.prototype.resolveSummary=function(staticSymbol){var rootSymbol=staticSymbol.members.length?this.staticSymbolCache.get(staticSymbol.filePath,staticSymbol.name):staticSymbol,summary=this.summaryCache.get(rootSymbol);return summary||(this._loadSummaryFile(staticSymbol.filePath),summary=this.summaryCache.get(staticSymbol)),rootSymbol===staticSymbol&&summary||null},AotSummaryResolver.prototype.getSymbolsOf=function(filePath){return this._loadSummaryFile(filePath)?Array.from(this.summaryCache.keys()).filter(function(symbol){return symbol.filePath===filePath}):null},AotSummaryResolver.prototype.getImportAs=function(staticSymbol){return staticSymbol.assertNoMembers(),this.importAs.get(staticSymbol)},AotSummaryResolver.prototype.getKnownModuleName=function(importedFilePath){return this.knownFileNameToModuleNames.get(importedFilePath)||null},AotSummaryResolver.prototype.addSummary=function(summary){this.summaryCache.set(summary.symbol,summary)},AotSummaryResolver.prototype._loadSummaryFile=function(filePath){var _this=this,hasSummary=this.loadedFilePaths.get(filePath);if(null!=hasSummary)return hasSummary;var json=null;if(this.isLibraryFile(filePath)){var summaryFilePath=summaryFileName(filePath);try{json=this.host.loadSummary(summaryFilePath)}catch(e){throw console.error("Error loading summary file "+summaryFilePath),e}}if(hasSummary=null!=json,this.loadedFilePaths.set(filePath,hasSummary),json){var _a=deserializeSummaries(this.staticSymbolCache,this,filePath,json),moduleName=_a.moduleName,summaries=_a.summaries,importAs=_a.importAs;summaries.forEach(function(summary){return _this.summaryCache.set(summary.symbol,summary)}),moduleName&&this.knownFileNameToModuleNames.set(filePath,moduleName),importAs.forEach(function(importAs){_this.importAs.set(importAs.symbol,importAs.importAs)})}return hasSummary},AotSummaryResolver}(),SummaryResolver=function(){function SummaryResolver(){}return SummaryResolver}(),JitSummaryResolver=function(){function JitSummaryResolver(){this._summaries=new Map}return JitSummaryResolver.prototype.isLibraryFile=function(){return!1},JitSummaryResolver.prototype.toSummaryFileName=function(fileName){return fileName},JitSummaryResolver.prototype.fromSummaryFileName=function(fileName){return fileName},JitSummaryResolver.prototype.resolveSummary=function(reference){return this._summaries.get(reference)||null},JitSummaryResolver.prototype.getSymbolsOf=function(){return[]},JitSummaryResolver.prototype.getImportAs=function(reference){return reference},JitSummaryResolver.prototype.getKnownModuleName=function(fileName){return null},JitSummaryResolver.prototype.addSummary=function(summary){this._summaries.set(summary.symbol,summary)},JitSummaryResolver}(),_ExecutionContext=function(){function _ExecutionContext(parent,instance,className,vars){this.parent=parent,this.instance=instance,this.className=className,this.vars=vars,this.exports=[]}return _ExecutionContext.prototype.createChildWihtLocalVars=function(){return new _ExecutionContext(this,this.instance,this.className,new Map)},_ExecutionContext}(),ReturnValue=function(){function ReturnValue(value){this.value=value}return ReturnValue}(),StatementInterpreter=function(){function StatementInterpreter(reflector){this.reflector=reflector}return StatementInterpreter.prototype.debugAst=function(ast){return debugOutputAstAsTypeScript(ast)},StatementInterpreter.prototype.visitDeclareVarStmt=function(stmt,ctx){return ctx.vars.set(stmt.name,stmt.value.visitExpression(this,ctx)),stmt.hasModifier(StmtModifier.Exported)&&ctx.exports.push(stmt.name),null},StatementInterpreter.prototype.visitWriteVarExpr=function(expr,ctx){for(var value=expr.value.visitExpression(this,ctx),currCtx=ctx;null!=currCtx;){if(currCtx.vars.has(expr.name))return currCtx.vars.set(expr.name,value),value;currCtx=currCtx.parent}throw new Error("Not declared variable "+expr.name)},StatementInterpreter.prototype.visitReadVarExpr=function(ast,ctx){var varName=ast.name;if(null!=ast.builtin)switch(ast.builtin){case BuiltinVar.Super:return ctx.instance.__proto__;case BuiltinVar.This:return ctx.instance;case BuiltinVar.CatchError:varName=CATCH_ERROR_VAR$2;break;case BuiltinVar.CatchStack:varName=CATCH_STACK_VAR$2;break;default:throw new Error("Unknown builtin variable "+ast.builtin)}for(var currCtx=ctx;null!=currCtx;){if(currCtx.vars.has(varName))return currCtx.vars.get(varName);currCtx=currCtx.parent}throw new Error("Not declared variable "+varName)},StatementInterpreter.prototype.visitWriteKeyExpr=function(expr,ctx){var receiver=expr.receiver.visitExpression(this,ctx),index=expr.index.visitExpression(this,ctx),value=expr.value.visitExpression(this,ctx);return receiver[index]=value,value},StatementInterpreter.prototype.visitWritePropExpr=function(expr,ctx){var receiver=expr.receiver.visitExpression(this,ctx),value=expr.value.visitExpression(this,ctx);return receiver[expr.name]=value,value},StatementInterpreter.prototype.visitInvokeMethodExpr=function(expr,ctx){var result,receiver=expr.receiver.visitExpression(this,ctx),args=this.visitAllExpressions(expr.args,ctx);if(null!=expr.builtin)switch(expr.builtin){case BuiltinMethod.ConcatArray:result=receiver.concat.apply(receiver,args);break;case BuiltinMethod.SubscribeObservable:result=receiver.subscribe({next:args[0]});break;case BuiltinMethod.Bind:result=receiver.bind.apply(receiver,args);break;default:throw new Error("Unknown builtin method "+expr.builtin)}else result=receiver[expr.name].apply(receiver,args);return result},StatementInterpreter.prototype.visitInvokeFunctionExpr=function(stmt,ctx){var args=this.visitAllExpressions(stmt.args,ctx),fnExpr=stmt.fn;return fnExpr instanceof ReadVarExpr&&fnExpr.builtin===BuiltinVar.Super?(ctx.instance.constructor.prototype.constructor.apply(ctx.instance,args),null):stmt.fn.visitExpression(this,ctx).apply(null,args)},StatementInterpreter.prototype.visitReturnStmt=function(stmt,ctx){return new ReturnValue(stmt.value.visitExpression(this,ctx))},StatementInterpreter.prototype.visitDeclareClassStmt=function(stmt,ctx){var clazz=createDynamicClass(stmt,ctx,this);return ctx.vars.set(stmt.name,clazz),stmt.hasModifier(StmtModifier.Exported)&&ctx.exports.push(stmt.name),null},StatementInterpreter.prototype.visitExpressionStmt=function(stmt,ctx){return stmt.expr.visitExpression(this,ctx)},StatementInterpreter.prototype.visitIfStmt=function(stmt,ctx){return stmt.condition.visitExpression(this,ctx)?this.visitAllStatements(stmt.trueCase,ctx):null!=stmt.falseCase?this.visitAllStatements(stmt.falseCase,ctx):null},StatementInterpreter.prototype.visitTryCatchStmt=function(stmt,ctx){try{return this.visitAllStatements(stmt.bodyStmts,ctx)}catch(e){var childCtx=ctx.createChildWihtLocalVars();return childCtx.vars.set(CATCH_ERROR_VAR$2,e),childCtx.vars.set(CATCH_STACK_VAR$2,e.stack),this.visitAllStatements(stmt.catchStmts,childCtx)}},StatementInterpreter.prototype.visitThrowStmt=function(stmt,ctx){throw stmt.error.visitExpression(this,ctx)},StatementInterpreter.prototype.visitCommentStmt=function(stmt,context){return null},StatementInterpreter.prototype.visitInstantiateExpr=function(ast,ctx){var args=this.visitAllExpressions(ast.args,ctx),clazz=ast.classExpr.visitExpression(this,ctx);return new(clazz.bind.apply(clazz,[void 0].concat(args)))},StatementInterpreter.prototype.visitLiteralExpr=function(ast,ctx){return ast.value},StatementInterpreter.prototype.visitExternalExpr=function(ast,ctx){return this.reflector.resolveExternalReference(ast.value)},StatementInterpreter.prototype.visitConditionalExpr=function(ast,ctx){return ast.condition.visitExpression(this,ctx)?ast.trueCase.visitExpression(this,ctx):null!=ast.falseCase?ast.falseCase.visitExpression(this,ctx):null},StatementInterpreter.prototype.visitNotExpr=function(ast,ctx){return!ast.condition.visitExpression(this,ctx)},StatementInterpreter.prototype.visitAssertNotNullExpr=function(ast,ctx){return ast.condition.visitExpression(this,ctx)},StatementInterpreter.prototype.visitCastExpr=function(ast,ctx){return ast.value.visitExpression(this,ctx)},StatementInterpreter.prototype.visitFunctionExpr=function(ast,ctx){return _declareFn(ast.params.map(function(param){return param.name}),ast.statements,ctx,this)},StatementInterpreter.prototype.visitDeclareFunctionStmt=function(stmt,ctx){var paramNames=stmt.params.map(function(param){return param.name});return ctx.vars.set(stmt.name,_declareFn(paramNames,stmt.statements,ctx,this)),stmt.hasModifier(StmtModifier.Exported)&&ctx.exports.push(stmt.name),null},StatementInterpreter.prototype.visitBinaryOperatorExpr=function(ast,ctx){var _this=this,lhs=function(){return ast.lhs.visitExpression(_this,ctx)},rhs=function(){return ast.rhs.visitExpression(_this,ctx)};switch(ast.operator){case BinaryOperator.Equals:return lhs()==rhs();case BinaryOperator.Identical:return lhs()===rhs();case BinaryOperator.NotEquals:return lhs()!=rhs();case BinaryOperator.NotIdentical:return lhs()!==rhs();case BinaryOperator.And:return lhs()&&rhs();case BinaryOperator.Or:return lhs()||rhs();case BinaryOperator.Plus:return lhs()+rhs();case BinaryOperator.Minus:return lhs()-rhs();case BinaryOperator.Divide:return lhs()/rhs();case BinaryOperator.Multiply:return lhs()*rhs();case BinaryOperator.Modulo:return lhs()%rhs();case BinaryOperator.Lower:return lhs()<rhs();case BinaryOperator.LowerEquals:return lhs()<=rhs();case BinaryOperator.Bigger:return lhs()>rhs();case BinaryOperator.BiggerEquals:return lhs()>=rhs();default:throw new Error("Unknown operator "+ast.operator)}},StatementInterpreter.prototype.visitReadPropExpr=function(ast,ctx){return ast.receiver.visitExpression(this,ctx)[ast.name]},StatementInterpreter.prototype.visitReadKeyExpr=function(ast,ctx){return ast.receiver.visitExpression(this,ctx)[ast.index.visitExpression(this,ctx)]},StatementInterpreter.prototype.visitLiteralArrayExpr=function(ast,ctx){return this.visitAllExpressions(ast.entries,ctx)},StatementInterpreter.prototype.visitLiteralMapExpr=function(ast,ctx){var _this=this,result={};return ast.entries.forEach(function(entry){return result[entry.key]=entry.value.visitExpression(_this,ctx)}),result},StatementInterpreter.prototype.visitCommaExpr=function(ast,context){var values=this.visitAllExpressions(ast.parts,context);return values[values.length-1]},StatementInterpreter.prototype.visitAllExpressions=function(expressions,ctx){var _this=this;return expressions.map(function(expr){return expr.visitExpression(_this,ctx)})},StatementInterpreter.prototype.visitAllStatements=function(statements,ctx){for(var i=0;i<statements.length;i++){var stmt=statements[i],val=stmt.visitStatement(this,ctx);if(val instanceof ReturnValue)return val}return null},StatementInterpreter}(),CATCH_ERROR_VAR$2="error",CATCH_STACK_VAR$2="stack",AbstractJsEmitterVisitor=function(_super){function AbstractJsEmitterVisitor(){return _super.call(this,!1)||this}return __extends(AbstractJsEmitterVisitor,_super),AbstractJsEmitterVisitor.prototype.visitDeclareClassStmt=function(stmt,ctx){var _this=this;return ctx.pushClass(stmt),this._visitClassConstructor(stmt,ctx),null!=stmt.parent&&(ctx.print(stmt,stmt.name+".prototype = Object.create("),stmt.parent.visitExpression(this,ctx),ctx.println(stmt,".prototype);")),stmt.getters.forEach(function(getter){return _this._visitClassGetter(stmt,getter,ctx)}),stmt.methods.forEach(function(method){return _this._visitClassMethod(stmt,method,ctx)}),ctx.popClass(),null},AbstractJsEmitterVisitor.prototype._visitClassConstructor=function(stmt,ctx){ctx.print(stmt,"function "+stmt.name+"("),null!=stmt.constructorMethod&&this._visitParams(stmt.constructorMethod.params,ctx),ctx.println(stmt,") {"),ctx.incIndent(),null!=stmt.constructorMethod&&stmt.constructorMethod.body.length>0&&(ctx.println(stmt,"var self = this;"),this.visitAllStatements(stmt.constructorMethod.body,ctx)),ctx.decIndent(),ctx.println(stmt,"}")},AbstractJsEmitterVisitor.prototype._visitClassGetter=function(stmt,getter,ctx){ctx.println(stmt,"Object.defineProperty("+stmt.name+".prototype, '"+getter.name+"', { get: function() {"),ctx.incIndent(),getter.body.length>0&&(ctx.println(stmt,"var self = this;"),this.visitAllStatements(getter.body,ctx)),ctx.decIndent(),ctx.println(stmt,"}});")},AbstractJsEmitterVisitor.prototype._visitClassMethod=function(stmt,method,ctx){ctx.print(stmt,stmt.name+".prototype."+method.name+" = function("),this._visitParams(method.params,ctx),ctx.println(stmt,") {"),ctx.incIndent(),method.body.length>0&&(ctx.println(stmt,"var self = this;"),this.visitAllStatements(method.body,ctx)),ctx.decIndent(),ctx.println(stmt,"};")},AbstractJsEmitterVisitor.prototype.visitReadVarExpr=function(ast,ctx){if(ast.builtin===BuiltinVar.This)ctx.print(ast,"self");else{if(ast.builtin===BuiltinVar.Super)throw new Error("'super' needs to be handled at a parent ast node, not at the variable level!");_super.prototype.visitReadVarExpr.call(this,ast,ctx)}return null},AbstractJsEmitterVisitor.prototype.visitDeclareVarStmt=function(stmt,ctx){return ctx.print(stmt,"var "+stmt.name+" = "),stmt.value.visitExpression(this,ctx),ctx.println(stmt,";"),null},AbstractJsEmitterVisitor.prototype.visitCastExpr=function(ast,ctx){return ast.value.visitExpression(this,ctx),null},AbstractJsEmitterVisitor.prototype.visitInvokeFunctionExpr=function(expr,ctx){var fnExpr=expr.fn;return fnExpr instanceof ReadVarExpr&&fnExpr.builtin===BuiltinVar.Super?(ctx.currentClass.parent.visitExpression(this,ctx),ctx.print(expr,".call(this"),expr.args.length>0&&(ctx.print(expr,", "),this.visitAllExpressions(expr.args,ctx,",")),ctx.print(expr,")")):_super.prototype.visitInvokeFunctionExpr.call(this,expr,ctx),null},AbstractJsEmitterVisitor.prototype.visitFunctionExpr=function(ast,ctx){return ctx.print(ast,"function("),this._visitParams(ast.params,ctx),ctx.println(ast,") {"),ctx.incIndent(),this.visitAllStatements(ast.statements,ctx),ctx.decIndent(),ctx.print(ast,"}"),null},AbstractJsEmitterVisitor.prototype.visitDeclareFunctionStmt=function(stmt,ctx){return ctx.print(stmt,"function "+stmt.name+"("),this._visitParams(stmt.params,ctx),ctx.println(stmt,") {"),ctx.incIndent(),this.visitAllStatements(stmt.statements,ctx),ctx.decIndent(),ctx.println(stmt,"}"),null},AbstractJsEmitterVisitor.prototype.visitTryCatchStmt=function(stmt,ctx){ctx.println(stmt,"try {"),ctx.incIndent(),this.visitAllStatements(stmt.bodyStmts,ctx),ctx.decIndent(),ctx.println(stmt,"} catch ("+CATCH_ERROR_VAR$1.name+") {"),ctx.incIndent();var catchStmts=[CATCH_STACK_VAR$1.set(CATCH_ERROR_VAR$1.prop("stack")).toDeclStmt(null,[StmtModifier.Final])].concat(stmt.catchStmts);return this.visitAllStatements(catchStmts,ctx),ctx.decIndent(),ctx.println(stmt,"}"),null},AbstractJsEmitterVisitor.prototype._visitParams=function(params,ctx){this.visitAllObjects(function(param){return ctx.print(null,param.name)},params,ctx,",")},AbstractJsEmitterVisitor.prototype.getBuiltinMethodName=function(method){var name;switch(method){case BuiltinMethod.ConcatArray:name="concat";break;case BuiltinMethod.SubscribeObservable:name="subscribe";break;case BuiltinMethod.Bind:name="bind";break;default:throw new Error("Unknown builtin method: "+method)}return name},AbstractJsEmitterVisitor}(AbstractEmitterVisitor),JitEmitterVisitor=function(_super){function JitEmitterVisitor(reflector){var _this=_super.call(this)||this;return _this.reflector=reflector,_this._evalArgNames=[],_this._evalArgValues=[],_this._evalExportedVars=[],_this}return __extends(JitEmitterVisitor,_super),JitEmitterVisitor.prototype.createReturnStmt=function(ctx){new ReturnStatement(new LiteralMapExpr(this._evalExportedVars.map(function(resultVar){return new LiteralMapEntry(resultVar,variable(resultVar),!1)}))).visitStatement(this,ctx)},JitEmitterVisitor.prototype.getArgs=function(){for(var result={},i=0;i<this._evalArgNames.length;i++)result[this._evalArgNames[i]]=this._evalArgValues[i];return result},JitEmitterVisitor.prototype.visitExternalExpr=function(ast,ctx){var value=this.reflector.resolveExternalReference(ast.value),id=this._evalArgValues.indexOf(value);if(-1===id){id=this._evalArgValues.length,this._evalArgValues.push(value);var name_1=identifierName({reference:value})||"val";this._evalArgNames.push("jit_"+name_1+"_"+id)}return ctx.print(ast,this._evalArgNames[id]),null},JitEmitterVisitor.prototype.visitDeclareVarStmt=function(stmt,ctx){return stmt.hasModifier(StmtModifier.Exported)&&this._evalExportedVars.push(stmt.name),_super.prototype.visitDeclareVarStmt.call(this,stmt,ctx)},JitEmitterVisitor.prototype.visitDeclareFunctionStmt=function(stmt,ctx){return stmt.hasModifier(StmtModifier.Exported)&&this._evalExportedVars.push(stmt.name),_super.prototype.visitDeclareFunctionStmt.call(this,stmt,ctx)},JitEmitterVisitor.prototype.visitDeclareClassStmt=function(stmt,ctx){return stmt.hasModifier(StmtModifier.Exported)&&this._evalExportedVars.push(stmt.name),_super.prototype.visitDeclareClassStmt.call(this,stmt,ctx)},JitEmitterVisitor
}(AbstractJsEmitterVisitor),JitCompiler=function(){function JitCompiler(_metadataResolver,_templateParser,_styleCompiler,_viewCompiler,_ngModuleCompiler,_summaryResolver,_reflector,_compilerConfig,_console,getExtraNgModuleProviders){this._metadataResolver=_metadataResolver,this._templateParser=_templateParser,this._styleCompiler=_styleCompiler,this._viewCompiler=_viewCompiler,this._ngModuleCompiler=_ngModuleCompiler,this._summaryResolver=_summaryResolver,this._reflector=_reflector,this._compilerConfig=_compilerConfig,this._console=_console,this.getExtraNgModuleProviders=getExtraNgModuleProviders,this._compiledTemplateCache=new Map,this._compiledHostTemplateCache=new Map,this._compiledDirectiveWrapperCache=new Map,this._compiledNgModuleCache=new Map,this._sharedStylesheetCount=0,this._addedAotSummaries=new Set}return JitCompiler.prototype.compileModuleSync=function(moduleType){return SyncAsync.assertSync(this._compileModuleAndComponents(moduleType,!0))},JitCompiler.prototype.compileModuleAsync=function(moduleType){return Promise.resolve(this._compileModuleAndComponents(moduleType,!1))},JitCompiler.prototype.compileModuleAndAllComponentsSync=function(moduleType){return SyncAsync.assertSync(this._compileModuleAndAllComponents(moduleType,!0))},JitCompiler.prototype.compileModuleAndAllComponentsAsync=function(moduleType){return Promise.resolve(this._compileModuleAndAllComponents(moduleType,!1))},JitCompiler.prototype.getComponentFactory=function(component){return this._metadataResolver.getDirectiveSummary(component).componentFactory},JitCompiler.prototype.loadAotSummaries=function(summaries){this.clearCache(),this._addAotSummaries(summaries)},JitCompiler.prototype._addAotSummaries=function(fn$$1){if(!this._addedAotSummaries.has(fn$$1)){this._addedAotSummaries.add(fn$$1);for(var summaries=fn$$1(),i=0;i<summaries.length;i++){var entry=summaries[i];if("function"==typeof entry)this._addAotSummaries(entry);else{var summary=entry;this._summaryResolver.addSummary({symbol:summary.type.reference,metadata:null,type:summary})}}}},JitCompiler.prototype.hasAotSummary=function(ref){return!!this._summaryResolver.resolveSummary(ref)},JitCompiler.prototype._filterJitIdentifiers=function(ids){var _this=this;return ids.map(function(mod){return mod.reference}).filter(function(ref){return!_this.hasAotSummary(ref)})},JitCompiler.prototype._compileModuleAndComponents=function(moduleType,isSync){var _this=this;return SyncAsync.then(this._loadModules(moduleType,isSync),function(){return _this._compileComponents(moduleType,null),_this._compileModule(moduleType)})},JitCompiler.prototype._compileModuleAndAllComponents=function(moduleType,isSync){var _this=this;return SyncAsync.then(this._loadModules(moduleType,isSync),function(){var componentFactories=[];return _this._compileComponents(moduleType,componentFactories),{ngModuleFactory:_this._compileModule(moduleType),componentFactories:componentFactories}})},JitCompiler.prototype._loadModules=function(mainModule,isSync){var _this=this,loading=[],mainNgModule=this._metadataResolver.getNgModuleMetadata(mainModule);return this._filterJitIdentifiers(mainNgModule.transitiveModule.modules).forEach(function(nestedNgModule){var moduleMeta=_this._metadataResolver.getNgModuleMetadata(nestedNgModule);_this._filterJitIdentifiers(moduleMeta.declaredDirectives).forEach(function(ref){var promise=_this._metadataResolver.loadDirectiveMetadata(moduleMeta.type.reference,ref,isSync);promise&&loading.push(promise)}),_this._filterJitIdentifiers(moduleMeta.declaredPipes).forEach(function(ref){return _this._metadataResolver.getOrLoadPipeMetadata(ref)})}),SyncAsync.all(loading)},JitCompiler.prototype._compileModule=function(moduleType){var ngModuleFactory=this._compiledNgModuleCache.get(moduleType);if(!ngModuleFactory){var moduleMeta=this._metadataResolver.getNgModuleMetadata(moduleType),extraProviders=this.getExtraNgModuleProviders(moduleMeta.type.reference),outputCtx=createOutputContext(),compileResult=this._ngModuleCompiler.compile(outputCtx,moduleMeta,extraProviders);ngModuleFactory=this._interpretOrJit(ngModuleJitUrl(moduleMeta),outputCtx.statements)[compileResult.ngModuleFactoryVar],this._compiledNgModuleCache.set(moduleMeta.type.reference,ngModuleFactory)}return ngModuleFactory},JitCompiler.prototype._compileComponents=function(mainModule,allComponentFactories){var _this=this,ngModule=this._metadataResolver.getNgModuleMetadata(mainModule),moduleByJitDirective=new Map,templates=new Set,transJitModules=this._filterJitIdentifiers(ngModule.transitiveModule.modules);transJitModules.forEach(function(localMod){var localModuleMeta=_this._metadataResolver.getNgModuleMetadata(localMod);_this._filterJitIdentifiers(localModuleMeta.declaredDirectives).forEach(function(dirRef){moduleByJitDirective.set(dirRef,localModuleMeta);var dirMeta=_this._metadataResolver.getDirectiveMetadata(dirRef);if(dirMeta.isComponent&&(templates.add(_this._createCompiledTemplate(dirMeta,localModuleMeta)),allComponentFactories)){var template=_this._createCompiledHostTemplate(dirMeta.type.reference,localModuleMeta);templates.add(template),allComponentFactories.push(dirMeta.componentFactory)}})}),transJitModules.forEach(function(localMod){var localModuleMeta=_this._metadataResolver.getNgModuleMetadata(localMod);_this._filterJitIdentifiers(localModuleMeta.declaredDirectives).forEach(function(dirRef){var dirMeta=_this._metadataResolver.getDirectiveMetadata(dirRef);dirMeta.isComponent&&dirMeta.entryComponents.forEach(function(entryComponentType){var moduleMeta=moduleByJitDirective.get(entryComponentType.componentType);templates.add(_this._createCompiledHostTemplate(entryComponentType.componentType,moduleMeta))})}),localModuleMeta.entryComponents.forEach(function(entryComponentType){if(!_this.hasAotSummary(entryComponentType.componentType.reference)){var moduleMeta=moduleByJitDirective.get(entryComponentType.componentType);templates.add(_this._createCompiledHostTemplate(entryComponentType.componentType,moduleMeta))}})}),templates.forEach(function(template){return _this._compileTemplate(template)})},JitCompiler.prototype.clearCacheFor=function(type){this._compiledNgModuleCache.delete(type),this._metadataResolver.clearCacheFor(type),this._compiledHostTemplateCache.delete(type),this._compiledTemplateCache.get(type)&&this._compiledTemplateCache.delete(type)},JitCompiler.prototype.clearCache=function(){this._metadataResolver.clearCache(),this._compiledTemplateCache.clear(),this._compiledHostTemplateCache.clear(),this._compiledNgModuleCache.clear()},JitCompiler.prototype._createCompiledHostTemplate=function(compType,ngModule){if(!ngModule)throw new Error("Component "+stringify(compType)+" is not part of any NgModule or the module has not been imported into your module.");var compiledTemplate=this._compiledHostTemplateCache.get(compType);if(!compiledTemplate){var compMeta=this._metadataResolver.getDirectiveMetadata(compType);assertComponent(compMeta);var hostMeta=this._metadataResolver.getHostComponentMetadata(compMeta,compMeta.componentFactory.viewDefFactory);compiledTemplate=new CompiledTemplate(!0,compMeta.type,hostMeta,ngModule,[compMeta.type]),this._compiledHostTemplateCache.set(compType,compiledTemplate)}return compiledTemplate},JitCompiler.prototype._createCompiledTemplate=function(compMeta,ngModule){var compiledTemplate=this._compiledTemplateCache.get(compMeta.type.reference);return compiledTemplate||(assertComponent(compMeta),compiledTemplate=new CompiledTemplate(!1,compMeta.type,compMeta,ngModule,ngModule.transitiveModule.directives),this._compiledTemplateCache.set(compMeta.type.reference,compiledTemplate)),compiledTemplate},JitCompiler.prototype._compileTemplate=function(template){var _this=this;if(!template.isCompiled){var compMeta=template.compMeta,externalStylesheetsByModuleUrl=new Map,outputContext=createOutputContext(),componentStylesheet=this._styleCompiler.compileComponent(outputContext,compMeta);compMeta.template.externalStylesheets.forEach(function(stylesheetMeta){var compiledStylesheet=_this._styleCompiler.compileStyles(createOutputContext(),compMeta,stylesheetMeta);externalStylesheetsByModuleUrl.set(stylesheetMeta.moduleUrl,compiledStylesheet)}),this._resolveStylesCompileResult(componentStylesheet,externalStylesheetsByModuleUrl);var _a=(template.ngModule.transitiveModule.pipes.map(function(pipe){return _this._metadataResolver.getPipeSummary(pipe.reference)}),this._parseTemplate(compMeta,template.ngModule,template.directives)),parsedTemplate=_a.template,usedPipes=_a.pipes,compileResult=this._viewCompiler.compileComponent(outputContext,compMeta,parsedTemplate,variable(componentStylesheet.stylesVar),usedPipes),evalResult=this._interpretOrJit(templateJitUrl(template.ngModule.type,template.compMeta),outputContext.statements),viewClass=evalResult[compileResult.viewClassVar],rendererType=evalResult[compileResult.rendererTypeVar];template.compiled(viewClass,rendererType)}},JitCompiler.prototype._parseTemplate=function(compMeta,ngModule,directiveIdentifiers){var _this=this,preserveWhitespaces=compMeta.template.preserveWhitespaces,directives=directiveIdentifiers.map(function(dir){return _this._metadataResolver.getDirectiveSummary(dir.reference)}),pipes=ngModule.transitiveModule.pipes.map(function(pipe){return _this._metadataResolver.getPipeSummary(pipe.reference)});return this._templateParser.parse(compMeta,compMeta.template.htmlAst,directives,pipes,ngModule.schemas,templateSourceUrl(ngModule.type,compMeta,compMeta.template),preserveWhitespaces)},JitCompiler.prototype._resolveStylesCompileResult=function(result,externalStylesheetsByModuleUrl){var _this=this;result.dependencies.forEach(function(dep,i){var nestedCompileResult=externalStylesheetsByModuleUrl.get(dep.moduleUrl),nestedStylesArr=_this._resolveAndEvalStylesCompileResult(nestedCompileResult,externalStylesheetsByModuleUrl);dep.setValue(nestedStylesArr)})},JitCompiler.prototype._resolveAndEvalStylesCompileResult=function(result,externalStylesheetsByModuleUrl){return this._resolveStylesCompileResult(result,externalStylesheetsByModuleUrl),this._interpretOrJit(sharedStylesheetJitUrl(result.meta,this._sharedStylesheetCount++),result.outputCtx.statements)[result.stylesVar]},JitCompiler.prototype._interpretOrJit=function(sourceUrl,statements){return this._compilerConfig.useJit?jitStatements(sourceUrl,statements,this._reflector,this._compilerConfig.jitDevMode):interpretStatements(statements,this._reflector)},JitCompiler}(),CompiledTemplate=function(){function CompiledTemplate(isHost,compType,compMeta,ngModule,directives){this.isHost=isHost,this.compType=compType,this.compMeta=compMeta,this.ngModule=ngModule,this.directives=directives,this._viewClass=null,this.isCompiled=!1}return CompiledTemplate.prototype.compiled=function(viewClass,rendererType){this._viewClass=viewClass,this.compMeta.componentViewType.setDelegate(viewClass);for(var prop in rendererType)this.compMeta.rendererType[prop]=rendererType[prop];this.isCompiled=!0},CompiledTemplate}(),CompileReflector=function(){function CompileReflector(){}return CompileReflector}(),UrlResolver=function(){function UrlResolverImpl(_packagePrefix){void 0===_packagePrefix&&(_packagePrefix=null),this._packagePrefix=_packagePrefix}return UrlResolverImpl.prototype.resolve=function(baseUrl,url){var resolvedUrl=url;null!=baseUrl&&baseUrl.length>0&&(resolvedUrl=_resolveUrl(baseUrl,resolvedUrl));var resolvedParts=_split(resolvedUrl),prefix=this._packagePrefix;if(null!=prefix&&null!=resolvedParts&&"package"==resolvedParts[_ComponentIndex.Scheme]){var path=resolvedParts[_ComponentIndex.Path];return prefix=prefix.replace(/\/+$/,""),path=path.replace(/^\/+/,""),prefix+"/"+path}return resolvedUrl},UrlResolverImpl}(),_splitRe=new RegExp("^(?:([^:/?#.]+):)?(?://(?:([^/?#]*)@)?([\\w\\d\\-\\u0100-\\uffff.%]*)(?::([0-9]+))?)?([^?#]+)?(?:\\?([^#]*))?(?:#(.*))?$"),_ComponentIndex={Scheme:1,UserInfo:2,Domain:3,Port:4,Path:5,QueryData:6,Fragment:7};_ComponentIndex[_ComponentIndex.Scheme]="Scheme",_ComponentIndex[_ComponentIndex.UserInfo]="UserInfo",_ComponentIndex[_ComponentIndex.Domain]="Domain",_ComponentIndex[_ComponentIndex.Port]="Port",_ComponentIndex[_ComponentIndex.Path]="Path",_ComponentIndex[_ComponentIndex.QueryData]="QueryData",_ComponentIndex[_ComponentIndex.Fragment]="Fragment";/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
var ResourceLoader=function(){function ResourceLoader(){}return ResourceLoader.prototype.get=function(url){return""},ResourceLoader}(),Extractor=function(){function Extractor(host,staticSymbolResolver,messageBundle,metadataResolver){this.host=host,this.staticSymbolResolver=staticSymbolResolver,this.messageBundle=messageBundle,this.metadataResolver=metadataResolver}return Extractor.prototype.extract=function(rootFiles){var _this=this,_a=analyzeAndValidateNgModules(rootFiles,this.host,this.staticSymbolResolver,this.metadataResolver),files=_a.files,ngModules=_a.ngModules;return Promise.all(ngModules.map(function(ngModule){return _this.metadataResolver.loadNgModuleDirectiveAndPipeMetadata(ngModule.type.reference,!1)})).then(function(){var errors=[];if(files.forEach(function(file){var compMetas=[];file.directives.forEach(function(directiveType){var dirMeta=_this.metadataResolver.getDirectiveMetadata(directiveType);dirMeta&&dirMeta.isComponent&&compMetas.push(dirMeta)}),compMetas.forEach(function(compMeta){var html=compMeta.template.template,interpolationConfig=InterpolationConfig.fromArray(compMeta.template.interpolation);errors.push.apply(errors,_this.messageBundle.updateFromTemplate(html,file.fileName,interpolationConfig))})}),errors.length)throw new Error(errors.map(function(e){return e.toString()}).join("\n"));return _this.messageBundle})},Extractor.create=function(host,locale){var htmlParser=new HtmlParser,urlResolver=createAotUrlResolver(host),symbolCache=new StaticSymbolCache,summaryResolver=new AotSummaryResolver(host,symbolCache),staticSymbolResolver=new StaticSymbolResolver(host,symbolCache,summaryResolver),staticReflector=new StaticReflector(summaryResolver,staticSymbolResolver),config=new CompilerConfig({defaultEncapsulation:ViewEncapsulation.Emulated,useJit:!1}),normalizer=new DirectiveNormalizer({get:function(url){return host.loadResource(url)}},urlResolver,htmlParser,config),elementSchemaRegistry=new DomElementSchemaRegistry,resolver=new CompileMetadataResolver(config,htmlParser,new NgModuleResolver(staticReflector),new DirectiveResolver(staticReflector),new PipeResolver(staticReflector),summaryResolver,elementSchemaRegistry,normalizer,console,symbolCache,staticReflector),messageBundle=new MessageBundle(htmlParser,[],{},locale);return{extractor:new Extractor(host,staticSymbolResolver,messageBundle,resolver),staticReflector:staticReflector}},Extractor}();exports.core=core,exports.CompilerConfig=CompilerConfig,exports.preserveWhitespacesDefault=preserveWhitespacesDefault,exports.isLoweredSymbol=isLoweredSymbol,exports.createLoweredSymbol=createLoweredSymbol,exports.Identifiers=Identifiers,exports.JitCompiler=JitCompiler,exports.DirectiveResolver=DirectiveResolver,exports.PipeResolver=PipeResolver,exports.NgModuleResolver=NgModuleResolver,exports.DEFAULT_INTERPOLATION_CONFIG=DEFAULT_INTERPOLATION_CONFIG,exports.InterpolationConfig=InterpolationConfig,exports.NgModuleCompiler=NgModuleCompiler,exports.AssertNotNull=AssertNotNull,exports.BinaryOperator=BinaryOperator,exports.BinaryOperatorExpr=BinaryOperatorExpr,exports.BuiltinMethod=BuiltinMethod,exports.BuiltinVar=BuiltinVar,exports.CastExpr=CastExpr,exports.ClassStmt=ClassStmt,exports.CommaExpr=CommaExpr,exports.CommentStmt=CommentStmt,exports.ConditionalExpr=ConditionalExpr,exports.DeclareFunctionStmt=DeclareFunctionStmt,exports.DeclareVarStmt=DeclareVarStmt,exports.ExpressionStatement=ExpressionStatement,exports.ExternalExpr=ExternalExpr,exports.ExternalReference=ExternalReference,exports.FunctionExpr=FunctionExpr,exports.IfStmt=IfStmt,exports.InstantiateExpr=InstantiateExpr,exports.InvokeFunctionExpr=InvokeFunctionExpr,exports.InvokeMethodExpr=InvokeMethodExpr,exports.LiteralArrayExpr=LiteralArrayExpr,exports.LiteralExpr=LiteralExpr,exports.LiteralMapExpr=LiteralMapExpr,exports.NotExpr=NotExpr,exports.ReadKeyExpr=ReadKeyExpr,exports.ReadPropExpr=ReadPropExpr,exports.ReadVarExpr=ReadVarExpr,exports.ReturnStatement=ReturnStatement,exports.ThrowStmt=ThrowStmt,exports.TryCatchStmt=TryCatchStmt,exports.WriteKeyExpr=WriteKeyExpr,exports.WritePropExpr=WritePropExpr,exports.WriteVarExpr=WriteVarExpr,exports.StmtModifier=StmtModifier,exports.Statement=Statement,exports.collectExternalReferences=collectExternalReferences,exports.EmitterVisitorContext=EmitterVisitorContext,exports.ViewCompiler=ViewCompiler,exports.getParseErrors=getParseErrors,exports.isSyntaxError=isSyntaxError,exports.syntaxError=syntaxError,exports.Version=Version,exports.VERSION=VERSION,exports.TextAst=TextAst,exports.BoundTextAst=BoundTextAst,exports.AttrAst=AttrAst,exports.BoundElementPropertyAst=BoundElementPropertyAst,exports.BoundEventAst=BoundEventAst,exports.ReferenceAst=ReferenceAst,exports.VariableAst=VariableAst,exports.ElementAst=ElementAst,exports.EmbeddedTemplateAst=EmbeddedTemplateAst,exports.BoundDirectivePropertyAst=BoundDirectivePropertyAst,exports.DirectiveAst=DirectiveAst,exports.ProviderAst=ProviderAst,exports.ProviderAstType=ProviderAstType,exports.NgContentAst=NgContentAst,exports.PropertyBindingType=PropertyBindingType,exports.NullTemplateVisitor=NullTemplateVisitor,exports.RecursiveTemplateAstVisitor=RecursiveTemplateAstVisitor,exports.templateVisitAll=templateVisitAll,exports.identifierName=identifierName,exports.identifierModuleUrl=identifierModuleUrl,exports.viewClassName=viewClassName,exports.rendererTypeName=rendererTypeName,exports.hostViewClassName=hostViewClassName,exports.componentFactoryName=componentFactoryName,exports.CompileSummaryKind=CompileSummaryKind,exports.tokenName=tokenName,exports.tokenReference=tokenReference,exports.CompileStylesheetMetadata=CompileStylesheetMetadata,exports.CompileTemplateMetadata=CompileTemplateMetadata,exports.CompileDirectiveMetadata=CompileDirectiveMetadata,exports.CompilePipeMetadata=CompilePipeMetadata,exports.CompileNgModuleMetadata=CompileNgModuleMetadata,exports.TransitiveCompileNgModuleMetadata=TransitiveCompileNgModuleMetadata,exports.ProviderMeta=ProviderMeta,exports.flatten=flatten,exports.templateSourceUrl=templateSourceUrl,exports.sharedStylesheetJitUrl=sharedStylesheetJitUrl,exports.ngModuleJitUrl=ngModuleJitUrl,exports.templateJitUrl=templateJitUrl,exports.createAotUrlResolver=createAotUrlResolver,exports.createAotCompiler=createAotCompiler,exports.AotCompiler=AotCompiler,exports.analyzeNgModules=analyzeNgModules,exports.analyzeAndValidateNgModules=analyzeAndValidateNgModules,exports.analyzeFile=analyzeFile,exports.mergeAnalyzedFiles=mergeAnalyzedFiles,exports.GeneratedFile=GeneratedFile,exports.toTypeScript=toTypeScript,exports.formattedError=formattedError,exports.isFormattedError=isFormattedError,exports.StaticReflector=StaticReflector,exports.StaticSymbol=StaticSymbol,exports.StaticSymbolCache=StaticSymbolCache,exports.ResolvedStaticSymbol=ResolvedStaticSymbol,exports.StaticSymbolResolver=StaticSymbolResolver,exports.unescapeIdentifier=unescapeIdentifier,exports.unwrapResolvedMetadata=unwrapResolvedMetadata,exports.AotSummaryResolver=AotSummaryResolver,exports.AstPath=AstPath,exports.SummaryResolver=SummaryResolver,exports.JitSummaryResolver=JitSummaryResolver,exports.CompileReflector=CompileReflector,exports.createUrlResolverWithoutPackagePrefix=createUrlResolverWithoutPackagePrefix,exports.createOfflineCompileUrlResolver=createOfflineCompileUrlResolver,exports.UrlResolver=UrlResolver,exports.getUrlScheme=getUrlScheme,exports.ResourceLoader=ResourceLoader,exports.ElementSchemaRegistry=ElementSchemaRegistry,exports.Extractor=Extractor,exports.I18NHtmlParser=I18NHtmlParser,exports.MessageBundle=MessageBundle,exports.Serializer=Serializer,exports.Xliff=Xliff,exports.Xliff2=Xliff2,exports.Xmb=Xmb,exports.Xtb=Xtb,exports.DirectiveNormalizer=DirectiveNormalizer,exports.ParserError=ParserError,exports.ParseSpan=ParseSpan,exports.AST=AST,exports.Quote=Quote,exports.EmptyExpr=EmptyExpr,exports.ImplicitReceiver=ImplicitReceiver,exports.Chain=Chain,exports.Conditional=Conditional,exports.PropertyRead=PropertyRead,exports.PropertyWrite=PropertyWrite,exports.SafePropertyRead=SafePropertyRead,exports.KeyedRead=KeyedRead,exports.KeyedWrite=KeyedWrite,exports.BindingPipe=BindingPipe,exports.LiteralPrimitive=LiteralPrimitive,exports.LiteralArray=LiteralArray,exports.LiteralMap=LiteralMap,exports.Interpolation=Interpolation,exports.Binary=Binary,exports.PrefixNot=PrefixNot,exports.NonNullAssert=NonNullAssert,exports.MethodCall=MethodCall,exports.SafeMethodCall=SafeMethodCall,exports.FunctionCall=FunctionCall,exports.ASTWithSource=ASTWithSource,exports.TemplateBinding=TemplateBinding,exports.NullAstVisitor=NullAstVisitor,exports.RecursiveAstVisitor=RecursiveAstVisitor,exports.AstTransformer=AstTransformer,exports.visitAstChildren=visitAstChildren,exports.TokenType=TokenType,exports.Lexer=Lexer,exports.Token=Token,exports.EOF=EOF,exports.isIdentifier=isIdentifier,exports.isQuote=isQuote,exports.SplitInterpolation=SplitInterpolation,exports.TemplateBindingParseResult=TemplateBindingParseResult,exports.Parser=Parser,exports._ParseAST=_ParseAST,exports.ERROR_COMPONENT_TYPE=ERROR_COMPONENT_TYPE,exports.CompileMetadataResolver=CompileMetadataResolver,exports.Text=Text,exports.Expansion=Expansion,exports.ExpansionCase=ExpansionCase,exports.Attribute=Attribute$1,exports.Element=Element,exports.Comment=Comment,exports.visitAll=visitAll,exports.RecursiveVisitor=RecursiveVisitor,exports.findNode=findNode,exports.ParseTreeResult=ParseTreeResult,exports.TreeError=TreeError,exports.HtmlParser=HtmlParser,exports.HtmlTagDefinition=HtmlTagDefinition,exports.getHtmlTagDefinition=getHtmlTagDefinition,exports.TagContentType=TagContentType,exports.splitNsName=splitNsName,exports.isNgContainer=isNgContainer,exports.isNgContent=isNgContent,exports.isNgTemplate=isNgTemplate,exports.getNsPrefix=getNsPrefix,exports.mergeNsAndName=mergeNsAndName,exports.NAMED_ENTITIES=NAMED_ENTITIES,exports.NGSP_UNICODE=NGSP_UNICODE,exports.debugOutputAstAsTypeScript=debugOutputAstAsTypeScript,exports.TypeScriptEmitter=TypeScriptEmitter;exports.ParseLocation=ParseLocation,exports.ParseSourceFile=ParseSourceFile,exports.ParseSourceSpan=ParseSourceSpan,exports.ParseErrorLevel=ParseErrorLevel,exports.ParseError=ParseError,exports.typeSourceSpan=typeSourceSpan,exports.DomElementSchemaRegistry=DomElementSchemaRegistry,exports.CssSelector=CssSelector,exports.SelectorMatcher=SelectorMatcher,exports.SelectorListContext=SelectorListContext,exports.SelectorContext=SelectorContext,exports.StylesCompileDependency=StylesCompileDependency,exports.CompiledStylesheet=CompiledStylesheet,exports.StyleCompiler=StyleCompiler,exports.TemplateParseError=TemplateParseError,exports.TemplateParseResult=TemplateParseResult,exports.TemplateParser=TemplateParser,exports.splitClasses=splitClasses,exports.createElementCssSelector=createElementCssSelector,exports.removeSummaryDuplicates=removeSummaryDuplicates,Object.defineProperty(exports,"__esModule",{value:!0})});
//# sourceMappingURL=compiler.umd.min.js.map